\newcommand\classname{RCL}
\newcommand\lastmodifieddate{2020/05/29}
\newcommand\versionnumber{0.1}

% Are we printing crop marks?
\newif\if@cropmarkson \@cropmarksontrue

\NeedsTeXFormat{LaTeX2e}[2000/06/01]
\ProvidesClass{\classname}[\lastmodifieddate\space RCL Author class file
                           Version \versionnumber^^J]

\setlength{\paperheight}{228mm}
\setlength{\paperwidth}{152mm}

\newif\if@numberedref \@numberedreftrue
\newif\if@endproofbox \@endproofboxtrue
\newif\ifnoquery
\newif\iffinal
\newif\ifpreview
\newif\ifrevised
\newif\ifprinter
\newif\iflink
\newif\ifopenac
\newif\iffrench
\newif\ifsubmission

\DeclareOption{submission}{\submissiontrue}
\DeclareOption{french}{\frenchtrue}
\DeclareOption{openac}{\openactrue}
\DeclareOption{link}{\linktrue}
\DeclareOption{noquery}{\noquerytrue}
\DeclareOption{final}{\finaltrue}
\DeclareOption{preview}{\previewtrue}
\DeclareOption{revised}{\revisedtrue}
\DeclareOption{printer}{\printertrue}
\DeclareOption{draft}{\PassOptionsToPackage{draft}{graphicx}}
\DeclareOption{a4paper}{\PassOptionsToPackage{a4}{crop}}
\DeclareOption{centre}{\PassOptionsToPackage{center}{crop}}
\DeclareOption{crop}{\PassOptionsToPackage{cam}{crop}\global\@cropmarksontrue}
\DeclareOption{nocrop}{\PassOptionsToPackage{off}{crop}\global\@cropmarksonfalse}
\DeclareOption{info}{\PassOptionsToPackage{info}{crop}}
\DeclareOption{noinfo}{\PassOptionsToPackage{noinfo}{crop}}
\DeclareOption{numbered}{\global\@numberedreftrue}
\DeclareOption{named}{\global\@numberedreffalse}
\DeclareOption{noproofbox}{\global\@endproofboxfalse}
\DeclareOption{proofbox}{\global\@endproofboxtrue}
\DeclareOption{courier}{\def\verbatim@font{\normalfont\ttfamily}}
\DeclareOption{times}{\def\verbatim@font{\normalfont\rmfamily}}
\newif\iflineno
\DeclareOption{lineno}{\linenotrue}

\ExecuteOptions{a4paper,crop,centre,info,proofbox}

\ProcessOptions

% Language selection
\iffrench
	\usepackage[canadian,francais]{babel}
	\else
	\usepackage[francais,canadian]{babel}
\fi

% Don't let choosing French change a bunch of unrelated things (bulleted lists, size of footnotes, indent in first paragraph of section, etc.):
\frenchbsetup{StandardLayout=true}


% Load all necessary packages
\RequirePackage[OT1]{fontenc}
\RequirePackage{mathptmx}

\RequirePackage{upgreek}
\RequirePackage{crop,graphicx,array,amsmath,amsthm,amssymb,amsfonts}
\RequirePackage{rotating}
\RequirePackage{vruler,color}
\RequirePackage{amsthm}


% Not sure if needed.
\newcommand\@ptsize{0}

% Set twoside printing
\@twosidetrue

% Marginal notes are on the outside edge
\@mparswitchtrue

% Default font sizes
\renewcommand\normalsize{%
  \@setfontsize\normalsize{10\p@}{12\p@}%
  \abovedisplayskip 10\p@ \@plus 3\p@ \@minus4\p@
  \abovedisplayshortskip 3\p@ \@plus 3\p@ \@minus1\p@
  \belowdisplayshortskip 6\p@ \@plus 3\p@ \@minus2\p@
  \belowdisplayskip \abovedisplayskip
  \let\@listi\@listI}
\normalsize
\let\@bls\baselineskip

\newcommand\small{%
  \@setfontsize\small{9\p@}{11\p@}%
  \abovedisplayskip 6\p@ \@plus1\p@ \@minus1\p@
  \abovedisplayshortskip 3\p@ \@plus 2\p@ \@minus1\p@
  \belowdisplayshortskip 2\p@ \@plus 1\p@ \@minus1\p@
  \def\@listi{\leftmargin\leftmargini
              \listparindent \parindent
              \topsep 6\p@ \@plus2\p@ \@minus1\p@
              \parsep \z@ \itemsep \z@}%
  \belowdisplayskip \abovedisplayskip}

\newcommand\footnotesize{%
  \@setfontsize\footnotesize{8\p@}{9\p@}%
  \abovedisplayskip 6\p@ \@plus2\p@ \@minus4\p@
  \abovedisplayshortskip \z@ \@plus \p@
  \belowdisplayshortskip 1\p@ \@plus2\p@ \@minus2\p@
  \def\@listi{\leftmargin\leftmargini
              \listparindent 1em
              \topsep 5\p@ \@plus 2\p@ \@minus 1\p@
              \parsep \z@ \itemsep \z@}%
  \belowdisplayskip \abovedisplayskip}

\def\scriptsize{\@setfontsize\scriptsize{7\p@}{9\p@}}
\def\tiny{\@setfontsize\tiny{6\p@}{7\p@}}
\def\little{\@setfontsize\little{5\p@}{6\p@}}
\def\large{\@setfontsize\large{12\p@}{14\p@}}
\def\Large{\@setfontsize\Large{14\p@}{16\p@}}
\def\LARGE{\@setfontsize\LARGE{16\p@}{18\p@}}
\def\huge{\@setfontsize\huge{24\p@}{26\p@}}
\def\Huge{\@setfontsize\Huge{25\p@}{27\p@}}

\gdef\rev#1{\gdef\@rev{#1}}\rev{}
\gdef\acc#1{\gdef\@acc{#1}}\acc{}
\gdef\sub#1{\gdef\@sub{#1}}\sub{}
\gdef\fpub#1{\gdef\@fpub{#1}}\fpub{}


\DeclareOldFontCommand{\rm}{\normalfont\rmfamily}{\mathrm}
\DeclareOldFontCommand{\sf}{\normalfont\sffamily}{\mathsf}
\DeclareOldFontCommand{\tt}{\normalfont\ttfamily}{\mathtt}
\DeclareOldFontCommand{\bf}{\normalfont\bfseries}{\mathbf}
\DeclareOldFontCommand{\it}{\normalfont\itshape}{\mathit}
\DeclareOldFontCommand{\sl}{\normalfont\slshape}{\@nomath\sl}
\DeclareOldFontCommand{\sc}{\normalfont\scshape}{\@nomath\sc}

% Line spacing
\setlength\lineskip{1\p@}
\setlength\normallineskip{1\p@}
\renewcommand\baselinestretch{}
% Double spacing if submission option is used
\ifsubmission
	\renewcommand\baselinestretch{1.655}
\fi

% Paragraph dimensions and inter-para spacing
\setlength\parskip{0\p@}
\setlength\parindent{10pt}

% Set inter-para skips
\setlength\smallskipamount{3\p@ \@plus 1\p@ \@minus 1\p@}
\setlength\medskipamount{6\p@ \@plus 2\p@ \@minus 2\p@}
\setlength\bigskipamount{12\p@ \@plus 4\p@ \@minus 4\p@}

% Page break penalties
\@lowpenalty   51
\@medpenalty  151
\@highpenalty 301

% Disallow widows and orphans
\clubpenalty 10000
\widowpenalty 10000

% Disable page breaks before equations, allow pagebreaks after
% equations and discourage widow lines before equations.
\displaywidowpenalty 100
\predisplaypenalty   10000
\postdisplaypenalty  2500

% Allow breaking the page in the middle of a paragraph
\interlinepenalty 0

% Disallow breaking the page after a hyphenated line
\brokenpenalty 10000

% Hyphenation; don't split words into less than three characters
\lefthyphenmin=3
\righthyphenmin=3

%
% Set page layout dimensions
%
\setlength\headheight{7\p@}          % height of running head
\setlength\topmargin{2.8pc}            % top margin 3pc, 9pt
\addtolength\topmargin{8\p@}         %
\addtolength\topmargin{-1in}         % subtract out the 1 inch driver margin

\setlength\topskip{8\p@}            % height of first line of text%% {10\p@}
\setlength\headsep{21\p@}          % space below running head --
\addtolength\headsep{-\topskip}      %   base to base with first line of text

\setlength\footskip{22.5\p@}           % space above footer line
\setlength\maxdepth{.5\topskip}      % pages can be short or deep by half a line?

\setlength\textwidth{118mm}           % text measure excluding margins
%\addtolength\textwidth{9.89\p@}      % -> textwidth of 30pc, 9.89pt!

\setlength\textheight{44\@bls}       % text height of 45pc,
\addtolength\textheight{\topskip}    %  - including first line of text

% Set the margins
\setlength\marginparsep{16\p@}
\setlength\marginparpush{12\p@}
\setlength\marginparwidth{5pc}

\setlength\oddsidemargin{55.64pt}%
\addtolength\oddsidemargin{-1in}    % subtract out the 1 inch driver margin
\setlength\@tempdima{\paperwidth}
\addtolength\@tempdima{-\textwidth}
\addtolength\@tempdima{-55.64pt}
\setlength\evensidemargin{\@tempdima}
\addtolength\evensidemargin{-1in}

\setlength\columnsep{6\p@}          % space between columns for double-column text
\setlength\columnseprule{0\p@}      % width of rule between two columns

% Footnotes
\setlength\footnotesep{0\p@}     % space between footnotes
\setlength{\skip\footins}{16\p@ \@plus 4\p@ \@minus 2\p@}

% Float placement parameters
\setcounter{totalnumber}{10}
\setcounter{topnumber}{5}
\setcounter{bottomnumber}{5}

% The maximum part of the top or bottom of a text page that can be
% occupied by floats. This is set so that at least four lines of text
% fit on the page.
\renewcommand\topfraction{.921}
\renewcommand\bottomfraction{.921}

% The minimum amount of a text page that must be occupied by text.
% This should accomodate four lines of text.
\renewcommand\textfraction{.079}

% The minimum amount of a float page that must be occupied by floats.
\renewcommand\floatpagefraction{.887}

% The same parameters repeated for double column output
\renewcommand\dbltopfraction{.88}
\renewcommand\dblfloatpagefraction{.88}

% Space between floats
\setlength\floatsep    {18\p@ \@plus 2\p@ \@minus 2\p@}

% Space between floats and text
\setlength\textfloatsep{20\p@ \@plus 2\p@ \@minus 4\p@}

% Space above and below an inline figure
\setlength\intextsep   {18\p@ \@plus 2\p@ \@minus 2\p@}

% For double column floats
\setlength\dblfloatsep    {12\p@ \@plus 2\p@ \@minus 2\p@}
\setlength\dbltextfloatsep{20\p@ \@plus 2\p@ \@minus 4\p@}

% Space left at top, bottom and inbetween floats on a float page.
\setlength\@fptop{0\p@}         % no space above float page figures
\setlength\@fpsep{12\p@ \@plus 2fil}
\setlength\@fpbot{0\p@ \@plus 1fil}


% The same for double column
\setlength\@dblfptop{0\p@}
\setlength\@dblfpsep{12\p@ \@plus 1fil}
\setlength\@dblfpbot{0\p@ \@plus 2fil}

%%%%%%%%%%%%%%%%%%%%%%%%%%%% Article Identification %%%%%%%%%%%%%%%%%%%%%%%%%%%%
\def\@default@journal@title{Journal Title}
\let\@journal@title\@default@journal@title
\def\art-id@info{}
\def\month@info{Month~}
\def\year@info{\the\year}
\def\vol@info{00}
\def\price@info{00}
\def\issue@info{00}
\def\@print@issn{0000-0000}
\def\@price{0000-0000}

\iflink
\newcommand{\page@extent@info}{%
  \thepage--\pageref*{LastPage}}

\newcommand{\totalpage}{%
  \pageref*{LastPage}}
\else
\newcommand{\page@extent@info}{%
  \thepage--\pageref{LastPage}}

\newcommand{\totalpage}{%
  \pageref{LastPage}}
\fi

\newcommand{\issn@line}{\@print@issn}
\newcommand{\copyright@line}{\textcopyright\ \year@info\ Cambridge University Press}
\newcommand{\webcommand}{{http:$//$www.informaworld.com}}%\href{mailto:http:$//$www.informaworld.com}
\gdef\doi@string{0000000000}

% Article information user commands
\def\Year#1{\gdef\year@info{#1}}
\def\Vol#1{\gdef\vol@info{#1}}
\def\Price#1{\gdef\price@info{#1}}
\def\Issue#1{\gdef\issue@info{#1}}
\def\art-id#1{\gdef\art-id@info{#1}}
\def\Month#1{\gdef\month@info{#1}}
\newcommand\DOI[2][\@doi@fixed@field]{%
  \gdef\@doi@variable@field{#1}%
  \setDOI{#1}{#2}}
\newcommand{\setDOI}[2]{%
  \gdef\doi@string{#1#2}}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Firstpage %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\newcommand{\firstpage}[1]{%
  \setcounter{page}{#1}}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%% Page Styles %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\def\ps@titlepage{%
\vspace*{17pt}
  \let\@evenfoot\relax
 \def\@evenhead{\fontsize{8}{9}\selectfont \titlepageheadline}
 \def\@oddhead{\hbox{\fontsize{9}{9}\selectfont \titlepageheadline}}%
  \def\@oddfoot{\ifopenac\titlepagefootline\fi}%
  \def\@evenfoot{\ifopenac\titlepagefootline\fi}%
  \def\authormark##1{\def\leftmark{##1}}%
  \def\titlemark##1{\markboth{##1}{##1}}}

\def\ps@headings{%
  \let\@oddfoot\@empty%
  \let\@evenfoot\@empty%
  \def\@evenhead{{\let\etal=\tetal{\fontsize{10}{12}\selectfont{\thepage}}\hfil{{\fontsize{9}{11}\selectfont\MakeUppercase{\leftmark}}\hfil}}}
  \def\@oddhead{\let\etal=\tetal{\fontsize{9}{11}\selectfont\hfil{\MakeUppercase{\rightmark}}}\hfil{\fontsize{10}{12}\selectfont\thepage}}
  \def\authormark##1{\def\leftmark{##1}}%
  \def\titlemark##1{\markboth{##1}{##1}}}

\def\ps@myheadings{%
  \def\@oddfoot{\hfill{\fontsize{9}{10}\selectfont\thepage}}%
  \let\@evenfoot\@empty%
  \def\@evenhead{\hfil}%
  \def\@oddhead{}

  \def\authormark##1{\def\leftmark{##1}}%
  \def\titlemark##1{\markboth{##1}{##1}}}

\newcommand{\titlepageheadline}{%
%\addtolength\topskip{2\p@}            % height of first line of text%% {10\p@}
  \vbox to 2\baselineskip{%
    \hbox to \textwidth{%
      \parbox{\textwidth}{%                   <- textwidth minus logo width
  \fontsize{7.5}{8.5}\selectfont
        {\@journal@title}\\
        {doi:\doi@string}\\
        $\copyright$\ Canadian Linguistic Association/Association canadienne de linguistique \year@info\\[-5pt]
        \hrule height.3mm depth0pt}}}}

\def\today{\number\day/\ifcase\month\or
 1\or 2\or 3\or 4\or 5\or 6\or 7\or 8\or 9\or 10\or 11\or 12\fi/\number\year}

% No headers for float pages - requires the floatpag package
%% \floatpagestyle{headings}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%
% Sectional units
%

% Counters
\newcounter{part}
\newcounter{section}
\newcounter{subsection}[section]
\newcounter{subsubsection}[subsection]
\newcounter{paragraph}[subsubsection]
\newcounter{subparagraph}[paragraph]
\newcounter{refsection}[section]
\newcounter{appsection}[section]
\newcounter{appsubsection}[section]
\newcounter{figure}
\newcounter{scheme}
\newcounter{table}

% Form of the numbers
\newcommand\thepage{\arabic{page}}
\renewcommand\thesection{\arabic{section}}
\renewcommand\thesubsection{{\thesection.\arabic{subsection}}}
\renewcommand\thesubsubsection{{\thesubsection.\arabic{subsubsection}}}
\renewcommand\theparagraph{\thesubsubsection.\arabic{paragraph}}
\renewcommand\thesubparagraph{\theparagraph.\arabic{subparagraph}}
\renewcommand\theequation{\arabic{equation}}

% Form of the words
\def\contentsname{Contents}
\def\frenchcontentsname{Table des mati\`eres}

\def\guestname{GUEST EDITORS}
\def\listfigurename{List of Figures}
\def\listtablename{List of Tables}
\def\partname{Part}
\def\appendixname{Appendix}
\def\abstractname{Abstract}
\def\frenchabstractname{R\'{e}sum\'{e}}
\def\refname{References}
\def\frenchrefname{R\'ef\'erences}
\def\bibname{References}
\def\frenchbibname{R\'ef\'erences}
\def\normsname{Norms}
\def\indexname{Index}
\def\figurename{Figure}
\def\frenchfigurename{Figure}
\def\schemename{Scheme}
\def\tablename{Table}
\def\frenchtablename{Tableau}

% Clearemptydoublepage should really clear the running heads too
\newcommand{\clearemptydoublepage}{\newpage{\pagestyle{empty}\cleardoublepage}}


%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Titling Macros %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Reset default command signatures

\def\title{\@ifnextchar[{\@title@wst@}{\@title@nst@}}
\def\@title@wst@[#1]{\titlemark{#1}\@title@assign@}
\def\@title@nst@#1{\titlemark{\@journal@title}\@title@assign@{#1}}
\def\@title@assign@#1{\def\@title{#1}}

\def\author{\@ifnextchar[{\@author@wst@}{\@author@nst@}}
\def\@author@wst@[#1]{\shortauthor{#1}\@author@assign@}
\def\@author@nst@#1{\shortauthor{#1}\@author@assign@{#1}}
\def\@author@assign@#1{\gdef\@author{#1}}

\def\shortauthor#1{\gdef\@shortauthor{#1}}\shortauthor{}

\def\and{\MakeLowercase{and}\space\ignorespaces}

% Ifs for titling commands
\newif\if@supertitle@provided \@supertitle@providedfalse
\newif\if@specialissue@provided \@specialissue@providedfalse
\newif\if@guesteditor@provided \@guesteditor@providedfalse
\newif\if@subtitle@provided \@subtitle@providedfalse
\newif\if@date@provided \@date@providedfalse
\newif\if@dedi@provided \@dedi@providedfalse
\newif\if@classification@provided \@classification@providedfalse
\newif\if@fabstract@provided \@fabstract@providedfalse %%5/7/2004
\newif\if@abstract@provided \@abstract@providedfalse %%5/7/2004
\newif\if@keywords@provided \@keywords@providedfalse
\newif\if@fkeywords@provided \@fkeywords@providedfalse

\def\keywordsname{Keywords}
\def\fkeywordsname{Mots-cl\'{e}s}

\def\date#1{\gdef\@date{#1}\global\@date@providedtrue}
\def\dedi#1{\def\@dedi{#1}\global\@dedi@providedtrue}
\def\keywords#1{\gdef\@keywords{#1}\global\@keywords@providedtrue}
\def\fkeywords#1{\gdef\@fkeywords{#1}\global\@fkeywords@providedtrue}
\def\subtitle#1{\def\@subtitle{{#1}}\global\@subtitle@providedtrue}
\def\supertitle#1{\def\@supertitle{{\noindent #1}}\global\@supertitle@providedtrue}
\def\specialissue#1{\def\@specialissue{{\noindent SPECIAL ISSUE:~#1}}\global\@specialissue@providedtrue}
\def\guesteditor#1{\def\@guesteditor{{\noindent \guestname:~#1}}\global\@guesteditor@providedtrue}
\def\@abbreviations{}
\def\@classification{}
\newcommand\classification[2][Jel Classification]{%
     \global\@classification@providedtrue
     \gdef\@classification{{\leftskip=2pc\rightskip=2pc \noindent\textit{#1}:\enskip #2\par}}}

\newbox\@fabstractbox
\newenvironment{fabstract}{\global\@fabstract@providedtrue%%% 5/7/2004
  \global\setbox\@fabstractbox\vbox\bgroup\fontsize{8}{9.5}\selectfont
  \@afterindentfalse\@afterheading\selectlanguage{francais}}{\par\egroup}%


\newbox\@abstractbox
\newenvironment{abstract}{\global\@abstract@providedtrue%%% 5/7/2004
  \global\setbox\@abstractbox\vbox\bgroup\fontsize{8}{9.5}\selectfont
  \@afterindentfalse\@afterheading\selectlanguage{canadian}}{\par\egroup}%

\def\@fnsymbol#1{\ifcase#1\or *\or \dagger\or \ddagger\or
    \S\or \P\or \|\or **\or \dagger\dagger
    \or \ddagger\ddagger \else\@ctrerr\fi}


\mathchardef\Register="20AE%
\mathchardef\ter="099%
\def\titdagger{\hbox{$\dagger$}}
\def\titddagger{\hbox{$\ddagger$}}
\def\titS{\hbox{$\S$}}
\def\titP{\hbox{$\P$}}

%% Reimplement Titling Layout
\newcommand\maketitle{\par
   \begingroup
%\renewcommand{\@fnsymbol}[1]{\ifcase##1\or \hbox{*}\or \titdagger\or \titddagger\or
%    \titS\or \titP\or \|\or \hbox{**}\or \titdagger\titdagger
%    \or \titddagger\titddagger \else\@ctrerr\fi}
    \thispagestyle{titlepage}%
    \setcounter{footnote}{0}
   % No footnote reference mark for acknowledgements footnote to title
    \renewcommand\thefootnote{}%
  \global\@topnum\z@   % Prevents figures from going at top of page.
    \@maketitle
  \endgroup
  \global\let\author\relax
  \@afterindentfalse
  \@afterheading
  \setcounter{footnote}{0}%
  \global\let\maketitle\relax
  \global\let\@maketitle\relax
}
\def\@maketitle{%
  \vspace*{2.5pt}%
  % Check if necessary information is present:
  \ifx\@journal@title\@default@journal@title
  \ClassError{TandF}{Journal Code not specified. Processing stopped.}
  {The journal code is a required field. Your LaTeX file must contain\MessageBreak
   \protect\journal{JJJJ}, where JJJJ is the four letter journal code.}%
  \fi
     \if@supertitle@provided%
 \vskip8pt
       {\fontsize{14}{16}\fontseries{b}\selectfont\@supertitle\par%
\vspace*{-9pt}
       \noindent\rule{\textwidth}{.5pt}%
\vspace*{6pt}}
    \else
       \vskip6pt%
     \fi
%%%%%%%%%%
  \begingroup%
    {\noindent\fontsize{18}{20}\fontseries{m}\fontshape{it}\mathversion{bold}\centering\selectfont%
      {\@title}%
      \par}%
     \if@subtitle@provided%
       \vspace{20\p@}%
       {\raggedright\fontsize{14}{16}\fontseries{b}\centering\selectfont\itshape\MakeUppercase\@subtitle\par%
        \vspace{21\p@}}%
     \else%
\ifsubmission\else\vspace{21\p@}\fi%
     \fi%
% Insert acknowledgements as footnote with asterisk
  \let\footnote\thanks
  \def\@makefnmark{}
  \@thanks    
%%%%%%%%
    \begingroup%
\ifsubmission\else{\noindent\fontsize{9}{11}\centering\selectfont{\@author}\par}\fi%
    \endgroup%
%%%%%%%%%
     \if@date@provided%
\vspace*{11pt}%
    {\noindent\fontsize{8}{9.5}\fontshape{n}\selectfont\itshape{\@date\ifx\@sub\empty\else Submitted \@sub;\ \fi %
    \ifx\@rev\empty\else \ifx\@sub\empty Revised \@rev;\ \else revised \@rev;\ \fi \fi \ifx\@acc\empty\else \ifx\@fpub\empty accepted \@acc\else accepted \@acc;\ \fi\fi \ifx\@fpub\empty\else first published online \@fpub\fi}\par}%
\vspace{3\p@}%%
     \else
    \vspace{0\p@}%
     \fi
     \if@dedi@provided%
       {\fontsize{8}{10}\fontseries{rm}\selectfont{\@dedi}\par
        \vspace{18.25\p@}}%
     \else
       \vspace{0\p@}%
     \fi
\vskip7pt
\hrule height.3mm depth0pt
\endgroup
%%%%%%%%%%%
\iffrench
\if@fabstract@provided%
\vspace{10pt}
    {\noindent\fontsize{8}{9.5}\selectfont\noindent\centering{{\bfseries\itshape R\'esum\'e}\vskip8pt}\par\unvbox\@fabstractbox\par}%
    \vspace{9.5\p@}%
    \else
       \vspace{0\p@}%
     \fi
\if@fkeywords@provided%
      {\parindent=0pt\fontsize{8}{9}\selectfont
      \textbf{\fkeywordsname~:}\enskip \@fkeywords\par}%
    \vspace{6\p@}%
\else%
       \vspace{0\p@}%
\fi%
\if@abstract@provided%
    {\noindent\fontsize{8}{9.5}\selectfont\noindent\centering{{\bfseries\itshape Abstract}\vskip8pt}\par\unvbox\@abstractbox\par}%
    \vspace{9.5\p@}%
    \else
       \vspace{0\p@}%
     \fi
\if@keywords@provided%
      {\parindent=0pt\fontsize{8}{9}\selectfont
      \textbf{\keywordsname:}\enskip \@keywords\par}%
    \vspace{6\p@}%
\else%
       \vspace{0\p@}%
\fi%
\else
\if@abstract@provided%
\vspace{10pt}
    {\noindent\fontsize{8}{9.5}\selectfont\noindent\centering{{\bfseries\itshape Abstract}\vskip8pt}\par\unvbox\@abstractbox\par}%
    \vspace{9.5\p@}%
    \else
       \vspace{0\p@}%
     \fi
\if@keywords@provided%
      {\parindent=0pt\fontsize{8}{9}\selectfont
      \textbf{\keywordsname:}\enskip \@keywords\par}%
    \vspace{6\p@}%
\else%
       \vspace{0\p@}%
\fi%
\if@fabstract@provided%
    {\noindent\fontsize{8}{9.5}\selectfont\noindent\centering{{\bfseries\itshape R\'esum\'e}\vskip8pt}\par\unvbox\@fabstractbox\par}%
    \vspace{9.5\p@}%
    \else
       \vspace{0\p@}%
     \fi
\if@fkeywords@provided%
      {\parindent=0pt\fontsize{8}{9}\selectfont
      \textbf{\fkeywordsname~:}\enskip \@fkeywords\par}%
    \vspace{6\p@}%
\else%
       \vspace{0\p@}%
\fi%
\fi
    \if@classification@provided
      {\leftskip\z@\parfillskip=\z@ plus1fill%
        \fontsize{8}{9}\selectfont\@classification\par}%
    \fi
  \par
  \ifopenac\enlargethispage{-40pt}\fi
  \vspace{12pt plus 2\p@ minus 2\p@}}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\usepackage{lastpage}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Lastpage %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Last page number - from lastpage.sty
\def\lastpage@putlabel{\addtocounter{page}{-1}%
   \immediate\write\@auxout{\string
   \newlabel{LastPage}{{}{\thepage}}}%
   \addtocounter{page}{1}}
\AtEndDocument{%
   \message{Setting LastPage}%
   \clearpage\lastpage@putlabel}%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%% Sectioning macros %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Lowest level heading that takes a number by default
\setcounter{secnumdepth}{3}

% Reset the default section macros to help with title casing
\def\@sect#1#2#3#4#5#6[#7]#8{%
  \ifnum #2>\c@secnumdepth
    \let\@svsec\@empty
  \else
    \refstepcounter{#1}%
    \protected@edef\@svsec{\@seccntformat{#1}\relax}%
  \fi
  \@tempskipa #5\relax
  \ifdim \@tempskipa>\z@
    \begingroup
      #6{%
        \noindent\@hangfrom{\hskip #3\relax\@svsec}%
          \interlinepenalty \@M
% Modified to uppercase H1's and titlecase the rest
          \ifnum #2>1\relax
             {#8}%
          \else
            {\textsc{#8}}%
          \fi
        \@@par}%
    \endgroup
    \csname #1mark\endcsname{#7}%
    \addcontentsline{toc}{#1}{%
      \ifnum #2>\c@secnumdepth \else
        \protect\numberline{\csname the#1\endcsname}%
      \fi
      #7}%
  \else
    \def\@svsechd{%
      #6{\hskip #3\relax
      \@svsec #8}%
      \csname #1mark\endcsname{#7}%
      \addcontentsline{toc}{#1}{%
        \ifnum #2>\c@secnumdepth \else
          \protect\numberline{\csname the#1\endcsname}%
        \fi
        #7}}%
  \fi
  \@xsect{#5}}

% H1
\def\section{%
\renewcommand{\@seccntformat}[1]{{{\csname the##1\endcsname.\hskip10pt}}}
  \@startsection{section}{1}{\z@}
  {-27\p@ plus -3\p@ minus -3\p@}{2.5\p@}
  {\fontsize{10}{12}\selectfont\bfseries\raggedright\mathversion{bold}}}

% H2
\def\subsection{%
\renewcommand{\@seccntformat}[1]{{{\csname the##1\endcsname\hskip10pt}}}
  \@startsection{subsection}{2}{\z@}
  {-10.5\p@ plus -1\p@ minus -2\p@}{4\p@}
  {\fontsize{10}{12}\selectfont\bfseries\raggedright}}

% H3
\def\subsubsection{%
\renewcommand{\@seccntformat}[1]{{{\csname the##1\endcsname\enskip}}}
  \@startsection{subsubsection}{3}{\z@}
  {-19\p@ plus -1\p@ minus -2\p@}{0.0001\p@}
  {\normalsize\selectfont
    \raggedright}}

\def\paragraph{%
  \@startsection{paragraph}{4}{\z@}
  {-1\@bls plus -1\p@}{-1em}
  {\reset@font\normalfont\normalsize\itshape}}


 % H5
 \def\subparagraph{%
   \@startsection{subparagraph}{5}{\z@}
   {-12\p@ plus -1\p@}{-1em}
   {\indent\reset@font\normalfont\normalsize%\bfseries
   }}

\def\refsection{%
  \@startsection{section}{1}{\z@}
  {-18\p@ plus -2\p@ minus -1\p@}{11\p@}
  {\fontsize{9.5}{11}\selectfont\bfseries\centering}}

\def\appsection{%
  \@startsection{section}{1}{\z@}
  {-24\p@ plus -2\p@ minus -1\p@}{0.0001pt}
  {\fontsize{9.5}{11}\selectfont\bfseries}}

\def\appsections{%
  \@startsection{section}{1}{\z@}
  {-24\p@ plus -2\p@ minus -1\p@}{14pt}
  {\fontsize{9.5}{11}\selectfont\bfseries}}

\def\appsubsection{%
  \@startsection{section}{1}{\z@}
  {-12\p@ plus -2\p@ minus -1\p@}{0.0001\p@}
  {\fontsize{9.5}{11}\selectfont\itshape}}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Footnotes %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\renewcommand\footnoterule{\begingroup\leftskip\z@
\noindent\rule{11pc}{1pt}\vspace{4\p@}\endgroup}

\def\footnotealign{\hskip8pt}

\newcommand\@makefntext[1]{%
\begingroup%
\small
    \parindent 14pt%
    \footnotealign\llap{\hss{\@makefnmark}}#1\par
    \endgroup}%


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% From ifmtarg.sty
% Copyright Peter Wilson and Donald Arseneau, 2000
\begingroup
\catcode`\Q=3
\long\gdef\@ifmtarg#1{\@xifmtarg#1QQ\@secondoftwo\@firstoftwo\@nil}
\long\gdef\@xifmtarg#1#2Q#3#4#5\@nil{#4}
\long\gdef\@ifnotmtarg#1{\@xifmtarg#1QQ\@firstofone\@gobble\@nil}
\endgroup
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%% PostScript Rotation Macros %%%%%%%%%%%%%%%%%%%%%%%%%%%%
\newif\if@rotate \@rotatefalse
\newif\if@rotatecenter \@rotatecenterfalse
\def\rotatecenter{\global\@rotatecentertrue}
\def\rotateendcenter{\global\@rotatecenterfalse}
\def\rotate{\global\@rotatetrue}
\def\endrotate{\global\@rotatefalse}
\newdimen\rotdimen
\def\rotstart#1{\special{ps: gsave currentpoint currentpoint translate
    #1 neg exch neg exch translate}}
\def\rotfinish{\special{ps: currentpoint grestore moveto}}
\def\rotl#1{\rotdimen=\ht#1\advance\rotdimen by \dp#1
    \hbox to \rotdimen{\vbox to\wd#1{\vskip \wd#1
    \rotstart{270 rotate}\box #1\vss}\hss}\rotfinish}
\def\rotr#1{\rotdimen=\ht #1\advance\rotdimen by \dp#1
    \hbox to \rotdimen{\vbox to \wd#1{\vskip \wd#1
    \rotstart{90 rotate}\box #1\vss}\hss}\rotfinish}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%% Figures and Tables %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\newlength{\abovecaptionskip}
\newlength{\belowcaptionskip}
\setlength{\abovecaptionskip}{1.25\p@}
\setlength{\belowcaptionskip}{2\p@}

\usepackage[hypcap]{caption}

\newbox\figurecaptionbox
\long\def\@makecaption#1#2{\vspace{\abovecaptionskip}\par%
  \setbox\figurecaptionbox=\hbox{\fontsize{9}{10}\selectfont
    {\textbf{#1}}\enskip{#2}\par}%
  \ifdim\wd\figurecaptionbox<\hsize
\centerline{\box\figurecaptionbox}
  \else
    \fontsize{9}{10}\selectfont
    \unhbox\figurecaptionbox
    \par
  \fi}

\newbox\schemecaptionbox
\long\def\@schemecaption#1#2{\vspace{\abovecaptionskip}\par%
  \setbox\schemecaptionbox=\hbox{#1\quad #2}%
  \ifdim\wd\schemecaptionbox<\hsize
{\box\schemecaptionbox}
  \else
\fontsize{8}{9}\selectfont
    \unhbox\schemecaptionbox
    \par
  \fi}

\newbox\tablecaptionbox
\long\def\@tablecaption#1#2{\par%
\setbox\tablecaptionbox=\hbox{\fontsize{9}{10}\selectfont
  {\textbf{#1}}\enskip {#2}\par} %
  \ifdim\wd\tablecaptionbox<\hsize%
\centerline{\box\tablecaptionbox}
\vskip3pt
  \else
    \fontsize{9}{10}\selectfont
    \centering{\unhbox\tablecaptionbox}
\vskip3pt
    \par
  \fi}



\def\thefigure{\@arabic\c@figure}
\def\fps@figure{tbp}
\def\ftype@figure{1}
\def\ext@figure{lof}
\def\fnum@figure{{\figurename}\enspace\thefigure\iffrench\,\fi:}
\def\figure{\@float{figure}}
\def\endfigure{\end@float}
\@namedef{figure*}{\@dblfloat{figure}}
\@namedef{endfigure*}{\end@dblfloat}

\def\thescheme{\@arabic\c@scheme}
\def\fps@scheme{h}
\def\ftype@scheme{2}
\def\ext@scheme{los}
\def\fnum@scheme{\MakeUppercase{\schemename}~\thescheme\iffrench\,\fi:}
\def\scheme{\let\@makecaption\@schemecaption\@float{scheme}}
\def\endscheme{\end@float}
\@namedef{scheme*}{\let\@makecaption\@schemecaption\@dblfloat{scheme}}
\@namedef{endscheme*}{\end@dblfloat}

\def\thetable{\@arabic\c@table}
\def\fps@table{tbp}
\def\ftype@table{3}
\def\ext@table{lot}
\def\fnum@table{{\tablename}\enspace\thetable\iffrench\,\fi:}
\def\table{\let\@makecaption\@tablecaption\@float{table}}
\def\endtable{\end@float}
\@namedef{table*}{\let\@makecaption\@tablecaption\@dblfloat{table}}
\@namedef{endtable*}{\end@dblfloat}

\newdimen\tempdime
\newbox\temptbox

\newlength{\abovefigskip}
\newlength{\belowfigskip}
\setlength{\abovefigskip}{\z@}
\setlength{\belowfigskip}{\z@}

\def\toprule{\noalign{\ifnum0=`}\fi
  \hrule \@height 1\p@
  \hrule \@height 2.5\p@ \@width \z@
  \futurelet \@tempa\@xhline}

\def\midrule{\noalign{\ifnum0=`}\fi
  \hrule \@height 3\p@ \@width \z@
  \hrule \@height 0.5\p@
  \hrule \@height 5\p@ \@width\z@
  \futurelet \@tempa\@xhline}

\def\botrule{\noalign{\ifnum0=`}\fi
  \hrule \@height 4\p@ \@width \z@
  \hrule \@height 1\p@
  \hrule \@height 3\p@ \@width \z@
  \futurelet \@tempa\@xhline}

% Table and array parameters
\setlength\arraycolsep{.5em}
\setlength\tabcolsep{.5em}
\setlength\arrayrulewidth{.25pt}
\setlength\doublerulesep{2.5pt}
\renewcommand\arraystretch{1}

\def\hrulefill{\leavevmode\leaders\hrule height .25pt\hfill\kern\z@}

\newcolumntype{P}[1]{>{\raggedright\let\\\@arraycr\hangindent1em}p{#1}}

\newenvironment{processtable}[3]{\setbox\temptbox=\hbox{{\fontsize{9}{10}\selectfont#2\par}}%
\tempdime\wd\temptbox\@processtable{#1}{#2}{#3}{\tempdime}}%
{\relax}

\newenvironment{@processtable}[4]{%
\let\citeauthor\tabciteauthor
\let\citeyear\tabciteyear
\let\cite\tabcite
\let\citealp\tabcitealp
\let\citep\tabcitep
\let\citet\tabcitet
\if!#1!%
\addtocounter{table}{-1}%%ADDED ON 21/12/05
\def\fnum@table{}%
\else%
\def\fnum@table{{\tablename}\enspace\thetable.}%
\fi%
\if@rotate
\setbox4=\vbox to \textwidth{\vss\hbox to \textheight{%
\begin{minipage}{#4}%
{\fontsize{9}{10}\selectfont#2}%
\@ifmtarg{#3}{}{\vskip3pt\noindent
\parbox{#4}{\fontsize{9}{10}\selectfont #3}}%
\caption{#1}
\end{minipage}}\vss}
\else
\setbox4=\hbox to \textwidth{{\hss\begin{minipage}[t]{#4}%
{\fontsize{9}{10}\selectfont{#2}}
\@ifmtarg{#3}{}{\vskip3pt\noindent
\parbox{#4}{\fontsize{9}{10}\selectfont #3}}
\caption{#1}
\end{minipage}\hss}}
\fi
\if@rotate\rotr{4}\else\box4\fi}
{\relax}

\newcommand{\tabhead}[1]{\textit{#1}}%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Lists %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\def\labelenumi{({\rm\arabic{enumi}})}
\def\theenumi{\arabic{enumi}}
\def\labelenumii{{\rm(\alph{enumii})}}
\def\theenumii{\alph{enumii}}
\def\p@enumii{\theenumi}
\def\labelenumiii{{\rm(\arabic{enumiii})}}
\def\theenumiii{\roman{enumiii}}
\def\p@enumiii{\theenumi(\theenumii)}
\def\labelenumiv{{\rm(\arabic{enumiv})}}
\def\theenumiv{\Alph{enumiv}}
\def\p@enumiv{\p@enumiii\theenumiii}
\def\labelitemi{$\bullet$}
\def\labelitemii{$\bullet$}
\def\labelitemiii{$\bullet$}
\def\labelitemiv{$\bullet$}

\setlength{\leftmargini}{21.5pt}
\setlength{\leftmarginii}{25pt}
\setlength{\leftmarginiii}{\z@}
\setlength{\leftmarginiv}{\z@}

\def\enumargs{%
   \partopsep     \z@
   \itemsep       0\p@
   \parsep        \z@
   \leftmargin    0pt
   \rightmargin   \z@
   \labelsep      0em
   \listparindent \z@
   \itemindent    \z@}

\def\enumerate{%
    \@ifnextchar[{\@numerate}{\@numerate[(iii)]}}

\def\@numerate[#1]{%
     \ifnum \@enumdepth >3 \@toodeep\else
     \advance\@enumdepth \@ne
     \edef\@enumctr{enum\romannumeral\the\@enumdepth}
     \list{\csname label\@enumctr\endcsname}{%
       \enumargs
       \setlength{\leftmargin}{\csname leftmargin\romannumeral\the\@listdepth\endcsname}
       \usecounter{\@enumctr}
       \settowidth\labelwidth{#1}
       \addtolength{\leftmargin}{\labelwidth}
       \addtolength{\leftmargin}{\labelsep}
       \def\makelabel##1{\llap{##1}}}%
     \fi
   }
\def\endenumerate{\endlist\advance \@listdepth -1}


\def\romenumargs{%
   \partopsep     \z@
   \itemsep       0\p@
   \parsep        \z@
   \leftmargin    16.5pt
   \rightmargin   \z@
   \labelsep      -0.6em
   \listparindent \z@
   \itemindent    \z@}

\def\romenumerate{%
    \@ifnextchar[{\@numerate}{\@romnumerate[(iii)]}}

\def\@romnumerate[#1]{%
     \ifnum \@enumdepth >3 \@toodeep\else
     \advance\@enumdepth \@ne
     \edef\@enumctr{enum\romannumeral\the\@enumdepth}
     \list{\csname label\@enumctr\endcsname}{%
       \romenumargs
       \setlength{\leftmarginii}{\csname leftmargin\romannumeral\the\@listdepth\endcsname}
       \usecounter{\@enumctr}
       \settowidth\labelwidth{#1}
       \addtolength{\leftmargin}{\labelwidth}
       \addtolength{\leftmargin}{\labelsep}
       \def\makelabel##1{\llap{##1}}}%
     \fi
   }
\def\endromenumerate{\endlist\advance \@listdepth -1}


% Changes to the list parameters for itemize
\def\itemargs{%
   \partopsep     \z@
   \itemsep       0pt
   \parsep        \z@
   \rightmargin   \z@
   \labelsep      1em
   \listparindent \parindent
   \itemindent    \z@}

\def\itemize{%
    \@ifnextchar[{\@itemize}{\@itemize[$\bullet$]}}

\def\@itemize[#1]{%
     \ifnum \@itemdepth >3 \@toodeep\else
     \advance\@itemdepth \@ne
     \edef\@itemctr{item\romannumeral\the\@itemdepth}
     \list{\csname label\@itemctr\endcsname}{%
       \itemargs
       \setlength{\leftmargin}{\csname leftmargin\romannumeral\the\@listdepth\endcsname}
       \settowidth\labelwidth{#1}
       \addtolength{\leftmargin}{\labelwidth}
       \addtolength{\leftmargin}{\labelsep}
       \def\makelabel##1{\hss \llap{##1}}}%
     \fi
   }
\let\enditemize\endlist

\setlength{\topsep}{6\p@}% \@plus 1\p@ \@minus 1\p@}
\setlength{\itemsep}{\z@}

\def\@listI{\leftmargin\leftmargini\topsep6.5\p@ plus 4\p@}
\let\@listi\@listI
\@listi
\def\@listii{\leftmargin\leftmarginii\topsep\z@}
\def\@listiii{\leftmargin\leftmarginiii\topsep\z@}
\def\@listiv{\leftmargin\leftmarginiv\topsep\z@}
\def\@listv{\leftmargin\leftmarginv\topsep\z@}
\def\@listvi{\leftmargin\leftmarginvi\topsep\z@}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% unnumbered list %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\newenvironment{description}{%
  \begin{list}{}{%
      \usecounter{enumi}%
      \setlength{\itemsep}{\z@}%
      \setlength{\labelwidth}{\z@}%
      \setlength{\leftmargin}{2em}%
      \setlength{\itemindent}{-2em}}}%
{\end{list}}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Extracts %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\def\quotation{\par\begin{list}{}{%\fontsize{9}{10}\selectfont%  Extracts in small type
      \setlength{\topsep}{\medskipamount}%
      \setlength{\itemsep}{\z@}%
      \setlength\labelwidth{\z@}%
      \setlength\labelsep{\z@}%
      \setlength\leftmargin{18pt}%
      \setlength\rightmargin{18pt}%
      \listparindent \parindent}%
  \item[\vrule width\z@ height 9\p@]}
\def\endquotation{\end{list}}
\let\quote\quotation
\let\endquote\endquotation
\newcommand{\source}[1]{\newline{\textit{Source}: {\rm #1}}}
\newcommand{\note}[1]{\newline{\textit{Note}: {\rm #1}}}
\newcommand{\notess}[1]{\newline{\textit{Notes}: {\rm #1}}}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% programs %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

{\obeyspaces\global\let =\ }

\newskip\cmskipamount%
\cmskipamount=12pt plus 6pt minus 3pt%

\def\cmskip{\removelastskip\vskip\cmskipamount}

\long\def\bCM{\begingroup\parindent=0pt\cmskip\ttfamily%
\obeylines\obeyspaces}%

\def\eCM{\cmskip\endgroup}%

\long\def\tbCM{\begingroup\parindent=0pt\cmskip%
\obeylines\obeyspaces}%

\def\teCM{\cmskip\endgroup}%


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


\renewcommand{\proofname}{{\textit{Proof}}}

\renewcommand{\qedsymbol}{\ensuremath{\square}}
\renewenvironment{proof}[1][\proofname]{\par
  \if@endproofbox\pushQED{\qed}\fi%
  \normalfont
  \topsep\bigskipamount
  \labelsep=0.5em\relax
  \trivlist
  \item[\quad\hskip\labelsep
        {#1}{\rm\,:}]\ignorespaces
}{%
  \if@endproofbox\popQED\fi
  \endtrivlist\@endpefalse
}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Counter for saving the section numbering depth
\newcounter{savesecnumdepth}

%%%%%%%%%%%%%%%%%%%%%%%%%% Acknowledgments %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\newcommand{\ack}[1][\ackname]{\vskip 4\p@ plus 0\p@ minus 0\p@
\noindent\fontsize{8.5}{10}\selectfont\leftskip9pt%
  \setcounter{savesecnumdepth}{\value{secnumdepth}}%
  \setcounter{secnumdepth}{0}%
  \setcounter{secnumdepth}{\value{savesecnumdepth}}%
}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Notes %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\def\enoteheading{\refsection*{\fontsize{9}{10}\selectfont\itshape \notesname
  \@mkboth{{\notesname}}{{\notesname}}}\vspace*{7pt}%
     \leavevmode\par}

\def\enoteformat{\rightskip\z@ \leftskip\z@\parindent=0pt
     \leavevmode{\hbox{\hskip14pt${\@theenmark}$}.\enskip}}


\newenvironment{notes}[1][99]{%
  \begingroup%
 }%
{\endgroup}%

%%%%%%%%%%%%%%%%%%%%%%%%% Nomenclature %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\providecommand{\nomenname}{Nomenclature}
\newcommand{\nomen}[1][\nomenname]{%
  \setcounter{savesecnumdepth}{\value{secnumdepth}}%
  \setcounter{secnumdepth}{0}%
  \refsection{#1}%
\vspace*{5pt}
  \setcounter{secnumdepth}{\value{savesecnumdepth}}%
}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\newenvironment{thebibliography}[1]{}{}
\usepackage[authoryear]{natbib}

\let\tempcite\cite%
\def\tabcite#1{\setlength{\baselineskip}{9pt}\tempcite{#1}}%

\let\tempciteauthor\citeauthor%
\def\tabciteauthor#1{\setlength{\baselineskip}{9pt}\tempciteauthor{#1}}%

\let\tempciteyear\citeyear%
\def\tabciteyear#1{\setlength{\baselineskip}{9pt}\tempciteyear{#1}}%

\let\tempcitealp\citealp%
\def\tabcitealp#1{\setlength{\baselineskip}{9pt}\tempcitealp{#1}}%

\let\tempcitet\citet%
\def\tabcitet#1{\setlength{\baselineskip}{9pt}\tempcitet{#1}}%

\let\tempcitep\citep%
\def\tabcitep#1{\setlength{\baselineskip}{9pt}\tempcitep{#1}}%



\renewenvironment{thebibliography}[1]{%
  \begingroup
  \fontsize{9}{11}\selectfont
  \setcounter{secnumdepth}{0}
%  \refsection*{\scshape\refname}%
  \iffrench
  	\refsection*{\scshape R\'ef\'erences}
  \else
  	\refsection*{\scshape References}
  \fi
  \begin{list}{}{%
      \usecounter{enumi}%
      \setlength{\labelwidth}{0pt}%
      \setlength{\leftmargin}{16pt}%
      \setlength{\itemindent}{-16pt}
      }}%
{\end{list}\endgroup}



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


\newskip\normskip
\setlength\normskip{6pt}

\newenvironment{normes}{%
  \begingroup
  \footnotesize\parindent=0pt
  \setcounter{secnumdepth}{0}
  \vskip\normskip
  {\fontsize{10}{12}\selectfont\bf\normsname}%
  \begin{list}{}{%
      \usecounter{enumi}%
      \setlength{\itemsep}{\z@}%
      \setlength{\labelwidth}{0pt}%
      \setlength{\leftmargin}{2em}%
      \setlength{\itemindent}{-2em}}}%
{\end{list}\endgroup}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Index %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\newif\if@restonecol
\def\theindex{\@mainmatterfalse
  \@restonecoltrue\if@twocolumn\@restonecolfalse\fi
  \begingroup\parindent \z@
  \addcontentsline{toc}{section}{Index}
  \columnseprule \z@
  \columnsep 1pc\section*{\indexname} %Subject or Author here
  \parskip\z@ plus .3\p@\relax\let\item\idxitem\fontsize{8\p@}{10\p@}\selectfont}
\def\idxitem{\par\raggedright\hangindent 3em}
\def\subitem{\par\penalty1000\raggedright\hangindent 3em\hspace*{1em}}
\def\subsubitem{\par\penalty1000\raggedright\hangindent 3em\hspace*{2em}}
\def\endtheindex{\if@restonecol\endgroup\onecolumn\else\clearpage\fi}
\def\indexspace{\par \vskip 18\p@ plus 12\p@ minus 12\p@\relax}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%% Appendix %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\newif\ifappend % Are we in the Appendix?
\def\appendix{\fontsize{9.5}{11}\selectfont\par
  \setcounter{secnumdepth}{0}
  \renewcommand{\thesection}{\Alph{section}}
  \renewcommand{\@seccntformat}[1]{{\csname
  the##1\endcsname}\quad}
\def\thetable{\thesection\@arabic\c@table}
\def\thefigure{\thesection\@arabic\c@figure}
\renewcommand\theequation{\thesection\arabic{equation}}
        \setcounter{section}{0}
        \setcounter{table}{0}
        \setcounter{equation}{0}
        \setcounter{subsection}{0}
        \appendtrue}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Override settings in MathTime back to TeX defaults
\DeclareMathSizes{5}     {5}   {5}  {5}
\DeclareMathSizes{6}     {6}   {5}  {5}
\DeclareMathSizes{7}     {7}   {5}  {5}
\DeclareMathSizes{8}     {8}   {6}  {5}
\DeclareMathSizes{9}     {9}   {7}  {5}
\DeclareMathSizes{10}   {10}   {7}  {5}
\DeclareMathSizes{12}   {12}   {9}  {7}

%Math parameters
\setlength{\jot}{5\p@}
\skip\@mpfootins = \skip\footins
\fboxsep=6\p@
\fboxrule=.25\p@

\medmuskip=4mu% plus 2mu minus 4mu
\thickmuskip=5mu% plus 5mu

\vbadness=9999
\tolerance=9999
\doublehyphendemerits=10000
\doublehyphendemerits 640000
\finalhyphendemerits  1000000

\flushbottom
\frenchspacing
\onecolumn
\pagestyle{headings}


% Author queries
\fboxsep=4\p@
\fboxrule=0.5\p@

\ifnoquery
\newcommand{\query}[2][0pt]{\marginpar{}}
\def\surname#1{#1}
\else
\definecolor{mag}{cmyk}{0,.36,0,0}
\def\surname#1{\fboxsep=1pt\colorbox{mag}{#1}}%
\newcommand{\query}[2][0pt]{%
  \marginpar{%\vspace*{#1}%
    {\parbox{\marginparwidth}{%
     \raggedright\small{\bf #2}}}}}
\fi

\newenvironment{queries}[1][9.99]{%
  \begingroup
  \thispagestyle{empty}
  \advance\@enumdepth \@ne
  \edef\@enumctr{enum\romannumeral\the\@enumdepth}
  \def\labelenumi{\arabic{enumi})}
  \def\labelenumii{\alph{enumii})}
  \begin{list}{\csname label\@enumctr\endcsname}{%\small%
      \setlength{\topsep}{12\p@}%
    \setlength{\itemsep}{6\p@}%
      \setlength{\leftmargin}{\z@}%
      \settowidth{\labelwidth}{\bfseries#1}%
      \setlength{\labelsep}{1.5em}%
      \addtolength{\leftmargin}{\labelwidth}%
      \addtolength{\leftmargin}{\labelsep}
      \def\makelabel##1{\hss\llap{{##1}}}
    }}
{\end{list}\endgroup}

% Short-form coding
\newcommand\tetal{{{\rm et~al.}}}
\newcommand\etal{\textit{et~al.}}
\newcommand\eg{\textit{e.g.}}
\newcommand\ie{\textit{i.e.}}
\let\endash\textendash

\def\dbond{\raise0.18ex\hbox{$=$}}
\def\bond{\raise0.18ex\hbox{$-$}}

\def\endash{--}
\def\emdash{\,--\,}
\def\sdot#1{{\buildrel{\scriptscriptstyle\bullet}\over{\hbox{$#1$}}}}
\def\ssdot#1{{\buildrel{\scriptscriptstyle\bullet\bullet}\over{\hbox{$#1$}}}}

\def\refmsg{\noindent\hangindent=1em}%

\def\z{\phantom}

\hyphenation{Table}
\hyphenation{Figure}
\hyphenation{Section}
\hyphenation{equation}
\hyphenation{Theorem}
\hyphenation{Lemma}
\hyphenation{Algorithm}
\hyphenation{Definition}
\hyphenation{Corollary}
\hyphenation{Proof}
\hyphenation{Remark}

\def\bcontinued{({\it continued\/})}
\def\tcontinued{Continued}

\def\dd{{\rm d}}
\def\ee{{\rm e}}
\def\cir#1{{\accent"17 #1}}

\newdimen\p@renwd

\def\spbordermatrix#1{\begingroup \m@th
  \setbox\z@\vbox{\def\cr{\crcr\noalign{\kern2\p@\global\let\cr\endline}}%
    \ialign{$##$\hfil\kern2\p@\kern\p@renwd&\thinspace\hfil$##$\hfil
      &&\quad\hfil$##$\hfil\crcr
      \omit\strut\hfil\crcr\noalign{\kern-\baselineskip}%
      #1\crcr\omit\strut\cr}}%
  \setbox\tw@\vbox{\unvcopy\z@\global\setbox\@ne\lastbox}%
  \setbox\tw@\hbox{\unhbox\@ne\unskip\global\setbox\@ne\lastbox}%
  \setbox\tw@\hbox{$\kern\wd\@ne\kern-\p@renwd\left[\kern-\wd\@ne
    \global\setbox\@ne\vbox{\box\@ne\kern2\p@}%
    \vcenter{\kern-\ht\@ne\unvbox\z@\kern-\baselineskip}\,\hskip-\bmskip\right]$}%
  \null\;\vbox{\kern\ht\@ne\box\tw@}\endgroup}


\def\sqbordermatrix#1{\begingroup \m@th
  \setbox\z@\vbox{\def\cr{\crcr\noalign{\kern2\p@\global\let\cr\endline}}%
    \ialign{$##$\hfil\kern2\p@\kern\p@renwd&\thinspace\hfil$##$\hfil
      &&\quad\hfil$##$\hfil\crcr
      \omit\strut\hfil\crcr\noalign{\kern-\baselineskip}%
      #1\crcr\omit\strut\cr}}%
  \setbox\tw@\vbox{\unvcopy\z@\global\setbox\@ne\lastbox}%
  \setbox\tw@\hbox{\unhbox\@ne\unskip\global\setbox\@ne\lastbox}%
  \setbox\tw@\hbox{$\kern\wd\@ne\kern-\p@renwd\left[\kern-\wd\@ne
    \global\setbox\@ne\vbox{\box\@ne\kern2\p@}%
    \vcenter{\kern-\ht\@ne\unvbox\z@\kern-\baselineskip}\,\right]$}%
  \null\;\vbox{\kern\ht\@ne\box\tw@}\endgroup}

\def\llbordermatrix#1{\begingroup \m@th
  \setbox\z@\vbox{\def\cr{\crcr\noalign{\kern2\p@\global\let\cr\endline}}%
    \ialign{$##$\hfil\kern2\p@\kern\p@renwd&\thinspace\hfil$##$\hfil
      &&\quad\hfil$##$\hfil\crcr
      \omit\strut\hfil\crcr\noalign{\kern-\baselineskip}%
      #1\crcr\omit\strut\cr}}%
  \setbox\tw@\vbox{\unvcopy\z@\global\setbox\@ne\lastbox}%
  \setbox\tw@\hbox{\unhbox\@ne\unskip\global\setbox\@ne\lastbox}%
  \setbox\tw@\hbox{$\kern\wd\@ne\kern-\p@renwd\left[\kern-\wd\@ne
    \global\setbox\@ne\vbox{\box\@ne\kern2\p@}%
    \vcenter{\kern-\ht\@ne\unvbox\z@\kern-\baselineskip}\,\right.$}%
  \null\;\vbox{\kern\ht\@ne\box\tw@}\endgroup}

\def\lbordermatrix#1{\begingroup \m@th
  \setbox\z@\vbox{\def\cr{\crcr\noalign{\kern2\p@\global\let\cr\endline}}%
    \ialign{$##$\hfil\kern2\p@\kern\p@renwd&\thinspace\hfil$##$\hfil
      &&\quad\hfil$##$\hfil\crcr
      \omit\strut\hfil\crcr\noalign{\kern-\baselineskip}%
      #1\crcr\omit\strut\cr}}%
  \setbox\tw@\vbox{\unvcopy\z@\global\setbox\@ne\lastbox}%
  \setbox\tw@\hbox{\unhbox\@ne\unskip\global\setbox\@ne\lastbox}%
  \setbox\tw@\hbox{$\left[\kern\wd\@ne\kern-\p@renwd\kern-\wd\@ne
    \global\setbox\@ne\vbox{\box\@ne\kern2\p@}%
    \vcenter{\kern-\ht\@ne\unvbox\z@\kern-\baselineskip}\,\right.$}%
  \null\;\vbox{\kern\ht\@ne\box\tw@}\endgroup}

\newdimen\bmskip
\bmskip=0pt

\def\rbordermatrix#1{\begingroup \m@th
  \setbox\z@\vbox{\def\cr{\crcr\noalign{\kern2\p@\global\let\cr\endline}}%
    \ialign{\hfil$##$\hfil\kern6\p@\kern\p@renwd&\thinspace\hfil$##$\hfil
      &&\quad\hfil$##$\hfil\crcr
      \omit\strut\hfil\crcr\noalign{\kern-\baselineskip}%
      #1\crcr\omit\strut\cr}}%
  \setbox\tw@\vbox{\unvcopy\z@\global\setbox\@ne\lastbox}%
  \setbox\tw@\hbox{\unhbox\@ne\unskip\global\setbox\@ne\lastbox}%
  \setbox\tw@\hbox{$\left.\kern\wd\@ne\kern-\p@renwd\kern-\wd\@ne
    \global\setbox\@ne\vbox{\box\@ne\kern2\p@}
    \vcenter{\kern-\ht\@ne\unvbox\z@\kern-\baselineskip}\hskip-\bmskip\right]$}%
  \null\;\vbox{\kern\ht\@ne\box\tw@}\endgroup}

\chardef\permil="89%

\newtheorem{mythm}{mythm}[section]

\usepackage{textcomp}
\let\euro\texteuro

\def\corr{{\vskip5pt $^{\ast}$\ Corresponding author}}

\usepackage{marginnote}

\definecolor{mag}{cmyk}{0,.36,0,0}

\ifprinter
\usepackage[breaklinks]{hyperref}
\hypersetup{
    colorlinks,%
    citecolor=black,%
    filecolor=black,%
    linkcolor=black,%
    urlcolor=black
}
\else
\setcounter{tocdepth}{4}
\usepackage[bookmarksnumbered,breaklinks]{hyperref}
\hypersetup{
    colorlinks,%
    citecolor=blue,%
    filecolor=blue,%
    linkcolor=blue,%
    urlcolor=blue
}
\fi

% Don't set URLs in monospaced font:
\urlstyle{same}

\usepackage{authblk-modified}

\iffrench
	\def\email#1{\par\href{mailto:#1}{Courriel: #1}}
\else
	\def\email#1{\par\href{mailto:#1}{Email: #1}}
\fi

\def\name#1{{\noindent\fontsize{10}{11}\centering\selectfont#1\par\vspace{2.5\p@}}}

\def\@journal@title{Canadian Journal of Linguistics/Revue canadienne de linguistique \issue@info(\vol@info): \page@extent@info} 

\def\@print@issn{0269-9648/11}
\def\@doi@fixed@field{10.1017/S1355770X}
\def\@doi@variable@field{00000000000000000000}
\def\jourinf{Vol.~\vol@info, No.~\issue@info, \month@info\space \year@info, \page@extent@info}

\renewcommand{\copyright@line}{\textcopyright\ \year@info\ Cambridge University Press}

\newcommand{\titlepagefootline}{%
  \vbox to 2\baselineskip{%
    \hbox to \textwidth{%
      \parbox{\textwidth}{%                   <- textwidth minus logo width
  \fontsize{8}{9}\selectfont
        \hbox to \textwidth{The online version of this article is published within an Open Access environment}
\hbox to \textwidth{subject to the conditions of the Creative Commons Attribution licence http://}
\hbox to \textwidth{creativecommons.org/licenses/by/3.0/}}}}}

\Year{2016}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\newcommand\T{\rule{0pt}{2.6ex}}            % = `top' strut
\newcommand\B{\rule[-1.2ex]{0pt}{0pt}}      % = `bottom' strut

\let\Top=\T

\def\Prime{{$^{\scriptscriptstyle\prime}$}} %% old: \scriptstyle

\def\diatop[#1|#2]{\leavevmode{\setbox1=\hbox{{#1{}}}%
                     \setbox2=\hbox{{#2{}}}%
                     \dimen0=\ifdim\wd1>\wd2\wd1\else\wd2\fi%
                     \dimen1=\ht2\advance\dimen1by-1ex%
                     \setbox1=\hbox to1\dimen0{\hss#1\hss}%
                     \rlap{\raise1\dimen1\box1}%
                     \hbox to1\dimen0{\hss#2\hss}}}%
 
%% Dotless-j solution (courtesy Michael Doob):
\setbox0=\hbox{\i} % We want to know the height of a dotless i
\setbox1=\hbox{j}  % We also want to know the width of a j

% We make a special strut: it has the height of a dotless i
% the width of a j and depth set so that it is invisible.
% We will put an accent over it and TeX will position that
% accent as if it were over a dotless j.
\def\specialstrut{\vrule height \ht0 width \wd1 depth -\ht0}
 
% Now we make the dotless j. We print a j and follow by printing
% an opaque square on top of the dot.
\def\dotlessj{%
   \hbox{\rlap{j}}% First print the j but don't move the basepoint
   \special{" gsave newpath % dvips notation for literal PostScript
   /squaresize 1 def %the size of the opaque square in big points
   1.18 7.05 moveto % horizontal and vertical displacement of lower left
               % corner of the square necessary to cover the dot
   squaresize 0 rlineto 0 squaresize rlineto
   squaresize neg 0 rlineto closepath % construct the square
   1 setgray fill % fill it with white (0 setgray would be black)
   grestore}}

%% Dotless-j:
\def\Dj{{\kern.03em\dotlessj}}

%% Dotless-j with hacek for 12pt version:
\def\Djh{\kern.036em{\dotlessj\v\specialstrut}\kern-.275em}

%% for 10pt/9pt version (different /squaresize values):
\def\Dotlessj{%
   \hbox{\rlap{j}}% First print the j but don't move the basepoint
   \special{" gsave newpath % dvips notation for literal PostScript
   /squaresize 1 def %the size of the opaque square in big points
   .75 6 moveto % horizontal and vertical displacement of lower left
                % corner of the square necessary to cover the dot
   squaresize 0 rlineto 0 squaresize rlineto
   squaresize neg 0 rlineto closepath % construct the square
   1 setgray fill % fill it with white (0 setgray would be black)
   grestore}}

\def\DJH{\kern.036em{\Dotlessj\v\specialstrut}\kern-.275em}

\newcommand{\alternate}{{\smallsym\char'030}}  %%  3 NOV 11

%% New macros for use in glossed examples, via the following \def:
%%           \def\{{\sc }\spacefactor = 1000 } 

\def\ABL{{\sc abl}\spacefactor = 1000 }      %% Knittle (54,2)
\def\ABS{{\sc abs}\spacefactor = 1000 }      %% 10 APR 07
\def\ACC{{\sc acc}\spacefactor = 1000 } 
\def\ADJ{{\sc adj}\spacefactor = 1000 }      %% 16 JUL 09
\def\AG{{\sc ag}\spacefactor = 1000 }        %%  2 JUN 06
\def\AGR{{\sc agr}\spacefactor = 1000 } 
\def\ANIM{{\sc anim}\spacefactor = 1000 }    %% 26 JUN 03
\def\AOR{{\sc aor}\spacefactor = 1000 }      %% 20 JUL 04 
\def\AP{{\sc ap}\spacefactor = 1000 }        %% 30 JUN 10
\def\ARB{{\sc arb}\spacefactor = 1000 }      %% 28 APR 08
\def\ARG{{\sc arg}\spacefactor = 1000 }      %% 24 APR 07
\def\ART{{\sc art}\spacefactor = 1000 }      %% 24 MAY 07
\def\ASP{{\sc asp}\spacefactor = 1000 } 
\def\ASS{{\sc ass}\spacefactor = 1000 }      %% 20 FEB 09
\def\Atr{{\sc Atr}\spacefactor = 1000 }      %% Akinlabi (54,2)
\def\AUG{{\sc aug}\spacefactor = 1000 }      %% 10 APR 07
\def\AUX{{\sc aux}\spacefactor = 1000 } 
\def\AV{{\sc av}\spacefactor = 1000 }        %% 29 DEC 10
\def\BEN{{\sc ben}\spacefactor = 1000 }      %% 12 APR 07
\def\CAU{{\sc cau}\spacefactor = 1000 }      %% 20 FEB 09
\def\CAUS{{\sc caus}\spacefactor = 1000 }    %% 22 MAR 07
\def\CJ{{\sc cj}\spacefactor = 1000 }        %% Wolfart (55,1)
\def\CL{{\sc cl}\spacefactor = 1000 }        %% 13 DEC 02
\def\CLS{{\sc cls}\spacefactor = 1000 }      %% 24 APR 07
\def\CLEFT{{\sc cleft}\spacefactor = 1000 } 
\def\CNST{{\sc cnst}\spacefactor = 1000 } 
\def\COMP{{\sc comp}\spacefactor = 1000 } 
\def\COND{{\sc cond}\spacefactor = 1000 } 
\def\CONJ{{\sc conj}\spacefactor = 1000 }    %% 27 SEP 10
\def\CONT{{\sc cont}\spacefactor = 1000 }    %%  8 JUN 06
\def\COP{{\sc cop}\spacefactor = 1000 } 
\def\CP{{\sc cp}\spacefactor = 1000 }        %% 18 APR 11
\def\DAT{{\sc dat}\spacefactor = 1000 }      %%  2 JUN 98
\def\DEF{{\sc def}\spacefactor = 1000 }      %% 26 JUN 03
\def\DEIC{{\sc deic}\spacefactor = 1000 }    %% 22 MAR 07
\def\DEM{{\sc dem}\spacefactor = 1000 }      %% 26 JUN 03
\def\DET{{\sc det}\spacefactor = 1000 }      %% 28 JAN 98
%% 15 JAN 98: tallerman article: change \sc to small:
%%            \def\ECM{{\sc ecm}\spacefactor = 1000 } 
\def\DIM{{\sc dim}\spacefactor = 1000 }      %% 20 JUL 04
\def\DIST{{\sc dist}\spacefactor = 1000 }    %%  2 JUL 03
\def\DISTRIB{{\sc distrib}\spacefactor = 1000 } %% 24 APR 07
\def\DP{{\sc dp}\spacefactor = 1000 }        %% Knittle (54,2)
\def\DUP{{\sc dup}\spacefactor = 1000 }      %% 24 APR 07
\def\DUR{{\sc dur}\spacefactor = 1000 }      %% 22 MAR 07
\def\EC{{\sc ec}\spacefactor = 1000 }        %% Knittle (54,2)
\def\ECM{{\small ECM}\spacefactor = 1000 } 
\def\ECP{{\small ECP}\spacefactor = 1000 } 
\def\EMPH{{\sc emph}\spacefactor = 1000 } 
\def\ERG{{\sc erg}\spacefactor = 1000 } 
\def\EV{{\sc ev}\spacefactor = 1000 } 
\def\EX{{\sc ex}\spacefactor = 1000 }        %%  2 JUN 06
\def\F{{\sc f}\spacefactor = 1000 }          %% 17 APR 02
\def\FEM{{\sc fem}\spacefactor = 1000 }      %% 28 JAN 98
\def\FF{{\sc ff}\spacefactor = 1000 }        %% 14 OCT 08
\def\FOC{{\sc foc}\spacefactor = 1000 }      %% 14 APR 07
\def\FP{{\sc fp}\spacefactor = 1000 }        %% Knittle (54,2)
\def\FUT{{\sc fut}\spacefactor = 1000 } 
\def\GEN{{\sc gen}\spacefactor = 1000 } 
\def\GRAD{{\sc grad}\spacefactor = 1000 }    %% 24 APR 07
\def\HAB{{\sc hab}\spacefactor = 1000 } 
\def\HUM{{\sc hum}\spacefactor = 1000 }      %%  8 JUN 06
\def\IMPER{{\sc imper}\spacefactor = 1000 } 
\def\IMP{{\sc imp}\spacefactor = 1000 } 
\def\IMPF{{\sc impf}\spacefactor = 1000 } 
\def\IMPS{{\sc imps}\spacefactor = 1000 } 
\def\INESSIF{{\sc inessif}\spacefactor = 1000 }    %% Knittle (54,2)
\def\IMV{{\sc imv}\spacefactor = 1000 }      %% Wolfart (55,1)
\def\INAL{{\sc inal}\spacefactor = 1000 }    %% 22 MAR 07
\def\INAN{{\sc inan}\spacefactor = 1000 }    %% 26 JUN 03
\def\INC{{\sc inc}\spacefactor = 1000 }      %% 24 APR 07
\def\IND{{\sc ind}\spacefactor = 1000 }      %% 24 JUL 98
\def\INDEF{{\sc indef}\spacefactor = 1000 }  %% 26 JUN 03
\def\INDEP{{\sc indep}\spacefactor = 1000 }  %%  8 APR 04
\def\INF{{\sc inf}\spacefactor = 1000 } 
\def\INFL{{\sc infl}\spacefactor = 1000 } 
\def\INSTR{{\sc instr}\spacefactor = 1000 }  %% 30 MAY 06
\def\INT{{\sc int}\spacefactor = 1000 }      %% 26 JUN 03
\def\INTENT{{\sc intent}\spacefactor = 1000 } %% 24 APR 07
\def\INTRANS{{\sc intrans}\spacefactor = 1000 } %%  7 MAY 04
\def\IREL{{\sc irel}\spacefactor = 1000 }    %% 22 MAR 07; 
                                             %% 20 APR 07: i.rel --> irel
\def\ITER{{\sc iter}\spacefactor = 1000 }    %% 11 APR 07
\def\ITS{{\sc its}\spacefactor = 1000 }      %%  8 JUN 06
\def\KP{{\sc kp}\spacefactor = 1000 }        %% Knittle (54,2)
\def\LOC{{\sc loc}\spacefactor = 1000 } 
\def\M{{\sc m}\spacefactor = 1000 } 
\def\MASC{{\sc masc}\spacefactor = 1000 }    %% 28 JAN 98
\def\MASSIF{{\sc massif}\spacefactor = 1000 }    %% Knittle (54,2)
\def\MC{{\sc mc}\spacefactor = 1000 }        %% 24 APR 07
\def\MOM{{\sc mom}\spacefactor = 1000 }      %% 24 APR 07
\def\MID{{\sc mid}\spacefactor = 1000 }      %% 20 FEB 09
\def\NEG{{\sc neg}\spacefactor = 1000 } 
\def\NOM{{\sc nom}\spacefactor = 1000 } 
\def\NOML{{\sc noml}\spacefactor = 1000 }    %%  2 JUN 06
\def\NONHUM{{\sc non.hum}\spacefactor = 1000 } %%  2 JUN 06; 
                                             %% 31 JUL 06: - -> .
\def\NOW{{\sc now}\spacefactor = 1000 }      %% 24 APR 07
\def\NP{{\sc np}\spacefactor = 1000 } 
\def\NUM{{\sc num}\spacefactor = 1000 }      %% 23 SEP 08 
\def\OBJ{{\sc obj}\spacefactor = 1000 }      %%  8 APR 04
\def\OBL{{\sc obl}\spacefactor = 1000 }      %%  5 MAY 04
\def\OP{{\sc op}\spacefactor = 1000 }        %% 14 OCT 08
\def\OREL{{\sc orel}\spacefactor = 1000 }    %% 23 SEP 08 
\def\PART{{\sc part}\spacefactor = 1000 } 
\def\PASS{{\sc pass}\spacefactor = 1000 } 
\def\PAST{{\sc past}\spacefactor = 1000 } 
\def\PER{{\sc per}\spacefactor = 1000 }      %% 23 SEP 08 
\def\PERF{{\sc perf}\spacefactor = 1000 } 
\def\PHON{{\sc phon}\spacefactor = 1000 }    %% 20 OCT 08
\def\PL{{\sc pl}\spacefactor = 1000 } 
\def\PLUP{{\sc plup}\spacefactor = 1000 }    %% LeBlanc (54,2)
\def\PP{{\sc pp}\spacefactor = 1000 }        %% Knittle (54,2)
\def\POSS{{\sc poss}\spacefactor = 1000 } 
\def\PRED{{\sc pred}\spacefactor = 1000 }    %% 14 OCT 08
\def\PREP{{\sc prep}\spacefactor = 1000 }    %% Knittle (54,2)
\def\PRES{{\sc pres}\spacefactor = 1000 } 
\def\PRET{{\sc pret}\spacefactor = 1000 }    %% 17 APR 02
%% 15 JAN 98: tallerman article: change \sc to \small:
%%            \def\PRO{{\sc pro}\spacefactor = 1000 } 
\def\PRO{{\small PRO}\spacefactor = 1000 }   %% 15 JAN 98: 
\def\scPRO{{\sc pro}\spacefactor = 1000 }    %%  3 JAN 11: reinstated a
                                             %%  sc version
\def\PROB{{\sc prob}\spacefactor = 1000 }    %% 13 JUN 07
\def\PROG{{\sc prog}\spacefactor = 1000 } 
\def\PRON{{\sc pron}\spacefactor = 1000 }    %% 28 OCT 08 (pronoun)
\def\PROX{{\sc prox}\spacefactor = 1000 }    %%  2 JUL 03
\def\PRC{{\sc prc}\spacefactor = 1000 } 
\def\PRT{{\sc prt}\spacefactor = 1000 } 
\def\PS{{\sc ps}\spacefactor = 1000 }        %% 10 APR 07
\def\PSM{{\sc psm}\spacefactor = 1000 }      %% 22 MAR 07
\def\PSR {{\sc psr}\spacefactor = 1000 }     %% 22 MAR 07
%% 20 APR 07: removed:
%% \def\PST {{\sc pst}\spacefactor = 1000 }     %% 22 MAR 07
\def\PV{{\sc pv}\spacefactor = 1000 }        %% 29 DEC 10
\def\Q{{\sc q}\spacefactor = 1000 } 
\def\QUES{{\sc ques}\spacefactor = 1000 }    %% 26 APR 10
\def\QUOT{{\sc quot}\spacefactor = 1000 }    %% 22 MAR 07
\def\RC{{\sc rc}\spacefactor = 1000 }        %% 11 APR 07
\def\RED{{\sc red}\spacefactor = 1000 }      %% 22 MAR 07
\def\REF{{\sc ref}\spacefactor = 1000 }      %% 24 APR 07
\def\REFL{{\sc refl}\spacefactor = 1000 } 
\def\REL{{\sc rel}\spacefactor = 1000 }      %% 22 MAR 07 
\def\REP{{\sc rep}\spacefactor = 1000 }      %% 24 APR 07
\def\SBJ{{\sc sbj}\spacefactor = 1000 } 
\def\SG{{\sc sg}\spacefactor = 1000 } 
\def\SGM{{\sc sgm}\spacefactor = 1000 } 
\def\SREL{{\sc srel}\spacefactor = 1000 }    %% 23 SEP 08 
\def\SS{{\sc ss}\spacefactor = 1000 }        %%  8 APR 04
\def\SUB{{\sc sub}\spacefactor = 1000 }      %% 10 APR 07
\def\SUFRED{{\sc suf.red}\spacefactor = 1000 } %% 21 JUN 07 %% old: 24 APR 07
\def\SUBJ{{\sc subj}\spacefactor = 1000 } 
\def\SUBSUBJ{{\sc sub.subj}\spacefactor = 1000 } %%  7 MAY 04
\def\SW{{\sc sw}\spacefactor = 1000 }        %% 24 APR 07
\def\T{{\sc t}\spacefactor = 1000 }          %% Knittle (54,2)
\def\TEMP{{\sc temp}\spacefactor = 1000 }    %% 22 MAR 07
\def\THEM{{\sc th}\spacefactor = 1000 }      %% Knittle (54,2)
\def\TOP{{\sc top}\spacefactor = 1000 }      %% 13 DEC 02
\def\TRAN{{\sc tran}\spacefactor = 1000 }    %% Knittle (54,2)
\def\TRANS{{\sc trans}\spacefactor = 1000 }  %%  8 APR 04
\def\VN{{\sc vn}\spacefactor = 1000 } 
\def\VOC{{\sc voc}\spacefactor = 1000 }      %% 24 APR 07
\def\WH{{\sc wh}\spacefactor = 1000 }        %%  2 JUN 06


%%  \def\{{\small }\spacefactor = 1000 } 

\def\GPSG{{\small GPSG}\spacefactor = 1000 } 
\def\SVO{{\small SVO}\spacefactor = 1000 } 
\def\SOV{{\small SOV}\spacefactor = 1000 } 
\def\VOS{{\small VOS}\spacefactor = 1000 } 
\def\VSO{{\small VSO}\spacefactor = 1000 } 

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\endinput
