%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% NAV AUTHOR TEMPLATE                                                             %
% Version: 1.0                                                                 %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\newcommand\classname{NAV}
\newcommand\lastmodifieddate{2019/03/01}
\newcommand\versionnumber{1.0}

% Are we printing crop marks?
\newif\if@cropmarkson \@cropmarksontrue

\NeedsTeXFormat{LaTeX2e}[2019/03/01]
\ProvidesClass{\classname}[\lastmodifieddate\space (C) 2019 Nova Techset Composition Pvt. Ltd.^^J^^J]

\setlength{\paperheight}{247mm}
\setlength{\paperwidth}{174mm}

\newif\if@numberedref \@numberedreftrue
\newif\if@endproofbox \@endproofboxtrue
\newif\ifnumbib

\DeclareOption{numbib}{\numbibtrue}
\DeclareOption{draft}{\PassOptionsToPackage{draft}{graphicx}}
\DeclareOption{a4paper}{\PassOptionsToPackage{a4}{crop}}
\DeclareOption{centre}{\PassOptionsToPackage{center}{crop}}
\DeclareOption{crop}{\PassOptionsToPackage{cam}{crop}\global\@cropmarksontrue}
\DeclareOption{nocrop}{\PassOptionsToPackage{off}{crop}\global\@cropmarksonfalse}
\DeclareOption{info}{\PassOptionsToPackage{info}{crop}}
\DeclareOption{noinfo}{\PassOptionsToPackage{noinfo}{crop}}
\DeclareOption{noproofbox}{\global\@endproofboxfalse}
\DeclareOption{proofbox}{\global\@endproofboxtrue}

\DeclareOption{cmfonts}{\let\CJ@fonts\relax}

\ExecuteOptions{a4paper,nocrop,centre,info,proofbox}

\ProcessOptions

%Load all necessary packages
\RequirePackage[T1]{fontenc}
\RequirePackage{crop,graphicx,array,amsmath,amsthm,amssymb,amsfonts,upref,endnotes,rotating}
\RequirePackage{color}
\usepackage{times}

\newcommand\@ptsize{0}

\@twosidetrue

\@mparswitchtrue

% Default font sizes
\renewcommand\normalsize{%
  \@setfontsize\normalsize{10\p@}{12\p@}%
  \abovedisplayskip 10\p@ \@plus 3\p@ \@minus4\p@
  \abovedisplayshortskip 3\p@ \@plus 3\p@ \@minus1\p@
  \belowdisplayshortskip 6\p@ \@plus 3\p@ \@minus2\p@
  \belowdisplayskip \abovedisplayskip
  \let\@listi\@listI}
\normalsize
\let\@bls\baselineskip

\newcommand\small{%
  \@setfontsize\small{9\p@}{11\p@}%
  \abovedisplayskip 6\p@ \@plus1\p@ \@minus1\p@
  \abovedisplayshortskip 3\p@ \@plus 2\p@ \@minus1\p@
  \belowdisplayshortskip 2\p@ \@plus 1\p@ \@minus1\p@
  \def\@listi{\leftmargin\leftmargini
              \listparindent \parindent
              \topsep 6\p@ \@plus2\p@ \@minus1\p@
              \parsep \z@ \itemsep \z@}%
  \belowdisplayskip \abovedisplayskip}

\newcommand\footnotesize{%
  \@setfontsize\footnotesize{8\p@}{9\p@}%
  \abovedisplayskip 6\p@ \@plus2\p@ \@minus4\p@
  \abovedisplayshortskip \z@ \@plus \p@
  \belowdisplayshortskip 1\p@ \@plus2\p@ \@minus2\p@
  \def\@listi{\leftmargin\leftmargini
              \listparindent 1em
              \topsep 5\p@ \@plus 2\p@ \@minus 1\p@
              \parsep \z@ \itemsep \z@}%
  \belowdisplayskip \abovedisplayskip}


\def\scriptsize{\@setfontsize\scriptsize{7\p@}{9\p@}}
\def\tiny{\@setfontsize\tiny{6\p@}{7\p@}}
\def\little{\@setfontsize\little{5\p@}{6\p@}}
\def\large{\@setfontsize\large{12\p@}{14\p@}}
\def\Large{\@setfontsize\Large{14\p@}{16\p@}}
\def\LARGE{\@setfontsize\LARGE{16\p@}{18\p@}}
\def\huge{\@setfontsize\huge{24\p@}{26\p@}}
\def\Huge{\@setfontsize\Huge{25\p@}{27\p@}}

\DeclareOldFontCommand{\rm}{\normalfont\rmfamily}{\mathrm}
\DeclareOldFontCommand{\sf}{\normalfont\sffamily}{\mathsf}
\DeclareOldFontCommand{\tt}{\normalfont\ttfamily}{\mathtt}
\DeclareOldFontCommand{\bf}{\normalfont\bfseries}{\mathbf}
\DeclareOldFontCommand{\it}{\normalfont\itshape}{\mathit}
\DeclareOldFontCommand{\sl}{\normalfont\slshape}{\@nomath\sl}
\DeclareOldFontCommand{\sc}{\normalfont\scshape}{\@nomath\sc}

% Line spacing
\setlength\lineskip{1\p@}
\setlength\normallineskip{1\p@}
\renewcommand\baselinestretch{}

% Paragraph dimensions and inter-para spacing
\setlength\parskip{0\p@}
\setlength\parindent{12pt}

% Set inter-para skips
\setlength\smallskipamount{3\p@ \@plus 1\p@ \@minus 1\p@}
\setlength\medskipamount{6\p@ \@plus 2\p@ \@minus 2\p@}
\setlength\bigskipamount{12\p@ \@plus 4\p@ \@minus 4\p@}

% Page break penalties
\@lowpenalty   51
\@medpenalty  151
\@highpenalty 301

% Disallow widows and orphans
\clubpenalty 10000
\widowpenalty 10000

% Disable page breaks before equations, allow pagebreaks after
% equations and discourage widow lines before equations.
\displaywidowpenalty 100
\predisplaypenalty   10000
\postdisplaypenalty  2500

% Allow breaking the page in the middle of a paragraph
\interlinepenalty 0

% Disallow breaking the page after a hyphenated line
\brokenpenalty 10000

% Hyphenation; don't split words into less than three characters
\lefthyphenmin=3
\righthyphenmin=3

% Set page layout dimensions

\setlength\headheight{7\p@}          % height of running head
\setlength\topmargin{12mm}            % top margin 3pc, 9pt
\addtolength\topmargin{8\p@}         %
\addtolength\topmargin{-1in}         % subtract out the 1 inch driver margin

\setlength\topskip{8\p@}            % height of first line of text%% {10\p@}
\setlength\headsep{24\p@}          % space below running head --
\addtolength\headsep{-\topskip}      %   base to base with first line of text

\setlength\footskip{22.5\p@}           % space above footer line
\setlength\maxdepth{.5\topskip}      % pages can be short or deep by half a line?

\setlength\textwidth{127mm}           % text measure excluding margins

\setlength\textheight{46\@bls}       % text height of 47pc,
\addtolength\textheight{\topskip}    %  - including first line of text

% Set the margins
\setlength\marginparsep{6\p@}
\setlength\marginparpush{8\p@}
\setlength\marginparwidth{1pc}

\setlength\oddsidemargin{17mm}%
\addtolength\oddsidemargin{-1in}    % subtract out the 1 inch driver margin
\setlength\@tempdima{\paperwidth}
\addtolength\@tempdima{-\textwidth}
\addtolength\@tempdima{-17mm}
\setlength\evensidemargin{\@tempdima}
\addtolength\evensidemargin{-1in}

\setlength\columnsep{6\p@}          % space between columns for double-column text
\setlength\columnseprule{0\p@}      % width of rule between two columns

% Footnotes
\setlength\footnotesep{0\p@}     % space between footnotes
% space between text and footnote
\setlength{\skip\footins}{12\p@ \@plus 6\p@ \@minus 1\p@}

% Float placement parameters

\setcounter{totalnumber}{10}
\setcounter{topnumber}{5}
\setcounter{bottomnumber}{5}
\renewcommand\topfraction{.921}
\renewcommand\bottomfraction{.921}
\renewcommand\textfraction{.079}
\renewcommand\floatpagefraction{.887}

\renewcommand\dbltopfraction{.88}
\renewcommand\dblfloatpagefraction{.88}

\setlength\floatsep    {18\p@ \@plus 2\p@ \@minus 2\p@}
\setlength\textfloatsep{20\p@ \@plus 2\p@ \@minus 4\p@}
\setlength\intextsep   {18\p@ \@plus 2\p@ \@minus 2\p@}

\setlength\dblfloatsep    {12\p@ \@plus 2\p@ \@minus 2\p@}
\setlength\dbltextfloatsep{20\p@ \@plus 2\p@ \@minus 4\p@}

% Space left at top, bottom and inbetween floats on a float page.
\setlength\@fptop{0\p@}         % no space above float page figures
\setlength\@fpsep{12\p@ \@plus 2fil}
\setlength\@fpbot{0\p@ \@plus 1fil}

% The same for double column
\setlength\@dblfptop{0\p@}
\setlength\@dblfpsep{12\p@ \@plus 1fil}
\setlength\@dblfpbot{0\p@ \@plus 2fil}

%%%%%%%%%%%%%%%%%%%%%%%%%%%% Article Identification %%%%%%%%%%%%%%%%%%%%%%%%%%%%
\def\@default@journal@title{Journal Title}
\let\@journal@title\@default@journal@title
\def\art-id@info{}
\def\month@info{Month~}
\def\year@info{\the\year}
\def\vol@info{00}
\def\price@info{00}
\def\issue@info{00}
\def\@print@issn{0000-0000}
\def\@price{0000-0000}

\newcommand{\page@extent@info}{%
  \thepage--\pageref*{LastPage}}

\newcommand{\totalpage}{%
  \pageref*{LastPage}}

\newcommand{\issn@line}{\@print@issn}
\newcommand{\copyright@line}{\textcopyright\ \year@info\ Cambridge University Press}
\newcommand{\webcommand}{{http:$//$www.xxx.xxx}}
\gdef\doi@string{0000000000}

% Article information user commands
\def\Year#1{\gdef\year@info{#1}}
\def\Vol#1{\gdef\vol@info{#1}}
\def\Price#1{\gdef\price@info{#1}}
\def\Issue#1{\gdef\issue@info{#1}}
\def\art-id#1{\gdef\art-id@info{#1}}
\def\Month#1{\gdef\month@info{#1}}
\newcommand\DOI[2][\@doi@fixed@field]{%
  \gdef\@doi@variable@field{#1}%
  \setDOI{#1}{#2}}
\newcommand{\setDOI}[2]{%
  \gdef\doi@string{#1#2}}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Firstpage %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\newcommand{\firstpage}[1]{%
  \setcounter{page}{#1}}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%% Page Styles %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\def\ps@titlepage{%
  \addtolength\headsep{3pt}      %   base to base with first line of text
  \let\@evenfoot\relax
 \def\@evenhead{\fontsize{8}{9}\selectfont \titlepageheadline}
 \def\@oddhead{\fontsize{8}{9}\selectfont \titlepageheadline}%
  \def\@oddfoot{}%
  \def\authormark##1{\def\leftmark{##1}}%
  \def\titlemark##1{\markboth{##1}{##1}}}

\def\ps@headings{%
  \let\@oddfoot\@empty%
  \let\@evenfoot\@empty%
  \def\@evenhead{\let\etal=\tetal\fontsize{10}{12}\selectfont\rlap{\thepage}\hfil
    {{\fontsize{8}{10}\selectfont\MakeUppercase{\rhtrack{\leftmark}}}}\hfil}%
  \def\@oddhead{\let\etal=\tetal\hfil
    {\fontsize{8}{10}\selectfont\MakeUppercase{\rhtrack{\rightmark}}}\hfil\llap{\fontsize{10}{12}\selectfont\thepage}}%
  \def\authormark##1{\def\leftmark{##1}}%
  \def\titlemark##1{\markboth{##1}{##1}}}

\def\ps@myheadings{%
  \def\@oddfoot{\hfill{\fontsize{9}{10}\selectfont\bfseries\thepage}}%
  \let\@evenfoot\@empty%
  \def\@evenhead{\hfil}%
  \def\@oddhead{\let\etal=\tetal\fontsize{9}{10}\selectfont\hfil
    {}\hfil\llap{\bfseries\phantom{09}}}%

  \def\authormark##1{\def\leftmark{##1}}%
  \def\titlemark##1{\markboth{##1}{##1}}}

\def\slinf{\hbox to \textwidth{Techset Composition Ltd,
    Salisbury\hfill\artname \hfill Page\#:\quad \totalpage\hfill  Printed:\ \today}}

\newcommand{\titlepageheadline}{%
  \vbox to 2\baselineskip{%
    \hbox to \textwidth{%
      \parbox{\textwidth}{%                   <- textwidth minus logo width
  \fontsize{8}{10}\selectfont
        {\@journal@title}\\
        doi:\doi@string}}}}

\def\today{\number\day/\ifcase\month\or
 1\or 2\or 3\or 4\or 5\or 6\or 7\or 8\or 9\or 10\or 11\or 12\fi/\number\year}

\newcommand{\titlepagefootline}{%
  \fontsize{7}{9}\selectfont
  \vbox{\vspace*{9pt}
\hbox{\copyright@line\hskip1pc \issn@line\ \$\price@info}}}

% No headers for float pages - requires the floatpag package
%% \floatpagestyle{headings}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%
% Sectional units
%

% Counters
\newcounter{part}
\newcounter{section}
\newcounter{rsection}
\newcounter{subsection}[section]
\newcounter{rsubsection}[section]
\newcounter{subsubsection}[subsection]
\newcounter{paragraph}[subsubsection]
\newcounter{subparagraph}[paragraph]
\newcounter{asection}[section]
\newcounter{refsection}[section]
\newcounter{appsection}[section]
\newcounter{appsubsection}[section]
\newcounter{figure}
\newcounter{scheme}
\newcounter{table}

% Form of the numbers
\newcommand\thepage{\arabic{page}}
\renewcommand\thesection{\arabic{section}}
\renewcommand\thersection{\arabic{section}}
\renewcommand\thesubsection{{\thesection.\arabic{subsection}}}
\renewcommand\thersubsection{{\thersection.\arabic{subsection}}}
\renewcommand\thersubsection{{\thersection.\arabic{subsection}}}
\renewcommand\thesubsubsection{{\thesubsection.\arabic{subsubsection}}}
\renewcommand\theparagraph{\thesubsubsection.\arabic{paragraph}}
\renewcommand\thesubparagraph{\theparagraph.\arabic{subparagraph}}
\renewcommand\theequation{\arabic{equation}}

% Form of the words
\newcommand\contentsname{Contents}
\newcommand\guestname{GUEST EDITORS}
\newcommand\listfigurename{List of Figures}
\newcommand\listtablename{List of Tables}
\newcommand\partname{Part}
\newcommand\appendixname{Appendix}
\newcommand\abstractname{Abstract}
\newcommand\refname{References}
\newcommand\bibname{{REFERENCES}}
\newcommand\normsname{Norms}
\newcommand\indexname{Index}
\newcommand\figurename{Figure}
\newcommand\schemename{Scheme}
\newcommand\tablename{Table}

% Clearemptydoublepage should really clear the running heads too
\newcommand{\clearemptydoublepage}{\newpage{\pagestyle{empty}\cleardoublepage}}


%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Titling Macros %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Reset default command signatures

\def\title{\@ifnextchar[{\@title@wst@}{\@title@nst@}}
\def\@title@wst@[#1]{\titlemark{#1}\@title@assign@}
\def\@title@nst@#1{\titlemark{\@journal@title}\@title@assign@{#1}}
\def\@title@assign@#1{\def\@title{#1}}

\def\author{\@ifnextchar[{\@author@wst@}{\@author@nst@}}
\def\@author@wst@[#1]{\authormark{#1}\@author@assign@}
\def\@author@nst@#1{\authormark{#1}\@author@assign@{#1}}
\def\@author@assign@#1{\gdef\@author{#1}\global\@author@providedtrue}

\def\and{\MakeLowercase{and}\space\ignorespaces}

% Ifs for titling commands
\newif\if@supertitle@provided \@supertitle@providedfalse
\newif\if@specialissue@provided \@specialissue@providedfalse
\newif\if@guesteditor@provided \@guesteditor@providedfalse
\newif\if@subtitle@provided \@subtitle@providedfalse
\newif\if@author@provided \@author@providedfalse
\newif\if@history@provided \@history@providedfalse
\newif\if@dedi@provided \@dedi@providedfalse
\newif\if@classification@provided \@classification@providedfalse
\newif\if@reviewby@provided \@reviewby@providedfalse
\newif\if@abstract@provided \@abstract@providedfalse %%5/7/2004
\newif\if@keywords@provided \@keywords@providedfalse

\usepackage{soul}

\sodef\keytrack{}{0.185em}{0.45em}{0pt}
\sodef\sectrack{}{0.115em}{0.45em}{0pt}
\sodef\rhtrack{}{0.115em}{0.45em}{0pt}

\def\keywordsname{{KEYWORDS}}

\def\address#1{\gdef\@address{#1}}
\def\revaddress#1{\gdef\@revaddress{#1}}
\def\history#1{\gdef\@history{#1}\global\@history@providedtrue}
\def\dedi#1{\def\@dedi{#1}\global\@dedi@providedtrue}
\def\keywords#1{\gdef\@keywords{#1}\global\@keywords@providedtrue}
\def\subtitle#1{\def\@subtitle{{#1}}\global\@subtitle@providedtrue}
\def\supertitle#1{\def\@supertitle{{\noindent #1}}\global\@supertitle@providedtrue}
\def\specialissue#1{\def\@specialissue{{\noindent SPECIAL ISSUE:~#1}}\global\@specialissue@providedtrue}
\def\guesteditor#1{\def\@guesteditor{{\noindent \guestname:~#1}}\global\@guesteditor@providedtrue}
\def\@abbreviations{}
\def\@classification{}
\newcommand\classification[2][Jel Classification]{%
     \global\@classification@providedtrue
     \gdef\@classification{{\leftskip=2pc\rightskip=2pc \noindent\textit{#1}:\enskip #2\par}}}
\def\@reviewby{}
\newcommand\reviewby[1]{%
     \global\@reviewby@providedtrue
     \gdef\@reviewby{{#1\par}}}

\newbox\@abstractbox
\newenvironment{abstract}{\leftskip=9pt\rightskip=9pt\global\@abstract@providedtrue%%% 5/7/2004
  \global\setbox\@abstractbox\vbox\bgroup\fontsize{9}{11}\selectfont
  \@afterindentfalse\@afterheading}{\par\egroup}%

\def\@fnsymbol#1{\ifcase#1\or *\or \dagger\or \ddagger\or
    \S\or \P\or \|\or **\or \dagger\dagger
    \or \ddagger\ddagger \else\@ctrerr\fi}


\mathchardef\Register="20AE%
\mathchardef\ter="099%
\def\titdagger{\hbox{$\dagger$}}
\def\titddagger{\hbox{$\ddagger$}}
\def\titS{\hbox{$\S$}}
\def\titP{\hbox{$\P$}}

\DeclareFontShape{OT1}{cmr}{m}{sc}{<->cmcsc10}{}%

\DeclareFontShape{OT1}{cmss}{m}{sc}{<->[0.75] cmss10}{}%

%% Reimplement Titling Layout
\newcommand\maketitle{\par
   \begingroup
\renewcommand{\@fnsymbol}[1]{\ifcase##1\or \hbox{*}\or \titdagger\or \titddagger\or
    \titS\or \titP\or \|\or \hbox{**}\or \titdagger\titdagger
    \or \titddagger\titddagger \else\@ctrerr\fi}
    \thispagestyle{titlepage}%
    \setcounter{footnote}{0}
    \renewcommand\thefootnote{\@fnsymbol\c@footnote}%
    \def\@makefnmark{\hbox{\rm\@thefnmark}}%
    \long\def\@makefntext##1{%\noindent
      {${\@thefnmark}$}{##1}}%
    \global\@topnum\z@   % Prevents figures from going at top of page.
    \@maketitle
  \endgroup
  \@afterindentfalse
  \@afterheading
  \global\let\maketitle\relax
  \global\let\@maketitle\relax}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% MAIN ARTICLE %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\def\@maketitle{%
     \if@supertitle@provided%
\vspace*{-4pt}
       {\centering\fontsize{14}{16}\fontshape{m}\selectfont\@supertitle\par%
\vspace*{4pt}}
    \else
\vspace*{6pt}
     \fi
  \begingroup
    \centering
    {\fontsize{22}{24}\fontseries{m}\selectfont
      {\@title}%
      \par}%
     \if@subtitle@provided%
       \vspace{20\p@}%
       {\fontsize{14}{16}\fontseries{b}\selectfont\itshape\MakeUppercase\@subtitle\par
        \vspace{23.5\p@}}%
     \else
       \vspace{17\p@}%
     \fi
    {\begingroup
     \if@author@provided%
      {\fontsize{12}{14}\selectfont\@author}%
    \vspace{6\p@}%
     \else
    \vspace{0\p@}%
      \fi
      \endgroup
      \par}%
    {\fontsize{10}{12}\itshape{\@address}\par}%
\vspace{21.65\p@}%%
     \if@dedi@provided%
       {\fontsize{8}{10}\fontseries{rm}\selectfont{\@dedi}\par
        \vspace{18.25\p@}}%
     \else
       \vspace{0\p@}%
     \fi
\endgroup
\if@abstract@provided%
    {\fontsize{9}{11}\selectfont\noindent\unvbox\@abstractbox\par}%
    \vspace{21\p@}%
    \else
       \vspace{0\p@}%
     \fi
\if@keywords@provided%
      {\parindent=0pt\centering
      {\fontsize{9}{10}\selectfont\keywordsname\par} 
      \vskip7pt
      {\fontsize{8}{9}\selectfont\@keywords\par}}%
    \vspace{15\p@}%
\else%
       \vspace{0\p@}%
\fi%
  \if@history@provided%
    {\fontsize{8}{10}\selectfont\centering\@history\par}%
\vspace{6.25\p@}%%
     \else
    \vspace{0\p@}%
     \fi
\if@classification@provided
      {\leftskip\z@\parfillskip=\z@ plus1fill%
        \fontsize{8}{9}\selectfont\@classification\par}%
 \fi
  \par
  \vspace{6pt plus 2\p@ minus 2\p@}
}
 
  
%%%%%%%%%%%%%%%%%%%%%%%%%%%% INCLUDING HYPERREF PACKAGE %%%%%%%%%%%%%%%%%%%%%%%%

\usepackage[bookmarksnumbered,raiselinks,breaklinks]{hyperref}
\hypersetup{
    colorlinks,%
    citecolor=blue,%
    filecolor=blue,%
    linkcolor=blue,%
    urlcolor=blue%
}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Lastpage %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Last page number - from lastpage.sty
\usepackage{lastpage}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\def\secdot{.}

%%%%%%%%%%%%%%%%%%%%%%%%%%% Sectioning macros %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Section macros
\def\@sect#1#2#3#4#5#6[#7]#8{%
  \ifnum #2>\c@secnumdepth
    \let\@svsec\@empty
  \else
    \refstepcounter{#1}%
    \protected@edef\@svsec{\@seccntformat{#1}\relax}%
    \protected@edef\@subsvsec{\@subseccntformat{#1}\relax}%
    \protected@edef\@subsubsvsec{\@subsubseccntformat{#1}\relax}%
  \fi
  \@tempskipa #5\relax
  \ifdim \@tempskipa>\z@
    \begingroup
      \ifnum #2=1
      #6{%
        \@hangfrom{\hskip #3\relax\@svsec}%
          \interlinepenalty \@M {#8}\@@par}%
      \fi
      \ifnum #2=2
      #6{%
        \@hangfrom{\hskip #3\relax\@subsvsec}%
          \interlinepenalty \@M {#8}\@@par}%
      \fi
      \ifnum #2>2
      #6{%
        {\hskip #3\relax\@subsubsvsec}%
          \interlinepenalty \@M {#8}\@@par}%
      \fi
    \endgroup
    \csname #1mark\endcsname{#7}%
    \addcontentsline{toc}{#1}{%
      \ifnum #2>\c@secnumdepth \else
        \protect\numberline{\csname the#1\endcsname}%
      \fi
      #7}%
  \else
    \def\@svsechd{%
      #6{\hskip #3\relax
\@svsec\ifnum #2=1\MakeUppercase{{#8}}\else#8\fi\secdot}
      \csname #1mark\endcsname{#7}%
}%
  \fi
  \@xsect{#5}}

\def\@ssect#1#2#3#4#5{%
  \@tempskipa #3\relax
  \ifdim \@tempskipa>\z@
    \begingroup
    \if\seclevel1
      #4\vbox{%
        \@hangfrom{\hskip #1}%
          \interlinepenalty \@M #5\@@par}%
    \fi
    \if\seclevel2
      #4{%
        \@hangfrom{\hskip #1}%
          \interlinepenalty \@M #5\@@par}%
    \fi
    \if\seclevel3
      #4{%
        \@hangfrom{\hskip #1}%
          \interlinepenalty \@M #5\@@par}%
    \fi
    \if\seclevel4
      #4{%
        \@hangfrom{\hskip #1}%
          \interlinepenalty \@M #5\@@par}%
    \fi
    \if\seclevel5
      #4{%
        \@hangfrom{\hskip #1}%
          \interlinepenalty \@M #5\@@par}%
    \fi
    \endgroup
  \else
    \def\@svsechd{#4{\hskip #1\relax #5}}%
  \fi
  \@xsect{#3}}

\def\@startsection#1#2#3#4#5#6{%
  \if@noskipsec \leavevmode \fi
  \par
  \@tempskipa #4\relax
  \@afterindenttrue
  \ifdim \@tempskipa <\z@
    \@tempskipa -\@tempskipa \@afterindentfalse
  \fi
  \if@nobreak
  \ifnum #2 = 1
    \vskip12pt
  \fi
  \ifnum #2 = 2
    \vskip1pt
  \fi
  \ifnum #2 = 3
    \vskip1.5pt
  \fi
    \everypar{}%
  \else
    \addpenalty\@secpenalty\addvspace\@tempskipa
  \fi
  \@ifstar
    {\@ssect{#3}{#4}{#5}{#6}}%
    {\@dblarg{\@sect{#1}{#2}{#3}{#4}{#5}{#6}}}}
%% Lowest level heading that takes a number by default
\setcounter{secnumdepth}{4}

\renewcommand{\@seccntformat}[1]{{{\csname the#1\endcsname\hskip7pt}}}
\newcommand{\@subseccntformat}[1]{{{\csname the#1\endcsname\hskip7pt}}}
\newcommand{\@subsubseccntformat}[1]{{{\csname the#1\endcsname\hskip7pt}}}

\def\section{%
\renewcommand{\@seccntformat}[1]{{{\csname the##1\endcsname.\hspace*{9pt}}}}
  \gdef\seclevel{1}
  \@startsection{section}{1}{\z@}
  {-18\p@ plus -3\p@ minus -3\p@}{-1em}
  {\fontsize{10}{11}\selectfont}}

\def\appsection{%
\renewcommand{\@seccntformat}[1]{{{APPENDIX.\hspace*{5.5pt}}}}
  \gdef\seclevel{1}
  \@startsection{section}{1}{\z@}
  {-18\p@ plus -3\p@ minus -3\p@}{9pt}
  {\fontsize{10}{12}\selectfont\centering\MakeUppercase}}

\def\ssubsection{%
\renewcommand{\@seccntformat}[1]{{{\rm\csname the##1\endcsname.\hspace*{9pt}}}}
  \gdef\seclevel{2}
  \@startsection{subsection}{2}{11pt}
  {\z@}{-1em}
  {\fontsize{10}{11}\fontseries{m}\fontshape{it}\selectfont\raggedright}}


\def\subsection{%
\renewcommand{\@seccntformat}[1]{{{\rm\csname the##1\endcsname.\hspace*{9pt}}}}
  \gdef\seclevel{2}
  \@startsection{subsection}{2}{11pt}
  {0\p@}{-1em}
  {\fontsize{10}{11}\fontseries{m}\fontshape{it}\selectfont\raggedright}}

\def\subsubsection{%
\renewcommand{\@seccntformat}[1]{{{\rm%\itshape Heading numbered changed as roman as per QC marking dated on 11/11/2016
\csname the##1\endcsname.\enskip}}}
  \gdef\seclevel{3}
  \@startsection{subsubsection}{3}{11pt}
  {0\p@}{-1em}
  {\normalsize\itshape\selectfont\raggedright}}

 \def\paragraph{%
 \renewcommand{\@seccntformat}[1]{{{\rm%\itshape Heading numbered changed as roman as per customer marking dated on 25/07/2018
\csname the##1\endcsname.\enskip}}}
  \gdef\seclevel{4}
   \@startsection{paragraph}{4}{12pt}
   {0\p@}{-11.7\p@}
   {\normalsize\itshape\selectfont\raggedright}}

\def\refsection{%
  \@startsection{paragraph}{4}{\z@}
  {-18\p@ plus -1\p@}{6pt}
  {\reset@font\normalfont\normalsize\centering}}

\def\asection{%
  \@startsection{section}{1}{\z@}
  {-24\p@ plus -2\p@ minus -1\p@}{11.5pt}
  {\fontsize{10}{12}\selectfont\bfseries\centering\MakeUppercase}}

\def\appsubsection{%
  \gdef\seclevel{1}
  \@startsection{section}{1}{\z@}
  {-18\p@ plus -3\p@ minus -3\p@}{9pt}
  {\fontsize{10}{12}\selectfont\raggedright\MakeUppercase}}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Footnotes %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\def\@makefnmark{$^{\@thefnmark}$}%
\renewcommand\footnoterule{\begingroup\leftskip\z@\noindent
  \rule{12pc}{0.5\p@}\vskip6pt%\vspace{6\p@}
  \endgroup}

\newcommand\@makefntext[1]{%
  \begingroup
    \leftskip=\z@\rightskip=\z@
    \footnotesize
    \setlength\parindent{1em}%
    \@makefnmark\ignorespaces\,#1%
  \endgroup}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% From ifmtarg.sty
% Copyright Peter Wilson and Donald Arseneau, 2000
\begingroup
\catcode`\Q=3
\long\gdef\@ifmtarg#1{\@xifmtarg#1QQ\@secondoftwo\@firstoftwo\@nil}
\long\gdef\@xifmtarg#1#2Q#3#4#5\@nil{#4}
\long\gdef\@ifnotmtarg#1{\@xifmtarg#1QQ\@firstofone\@gobble\@nil}
\endgroup
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%% PostScript Rotation Macros %%%%%%%%%%%%%%%%%%%%%%%%%%%%
\newif\if@rotate \@rotatefalse
\newif\if@rotatecenter \@rotatecenterfalse
\def\rotatecenter{\global\@rotatecentertrue}
\def\rotateendcenter{\global\@rotatecenterfalse}
\def\rotate{\global\@rotatetrue}
\def\endrotate{\global\@rotatefalse}
\newdimen\rotdimen
\def\rotstart#1{\special{ps: gsave currentpoint currentpoint translate
    #1 neg exch neg exch translate}}
\def\rotfinish{\special{ps: currentpoint grestore moveto}}
\def\rotl#1{\rotdimen=\ht#1\advance\rotdimen by \dp#1
    \hbox to \rotdimen{\vbox to\wd#1{\vskip \wd#1
    \rotstart{270 rotate}\box #1\vss}\hss}\rotfinish}
\def\rotr#1{\rotdimen=\ht #1\advance\rotdimen by \dp#1
    \hbox to \rotdimen{\vbox to \wd#1{\vskip \wd#1
    \rotstart{90 rotate}\box #1\vss}\hss}\rotfinish}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%% Figures and Tables %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\newlength{\abovecaptionskip}
\newlength{\belowcaptionskip}
\setlength{\abovecaptionskip}{2.7\p@}
\setlength{\belowcaptionskip}{2\p@}

\newbox\schemecaptionbox
\long\def\@schemecaption#1#2{\vspace{\abovecaptionskip}\par%
\let\query\figquery%
  \setbox\schemecaptionbox=\hbox{#1\quad #2}%
  \ifdim\wd\schemecaptionbox<\hsize
{\box\schemecaptionbox}
  \else
\fontsize{8}{9}\selectfont
    \unhbox\schemecaptionbox
    \par
  \fi}

\long\def\@makecaption#1#2{%
\let\source\figsource%
\let\query\figquery%
  \vskip\abovecaptionskip
  \sbox\@tempboxa{\def\source##1{}\fontsize{8}{10}\selectfont{#1}\quad{#2}}%
  \ifdim \wd\@tempboxa <\hsize
        \global \@minipagefalse
        \centering{\fontsize{8}{10}\selectfont{#1}\quad {#2}\par}%
  \else
    \ifdim \wd\@tempboxa >1.95\hsize
        {\leftskip5mm\rightskip5mm\fontsize{8}{10}\selectfont{#1}\quad {#2}\par}
    \else
        \centering{\fontsize{8}{10}\selectfont{#1}\quad {#2}\par}
    \fi
  \fi
  \vskip\belowcaptionskip}

\newbox\tablecaptionbox
\long\def\@tablecaption#1#2{\par%
\let\query\tabquery%
\setbox\tablecaptionbox=\hbox{\fontsize{8}{10}\selectfont{#1}\quad{#2}}%
\ifdim \wd\tablecaptionbox <\hsize
    \centering{\fontsize{8}{10}\selectfont{#1}\quad {#2\vphantom{Ay}}\par}%
\else
  \ifdim \wd\tablecaptionbox >1.95\hsize%
    {\fontsize{8}{10}\selectfont{#1}\quad {#2\vphantom{Ay}}\par}%
  \else
    \centering{\fontsize{8}{10}\selectfont{#1}\quad {#2\vphantom{Ay}}\par}%
\fi\fi\vskip3pt}

\def\thefigure{\@arabic\c@figure}
\def\fps@figure{tbp}
\def\ftype@figure{1}
\def\ext@figure{lof}
\def\fnum@figure{{\figurename}\enspace\thefigure.}
\def\figure{\@float{figure}}
\def\endfigure{\end@float}
\@namedef{figure*}{\@dblfloat{figure}}
\@namedef{endfigure*}{\end@dblfloat}

\def\thescheme{\@arabic\c@scheme}
\def\fps@scheme{h}
\def\ftype@scheme{2}
\def\ext@scheme{los}
\def\fnum@scheme{\MakeUppercase{\schemename}~\thescheme.}
\def\scheme{\let\@makecaption\@schemecaption\@float{scheme}}
\def\endscheme{\end@float}
\@namedef{scheme*}{\let\@makecaption\@schemecaption\@dblfloat{scheme}}
\@namedef{endscheme*}{\end@dblfloat}

\def\thetable{\@arabic\c@table}
\def\fps@table{tbp}
\def\ftype@table{3}
\def\ext@table{lot}
\def\fnum@table{{\tablename}\enspace\thetable.}
\def\table{\let\@makecaption\@tablecaption\@float{table}}
\def\endtable{\end@float}
\@namedef{table*}{\let\@makecaption\@tablecaption\@dblfloat{table}}
\@namedef{endtable*}{\end@dblfloat}

\newdimen\tempdime
\newbox\temptbox

\newlength{\abovefigskip}
\newlength{\belowfigskip}
\setlength{\abovefigskip}{\z@}
\setlength{\belowfigskip}{\z@}

\def\toprule{\noalign{\ifnum0=`}\fi
  \hrule \@height 1\p@
  \hrule \@height 4\p@ \@width \z@
  \futurelet \@tempa\@xhline}

\def\midrule{\noalign{\ifnum0=`}\fi
  \hrule \@height 4.5\p@ \@width \z@
  \hrule \@height 0.5\p@
  \hrule \@height 5\p@ \@width\z@
  \futurelet \@tempa\@xhline}

\def\botrule{\noalign{\ifnum0=`}\fi
  \hrule \@height 4\p@ \@width \z@
  \hrule \@height 1\p@
  \futurelet \@tempa\@xhline}


% Table and array parameters
\setlength\arraycolsep{.5em}
\setlength\tabcolsep{.5em}
\setlength\arrayrulewidth{.25pt}
\setlength\doublerulesep{2.5pt}
\renewcommand\arraystretch{1}

\def\hrulefill{\leavevmode\leaders\hrule height .25pt\hfill\kern\z@}

\newcolumntype{P}[1]{>{\raggedright\let\\\@arraycr\hangindent1em}p{#1}}

\usepackage{dcolumn}%

\newcolumntype{d}[1]{D{.}{.}{#1}}%


\let\tempcite\cite%
\def\tabcite#1{\setlength{\baselineskip}{9pt}\tempcite{#1}}%

\let\tempcitet\citet%
\def\tabcitet#1{\setlength{\baselineskip}{9pt}\tempcitet{#1}}%

\let\tempcitep\citep%
\def\tabcitep#1{\setlength{\baselineskip}{9pt}\tempcitep{#1}}%

\let\tempciteauthor\citeauthor%
\def\tabciteauthor#1{\setlength{\baselineskip}{9pt}\tempciteauthor{#1}}%

\let\tempciteyear\citeyear%
\def\tabciteyear#1{\setlength{\baselineskip}{9pt}\tempciteyear{#1}}%

\newenvironment{processtable}[3]{\let\cite\tabcite%
\let\citep\tabcitep%
\let\citet\tabcitet%
\let\citeauthor\tabciteauthor%
\let\citeyear\tabciteyear%
\setbox\temptbox=\hbox{{\fontsize{9}{11}\selectfont#2}}%
\tempdime\wd\temptbox\@processtable{#1}{#2}{#3}{\tempdime}}%
{\relax}

\newenvironment{@processtable}[4]{%
\if!#1!%
\addtocounter{table}{-1}%%ADDED ON 21/12/05
\def\fnum@table{}%
\else%
\def\fnum@table{{\tablename}\enspace\thetable.}%
\fi%
\if@rotate
\setbox4=\vbox to \textwidth{\vss\hbox to \textheight{%
\begin{minipage}{#4}%
\caption{#1}{\fontsize{8}{10}\selectfont#2}%
\@ifmtarg{#3}{}{\vskip5pt\noindent
\parbox{#4}{\fontsize{7}{8}\selectfont #3\par}}%
\end{minipage}}\vss}
\else
\setbox4=\hbox to \textwidth{{\hss\begin{minipage}[t]{#4}%
\caption{#1}{\fontsize{8}{10}\selectfont#2}
\@ifmtarg{#3}{}{\vskip5pt\noindent
\parbox{#4}{\fontsize{7}{8}\selectfont #3\par}}
\end{minipage}\hss}}
\fi
\if@rotate\rotr{4}\else\box4\fi}
{\relax}

\newcommand{\tabhead}[1]{#1}%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Lists %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\def\labelenumi{{\rm\arabic{enumi}.}}
\def\theenumi{\arabic{enumi}}
\def\labelenumii{{\rm(\alph{enumii})}}
\def\theenumii{\alph{enumii}}
\def\p@enumii{\theenumi}
\def\labelenumiii{{\rm(\arabic{enumiii})}}
\def\theenumiii{\roman{enumiii}}
\def\p@enumiii{\theenumi(\theenumii)}
\def\labelenumiv{{\rm(\arabic{enumiv})}}
\def\theenumiv{\Alph{enumiv}}
\def\p@enumiv{\p@enumiii\theenumiii}
\def\labelitemi{$\bullet$}
\def\labelitemii{$\bullet$}
\def\labelitemiii{$\bullet$}
\def\labelitemiv{$\bullet$}

\setlength{\leftmargini}{12pt}
\setlength{\leftmarginii}{4pt}
\setlength{\leftmarginiii}{\z@}
\setlength{\leftmarginiv}{\z@}

\def\enumargs{%
   \partopsep     \z@
   \itemsep       0pt
   \parsep        \z@
   \leftmargin    \z@
   \rightmargin   \z@
   \labelsep      1em
   \listparindent \z@
   \itemindent    \z@}

\def\enumerate{%
    \@ifnextchar[{\@numerate}{\@numerate[3.]}}

\def\@numerate[#1]{%
     \ifnum \@enumdepth >3 \@toodeep\else
     \advance\@enumdepth \@ne
     \edef\@enumctr{enum\romannumeral\the\@enumdepth}
     \list{\csname label\@enumctr\endcsname}{%
       \enumargs
       \setlength{\leftmargin}{\csname leftmargin\romannumeral\the\@listdepth\endcsname}
       \usecounter{\@enumctr}
       \settowidth\labelwidth{#1}
       \addtolength{\leftmargin}{\labelwidth}
       \addtolength{\leftmargin}{\labelsep}
       \def\makelabel##1{\hss \llap{##1}}}%
     \fi
   }
\def\endenumerate{\endlist\advance \@listdepth -1}

\def\uenumargs{%
   \partopsep     \z@
   \itemsep       0pt
   \parsep        \z@
   \leftmargin    \z@
   \rightmargin   \z@
   \labelsep      0.5em
   \listparindent \z@
   \itemindent    \z@}

\def\uenumargsii{%
   \partopsep     \z@
   \itemsep       0\p@
   \parsep        \z@
   \labelsep      1em
   \leftmarginii  1pc
   \rightmargin   1pc
   \listparindent \parindent
   \itemindent    1pc}


\def\uenumerate{%
    \@ifnextchar[{\@unumerate}{\@unumerate[]}}

\def\@unumerate[#1]{%
     \ifnum \@enumdepth >3 \@toodeep\else
     \advance\@enumdepth \@ne
     \edef\@enumctr{enum\romannumeral\the\@enumdepth}
     \list{\csname label\@enumctr\endcsname}{%
       \csname uenumargs\romannumeral\the\@enumdepth\endcsname
       \setlength{\leftmargin}{\csname leftmargin\romannumeral\the\@listdepth\endcsname}
       \usecounter{\@enumctr}
       \def\makelabel##1{\hss \llap{##1}}}%
    \itemsep6pt
     \fi
   }
\def\enduenumerate{\endlist\advance \@listdepth -1}

\def\sublist{%
    \@ifnextchar[{\@numerate}{\@numerate[3.]}}

\def\@numerate[#1]{%
     \ifnum \@enumdepth >3 \@toodeep\else
     \advance\@enumdepth \@ne
     \edef\@enumctr{enum\romannumeral\the\@enumdepth}
     \list{\csname label\@enumctr\endcsname}{%
       \submargs
       \setlength{\leftmargin}{\csname leftmargin\romannumeral\the\@listdepth\endcsname}
       \usecounter{\@enumctr}
       \settowidth\labelwidth{#1}
       \addtolength{\leftmargin}{\labelwidth}
       \addtolength{\leftmargin}{\labelsep}
       \def\makelabel##1{\hss \llap{##1}}}%
     \fi
   }
\def\endsublist{\endlist\advance \@listdepth -1}

\def\submargs{%
   \partopsep     \z@
   \itemsep       0pt
   \parsep        \z@
   \leftmargin    \z@
   \rightmargin   \z@
   \labelsep      0.5em
   \listparindent \z@
   \itemindent    \z@}

% Changes to the list parameters for itemize
\def\itemargs{%
   \partopsep     \z@
   \itemsep       0pt
   \parsep        \z@
   \rightmargin   \z@
   \labelsep      1em
   \listparindent \parindent
   \itemindent    \z@}

\def\itemize{%
    \@ifnextchar[{\@itemize}{\@itemize[$\bullet$]}}

\def\@itemize[#1]{%
     \ifnum \@itemdepth >3 \@toodeep\else
     \advance\@itemdepth \@ne
     \edef\@itemctr{item\romannumeral\the\@itemdepth}
     \list{\csname label\@itemctr\endcsname}{%
       \itemargs
       \setlength{\leftmargin}{\csname leftmargin\romannumeral\the\@listdepth\endcsname}
       \settowidth\labelwidth{#1}
       \addtolength{\leftmargin}{\labelwidth}
       \addtolength{\leftmargin}{\labelsep}
       \def\makelabel##1{\hss \llap{##1}}}%
     \fi
   }
\let\enditemize\endlist

\setlength{\topsep}{6\p@}% \@plus 1\p@ \@minus 1\p@}
\setlength{\itemsep}{\z@}

\def\@listI{\leftmargin\leftmargini\topsep6.5\p@ plus 4\p@}
\let\@listi\@listI
\@listi
\def\@listii{\leftmargin\leftmarginii\topsep\z@}
\def\@listiii{\leftmargin\leftmarginiii\topsep\z@}
\def\@listiv{\leftmargin\leftmarginiv\topsep\z@}
\def\@listv{\leftmargin\leftmarginv\topsep\z@}
\def\@listvi{\leftmargin\leftmarginvi\topsep\z@}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% unnumbered list %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\newenvironment{description}{%
  \begin{list}{}{%
      \usecounter{enumi}%
      \setlength{\itemsep}{\z@}%
      \setlength{\labelwidth}{\z@}%
      \setlength{\leftmargin}{2em}%
      \setlength{\itemindent}{-2em}}}%
{\end{list}}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Extracts %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\def\quotation{\par\begin{list}{}{\fontsize{9}{10}\selectfont%  Extracts in small type
      \setlength{\topsep}{\medskipamount}%
      \setlength{\itemsep}{\z@}%
      \setlength\labelwidth{\z@}%
      \setlength\labelsep{\z@}%
      \setlength\leftmargin{18pt}%
      \setlength\rightmargin{18pt}%
      \listparindent \parindent}%
  \item[\vrule width\z@ height 9\p@]}
\def\endquotation{\end{list}}
\let\quote\quotation
\let\endquote\endquotation
\newcommand{\source}[1]{\newline\hbox{}\hfill{#1}}%
\newcommand{\figsource}[1]{\par#1}%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% programs %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

{\obeyspaces\global\let =\ }

\newskip\cmskipamount%
\cmskipamount=12pt plus 6pt minus 3pt%

\def\cmskip{\removelastskip\vskip\cmskipamount}

\long\def\bCM{\begingroup\parindent=0pt\cmskip\ttfamily%
\obeylines\obeyspaces}%

\def\eCM{\cmskip\endgroup}%

\long\def\tbCM{\begingroup\parindent=0pt\cmskip%
\obeylines\obeyspaces}%

\def\teCM{\cmskip\endgroup}%

\renewcommand{\proofname}{{\it Proof}}

\renewcommand{\qedsymbol}{\ensuremath{\blacksquare}}
\renewenvironment{proof}[1][\proofname]{\par
  \if@endproofbox\pushQED{\qed}\fi%
  \normalfont
  \topsep\bigskipamount
  \labelsep=0.5em\relax
  \trivlist
  \item[\hskip\labelsep
        {#1}{\rm.}]\ignorespaces
}{%
  \if@endproofbox\popQED\fi
  \endtrivlist\@endpefalse
}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Counter for saving the section numbering depth
\newcounter{savesecnumdepth}

%%%%%%%%%%%%%%%%%%%%%%%%%% Acknowledgments %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\providecommand{\ackname}{{ACKNOWLEDGMENTS}}
\newcommand{\ack}[1][\ackname]{\fontsize{9}{11}\selectfont%
  \setcounter{savesecnumdepth}{\value{secnumdepth}}%
  \setcounter{secnumdepth}{0}%
  \refsection*{#1}%
  \setcounter{secnumdepth}{\value{savesecnumdepth}}%
}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Notes %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\def\enoteheading{\refsection*{\fontsize{9}{10}\selectfont\itshape \notesname
  \@mkboth{{\notesname}}{{\notesname}}}\vspace*{7pt}%
     \leavevmode\par}

\def\enoteformat{\rightskip\z@ \leftskip\z@\parindent=0pt
     \leavevmode{\hbox{\hskip14pt${\@theenmark}$}.\enskip}}

\newenvironment{notes}[1][99]{%
  \begingroup%
 }%
{\endgroup}%

%%%%%%%%%%%%%%%%%%%%%%%%% Nomenclature %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\providecommand{\nomenname}{Nomenclature}
\newcommand{\nomen}[1][\nomenname]{%
  \setcounter{savesecnumdepth}{\value{secnumdepth}}%
  \setcounter{secnumdepth}{0}%
  \refsection{#1}%
\vspace*{5pt}
  \setcounter{secnumdepth}{\value{savesecnumdepth}}%
}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\newskip\normskip
\setlength\normskip{6pt}

\newenvironment{normes}{%
  \begingroup
  \footnotesize\parindent=0pt
  \setcounter{secnumdepth}{0}
  \vskip\normskip
  {\fontsize{10}{12}\selectfont\bf\normsname}%
  \begin{list}{}{%
      \usecounter{enumi}%
      \setlength{\itemsep}{\z@}%
      \setlength{\labelwidth}{0pt}%
      \setlength{\leftmargin}{2em}%
      \setlength{\itemindent}{-2em}}}%
{\end{list}\endgroup}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Index %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\newif\if@restonecol
\def\theindex{\@mainmatterfalse
  \@restonecoltrue\if@twocolumn\@restonecolfalse\fi
  \begingroup\parindent \z@
  \addcontentsline{toc}{section}{Index}
  \columnseprule \z@
  \columnsep 1pc\section*{\indexname} %Subject or Author here
  \parskip\z@ plus .3\p@\relax\let\item\idxitem\fontsize{8\p@}{10\p@}\selectfont}
\def\idxitem{\par\raggedright\hangindent 3em}
\def\subitem{\par\penalty1000\raggedright\hangindent 3em\hspace*{1em}}
\def\subsubitem{\par\penalty1000\raggedright\hangindent 3em\hspace*{2em}}
\def\endtheindex{\if@restonecol\endgroup\onecolumn\else\clearpage\fi}
\def\indexspace{\par \vskip 18\p@ plus 12\p@ minus 12\p@\relax}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%% Appendix %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\newif\ifappend% Are we in the Appendix?

\def\appendix{%
  \let\section\appsection
  \let\subsection\appsubsection
  \renewcommand\thesection{\Alph{section}}
  \renewcommand\thetable{\thesection\@arabic\c@table}
  \renewcommand\thefigure{\thesection\@arabic\c@figure}
  \renewcommand\theequation{\thesection\@arabic\c@equation}
  \renewcommand\theHequation   {\thesection.\arabic{equation}}%
  \setcounter{section}{0}
  \setcounter{table}{0}
  \setcounter{figure}{0}
  \setcounter{equation}{0}
  \appendtrue}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Override settings in MathTime back to TeX defaults
\DeclareMathSizes{5}     {5}   {5}  {5}
\DeclareMathSizes{6}     {6}   {5}  {5}
\DeclareMathSizes{7}     {7}   {5}  {5}
\DeclareMathSizes{8}     {8}   {6}  {5}
\DeclareMathSizes{9}     {9}   {7}  {5}
\DeclareMathSizes{10}   {10}   {7}  {5}
\DeclareMathSizes{12}   {12}   {9}  {7}

%Math parameters
\setlength{\jot}{5\p@}
\skip\@mpfootins = \skip\footins
\fboxsep=6\p@
\fboxrule=.25\p@

\medmuskip=4mu% plus 2mu minus 4mu
\thickmuskip=5mu% plus 5mu

\vbadness=9999
\tolerance=9999
\doublehyphendemerits=10000
\doublehyphendemerits 640000
\finalhyphendemerits  1000000

\flushbottom
\frenchspacing
\onecolumn
\pagestyle{headings}

% Author queries
\fboxsep=4\p@
\fboxrule=0.5\p@

% Short-form coding
\newcommand\tetal{{{\rm et~al.}}}
\newcommand\etal{\textit{et~al.}}
\newcommand\eg{\textit{e.g.}}
\newcommand\ie{\textit{i.e.}}
\let\endash\textendash

\def\dbond{\raise0.18ex\hbox{$=$}}
\def\bond{\raise0.18ex\hbox{$-$}}

\def\endash{--}
\def\emdash{\,--\,}
\def\sdot#1{{\buildrel{\scriptscriptstyle\bullet}\over{\hbox{$#1$}}}}
\def\ssdot#1{{\buildrel{\scriptscriptstyle\bullet\bullet}\over{\hbox{$#1$}}}}

\def\refmsg{\noindent\hangindent=1em}%

\def\z{\phantom}

%%%For New Table

\hyphenation{Table}
\hyphenation{Figure}
\hyphenation{Section}
\hyphenation{equation}
\hyphenation{Theorem}
\hyphenation{Lemma}
\hyphenation{Algorithm}
\hyphenation{Definition}
\hyphenation{Corollary}
\hyphenation{Proof}
\hyphenation{Remark}

\def\bcontinued{({\it continued\/})}
\def\tcontinued{Continued}

\def\dd{{\rm d}}
\def\ee{{\rm e}}
\def\cir#1{{\accent"17 #1}}

\newdimen\p@renwd

\def\spbordermatrix#1{\begingroup \m@th
  \setbox\z@\vbox{\def\cr{\crcr\noalign{\kern2\p@\global\let\cr\endline}}%
    \ialign{$##$\hfil\kern2\p@\kern\p@renwd&\thinspace\hfil$##$\hfil
      &&\quad\hfil$##$\hfil\crcr
      \omit\strut\hfil\crcr\noalign{\kern-\baselineskip}%
      #1\crcr\omit\strut\cr}}%
  \setbox\tw@\vbox{\unvcopy\z@\global\setbox\@ne\lastbox}%
  \setbox\tw@\hbox{\unhbox\@ne\unskip\global\setbox\@ne\lastbox}%
  \setbox\tw@\hbox{$\kern\wd\@ne\kern-\p@renwd\left[\kern-\wd\@ne
    \global\setbox\@ne\vbox{\box\@ne\kern2\p@}%
    \vcenter{\kern-\ht\@ne\unvbox\z@\kern-\baselineskip}\,\hskip-\bmskip\right]$}%
  \null\;\vbox{\kern\ht\@ne\box\tw@}\endgroup}


\def\sqbordermatrix#1{\begingroup \m@th
  \setbox\z@\vbox{\def\cr{\crcr\noalign{\kern2\p@\global\let\cr\endline}}%
    \ialign{$##$\hfil\kern2\p@\kern\p@renwd&\thinspace\hfil$##$\hfil
      &&\quad\hfil$##$\hfil\crcr
      \omit\strut\hfil\crcr\noalign{\kern-\baselineskip}%
      #1\crcr\omit\strut\cr}}%
  \setbox\tw@\vbox{\unvcopy\z@\global\setbox\@ne\lastbox}%
  \setbox\tw@\hbox{\unhbox\@ne\unskip\global\setbox\@ne\lastbox}%
  \setbox\tw@\hbox{$\kern\wd\@ne\kern-\p@renwd\left[\kern-\wd\@ne
    \global\setbox\@ne\vbox{\box\@ne\kern2\p@}%
    \vcenter{\kern-\ht\@ne\unvbox\z@\kern-\baselineskip}\,\right]$}%
  \null\;\vbox{\kern\ht\@ne\box\tw@}\endgroup}

\def\llbordermatrix#1{\begingroup \m@th
  \setbox\z@\vbox{\def\cr{\crcr\noalign{\kern2\p@\global\let\cr\endline}}%
    \ialign{$##$\hfil\kern2\p@\kern\p@renwd&\thinspace\hfil$##$\hfil
      &&\quad\hfil$##$\hfil\crcr
      \omit\strut\hfil\crcr\noalign{\kern-\baselineskip}%
      #1\crcr\omit\strut\cr}}%
  \setbox\tw@\vbox{\unvcopy\z@\global\setbox\@ne\lastbox}%
  \setbox\tw@\hbox{\unhbox\@ne\unskip\global\setbox\@ne\lastbox}%
  \setbox\tw@\hbox{$\kern\wd\@ne\kern-\p@renwd\left[\kern-\wd\@ne
    \global\setbox\@ne\vbox{\box\@ne\kern2\p@}%
    \vcenter{\kern-\ht\@ne\unvbox\z@\kern-\baselineskip}\,\right.$}%
  \null\;\vbox{\kern\ht\@ne\box\tw@}\endgroup}

\def\lbordermatrix#1{\begingroup \m@th
  \setbox\z@\vbox{\def\cr{\crcr\noalign{\kern2\p@\global\let\cr\endline}}%
    \ialign{$##$\hfil\kern2\p@\kern\p@renwd&\thinspace\hfil$##$\hfil
      &&\quad\hfil$##$\hfil\crcr
      \omit\strut\hfil\crcr\noalign{\kern-\baselineskip}%
      #1\crcr\omit\strut\cr}}%
  \setbox\tw@\vbox{\unvcopy\z@\global\setbox\@ne\lastbox}%
  \setbox\tw@\hbox{\unhbox\@ne\unskip\global\setbox\@ne\lastbox}%
  \setbox\tw@\hbox{$\left[\kern\wd\@ne\kern-\p@renwd\kern-\wd\@ne
    \global\setbox\@ne\vbox{\box\@ne\kern2\p@}%
    \vcenter{\kern-\ht\@ne\unvbox\z@\kern-\baselineskip}\,\right.$}%
  \null\;\vbox{\kern\ht\@ne\box\tw@}\endgroup}

\newdimen\bmskip
\bmskip=0pt

\def\rbordermatrix#1{\begingroup \m@th
  \setbox\z@\vbox{\def\cr{\crcr\noalign{\kern2\p@\global\let\cr\endline}}%
    \ialign{\hfil$##$\hfil\kern6\p@\kern\p@renwd&\thinspace\hfil$##$\hfil
      &&\quad\hfil$##$\hfil\crcr
      \omit\strut\hfil\crcr\noalign{\kern-\baselineskip}%
      #1\crcr\omit\strut\cr}}%
  \setbox\tw@\vbox{\unvcopy\z@\global\setbox\@ne\lastbox}%
  \setbox\tw@\hbox{\unhbox\@ne\unskip\global\setbox\@ne\lastbox}%
  \setbox\tw@\hbox{$\left.\kern\wd\@ne\kern-\p@renwd\kern-\wd\@ne
    \global\setbox\@ne\vbox{\box\@ne\kern2\p@}
    \vcenter{\kern-\ht\@ne\unvbox\z@\kern-\baselineskip}\hskip-\bmskip\right]$}%
  \null\;\vbox{\kern\ht\@ne\box\tw@}\endgroup}

\chardef\permil="89%

\renewcommand{\eqref}[1]{\textup{({\ref{#1}})}}

\newtheorem{mythm}{mythm}[section]

\definecolor{mag}{cmyk}{0,.36,0,0}

\gdef\figautoreflabel{}%

\newcommand{\key}[1]{#1.\hspace*{17pt}}

\def\acc#1{{Accepted: #1.\ }}
\def\sub#1{{Submitted: #1.\ }}
\def\fpo#1{{First published online: #1.}}

\def\email#1{{\rm (E-mail: \textcolor{blue}{\href{mailto:#1}{#1}})}}
\def\name#1{#1}

\newenvironment{thebibliography}[1]{%
  \begingroup
  \fontsize{8}{10}\selectfont
  \setcounter{secnumdepth}{0}
  \refsection*{\bibname}%
  \begin{list}{}{%
      \usecounter{enumi}%
      \setlength{\labelwidth}{0pt}%
      \setlength{\leftmargin}{8pt}%
      \setlength{\itemindent}{-8pt}
      }}%
{\end{list}\endgroup}
\usepackage[authoryear]{natbib}
\bibpunct[, ]{(}{)}{;}{a}{,}{;}

\let\tempcite\cite%
\def\tabcite#1{\setlength{\baselineskip}{9pt}\tempcite{#1}}%

\let\tempciteauthor\citeauthor%
\def\tabciteauthor#1{\setlength{\baselineskip}{9pt}\tempciteauthor{#1}}%

\let\tempciteyear\citeyear%
\def\tabciteyear#1{\setlength{\baselineskip}{9pt}\tempciteyear{#1}}%

\let\tempcitealp\citealp%
\def\tabcitealp#1{\setlength{\baselineskip}{9pt}\tempcitealp{#1}}%

\let\tempcitet\citet%
\def\tabcitet#1{\setlength{\baselineskip}{9pt}\tempcitet{#1}}%

\let\tempcitep\citep%
\def\tabcitep#1{\setlength{\baselineskip}{9pt}\tempcitep{#1}}%

\ifnumbib
\renewenvironment{thebibliography}[1]{%
  \begingroup
  \fontsize{8}{10}\selectfont
  \setcounter{secnumdepth}{0}
  \refsection*{\bibname}%
  \begin{list}{[\arabic{enumi}]}{%
      \usecounter{enumi}%
      \setlength{\itemsep}{5pt}
      \setlength\leftmargin{\z@}%
      \setlength{\labelsep}{0.5em}%%chgd. 1em to 0.5em on 21/7/2004 -- devi
      \settowidth{\labelwidth}{[#1]}%
      \addtolength{\leftmargin}{\labelwidth}%
      \addtolength{\leftmargin}{\labelsep}}}%
{\end{list}\endgroup}
\else
\renewenvironment{thebibliography}[1]{%
  \begingroup
  \fontsize{8}{10}\selectfont
  \setcounter{savesecnumdepth}{\value{secnumdepth}}%
  \setcounter{secnumdepth}{0}
  \refsection*{\bibname}%
  \begin{list}{}{%
      \usecounter{enumi}%
      \setlength{\labelwidth}{0pt}%
      \setlength{\leftmargin}{8pt}%
      \setlength{\itemindent}{-8pt}
      }}%
{\end{list}\setcounter{secnumdepth}{\value{savesecnumdepth}}%
\endgroup}
\fi

\usepackage{etoolbox}

% Patch case where name and year are separated by aysep
\patchcmd{\NAT@citex}
  {\@citea\NAT@hyper@{%
     \NAT@nmfmt{\NAT@nm}%
     \hyper@natlinkbreak{\NAT@aysep\NAT@spacechar}{\@citeb\@extra@b@citeb}%
     \NAT@date}}
  {\@citea\NAT@nmfmt{\NAT@nm}%
   \NAT@aysep\NAT@spacechar\NAT@hyper@{\NAT@date}}{}{}

% Patch case where name and year are separated by opening bracket
\patchcmd{\NAT@citex}
  {\@citea\NAT@hyper@{%
     \NAT@nmfmt{\NAT@nm}%
     \hyper@natlinkbreak{\NAT@spacechar\NAT@@open\if*#1*\else#1\NAT@spacechar\fi}%
       {\@citeb\@extra@b@citeb}%
     \NAT@date}}
  {\@citea\NAT@nmfmt{\NAT@nm}%
   \NAT@spacechar\NAT@@open\if*#1*\else#1\NAT@spacechar\fi\NAT@hyper@{\NAT@date}}
  {}{}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\def\neq{\not\raisebox{-1pt}{\kern-2pt =}}
\def\ne{\not\raisebox{-1pt}{\kern-2pt =}}

\let\tempcirc\textcircled%
\newcommand\sptextcircled[1]{\raisebox{1.25pt}{\tempcirc{\raisebox{-.3pt} {#1}}}}%

\def\@journal@title{{THE JOURNAL OF NAVIGATION} (\year@info), \page@extent@info.\quad {\usefont{T1}{ptm}{m}{n}\fontsize{6.5}{7.5}\selectfont\sptextcircled{c}}\ The Royal Institute of Navigation \year@info}
\def\@print@issn{0269-9648/15}
\def\@doi@fixed@field{10.1017/S03734633}
\def\@doi@variable@field{00000000000000000000}
\def\jourinf{Vol.~\vol@info, No.~\issue@info, \month@info\space \year@info, \page@extent@info}

\renewcommand{\copyright@line}{\textcopyright\ Cambridge University Press \year@info}

\def\date#1#2#3#4{\gdef\@date{#1 #2 #3 #4}\global\@date@providedtrue}

\Year{2019}

\def\add#1#2{{\textsuperscript{#1}}{#2\par}}

\endinput

%%%%%%%%%%%%%%%%%%%%%%%%%%% End of LaTeX Document Class %%%%%%%%%%%%%%%%%%%%%%%%
