%%
%% This is file `CUP-JNL-ETS.cls',
%% generated with the docstrip utility.
%%
%% The original source files were:
%%
%% classes.dtx  (with options: `CUP-JNL-ETS')
%%
%% This is a generated file.
%%
%% Copyright 1993 1994 1995 1996 1997 1998 1999 2000 2001 2002 2003 2004 2005 2006 2007 2008 2009
%% The LaTeX3 Project and any individual authors listed elsewhere
%% in this file.
%%
%% This file was generated from file(s) of the LaTeX base system.
%% --------------------------------------------------------------
%%
%% It may be distributed and/or modified under the
%% conditions of the LaTeX Project Public License, either version 1.3c
%% of this license or (at your option) any later version.
%% The latest version of this license is in
%%    http://www.latex-project.org/lppl.txt
%% and version 1.3c or later is part of all distributions of LaTeX
%% version 2005/12/01 or later.
%%
%% This file has the LPPL maintenance status "maintained".
%%
%% This file may only be distributed together with a copy of the LaTeX
%% base system. You may however distribute the LaTeX base system without
%% such generated files.
%%
%% The list of all files belonging to the LaTeX base distribution is
%% given in the file `manifest.txt'. See also `legal.txt' for additional
%% information.
%%
%% The list of derived (unpacked) files belonging to the distribution
%% and covered by LPPL is defined by the unpacking scripts (with
%% extension .ins) which are part of the distribution.
%% \CharacterTable
%%  {Upper-case    \A\B\C\D\E\F\G\H\I\J\K\L\M\N\O\P\Q\R\S\T\U\V\W\X\Y\Z
%%   Lower-case    \a\b\c\d\e\f\g\h\i\j\k\l\m\n\o\p\q\r\s\t\u\v\w\x\y\z
%%   Digits        \0\1\2\3\4\5\6\7\8\9
%%   Exclamation   \!     Double quote  \"     Hash (number) \#
%%   Dollar        \$     Percent       \%     Ampersand     \&
%%   Acute accent  \'     Left paren    \(     Right paren   \)
%%   Asterisk      \*     Plus          \+     Comma         \,
%%   Minus         \-     Point         \.     Solidus       \/
%%   Colon         \:     Semicolon     \;     Less than     \<
%%   Equals        \=     Greater than  \>     Question mark \?
%%   Commercial at \@     Left bracket  \[     Backslash     \\
%%   Right bracket \]     Circumflex    \^     Underscore    \_
%%   Grave accent  \`     Left brace    \{     Vertical bar  \|
%%   Right brace   \}     Tilde         \~}
\NeedsTeXFormat{LaTeX2e}[1995/12/01]
\ProvidesClass{CUP-JNL-ETS}
              [2020/05/04 v0.1: An authoring template for CUP ETS articles]

\newif\if@restonecol
\newif\if@titlepage   \@titlepagefalse
\newif\if@cropmarkson \@cropmarksonfalse

%% Template Options
\DeclareOption{a4paper}{\PassOptionsToPackage{a4}{crop}}
\DeclareOption{a3paper}{\PassOptionsToClass{a3paper}{article}\PassOptionsToPackage{a3}{crop}}
\DeclareOption{centre}{\PassOptionsToPackage{center}{crop}}
\DeclareOption{crop}{\PassOptionsToPackage{frame}{crop}\global\@cropmarksontrue}
\DeclareOption{nocrop}{\PassOptionsToPackage{off}{crop}\global\@cropmarksontrue}
\DeclareOption{info}{\PassOptionsToPackage{info}{crop}}
\DeclareOption{noinfo}{\PassOptionsToPackage{noinfo}{crop}}

%% Classfile Options
\DeclareOption{oneside}{\@twosidefalse \@mparswitchfalse}
\DeclareOption{twoside}{\@twosidetrue  \@mparswitchtrue}
\DeclareOption{draft}{\setlength\overfullrule{5pt}}
\DeclareOption{titlepage}{\@titlepagetrue}
\DeclareOption{notitlepage}{\@titlepagefalse}
\DeclareOption{onecolumn}{\@twocolumnfalse}
\DeclareOption{twocolumn}{\@twocolumntrue}
\DeclareOption{openbib}{\let\if@openbib\iftrue}
\DeclareOption{cupthm}{\let\if@cupthm\iftrue}

\ExecuteOptions{twosidecrop,crop,centre,info,croppage}
\ProcessOptions
\LoadClass[twoside,fleqn]{article}

%% General Packages Used
\RequirePackage{ifpdf}
\RequirePackage{url}
\RequirePackage{soul}
\RequirePackage{xcolor}
\RequirePackage{textcomp}%
\RequirePackage{ltxcmds}%
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%% Color Defs %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%% rgb colors
\definecolor{Black}{cmyk}{0.0,0.0,0.0,1}
\definecolor{White}{cmyk}{0.0,0.0,0.0,0.0}
\definecolor{gray}{cmyk}{0,0,0,0.2}%

%
%%%%%%%%%%%%%%%%%%%%%%%%%%%% Fonts & Sizes %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%% Fonts Used
\RequirePackage[T1]{fontenc}
\renewcommand\rmdefault{utm}
\renewcommand{\ttdefault}{pcr}
\AtBeginDocument{%
\usepackage{newtxmath}%
}%
\thinmuskip=2mu
\medmuskip=2.5mu plus 1mu minus 1mu
\thickmuskip=4mu plus 1.5mu minus 1mu

\DeclareOldFontCommand{\rm}{\normalfont\rmfamily}{\mathrm}
\DeclareOldFontCommand{\sf}{\normalfont\sffamily}{\mathsf}
\DeclareOldFontCommand{\tt}{\normalfont\ttfamily}{\mathtt}
\DeclareOldFontCommand{\bf}{\normalfont\bfseries}{\mathbf}
\DeclareOldFontCommand{\it}{\normalfont\itshape}{\mathit}
\DeclareOldFontCommand{\sl}{\normalfont\slshape}{\@nomath\sl}
\DeclareOldFontCommand{\sc}{\normalfont\scshape}{\@nomath\sc}
\DeclareRobustCommand*\cal{\@fontswitch\relax\mathcal}
\DeclareRobustCommand*\mit{\@fontswitch\relax\mathnormal}

\renewcommand\normalsize{%
   \@setfontsize\normalsize{10pt}{13pt}%
   \abovedisplayskip 6\p@ \@plus2\p@ \@minus0\p@
   \abovedisplayshortskip 4\p@ \@plus3\p@
   \belowdisplayshortskip 4\p@ \@plus3\p@ \@minus3\p@
   \belowdisplayskip \abovedisplayskip
   \let\@listi\@listI}%
\normalsize
\newcommand\medsize{%
   \@setfontsize\small\@xipt{13}%
   \abovedisplayskip 5\p@ \@plus3\p@ \@minus4\p@
   \abovedisplayshortskip \z@ \@plus2\p@
   \belowdisplayshortskip 3\p@ \@plus2\p@ \@minus2\p@
   \def\@listi{\leftmargin\leftmargini
               \topsep 4\p@ \@plus2\p@ \@minus2\p@
               \parsep 2\p@ \@plus\p@ \@minus\p@
               \itemsep \parsep}%
   \belowdisplayskip \abovedisplayskip}
\renewcommand\small{%
   \@setfontsize\small\@ixpt{11}%
   \abovedisplayskip 5\p@ \@plus3\p@ \@minus4\p@
   \abovedisplayshortskip \z@ \@plus2\p@
   \belowdisplayshortskip 3\p@ \@plus2\p@ \@minus2\p@
   \def\@listi{\leftmargin\leftmargini
               \topsep 4\p@ \@plus2\p@ \@minus2\p@
               \parsep 2\p@ \@plus\p@ \@minus\p@
               \itemsep \parsep}%
   \belowdisplayskip \abovedisplayskip}
\renewcommand\footnotesize{%
   \@setfontsize\footnotesize{7}{8}%
   \abovedisplayskip 5\p@ \@plus2\p@ \@minus4\p@
   \abovedisplayshortskip \z@ \@plus\p@
   \belowdisplayshortskip 3\p@ \@plus\p@ \@minus2\p@
   \def\@listi{\leftmargin\leftmargini
               \topsep 3\p@ \@plus\p@ \@minus\p@
               \parsep 2\p@ \@plus\p@ \@minus\p@
               \itemsep \parsep}%
   \belowdisplayskip \abovedisplayskip}
%
\renewcommand\scriptsize{\@setfontsize\scriptsize\@ixpt\@ixpt}
\newcommand\scrisize{\@setfontsize\scrisize{9.3}{9}}
\renewcommand\tiny{\@setfontsize\tiny\@vpt\@vipt}
\renewcommand\large{\@setfontsize\large{12}{14}}
\newcommand\larg{\@setfontsize\larg{11}{13}}
\renewcommand\Large{\@setfontsize\Large{16}{18}}
\renewcommand\LARGE{\@setfontsize\LARGE\@xviipt{22}}
\renewcommand\huge{\@setfontsize\huge\@xxpt{25}}
\renewcommand\Huge{\@setfontsize\Huge\@xxvpt{30}}
%
\DeclareMathSizes{\@ixpt}{\@ixpt}{7}{5}
\DeclareMathSizes{\@xpt}{\@xpt}{7}{5}
\DeclareMathSizes{\@xipt}{\@xipt}{7}{5}

\DeclareRobustCommand*\textsubscript[1]{%
  \@textsubscript{\selectfont#1}}%
\def\@textsubscript#1{%
  {\m@th\ensuremath{_{\mbox{\fontsize\sf@size\z@#1}}}}}

%
%%%%%%%%%%%%%%%%%%%%%%%%%%%% Layout Settings %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

\RequirePackage{geometry}

%% Regular Pages (for Opening page - redefined)
\geometry{%
   paperwidth=174truemm,
   paperheight=247truemm,
   top={22.5mm},
   headheight={8bp},
   headsep={15.25bp},
   textwidth={30.04pc},
   textheight={44\baselineskip},
   marginparsep=3mm,
   marginparwidth=10mm,
   bindingoffset=13.5mm,
   footskip=0mm}
%
\setlength{\marginparsep}{3mm}%
\setlength{\marginparwidth}{10mm}%
%
\setlength\footskip{0\p@}
\setlength\maxdepth{0pt}
%
\setlength\footnotesep{5.75\p@}
\setlength{\skip\footins}{8\p@ \@plus 4\p@ \@minus 0\p@}
\renewcommand\thefootnote{\fnsymbol{footnote}}
\AtBeginDocument{%
     \def\@makefnmark{{\textsuperscript{\@thefnmark}}}
     %%%
     \renewcommand\@makefntext[1]{%
         \hskip8pt{\smash{\@makefnmark}}#1}
}
%
\setlength\parindent{12pt}
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%% Pagination Settings %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Line spacing
\setlength\lineskip{1\p@}
\setlength\normallineskip{1\p@}
\renewcommand\baselinestretch{}
\parskip=0pt

% Page break penalties
\@lowpenalty   51
\@medpenalty  151
\@highpenalty 301

% Disallow widows and orphans
\clubpenalty 10000
\widowpenalty 10000

% Disable page breaks before equations, allow pagebreaks after
% equations and discourage widow lines before equations.
\displaywidowpenalty 100
\predisplaypenalty   10000
\postdisplaypenalty  0

% Set these global demerits
\doublehyphendemerits 1000000   % corresponds to badness 800
\finalhyphendemerits  1000000  % corresponds to badness 1000

% Allow loose lines rather than overfull lines
\vbadness=9999
\tolerance=9999

% Allow breaking the page in the middle of a paragraph
\interlinepenalty 0

% Disallow breaking the page after a hyphenated line
\brokenpenalty 10000

% Hyphenation; don't split words into less than three characters
\lefthyphenmin=3
\righthyphenmin=3

% Float placement parameters

% The total number of floats that can be allowed on a page.
\setcounter{totalnumber}{10}

% The maximum number of floats at the top and bottom of a page.
\setcounter{topnumber}{5}
\setcounter{bottomnumber}{5}

% The maximum part of the top or bottom of a text page that can be
% occupied by floats. This is set so that at least four lines of text
% fit on the page.
\renewcommand\topfraction{.921}
\renewcommand\bottomfraction{.921}

% The minimum amount of a text page that must be occupied by text.
% This should accomodate four lines of text.
\renewcommand\textfraction{.13}

% The minimum amount of a float page that must be occupied by floats.
\renewcommand\floatpagefraction{.887}

% The same parameters repeated for double column output
\renewcommand\dbltopfraction{.88}
\renewcommand\dblfloatpagefraction{.88}

% Space between floats
\setlength\floatsep    {18\p@ \@plus 2\p@ \@minus 2\p@}

% Space between floats and text
\setlength\textfloatsep{19\p@ \@plus 2\p@ \@minus 4\p@}

% Space above and below an inline figure
\setlength\intextsep   {18\p@ \@plus 2\p@ \@minus 2\p@}

% For double column floats
\setlength\dblfloatsep    {20\p@ \@plus 2\p@ \@minus 2\p@}
\setlength\dbltextfloatsep{18\p@ \@plus 2\p@ \@minus 4\p@}

\hyphenation{Figure Figures Table Tables Equation Equations Section Sections Appendix Theorem Lemma}

%
%%%%%%%%%%%%%%%%%%%%%%%%%%% Math Settings %%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%% For above/below spacing  
\def\eqnarray{%
   \stepcounter{equation}%
   \def\@currentlabel{\p@equation\theequation}%
   \global\@eqnswtrue
   \m@th
   \global\@eqcnt\z@
   \tabskip\@centering
   \let\\\@eqncr
   $$\everycr{}\halign to\displaywidth\bgroup
       \hskip\@centering$\displaystyle\tabskip\z@skip{##}$\@eqnsel
      &\global\@eqcnt\@ne\hskip \tw@\arraycolsep \hfil${##}$\hfil
      &\global\@eqcnt\tw@ \hskip \tw@\arraycolsep
         $\displaystyle{##}$\hfil\tabskip\@centering
      &\global\@eqcnt\thr@@ \hb@xt@\z@\bgroup\hss##\egroup
         \tabskip\z@skip
      \cr
}
\def\endeqnarray{%
      \@@eqncr
      \egroup
      \global\advance\c@equation\m@ne
   $$\@ignoretrue
}
%
%%%%%%%%%%%%%%%%%%%%%%%%%%% Titles %%%%%%%%%%%%%%%%%%%%%%%%%%%
%

\renewcommand\contentsname{Contents}
\renewcommand\listfigurename{List of Figures}
\renewcommand\listtablename{List of Tables}
\renewcommand\refname{References}
\renewcommand\indexname{Index}
\renewcommand\figurename{Figure}
\renewcommand\tablename{Table}
\renewcommand\partname{Part}
\renewcommand\appendixname{Appendix}
\renewcommand\abstractname{Abstract}

%
%%%%%%%%%%%%%%%%%%%%%%%%%%% Article Front Matter %%%%%%%%%%%%%%%%%%%%%%%%%%%
%

%% Article Type
\def\articletype#1{\gdef\ArtType{{#1}}\gdef\@ArtType{#1}}\articletype{}%

%% Meta Info
\def\@artid{xx}
\def\@jname{xxx xxx}
\def\@jshort{Ergod. Th. \& Dynam. Sys.}
\def\@jvol{00}
\def\@jissue{0}
\def\@jyear{{0000}}
\def\@jmonth{xx}
\def\@DOI{}
%
\def\artid#1{\gdef\@artid{#1}}
\def\jname#1{\gdef\@jname{#1}}
\def\jshort#1{\gdef\@jshort{#1}}
\def\jvol#1{\gdef\@jvol{#1}}
\def\jissue#1{\gdef\@jissue{#1}}
\def\jyear#1{\gdef\@jyear{#1}}
\def\jmonth#1{\gdef\@jmonth{#1}}
\def\jrcopyrightline#1{\gdef\@jrcopyrightline{#1}}
\def\jdoi#1{\gdef\@DOI{doi:\ltx@ifpackageloaded{hyperref}{\href{https://doi.org/#1}{#1}}{#1}}}
\jdoi{10.1017/etds.2020.xx}
\jrcopyrightline{Cambridge University Press}


%

%%% Font Def
\def\Titlefont{\fontsize{17.25bp}{22}\fontseries{b}\selectfont\centering\mathversion{bold}}
\def\Artcatfont{\fontsize{17.25bp}{22}\fontseries{b}\selectfont}
\def\Authorfont{\fontsize{10bp}{13bp}\selectfont\centering}
\def\addressfont{\fontsize{10bp}{13bp}\fontshape{it}\selectfont\centering}
\def\historyfont{\fontsize{10bp}{13bp}\fontshape{it}\selectfont\centering}
\def\abstractheadfont{\fontsize{10bp}{13bp}\fontshape{it}\selectfont}%
\def\abstractsubheadfont{\fontsize{10bp}{13bp}\selectfont}%
\def\abstractfont{\fontsize{10bp}{13bp}\selectfont}%
\def\keywordfont{\fontsize{10}{13}\selectfont}%
\def\artnotefont{\reset@font\fontfamily{\rmdefault}\fontsize{8.6}{13}\selectfont\raggedright}
\def\pubfont{\fontsize{10}{12}\selectfont}%
\def\dedicationfont{\fontsize{9}{12}\selectfont}%

%% Article Title
%\def\title#1{\gdef\@title{#1}}

\renewcommand{\title}[2][]{%
\gdef\@checktitle{#1}\ifx\@checktitle\empty\gdef\@title{#2}%
\gdef\s@title{#2}\else\gdef\@title{#2}\gdef\s@title{#1}\fi}

%% Cross Link for Author & Address
\def\jmkLabel#1{\@bsphack\protected@write\@auxout{}{\string\Newlabel{#1}{\@currentlabel}}\@esphack}
\def\Newlabel#1#2{\expandafter\xdef\csname X@#1\endcsname{#2}}
\def\jmkRef#1{\@ifundefined{X@#1}{0}{\csname X@#1\endcsname}}

%% Article Author(s)

\def\gname#1{\uppercase{#1}}
\def\sname#1{\uppercase{#1}}
\let\sep\@empty%
\let\ausep\@empty%
\let\authorsep\@empty%
\newcount\aucount%
\newcount\punctcount%
\def\author{\advance\aucount by 1\@ifstar\@@corrauthor\@@author}%
\def\au@and{\ifnum\punctcount=2\ and\else\unskip,\advance\punctcount by -1 \fi}%
\def\artauthors{}
\newif\if@auemail%
\newcommand{\@@author}[2][]{\g@addto@macro\artauthors{%
%%    \ifnum\aucount=1%
%%    \global\@auemailtrue%
%%    \else%
%%    \global\@auemailfalse%
%%    \fi%
    \Authorfont%
    \def\baselinestretch{1}%
    \authorsep{#2}\unskip\ifx#1\empty\else{\smash{{%
      \@for\@@affmark:=#1\do{\edef\affnum{\@ifundefined{X@\@@affmark}{1}{\jmkRef{\@@affmark}}}%
    \unskip\ausep\setcounter{aulink}{\affnum}\theaulink\let\ausep=,}}}}\fi%
    \def\authorsep{\au@and~}%%%
    \global\let\ausep\@empty\global\let\@corref\@empty%
}}%

\newcommand{\@@corrauthor}[2][]{\g@addto@macro\artauthors{%
    \Authorfont%
    \def\baselinestretch{1}%
    \authorsep{#2}\unskip\ifx#1\empty\else{\smash{{%
      \@for\@@affmark:=#1\do{\edef\affnum{\@ifundefined{X@\@@affmark}{1}{\jmkRef{\@@affmark}}}%
    \unskip\ausep\setcounter{aulink}{\affnum}\theaulink\let\ausep=,}}}}\fi
    \def\authorsep{\au@and~}%%%
    \global\let\sep\@empty\global\let\@corref\@empty%
}}%
%
%% Author Email
\def\emailfont{\fontshape{it}\selectfont}
\newif\ifcorrauth
\def\addressrule{\kern-10\p@ \hrule \@height.15pt \@width\marginparwidth \kern 1.6\p@}%
\def\@email{}
\DeclareUrlCommand\myemail{}%
\def\email#1{\if@auemail{\emailfont e-mail:}\global\@auemailfalse\fi\ \textcolor{blue}{\protect\myemail{#1}}}%

%\def\corremail{\protected@xdef\@corremail{%
%      {{\@email\par}}%
%        \par%
%}%
%\@corremail}

\def\@cupfnsymbol#1{%
   \ifcase#1\or 
   \TextOrMath \textdagger \dagger\or
   \TextOrMath \textdaggerdbl \ddagger \or
   \TextOrMath \textsection  \mathsection\or
   \TextOrMath \textparagraph \mathparagraph\or
   \TextOrMath \textbardbl \|\or
   \TextOrMath {\textasteriskcentered\textasteriskcentered}{**}\or
   \TextOrMath {\textdagger\textdagger}{\dagger\dagger}\or
   \TextOrMath {\textdaggerdbl\textdaggerdbl}{\ddagger\ddagger}\else
   \@ctrerr \fi
}%

\let\nomail\relax
\newcounter{afflink}%
\newcounter{aulink}%
\def\affilnumbering#1{%
  \gdef\theaulink{\csname @#1\endcsname\c@aulink}% for author number
  \gdef\theafflink{\csname @#1\endcsname\c@afflink}% for address number
}
\affilnumbering{cupfnsymbol}



%% Corrseponding Address 
\def\@copycorthanks{}
\def\auaddress{}
\def\@auaddress{}
\newcounter{affn}
\renewcommand\theaffn{\arabic{affn}}
\def\address{\@ifstar\@@coraddress\@@address}
\newcount\addcount% To check the count of address
\newcommand{\@@coraddress}[2][]{%\advance\addcount by 1
\g@addto@macro\auaddress{%
    \global\@auemailtrue%
     \ifx#1\@empty\else
     \stepcounter{affn}%
     \setcounter{afflink}{#1}%
     \xdef\@currentlabel{\theaffn}%
     \jmkLabel{\theaffn}%
     \fi%
     {\ifx#1\empty\else{\textup{\theafflink}}\ \fi#2}\par\addvspace{.5\baselineskip}}%\textsuperscript{#1}
}

%% Author Address 
\def\addsep{\par\vskip0pt}
\newcount\addcount% To check the count of address
\newcommand{\@@address}[2][]{\advance\addcount by 1\g@addto@macro\auaddress{%
    \global\@auemailtrue%
     \ifx#1\@empty\else
     \stepcounter{affn}%
     \setcounter{afflink}{#1}%
     \xdef\@currentlabel{\theaffn}%
     \jmkLabel{\theaffn}%
     \fi%
     {\ifx#1\empty\else{\textup{\theafflink}}\ \fi#2}\par\addvspace{.5\baselineskip}}%\textsuperscript{#1}\theaffn
}


%% Address tagging 
\newcommand{\orgdiv}[1]{#1}%
\newcommand{\orgname}[1]{#1}%
\newcommand{\orgaddress}[1]{#1}%
\newcommand{\street}[1]{#1}
\newcommand{\postcode}[1]{#1}
\newcommand{\city}[1]{#1}
\newcommand{\state}[1]{#1}
\newcommand{\country}[1]{#1}

%% Author name in Running Head
\def\@authormark{}% 
\def\authormark#1{\gdef\@authormark{#1}\gdef\@authormarkforcite{\def\etal{\textit{et al.}}#1}}%
\def\etal{\textit{et al.}}
\def\titlemark#1{\gdef\s@title{#1}}%

%% Optional Text
\def\artnotefont{\reset@font\fontfamily{\sfdefault}\fontsize{8.6}{13}\selectfont\raggedright}
\def\artnote#1{\gdef\@Artnote{#1}}\artnote{}%

%% Article Abstract
\newcommand\abstracthead{\@startsection {section}{1}{\z@}{-17pt \@plus0ex \@minus0ex}{-5pt}{\abstractheadfont}}
\newcommand\subabstracthead{\@startsection{subsection}{2}{\z@}{3pt \@plus0ex \@minus0ex}{-.5em}{\abstractsubheadfont}}

\renewenvironment{abstract}[1][\abstractname.]{\par\addvspace{0pt}%
\let\paragraph\subabstracthead%
\abstracthead*{#1}%
\abstractfont}%
{\par\addvspace{13pt}}

%
%% Keywords
\usepackage{xstring}
\def\keywordname{Key words}
\newcommand{\keywords}[2][\keywordname]{%
\IfSubStr{#1}{Class}{%
\IfSubStr{#1}{2010}{\GenericError{MSC Code}{MSC Inputs Are Wrong..}{Please confirm MSC 2020 codes are given !!!}{Please visit https://mathscinet.ams.org/msc/msc2020.html}}%
{\IfSubStr{#1}{2000}{\GenericError{MSC Code}{MSC Inputs Are Wrong..}{Please confirm MSC 2020 codes are given !!!}{Please visit https://mathscinet.ams.org/msc/msc2020.html}}{}}}{}%
{\par\addvspace{0pt}{\noindent \keywordfont{#1:} #2\par}}}
\def\@keywords{}
\def\codesep{\unskip, }%
\newcommand{\codes}[2][]{\ifx#1\empty #2\else#2 (#1)\codesep\fi\let\codesep\relax}%


%%%% Article History
\def\@history{}
\def\printhistory{{\par%
\historyfont\noindent%
\ifx\@history\empty\gdef\@history{Received xx xxx xxxx}\fi\textup{(}\@history\textup{)}\par}
}%
\newcommand{\Received}[2][Received]{\g@addto@macro\@history{{{#1} #2}}}%
\newcommand{\Revised}[2][revised]{\g@addto@macro\@history{{{#1} #2}}}%
\newcommand{\Accepted}[2][accepted]{\g@addto@macro\@history{{{#1} #2}}}%

%% Policy Statement

\RequirePackage{framed}
\definecolor{shadecolor}{gray}{.70}
\newbox\policybox
\def\policyfont{\fontsize{9}{11}\selectfont}
\newenvironment{policy}[1][Policy Significance Statement]{\global\setbox\policybox\vbox\bgroup\par\addvspace{26pt}\FrameSep=8pt\begin{shaded*}%
\policyfont\ifx#1\empty\else\vspace*{-2\baselineskip}\abstracthead*{\fontsize{9}{11}\selectfont#1}\vskip2pt\fi%
}{\end{shaded*}\par\addvspace{0pt}\egroup} 

\def\printpolcy{\ifvoid\policybox\else\box\policybox\fi\par}%


%% Article Header Definition
   \renewcommand{\@maketitle}
   {\noindent{\vbox{%
       \vskip6pt% 
       \hsize\textwidth\parindent0pt%
       %% Aritle Type
       \ifx\@ArtType\empty\else%
        \ifx\@ArtType\@Corrigendum\vskip33pt\else\vskip37pt\fi%
        {\hbox to \textwidth{\hfill{\Artcatfont\MakeUppercase{\ArtType}\hfill}\vspace*{-35.15pt}\par}}
       \fi
       %% Aritle Title
       \ifx\@title\empty\else%
           \vskip45.5pt%
           {\Titlefont\@title\par}
           %\addcontentsline{toc}{chapter}{\@title}% for bookmarks
       \fi%
       %% Aritle Authors, Address and Correspondings
       \ifnum\aucount>0
           \global\punctcount\aucount%
           \vskip15pt%
           \artauthors\par%%     authors and emails
           {\vskip3pt\addressfont\auaddress\par%%      corresponding adress
           %\corremail\par
           }
        \fi%
        \ifx\@history\empty\else%
            \vskip11pt%
            {\printhistory\par}%
        \fi
        \ifx\@ArtType\@Corrigendum%
            \vskip30.5pt%
            {\pubfont\noindent\@pubdetails\par}
        \fi
        \ifx\@ArtType\@Survey%
            \vskip13pt%
            {\dedicationfont\@dedication\par}
        \fi
        %%{\printkeywords\par}%
        %%{\printabstract\par}%
        %
       }}\@thanks\par\addvspace{43pt plus0pt minus0pt}}%

%% Printing Article Header
\renewcommand\maketitle{\par%
  \@afterindentfalse%
   \begingroup%
    \long\def\@makefntext##1{{\hskip12pt\@textsuperscript{\normalfont\@thefnmark}}##1\vphantom{py}\par}%
    \renewcommand\thefootnote{\@fnsymbol\c@footnote}%
    \if@twocolumn
      \ifnum \col@number=\@ne%
        \twocolumn[\@maketitle]%
      \else
        \twocolumn[\@maketitle]%
      \fi%
    \else%
      \newpage%
      \global\@topnum\z@% Prevents figures from going at top of page.
      \@maketitle%
    \fi%
%	\titlefoot
    \thispagestyle{plain}%
  \endgroup%
  \setcounter{footnote}{0}%
  %\global\let\thanks\relax%
  \global\let\maketitle\relax%
  \global\let\@maketitle\relax%
  %\global\let\@thanks\@empty%
  \global\let\@author\@empty%
  \global\let\@date\@empty%
  %\global\let\@title\@empty%
  \global\let\title\relax%
  \global\let\author\relax%
  \global\let\date\relax%
  \global\let\and\relax
  %%%print continuous abstract on next page
  \@afterheading}%

\def\printaddress{%
{\vskip8pt\addressfont\auaddress\par%% corresponding adress
}}

\newenvironment{Frontmatter}{\par}{\maketitle\par}

\newenvironment{Backmatter}{\par\fontsize{8}{10}\selectfont
\def\paragraphfont{\fontsize{8}{10}\fontseries{sb}\selectfont\raggedright}
\def\sectionfont{\reset@font\fontsize{10bp}{13bp}\fontshape{sc}\selectfont\centering}
\renewcommand\section{\@startsection {section}{1}{\z@}%
                                   {-10.25pt \@plus 0ex \@minus 0ex}%
                                   {2.5pt}%
                                   {\sectionfont}}
\renewcommand\paragraph{\@startsection{paragraph}{4}{\z@}%
                                    {2.25ex \@plus1ex \@minus.2ex}%
                                    {-.5em}%
                                    {\paragraphfont}}
\def\bibfont{\fontsize{8}{10}\selectfont}%
}{\par}
\def\bysame{\leavevmode\hbox to3em{\hrulefill}}

%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Page Styles %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
\RequirePackage{everypage}
\RequirePackage{lastpage}

\def\runheadstyle{\fontsize{10bp}{13bp}\selectfont\itshape}
\def\plainheadstyle{\fontsize{8bp}{10bp}\selectfont}
\def\foliostyle{\fontsize{10bp}{13bp}\selectfont}
\def\runfoliostyle{\fontsize{10bp}{13bp}\selectfont}


%% Regular Page Style      
   \def\ps@headings{\let\@mkboth\markboth%
      \let\@oddfoot\@empty%
      \let\@evenfoot\@empty%
      \def\@evenhead{\hbox to \textwidth{{\rlap{\runfoliostyle\thepage}\hfill{\runheadstyle \@authormark}\hfill}}}
      \def\@oddhead{\hbox to \textwidth{\hfill{\runheadstyle{\s@title}}\hfill\llap{\runfoliostyle\thepage}}}%%\s@title
           \def\chaptermark##1{\markboth{{##1}}%\thechapter\hskip.97em
           {{##1}}}%\thechapter\hskip.97em
           \def\sectionmark##1{\markright{{##1}}}%\thesection\hskip.91em
   }%

   \def\ps@plain{\let\@mkboth\markboth%
      \def\@oddhead{\plainheadstyle\@opjournalheader\hfill\llap{\runfoliostyle\thepage}}%
      \let\@evenhead\@oddhead%
      \def\@oddfoot{}%
      \let\@evenfoot\@oddfoot%
   }%

\def\@opjournalheader{\vbox{%
      \parbox[t]{\textwidth}{\hsize.92\textwidth\raggedright\textit{\@jshort}, Page {\thepage} of {\pageref*{LastPage}}\hskip1em {\textcopyright} {The Author(s),\ \@jyear. Published by \@jrcopyrightline}\par
      \@DOI\par}}}%


%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Sections %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
\def\numbered{\setcounter{secnumdepth}{3}}
\def\unnumbered{\setcounter{secnumdepth}{0}}
\numbered%% default is unnumbered Sections

\newcounter {chapter}[part]% for bookmarks
\renewcommand\thepart         {\@Roman\c@part}
\renewcommand\thesection      {\@arabic\c@section}
\renewcommand\thesubsection   {\thesection.\@arabic\c@subsection}
\renewcommand\thesubsubsection{\thesubsection.\@arabic\c@subsubsection}
\renewcommand\theparagraph    {\thesubsubsection.\@arabic\c@paragraph}
\renewcommand\thesubparagraph {\theparagraph.\@arabic\c@subparagraph}
%%
\renewcommand\part{\par
   \addvspace{4ex}%
   \@afterindentfalse
   \secdef\@part\@spart}
%%
\def\@part[#1]#2{%
    \ifnum \c@secnumdepth >\m@ne
      \refstepcounter{part}%
      \addcontentsline{toc}{part}{\thepart\hspace{1em}#1}%
    \else
      \addcontentsline{toc}{part}{#1}%
    \fi
    {\parindent \z@ \raggedright
     \interlinepenalty \@M
     \normalfont
     \ifnum \c@secnumdepth >\m@ne
       \Large\bfseries \partname~\thepart
       \par\nobreak
     \fi
     \huge \bfseries #2%
     \markboth{}{}\par}%
    \nobreak
    \vskip 3ex
    \@afterheading}

\def\@spart#1{%
    {\parindent \z@ \raggedright
     \interlinepenalty \@M
     \normalfont
     \huge \bfseries #1\par}%
     \nobreak
     \vskip 3ex
     \@afterheading}

\def\@sect#1#2#3#4#5#6[#7]#8{%
  \ifnum #2>\c@secnumdepth
    \let\@svsec\@empty
  \else
    \refstepcounter{#1}%
    \protected@edef\@svsec{\@seccntformat{#1}\relax}%
  \fi
  \@tempskipa #5\relax
  \ifdim \@tempskipa>\z@
    \begingroup
      #6{%
        \@hangfrom{\hskip #3\relax\@svsec}%
          \interlinepenalty \@M #8\@@par}%
    \endgroup
    \csname #1mark\endcsname{#7}%
    \addcontentsline{toc}{#1}{%
      \ifnum #2>\c@secnumdepth \else
        \protect\numberline{\csname the#1\endcsname}%
      \fi
      #7}%
  \else
    \def\@svsechd{%
      #6{\hskip #3\relax
      \@svsec #8.}%
      \csname #1mark\endcsname{#7}%
      \addcontentsline{toc}{#1}{%
        \ifnum #2>\c@secnumdepth \else
          \protect\numberline{\csname the#1\endcsname}%
        \fi
        #7}}%
  \fi
  \@xsect{#5}}
%
\def\sectionfont{\reset@font\fontsize{10bp}{13bp}\fontshape{it}\selectfont\raggedright}
\def\subsectionfont{\reset@font\fontsize{10bp}{13bp}\fontshape{it}\selectfont\raggedright}
\def\subsubsectionfont{\reset@font\fontsize{10bp}{13bp}\fontshape{it}\selectfont\raggedright}
\def\paragraphfont{\reset@font\fontsize{10bp}{12.5bp}\selectfont\raggedright}
\def\subparagraphfont{\reset@font\fontsize{10bp}{12.5bp}\selectfont\raggedright}

\def\@seccntformat#1{\textup{\csname the#1\endcsname.}\hskip7.5pt}

\renewcommand\section{\@startsection {section}{1}{\z@}%
                                   {-13bp \@plus -2pt \@minus 2pt}%
                                   {0.05bp}%
                                   {\sectionfont}}
\renewcommand\subsection{\@startsection{subsection}{2}{\z@}%
                                     {-13pt \@plus -2pt \@minus 2pt}%
                                     {-1em}%
                                     {\subsectionfont}}
\renewcommand\subsubsection{\@startsection{subsubsection}{3}{\z@}%
                                     {-13pt \@plus -2pt \@minus 2pt}%
                                     {-1em}%
                                     {\subsubsectionfont}}
\renewcommand\paragraph{\@startsection{paragraph}{4}{\z@}%
                                    {12.5pt \@plus 2pt \@minus 2pt}%
                                    {0.0001pt}%
                                    {\paragraphfont}}
\renewcommand\subparagraph{\@startsection{subparagraph}{5}{\z@}%
                                       {-6pt \@plus1ex \@minus .2ex}%
                                       {-1em}%
                                     {\subparagraphfont}}
%
\def\@startsection#1#2#3#4#5#6{%
  \if@noskipsec \leavevmode \fi
  \par
  \@tempskipa #4\relax
  \@afterindentfalse
  \ifdim \@tempskipa <\z@
    \@tempskipa -\@tempskipa \@afterindentfalse
  \fi
  \if@nobreak
    \everypar{}\ifnum#2=2\vskip0pt\fi\ifnum#2=3\vspace*{-1pt}\fi\ifnum#2=4\vskip-1pt\fi%
  \else
    \addpenalty\@secpenalty\addvspace\@tempskipa
  \fi
  \@ifstar
    {\@ssect{#3}{#4}{#5}{#6}}%
    {\@dblarg{\@sect{#1}{#2}{#3}{#4}{#5}{#6}}}}
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Lists %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

\newdimen\labelwidthi
\newdimen\labelwidthii
\newdimen\labelwidthiii
\newdimen\labelwidthiv
\def\normal@labelsep{0.5em}
\labelsep\normal@labelsep
\settowidth{\labelwidthi}{(iii)}
\settowidth{\labelwidthii}{(d)}
\settowidth{\labelwidthiii}{(iii)}
\settowidth{\labelwidthiv}{(M)}
\leftmargini\labelwidthi    \advance\leftmargini\labelsep
\leftmarginii\labelwidthii  \advance\leftmarginii\labelsep
\leftmarginiii\labelwidthiii \advance\leftmarginiii\labelsep
\leftmarginiv\labelwidthiv  \advance\leftmarginiv\labelsep
\def\setleftmargin#1#2{\settowidth{\@tempdima}{#2}\labelsep\normal@labelsep
  \csname labelwidth#1\endcsname\@tempdima
  \@tempdimb\@tempdima \advance\@tempdimb\labelsep
  \csname leftmargin#1\endcsname\@tempdimb}
\def\@listI{\leftmargin\leftmargini
  \labelwidth\labelwidthi \labelsep\normal@labelsep
  \topsep 6pt \partopsep\z@ \parsep\z@ \itemsep\z@
  \listparindent 1em}
\def\@listii{\leftmargin\leftmarginii
  \labelwidth\labelwidthii \labelsep\normal@labelsep
  \topsep\z@ \partopsep\z@ \parsep\z@ \itemsep\z@
  \listparindent 1em}
\def\@listiii{\leftmargin\leftmarginiii
  \labelwidth\labelwidthiii \labelsep\normal@labelsep
  \topsep\z@ \partopsep\z@ \parsep\z@ \itemsep\z@
  \listparindent 1em}
\def\@listiv{\leftmargin\leftmarginiv
  \labelwidth\labelwidthiv \labelsep\normal@labelsep
  \topsep\z@ \partopsep\z@ \parsep\z@ \itemsep\z@
  \listparindent 1em}
\let\@listi\@listI
\@listi
%
\setlength  \labelsep  {.5em}
\setlength  \labelwidth{\leftmargini}
\addtolength\labelwidth{-\labelsep}
\@beginparpenalty -\@lowpenalty
\@endparpenalty   -\@lowpenalty
\@itempenalty     -\@lowpenalty
\def\labelitemi{$\bullet$}          \def\labelitemii{$\cdot$}
\def\labelenumi{(\theenumi)}        \def\theenumi{\arabic{enumi}}
\def\labelenumii{(\alph{enumii})}   \def\theenumii{\theenumi\alph{enumii}}
\def\labelenumiii{(\roman{enumiii})}\def\theenumiii{\theenumii.\roman{enumiii}}
\def\labelenumiv{(\Alph{enumiv})}   \def\theenumiv{\theenumiii.\Alph{enumiv}}

%
%%%%%%%%%%%%%%%%%%%%%%%%%%% Ordered & Unordered List  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

\def\listfont{\selectfont}%

\def\enumargs{%
  \listfont%
  \leftmargini0pt%
  \topsep 0pt%3pt%
  \partopsep     \z@%
  \itemsep       \z@%
  \parsep        \z@%
  \labelsep      1em%
  \rightmargin   \z@%
  \raggedright%
  \listparindent \parindent%
  \itemindent    \z@}%

\def\labelenumi{\textup{(\theenumi)}}        \def\theenumi{\arabic{enumi}}
\def\labelenumii{\textup{(\alph{enumii})}}   \def\theenumii{\theenumi\alph{enumii}}
\def\labelenumiii{\textup{(\roman{enumiii})}}\def\theenumiii{\theenumii.\roman{enumiii}}
\def\labelenumiv{\textup{(\Alph{enumiv})}}   \def\theenumiv{\theenumiii.\Alph{enumiv}}

\renewcommand\labelitemi{\raisebox{-1.55pt}{\fontsize{14}{12}\selectfont\textbullet}}

\def\enumerate{%
    \@ifnextchar[{\@numerate}{\@numerate[0.]}}

\def\@numerate[#1]{\par%
     \ifnum \@enumdepth >3 \@toodeep\else
     \advance\@enumdepth \@ne
     \edef\@enumctr{enum\romannumeral\the\@enumdepth}
     \list{\csname label\@enumctr\endcsname}{%
       \enumargs%
       \setlength{\leftmargin}{\csname leftmargin\romannumeral\the\@enumdepth\endcsname}
       \usecounter{\@enumctr}
       \settowidth\labelwidth{#1}
       \addtolength{\leftmargin}{\labelwidth}
       \addtolength{\leftmargin}{\labelsep}
       \def\makelabel##1{\hss\llap{##1}}}%
     \fi
   }
\let\endenumerate\endlist

%%Unnumbered list%%
\def\unenumargs{%
   \listfont%
   \leftmargini\parindent%
   \topsep6pt%
   \partopsep     \z@%
   \itemsep       \z@%
   \parsep        \z@%
   \labelsep      0\p@%
   \rightmargin   \z@%
   \raggedright%
   \listparindent \parindent%
   \itemindent    -10pt}%

\def\unenumerate{%
    \@ifnextchar[{\@unenumerate}{\@unenumerate[0.]}}

\def\@unenumerate[#1]{\par%
     \ifnum \@enumdepth >3 \@toodeep\else
     \advance\@enumdepth \@ne
     \edef\@enumctr{enum\romannumeral\the\@enumdepth}
     \list{\csname label\@enumctr\endcsname}{%
       \unenumargs
       \setlength{\leftmargin}{\csname leftmargin\romannumeral\the\@enumdepth\endcsname}
       \usecounter{\@enumctr}
       \settowidth\labelwidth{#1}
       \addtolength{\leftmargin}{\labelwidth}
       \addtolength{\leftmargin}{\labelsep}
       \def\makelabel##1{\hss\llap{##1}}}%
     \fi
   }
\let\endunenumerate\endlist%

\def\itemargs{%
   \listfont%
   \leftmargini0pt%
   \topsep0pt%3pt%
   \partopsep     \z@%
   \itemsep       \z@%
   \parsep        \z@%
   \labelsep      11pt%
   \rightmargin   \z@%
   \raggedright%
   \listparindent \parindent%
   \itemindent    \z@}%

\renewcommand\labelitemi{\raise1pt\hbox{\textbullet}}
\renewcommand\labelitemii{\textendash}

\def\itemize{%
   \@ifnextchar[{\@itemize}{\@itemize[$\bullet$]}}

\def\@itemize[#1]{\par%
     \ifnum \@itemdepth >3 \@toodeep\else
     \advance\@itemdepth \@ne
     \edef\@itemctr{item\romannumeral\the\@itemdepth}
     \list{\csname label\@itemctr\endcsname}{%
       \itemargs
       \setlength{\leftmargin}{\csname leftmargin\romannumeral\the\@itemdepth\endcsname}
       \settowidth\labelwidth{#1}
       \addtolength{\leftmargin}{\labelwidth}
       \addtolength{\leftmargin}{\labelsep}
       \def\makelabel##1{\hss \llap{##1}}}%
     \fi
   }
\let\enditemize\endlist
%
\def\verse{\let\\=\@centercr
  \list{}{\itemsep\z@
  \itemindent \z@
  \listparindent\z@
  \rightmargin 1em
  \leftmargin \rightmargin}\item[]}
\let\endverse\endlist
\def\quotation{\list{}{\vskip 8pt\itemindent\z@
 \leftmargin 1em \rightmargin \z@
  \parsep \z@ \@plus 1pt}\item[]}
\newcommand\e{\endlist\vskip 8pt}
\let\endquotation\e
\def\quote{\list{}{\itemindent\z@
   \leftmargin 1em \rightmargin \z@}%
\item[]}
\let\endquote\endlist
\def\descriptionlabel#1{\hspace\labelsep \itshape #1}
\def\description{\list{}{\labelwidth\z@
  \leftmargin \z@ \topsep6pt\itemindent \z@ %-\leftmargin
  \let\makelabel\descriptionlabel}}
\let\enddescription\endlist

%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Float %%%%%%%%%%%%%%%%%%%%%%%%%%%%

   \setlength\abovecaptionskip{9.5\p@}
   \setlength\belowcaptionskip{3\p@}

\setlength\arraycolsep{2\p@}
\setlength\tabcolsep{6\p@}
\setlength\arrayrulewidth{.4\p@}
\setlength\doublerulesep{2\p@}
\setlength\tabbingsep{\labelsep}

\def\fnum@figure{{\figurename}\space\relax{\thefigure}}
\def\fnum@table{{\tablename}\space\relax{\thetable}}

\def\FigName{figure}

\long\def\@makecaption#1#2{%
    \ifx\FigName\@captype
      \vskip\abovecaptionskip
        \@figurecaption{#1}{#2}
    \else
        \@tablecaption{#1}{#2}
      \vskip\belowcaptionskip
    \fi%
}


%% Figure

\def\figurenumfont{\reset@font\fontfamily{\rmdefault}\fontsize{8}{9.5}\fontshape{sc}\selectfont}
\def\figurecaptionfont{\fontfamily{\rmdefault}\fontsize{8}{9.5}\selectfont\leftskip=0cm plus 0.5fil \rightskip=0cm plus -0.5fil \parfillskip=0cm plus 1fil}

\newdimen\figwidth%
\newdimen\figheight%
\newdimen\sidecapwidth
\newdimen\wrapcapline%
\newdimen\totalwrapline%
\newdimen\wraptotline%

%% Figures macro
\newbox\figurebox%
\newbox\wrapfigcapbox
\def\FIG#1#2{%
\setbox\figurebox\hbox{#1}%
%% Figure dimensions
\figwidth\wd\figurebox%
\figheight\ht\figurebox%
{\parbox{\textwidth}{%
%% Figure width checking
\ifdim\figwidth>170pt%
    %% Normal figures
    \centerline{\box\figurebox}%
    %% Caption
    #2%
\else%
    \global\sidecapwidth\textwidth%
    \global\advance\sidecapwidth-\figwidth%
    \global\advance\sidecapwidth-10pt%
    %% Small figures
    \rightline{\box\figurebox}%
    %% Side Caption
    #2%
\fi%
}}}


%% Figures caption
\newbox\figcapbox
\newbox\capbox
\long\def\@figurecaption#1#2{%
{%
\setbox\figcapbox\hbox{\figurecaptionfont{\figurenumfont #1}\ #2:\vphantom{y}\par}
%% Caption printing depending on figure width
\ifdim\wd\figcapbox>\textwidth
{\figurecaptionfont{\figurenumfont #1:}\ {#2}.\par}%
\else
{\figurecaptionfont\centering{\figurenumfont #1:}\ {#2}.\par}%
\fi
}}%

%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
\RequirePackage{booktabs}
\cmidrulewidth=.15pt%
%
\def\tablenumfont{\reset@font\fontsize{10}{12}\fontshape{it}\fontseries{b}\selectfont}
\def\tablecaptionfont{\fontsize{10}{12}\fontshape{it}\selectfont}
\def\tablebodyfont{\fontsize{10}{12}\selectfont}
\def\tablecolheadfont{\fontsize{10}{12}\selectfont}
\def\tablefootnotefont{\fontsize{7}{8}\selectfont\raggedright}


%% Table Macro
\newbox\tablebox
%\newdimen\tabbodywidth
\long\def\TBL#1#2{%
\renewcommand\arraystretch{1}%
%\setbox\tablebox\hbox{\tablebodyfont #2\par}
%\tabbodywidth\wd\tablebox%
#1\vskip 0pt%
{\tablebodyfont #2\par}%
}

%% Table Caption
\newbox\tabcapbox
\newdimen\tabcapwidth
\long\def\@tablecaption#1#2{%
{\setbox\tabcapbox\hbox{\tablecaptionfont{\tablenumfont #1:}\ #2\vphantom{y}\endgraf}%
\tabcapwidth\wd\tabcapbox%
\ifdim\tabcapwidth<\textwidth%
    {\tablecaptionfont\centering{\tablenumfont #1:}\ #2\vphantom{y}\par}%
\else
    {\tablecaptionfont{\tablenumfont #1:}\ #2\vphantom{y}\par}%
\fi}}%

%% Table Column Heads
\def\TCH#1{{\tablecolheadfont #1}}

%% Table Footnotes
\newenvironment{fntable}[1][\columnwidth]{%
\def\@makefnmark{\hbox{\@textsuperscript{\fontsize{5}{5}\selectfont\@thefnmark}}}%
\begin{minipage}{#1}%
\def\thempfootnote{{\@arabic\c@mpfootnote}}
%%%%%%%%%%
\def\@xfootnotemark[##1]{%
   \begingroup
      %\c@footnote #1\relax
      \unrestored@protected@xdef\@thefnmark{##1}%
   \endgroup
   \@footnotemark}
%%%%%%%%%
\def\@xfootnotenext[##1]{%
  \begingroup
     %\csname c@\@mpfn\endcsname ##1\relax
     \unrestored@protected@xdef\@thefnmark{##1}%
  \endgroup
  \@footnotetext}
\renewcommand\@makefntext[1]{{%
\tablefootnotefont%
\hskip0pt{\smash{\@makefnmark}}##1\par}}
\renewcommand\footnotesize{\@setfontsize\footnotesize{7}{8.5}}%
}%
{\vspace{-0.4\skip\footins}%
\renewcommand{\footnoterule}{}%
\end{minipage}}%

%% Table Rules
\def\toprule{%\noalign{\vskip3pt}
\noalign{\ifnum0=`}\fi
  \hrule \@height 0\p@ \@width 0pt
  \hrule \@height 1.5\p@ % <- rule height
  \hrule \@height 5pt \@width 0pt
  \futurelet\@tempa\@xhline}
% Middle rule
\def\midrule{\noalign{\ifnum0=`}\fi%
  \hrule \@height 3pt \@width 0pt
  \hrule \@height 1.5pt % <- rule height
  \hrule \@height 5pt \@width 0pt
  \futurelet \@tempa\@xhline}
% Bottom rule
\def\botrule{\noalign{\ifnum0=`}\fi
  \hrule \@height 3pt \@width 0pt
  \hrule \@height 1.5pt % <- rule height
  \futurelet\@tempa\@xhline}
%
\def\@@@cmidrule[#1-#2]#3#4{\global\@cmidla#1\relax
    \global\advance\@cmidla\m@ne
    \ifnum\@cmidla>0\global\let\@gtempa\@cmidrulea\else
    \global\let\@gtempa\@cmidruleb\fi
    \global\@cmidlb#2\relax
    \global\advance\@cmidlb-\@cmidla
    \global\@thisrulewidth=#3
    \@setrulekerning{#4}
    \ifnum\@lastruleclass=\z@\vskip 3\p@\fi
    \ifnum0=`{\fi}\@gtempa
    \noalign{\ifnum0=`}\fi\futurenonspacelet\@tempa\@xcmidrule}
\def\@xcmidrule{%
   \ifx\@tempa\cmidrule
       \vskip-\@thisrulewidth
       \global\@lastruleclass=\@ne
   \else \ifx\@tempa\morecmidrules
       \vskip \cmidrulesep
       \global\@lastruleclass=\@ne\else
       \vskip 5\p@
       \global\@lastruleclass=\z@
   \fi\fi
   \ifnum0=`{\fi}}
\let\cline\cmidrule

%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%5
%

\renewcommand\@pnumwidth{1.55em}
\renewcommand\@tocrmarg{2.55em}
\renewcommand\@dotsep{4.5}
\setcounter{tocdepth}{3}
\renewcommand\tableofcontents{%
    \section*{\contentsname
        \@mkboth{%
           \MakeUppercase\contentsname}{\MakeUppercase\contentsname}}%
    \@starttoc{toc}%
    }
\renewcommand*\l@part[2]{%
  \ifnum \c@tocdepth >-2\relax
    \addpenalty\@secpenalty
    \addvspace{2.25em \@plus\p@}%
    \begingroup
      \setlength\@tempdima{3em}%
      \parindent \z@ \rightskip \@pnumwidth
      \parfillskip -\@pnumwidth
      {\leavevmode
       \large \bfseries #1\hfil \hb@xt@\@pnumwidth{\hss #2}}\par
       \nobreak
       \if@compatibility
         \global\@nobreaktrue
         \everypar{\global\@nobreakfalse\everypar{}}%
      \fi
    \endgroup
  \fi}
\renewcommand*\l@section[2]{%
  \ifnum \c@tocdepth >\z@
    \addpenalty\@secpenalty
    \addvspace{0em}% \@plus\p@}%
    \setlength\@tempdima{1.5em}%
    \begingroup
      \parindent \z@ \rightskip \@pnumwidth
      \parfillskip -\@pnumwidth
      \leavevmode \bfseries
      \advance\leftskip\@tempdima
      \hskip -\leftskip
      #1\nobreak\hfil \nobreak\hb@xt@\@pnumwidth{\hss #2}\par
    \endgroup
  \fi}
\renewcommand*\l@subsection{\@dottedtocline{2}{1.5em}{2.3em}}
\renewcommand*\l@subsubsection{\@dottedtocline{3}{3.8em}{3.2em}}
\renewcommand*\l@paragraph{\@dottedtocline{4}{7.0em}{4.1em}}
\renewcommand*\l@subparagraph{\@dottedtocline{5}{10em}{5em}}
\renewcommand\listoffigures{%
    \section*{\listfigurename
      \@mkboth{\MakeUppercase\listfigurename}%
              {\MakeUppercase\listfigurename}}%
    \@starttoc{lof}%
    }
\renewcommand*\l@figure{\@dottedtocline{1}{1.5em}{2.3em}}
\renewcommand\listoftables{%
    \section*{\listtablename
      \@mkboth{%
          \MakeUppercase\listtablename}{\MakeUppercase\listtablename}}%
    \@starttoc{lot}%
    }
\let\l@table\l@figure

%
%%%%%%%%%%%%%%%%%%%%%%%%%%%% Mini-TOC %%%%%%%%%%%%%%%%%%%%%%%%%
%

\RequirePackage{etoc}
\etocarticlestylenomarks
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%% Other Env. %%%%%%%%%%%%%%%%%%%%%%%%%
%

\renewenvironment{quote}
               {\list{}{\topsep=0pt\topsep6pt\leftmargin=1em\raggedright}%
                \item\relax}
               {\endlist}
               
\def\ackname{Acknowledgements}%
%
\newenvironment{ack}[1][\ackname]%
{\ifx#1\empty\else\subsection*{#1.}\fi\par}
{\par}
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%% Theorems %%%%%%%%%%%%%%%%%%%%%%%%%
%
\if@cupthm
    \RequirePackage{amsthm}
    \let\proof\relax
    \let\endproof\relax
    \newif\ifproofthm
    \gdef\QED{\global\proofthmfalse\vskip-\lastskip\vskip-8pt\nointerlineskip\leavevmode{\qed}\vspace*{8pt}\endgraf}
    \def\@endtheorem{\ifproofthm\qed\global\proofthmfalse\fi\endtrivlist\@endpefalse}
    %\def\@endtheorem{\endtrivlist\@endpefalse}

    %%%%%%%%%%%%%%%%%% StyleOne Definition
    \newtheoremstyle{cupplain}
    {8.5pt}                  % Space above
    {8.5pt}                  % Space below
    {\normalfont\itshape}           % Body font
    {0pt}            % Indent amount
    {\scshape}             % Theorem head font
    {.}                     % Punctuation after theorem head
    {.35em}                 % Space after theorem headi
    {\@ifempty{#2}{%        % Optional head on unnumbered
        \@ifempty{#3}{\thmname{#1}}{\thmname{#1}\space\thmnote{{\reset@font\the\thm@headfont\rm #3}}}%
    }{%                     % Main head on numbered
        \thmname{#1}\thmnumber{\@ifnotempty{#1}{ }\@upn{#2}}\thmnote{ {\reset@font\the\thm@notefont\rm #3}}%
    }}%
    %
    %
    %%%%%%%%%%%%%%%%%% StyleTwo Definition
    \newtheoremstyle{cupdefinition}%
    {8.5pt}                  % Space above
    {8.5pt}                  % Space below
    {\normalfont}           % Body font
    {0pt}            % Indent amount
    {\itshape}             % Theorem head font
    {}                     % Punctuation after theorem head
    {.35em}                 % Space after theorem headi
    {\@ifempty{#2}{%        % Optional head on unnumbered
        \@ifempty{#3}{\thmname{#1}}{\thmname{#1}\space\thmnote{\textup{\the\thm@headfont\rm #3}}}%
    }{%                     % Main head on numbered
        \thmname{#1}\thmnumber{\@ifnotempty{#1}{ }{#2.}}\thmnote{ \textup{\the\thm@notefont\rm #3}}%(#3)
    }}%
    %
    %%%%%%%%%%%%%%%%%% StyleThree Definition
    %
    \newtheoremstyle{cupremark}
    {8.5pt}                  % Space above
    {8.5pt}                  % Space below
    {\normalfont}           % Body font
    {0pt}            % Indent amount
    {\scshape}             % Theorem head font
    {.}                     % Punctuation after theorem head
    {.35em}                 % Space after theorem headi
    {\@ifempty{#2}{%        % Optional head on unnumbered
        \@ifempty{#3}{\thmname{#1}}{\thmname{#1}\space\thmnote{{\the\thm@headfont\rm #3}}}%
    }{%                     % Main head on numbered
        \thmname{#1}\thmnumber{\@ifnotempty{#1}{ }{#2}}\thmnote{ {\the\thm@notefont\rm #3}}%(#3)
    }}%
    %
    %%%%%%%%%%%%%%%%%% StyleFour Definition
    \newtheoremstyle{cupnote}
    {8.5pt}                  % Space above
    {8.5pt}                  % Space below
    {\normalfont}           % Body font
    {\parindent}            % Indent amount
    {\itshape}              % Theorem head font
    {.}                     % Punctuation after theorem head
    {.35em}                 % Space after theorem headi
    {\@ifempty{#2}{%        % Optional head on unnumbered
        \@ifempty{#3}{\thmname{#1}}{\thmname{#1}\space\thmnote{{\the\thm@headfont\rm #3}}}%
    }{                      % Main head on numbered
        \thmname{#1}\thmnumber{\@ifnotempty{#1}{ }\@upn{#2}}\thmnote{ {\the\thm@notefont\rm #3}}%(#3)
    }}%


    %%%%%%%%%%%%%%%%%% StyleFive Definition
    \newtheoremstyle{cupproof}
    {8.5pt}                  % Space above
    {8.5pt}                  % Space below
    {\normalfont}           % Body font
    {0pt}            % Indent amount
    {\itshape}             % Theorem head font
    {.}                     % Punctuation after theorem head
    {.45em}                 % Space after theorem headi
    {\global\proofthmtrue   % Theorem head spec (can be left empty, meaning `normal')
        \@ifempty{#3}{\thmname{#1}}{\thmname{#3}}%
    }
\fi

%
%%%%%%%%%%%%%%%%%%%%%%%%%%%% Appendix %%%%%%%%%%%%%%%%%%%%%%%%%
%

\newif\ifbackmatter%
\newcommand{\backmatter}{\par\global\backmattertrue}
               
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%% Appendix %%%%%%%%%%%%%%%%%%%%%%%%%
%
\def\appheader{%
%%\section*{APPENDIX}
\setcounter{section}{0}
\setcounter{theorem}{0}
\setcounter{equation}{0}
\renewcommand\thesection{\Alph{section}}
\renewcommand\thetheorem{A.\arabic{theorem}}
\renewcommand\thelemma{A.\arabic{lemma}}
\renewcommand\theequation{A.\arabic{equation}}
}
\ifx\appendix\undefined
\def\appendix{\bgroup\par}
\def\endappendix{\par\egroup}
\fi
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%% BackMatters %%%%%%%%%%%%%%%%%%%%%%%%%
%
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%


%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Doi-Links %%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%% From doi.sty %%

\DeclareRobustCommand{\doitext}{{doi}:}%

%% the meat of the code
%% the first command opens a group, and changes a few catcodes.
\newcommand*{\DOI}{%
  \begingroup
  \lccode`\~=`\#\relax
  \lowercase{\def~{\#}}%
  \lccode`\~=`\_\relax
  \lowercase{\def~{\_}}%
  \lccode`\~=`\<\relax
  \lowercase{\def~{\textless}}%
  \lccode`\~=`\>\relax
  \lowercase{\def~{\textgreater}}%
  \lccode`\~=0\relax
  \catcode`\#=\active
  \catcode`\_=\active
  \catcode`\<=\active
  \catcode`\>=\active
  \doitext\@mydoi
}

%% this is the actual command which processes the argument, with the catcodes
%% set in the previous command
%% it closes the group, and spits out the url.
\def\@mydoi#1{%
  \let\#\relax
  \let\_\relax
  \let\textless\relax
  \let\textgreater\relax
  \edef\x{\toks0={{#1}}}%
  \x
  \edef\#{\@percentchar23}%
  \edef\_{_}%
  \edef\textless{\@percentchar3C}% instead of {\string<} for Apple
  \edef\textgreater{\@percentchar3E}% instead of {\sting>} for Apple
  \edef\x{\toks1={\noexpand\href{http://dx.doi.org/#1}}}%
  \x
  \edef\x{\endgroup\the\toks1 \the\toks0}%
  \x
}
%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Article History  %%%%%%%%%%%%%%%%%%%%
%%%
%%\def\@history{}
%%\def\printhistory{{\par\addvspace{-10pt}%
%%\historyfont\noindent%
%%\ifx\@history\empty\gdef\@history{Received xx xxx xxxx}\fi\@history.\par}
%%}%

%
\renewenvironment{theindex}
               {\if@twocolumn
                  \@restonecolfalse
                \else
                  \@restonecoltrue
                \fi
                \columnseprule \z@
                \columnsep 35\p@
                \twocolumn[\section*{\indexname}]%
                \@mkboth{\MakeUppercase\indexname}%
                        {\MakeUppercase\indexname}%
                \thispagestyle{plain}\parindent\z@
                \parskip\z@ \@plus .3\p@\relax
                \let\item\@idxitem}
               {\if@restonecol\onecolumn\else\clearpage\fi}
\renewcommand\@idxitem{\par\hangindent 40\p@}
\renewcommand\subitem{\@idxitem \hspace*{20\p@}}
\renewcommand\subsubitem{\@idxitem \hspace*{30\p@}}
\renewcommand\indexspace{\par \vskip 10\p@ \@plus5\p@ \@minus3\p@\relax}

%
%%%%%%%%%%%%%%%%%%%%%%% Footnotes %%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

\renewcommand\footnoterule{%
  \kern2\p@%
  \hrule \@height.5pt \@width10pc%
  \kern3.25\p@}%
%

\def\@makefnmark{{\textsuperscript{\@thefnmark}}}

\renewcommand\@makefntext[1]{%
    \hskip12pt{\smash{\@makefnmark}}#1}

%

\RequirePackage{hyperref}
\RequirePackage{hypcap}
%%\RequirePackage[hyphenbreaks]{breakurl}
%%    \bgroup
%%      \catcode`\&=12\relax
%%      \hyper@normalise\burl@addtocharlistbefore{%}
%%      \hyper@normalise\burl@addtocharlistafter{:/.?#&_,;!=+~}%% for extra breaks in url
%%    \egroup
%%    \burl@defifstructure
%%%
\hypersetup{%
        colorlinks,
        breaklinks=true,
        plainpages=false,%
        citecolor=blue,
        linkcolor=blue,
        urlcolor=blue,
        bookmarksopen=true,%
        bookmarksnumbered=false,%
        bookmarksdepth=3%
}
\AtBeginDocument{\renewcommand\UrlFont{\rmfamily}}
%
\AtBeginDocument{%
\@ifpackageloaded{natbib}{%
\def\@biblabel#1{[#1]\hfill}
  \renewcommand\bibsection{%
   \section*{\refname}%
   \addcontentsline{toc}{section}{\refname}%
   \vspace*{8.75pt}%
  }%
}{}%
}%

\def\doi#1{\quad\url{http://dx.doi.org/#1}}
%
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

\pagestyle{headings}
\pagenumbering{arabic}
\sloppy
\frenchspacing
\flushbottom
\linepenalty=100

\endinput


