% CUP Journal ACTA Numerica document style -- V0.96 Released 22 October 1991
%
% Copyright (C) 1991 Cambridge University Press
%
%    V 0.92 mods by Rod Mulvey, 9 April 1991, see %RM
%    V 0.93 mods by Sue Brooks, 19 May 1991, see %SFB
%    V 0.94 mods by Sue Brooks, 10 July 1991, see %SFB 0.94
%    V 0.95 mods by Alison Woollatt, 18 October 1991, see %AJW
%    V 0.96 mods by Alison Woollatt, 22 October 1991, see %AJW
%    for LaTeX version 2.09
%
% based on ARTICLE DOCUMENT STYLE by Leslie Lamport
%
\typeout{Document Style `ACTA journal style' v0.96 released 22 October 1991}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% BJCB hacks to construct valid .cls file
%% BEGIN
%% 
%% There are only 5 changes made to this file. Just search for BEGIN
%% All changes are enclosed within the same comment declaration as this
%% initial change.
%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\NeedsTeXFormat{LaTeX2e}[1997/12/01]
\ProvidesClass{acta_2022}[1998/06/30 v1.0 Acta]

\DeclareOldFontCommand{\rm}{\normalfont\rmfamily}{\mathrm}
\DeclareOldFontCommand{\sf}{\normalfont\sffamily}{\mathsf}
\DeclareOldFontCommand{\tt}{\normalfont\ttfamily}{\mathtt}
\DeclareOldFontCommand{\bf}{\normalfont\bfseries}{\mathbf}
\DeclareOldFontCommand{\it}{\normalfont\itshape}{\mathit}
\DeclareOldFontCommand{\sl}{\normalfont\slshape}{\@nomath\sl}
\DeclareOldFontCommand{\sc}{\normalfont\scshape}{\@nomath\sc}
\DeclareRobustCommand*\cal{\@fontswitch\relax\mathcal}
\DeclareRobustCommand*\mit{\@fontswitch\relax\mathnormal}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% BJCB hacks to construct valid .cls file
%% END
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%
%  Journals use two-sided printing.
%
\@twosidetrue
\@mparswitchtrue
\def\ds@draft{\overfullrule 5pt}  % Causes overfull hboxes to be marked.
%
%AJW
%GES7Feb01% \newif\ifAMSSWITCH \AMSSWITCHfalse
%GES7Feb01% \def\ds@ams{\AMSSWITCHtrue}

\@options

%  ****************************************
%  *               FONTS                  *
%  ****************************************
%
\lineskip 1pt
\normallineskip 1pt
\def\baselinestretch{1}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% BJCB hacks to construct valid .cls file
%% BEGIN
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\renewcommand{\normalsize}{\@setsize\normalsize{13pt}\xipt\@xipt
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% BJCB hacks to construct valid .cls file
%% END
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 \abovedisplayskip 6.5pt plus 1pt minus 1pt
 \belowdisplayskip \abovedisplayskip
 \abovedisplayshortskip 3pt plus 1pt
 \belowdisplayshortskip  \abovedisplayskip
 \let\@listi\@listI}
\def\small{\@setsize\small{12pt}\xpt\@xpt
 \abovedisplayskip 6pt plus 1pt minus 1pt
 \belowdisplayskip \abovedisplayskip
 \abovedisplayshortskip 3pt plus 1pt
 \belowdisplayshortskip \abovedisplayskip
 \def\@listi{\leftmargin\leftmargini
  \topsep 2pt plus 1pt minus 1pt
  \parsep \z@
  \itemsep \parsep}}
\def\footnotesize{\@setsize\footnotesize{11pt}\ixpt\@ixpt
 \abovedisplayskip 5.5pt plus 1pt minus 1pt
 \belowdisplayskip \abovedisplayskip
 \abovedisplayshortskip \z@ plus 1pt
 \belowdisplayshortskip  \abovedisplayskip
 \def\@listi{\leftmargin\leftmargini
  \topsep 2pt plus 1pt minus 1pt
  \parsep \z@
  \itemsep \parsep}}
\def\indexsize{\@setsize\indexsize{9pt}\viiipt\@viiipt}
\def\scriptsize{\@setsize\scriptsize{8pt}\viipt\@viipt}
\def\tiny{\@setsize\tiny{6pt}\vpt\@vpt}
\def\large{\@setsize\large{15pt}\xiipt\@xiipt}
\def\Large{\@setsize\Large{18pt}\xivpt\@xivpt}
\def\LARGE{\@setsize\LARGE{21pt}\xviipt\@xviipt}
\def\huge{\@setsize\huge{25pt}\xxpt\@xxpt}
\def\Huge{\@setsize\Huge{30pt}\xxvpt\@xxvpt}
\normalsize  % Choose the normalsize font.

%AJW AMS fonts

%GES7Feb01%  \ifAMSSWITCH
%GES7Feb01%   \font\tenmsy=msbm10
%GES7Feb01% \else
%GES7Feb01%   \font\tenmsy=cmsy10
%GES7Feb01% \fi

%GES7Feb01% \newfam\msyfam
%GES7Feb01% \textfont\msyfam=\tenmsy

%GES7Feb01% \def\hexnumber#1{\ifcase#1 0\or1\or2\or3\or4\or5\or6\or7\or8\or9\or
%GES7Feb01% 	A\or B\or C\or D\or E\or F\fi }
%GES7Feb01% \edef\msy{\hexnumber\msyfam}

%GES7Feb01% \def\Bbb{\ifmmode\let\next\Bbb@\else
%GES7Feb01% \def\next{\errmessage{Use \string\Bbb\space only in math mode}}\fi\next}
%GES7Feb01% \def\Bbb@#1{{\Bbb@@{#1}}}
%GES7Feb01% \def\Bbb@@#1{\fam\msyfam#1}

%  ****************************************
%  *            PAGE LAYOUT               *
%  ****************************************
%
% All margin dimensions measured from a point one inch from top and side
% of page.
%
% SIDE MARGINS:
\oddsidemargin  2pc      % Left margin on odd-numbered pages.
\evensidemargin 2pc      % Left margin on even-numbered pages.

\marginparwidth 2.0cm    % Width of marginal notes.
\marginparsep 10pt       % Horizontal space between outer margin and
                         % marginal note
% VERTICAL SPACING:
% Top of page:
\topmargin 3pc           %    Nominal distance from top of page to top of
                         %    box containing running head.
\headheight 13pt         %    Height of box containing running head.
\headsep   13pt          %    Space between running head and text.
\topskip = 13pt          %    '\baselineskip' for first line of page.
                         % Bottom of page:
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% BJCB hacks to construct valid .cls file
%% BEGIN
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%\footheight 13pt         %    Height of box containing running foot.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% BJCB hacks to construct valid .cls file
%% END
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\footskip 26pt           %    Distance from baseline of box containing foot
                         %    to baseline of last line of text.
% DIMENSION OF TEXT:
%
\textheight = 42\baselineskip \advance\textheight by \topskip
                         % Height of text (including footnotes and figures,
                         % excluding running head and foot).
\textwidth 30pc          % Width of text line.
                         % For two-column mode:
\columnsep 10pt          %    Space between columns
\columnseprule 0pt       %    Width of rule between columns.
%
% FOOTNOTES:
%
\footnotesep 6.5pt   % Height of strut placed at the beginning of every
                     % footnote = height of normal \footnotesize strut,
                     % so no extra space between footnotes.
\skip\footins 13pt plus 13pt minus 1pt % Space between last line of text and
                                         % top of first footnote.
%  FOR FLOATS ON A TEXT PAGE:
%
\floatsep 13pt plus 6.5pt minus 1pt      % Space between adjacent floats moved
                                         % to top or bottom of text page.
\textfloatsep 13pt plus 6.5pt minus 3pt  % Space between main text and floats
                                         % at top or bottom of page.
\intextsep 13pt plus 6.5pt minus 2pt     % Space between in-text figures and
                                         % text.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% BJCB hacks to construct valid .cls file
%% BEGIN
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%\@maxsep 13pt                            % The maximum of \floatsep,
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% BJCB hacks to construct valid .cls file
%% END
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

                                         % \textfloatsep and \intextsep (minus
                                         % the stretch and shrink).
%    TWO-COLUMN FLOATS IN TWO-COLUMN MODE:
\dblfloatsep 13pt plus 6.5pt minus 2pt   % Same as \floatsep for double-column
                                         % figures in two-column mode.
\dbltextfloatsep 13pt plus 4.5pt minus 3pt % \textfloatsep for double-column
                                         % floats.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% BJCB hacks to construct valid .cls file
%% BEGIN
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%\@dblmaxsep 13pt                         % The maximum of \dblfloatsep and
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% BJCB hacks to construct valid .cls file
%% END
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

                                         % \dbltexfloatsep.
%  FOR FLOATS ON A SEPARATE FLOAT PAGE OR COLUMN:
\@fptop 0pt plus 0fil    % Stretch at top of float page/column. (Must be
                         % 0pt plus ...)
\@fpsep 13pt plus 0fil   % Space between floats on float page/column.
\@fpbot 0pt plus 3fil    % Stretch at bottom of float page/column. (Must be
                         % 0pt plus ... )
%  DOUBLE-COLUMN FLOATS IN TWO-COLUMN MODE.
\@dblfptop 0pt plus 0fil % Stretch at top of float page. (Must be 0pt plus ...)
\@dblfpsep 13pt plus 0fil % Space between floats on float page.
\@dblfpbot 0pt plus 3fil % Stretch at bottom of float page. (Must be
                         % 0pt plus ... )
% MARGINAL NOTES:
\marginparpush 5pt       % Minimum vertical separation between two marginal
                         % notes.

%  ****************************************
%  *           PARAGRAPHING               *
%  ****************************************
%
\parskip \z@ plus .1pt             % Extra vertical space between paragraphs.
\parindent 1em                     % Width of paragraph indentation.
\partopsep 0pt plus 1pt            % Extra vertical space, in addition to
%
% The following page-breaking penalties are defined
%
\@lowpenalty   51      % Produced by \nopagebreak[1] or \nolinebreak[1]
\@medpenalty  151      % Produced by \nopagebreak[2] or \nolinebreak[2]
\@highpenalty 301      % Produced by \nopagebreak[3] or \nolinebreak[3]
%
\@beginparpenalty -\@lowpenalty    % Before a list or paragraph environment.
\@endparpenalty   -\@lowpenalty    % After a list or paragraph environment.
\@itempenalty     -\@lowpenalty    % Between list items.
%
\clubpenalty=0        % 'Club line'  at bottom of page is OK.
\widowpenalty=10000   % 'Widow line' at top of page is not good.


%  ****************************************
%  *                 PARTS                *
%  ****************************************
%
\def\part{\par
 \addvspace{4ex}
 \@afterindentfalse
 \secdef\@part\@spart}
\def\@part[#1]#2{\ifnum \c@secnumdepth >\m@ne
  \refstepcounter{part}
%GES%  \addcontentsline{toc}{part}{Part \thepart: #1}
  \addcontentsline{toc}{part}{PART \thepart: #1} %GES% 091117
 \else
  \addcontentsline{toc}{part}{#1}
 \fi
 {\parindent 0pt \raggedright
  \ifnum \c@secnumdepth >\m@ne
%GES%   \large\rm PART
   \large\bf PART %GES%
   \ifcase\thepart \or ONE \or TWO \or THREE \or FOUR \or FIVE
     \or SIX \or SEVEN \or EIGHT \or NINE \or TEN \else \fi
   \par \nobreak
  \fi
%GES%  \LARGE \rm #2
  \large \bf #2 %GES% 091117
  \markboth{}{}\par }
 \nobreak \vskip 3ex
 \@afterheading
}
% Heading for \part* command
\def\@spart#1{%
 {\parindent 0pt \raggedright
  \LARGE \rm #1\par}
 \nobreak
 \vskip 3ex
 \@afterheading
}

%  ****************************************
%  *               SECTIONS               *
%  ****************************************
%
\def\section{\@startsection{section}{1}{\z@}
 {-11pt plus -6.5pt minus -3.25pt}
 {6.5pt plus 0pt minus 1pt}
 {\raggedright\large\bf}}
\def\subsection{\@startsection{subsection}{2}{\z@}
 {-13pt plus -6.5pt minus -3.25pt}
 {6.5pt plus 0pt minus 1pt}
 {\raggedright\normalsize\it}}
\def\subsubsection{\@startsection{subsubsection}{3}{\z@}
 {-13pt plus -6.5pt minus -3.25pt}
{1pt plus 0pt minus 1pt}
 {\raggedright\normalsize\it}}
\def\paragraph{\@startsection{paragraph}{4}{\z@}
 {6.5pt plus 3.25pt minus 1pt}
 {-0.5em}
 {\normalsize\it}}
\def\subparagraph{\@startsection{subparagraph}{4}{\parindent}
 {6.5pt plus 3.25pt minus 1pt}
 {-0.5em}
 {\normalsize\rm}}
% The value of the counter secnumdepth gives the depth of the
% highest-level sectioning command that is to produce section numbers.
%
%AJW
\setcounter{secnumdepth}{3}
%
% Changes to \@sect to achieve full points after numbers in section headings
%
\def\@sect#1#2#3#4#5#6[#7]#8{\ifnum #2>\c@secnumdepth
  \def\@svsec{}
 \else \refstepcounter{#1}
  \edef\@svsec{\csname the#1\endcsname.\hskip 0.5em}\fi
 \@tempskipa #5\relax
 \ifdim \@tempskipa>\z@
  \begingroup #6\relax
   \@hangfrom{\hskip #3\relax\@svsec}{\interlinepenalty \@M #8\par}
  \endgroup
  \csname #1mark\endcsname{#7}%
  \addcontentsline{toc}{#1}{\ifnum #2>\c@secnumdepth \else
    \protect\numberline{\csname the#1\endcsname}\fi #7}
 \else
  \def\@svsechd{#6\hskip #3\@svsec #8\csname #1mark\endcsname
    {#7}\addcontentsline{toc}{#1}{\ifnum #2>\c@secnumdepth \else
      \protect\numberline{\csname the#1\endcsname}\fi#7}}
 \fi
 \@xsect{#5}}
%
% APPENDIX
%
\def\appendix{\par
 \setcounter{section}{0}
 \setcounter{subsection}{0}
 \def\thesection{\Alph{section}}}

%  ****************************************
%  *               SKIPS                  *
%  ****************************************
%
\newskip\@indentskip    % General CUP indent
\newskip\smallindent    % para. indent
\newskip\@footindent    % footnote indent
\newskip\@leftskip      % for CUP float stuff

\@indentskip=2pc
\smallindent=1em
\@footindent=\smallindent
\@leftskip=1pc

%  ****************************************
%  *                LISTS                 *
%  ****************************************
%
\leftmargini   \@indentskip
\leftmarginii  1.5pc
\leftmarginiii 1.5pc
\leftmarginiv  1.5pc
\leftmarginv   1pc
\leftmarginvi  1pc
\leftmargin\leftmargini
\labelsep 0.5em
\labelwidth\leftmargini\advance\labelwidth-\labelsep
%
% label macros for Range-Left and Range-Right labels
\def\makeRLlabel#1{\rlap{#1}\hss}
\def\makeRRlabel#1{\hss\llap{#1}}
%
\def\@listI{\leftmargin\leftmargini
 \parsep \z@ plus 1pt minus 1pt
 \topsep 6.5pt plus 1pt minus 1pt
 \itemsep \z@ plus 1pt minus 1pt
 \let\makelabel\makeRLlabel}
\let\@listi\@listI
\@listi
\def\@listii{\leftmargin\leftmarginii
 \labelwidth\leftmarginii\advance\labelwidth-\labelsep
 \topsep 6.5pt plus 1pt minus 1pt
 \parsep \z@
 \itemsep \parsep
 \let\makelabel\makeRLlabel}
\def\@listiii{\leftmargin\leftmarginiii
 \labelwidth\leftmarginiii\advance\labelwidth-\labelsep
 \topsep 6.5pt plus 1pt minus 1pt
 \parsep \z@
 \partopsep \z@
 \itemsep \parsep
 \let\makelabel\makeRRlabel}
\def\@listiv{\leftmargin\leftmarginiv
 \labelwidth\leftmarginiv\advance\labelwidth-\labelsep
 \let\makelabel\makeRLlabel}
\def\@listv{\leftmargin\leftmarginv
 \labelwidth\leftmarginv\advance\labelwidth-\labelsep
 \let\makelabel\makeRLlabel}
\def\@listvi{\leftmargin\leftmarginvi
 \labelwidth\leftmarginvi\advance\labelwidth-\labelsep
 \let\makelabel\makeRLlabel}
%
% ENUMERATE
%GES\def\enumerate{\ifnum \@enumdepth >3 \@toodeep
%GES \else
%GES  \advance\@enumdepth \@ne
%GES  \edef\@enumctr{enum\romannumeral\the\@enumdepth}%
%GES  \list{\csname label\@enumctr\endcsname}%
%GES       {\usecounter{\@enumctr}\let\makelabel\makeRLlabel}%
%GES \fi}

\def\labelenumi{\theenumi}
\def\theenumi{\arabic{enumi}}

\def\labelenumii{(\theenumii)}
\def\theenumii{\alph{enumii}}
\def\p@enumii{\theenumi}

\def\labelenumiii{\theenumiii}
\def\theenumiii{\roman{enumiii}}
\def\p@enumiii{\theenumi(\theenumii)}

\def\labelenumiv{\theenumiv}
\def\theenumiv{\Alph{enumiv}}
\def\p@enumiv{\p@enumiii\theenumiii}
%
% ITEMIZE
%
%GES\def\itemize{\ifnum \@itemdepth >3 \@toodeep
%GES  \else
%GES   \advance\@itemdepth \@ne
%GES   \edef\@itemitem{labelitem\romannumeral\the\@itemdepth}%
%GES   \list{\csname\@itemitem\endcsname}{\let\makelabel\makeRLlabel}%
%GES  \fi}

\def\labelitemi{$\bullet$}
\def\labelitemii{\bf --}
\def\labelitemiii{$\ast$}
\def\labelitemiv{$\cdot$}
%
% DESCRIPTION
%
\def\descriptionlabel#1{\hspace\labelsep \bf #1}
\def\description{\list{}{\labelwidth\z@ \itemindent-\leftmargin
       \let\makelabel\descriptionlabel}}
\let\enddescription\endlist
%
% Unlabelled run-in list
%\def\unnumlabel#1{\rm #1}
\def\unnum{\list{}{\labelwidth\z@
%       \let\makelabel\unnumlabel
       \leftmargin \parindent
       \itemindent-\parindent
}}
\let\endunnum\endlist
%
% VERSE
%
\def\verse{\let\\=\@centercr
  \list{}{\itemsep\z@
          \itemindent -\@indentskip
          \listparindent \itemindent
          \rightmargin\leftmargin
          \advance\leftmargin \@indentskip}\item[]}
\let\endverse\endlist
%
% QUOTATION
%
\def\quotation{\list{}{\listparindent \smallindent
    \itemindent\listparindent
    \leftmargin\z@\rightmargin\leftmargin
    \parsep 0pt plus 1pt}\item[]\small}
\let\endquotation=\endlist
%
% QUOTE -- same as quotation except no paragraph indentation,
%
\def\quote{\list{}{\leftmargin\z@\rightmargin\leftmargin}\item[]\small}
\let\endquote=\endlist
%

%  ****************************************
%  *         TITLE AND ABSTRACT           *
%  ****************************************
%
\def\maketitle{\par
 \begingroup
   \def\thefootnote{\fnsymbol{footnote}}
   \def\@makefnmark{\hbox to 0pt{$^{\@thefnmark}$\hss}}
   \newpage
   \global\@topnum\z@
   \@maketitle
   \thispagestyle{titlepage}
   \@thanks
 \endgroup
 \setcounter{footnote}{0}
 \let\maketitle\relax
 \let\@maketitle\relax
 \gdef\@thanks{}
% \gdef\@author{}\gdef\@title{}
 \let\thanks\relax}
\def\and{\end{author@tabular}\vskip .25em\par
   \begin{author@tabular}[t]{@{}c@{}}}

\def\@maketitle{%
 \vspace*{0\baselineskip}
 \noindent
 \raisebox{0pt}[0pt][0pt]{\begin{minipage}[t]{\textwidth}%
  \parindent 0pt \centering\sloppy
  {\LARGE \bf \@title \par}
   \vskip 15pt
  {\large
   \begin{author@tabular}[t]{@{}c@{}}\@author
   \end{author@tabular}\par}
%RM  \vskip 13pt
%RM  {\small\it (Received \@date)}
  \par\noindent
  \end{minipage}}
 \par\noindent \nobreak
 \vskip 10\baselineskip plus 0.5\baselineskip minus 0.25\baselineskip
}
\def\abstract{\list{}{\leftmargin 1pc\rightmargin 1pc
    \parsep 0pt plus 1pt}%\raggedright
    \item[]\small}
\def\endabstract{\endlist\vspace{6.5pt}}

%  ****************************************
%  *            PAGE STYLES               *
%  ****************************************
%
\mark{{}{}}   % Initializes TeX's marks

\gdef\@author{\mbox{}} % SFB 0.93
\def\author{\@ifnextchar [{\@authortwo}{\@authorone}}
\def\@authortwo[#1]#2{\gdef\@author{#2}\gdef\@shortauthor{#1}}
\def\@authorone#1{\gdef\@author{#1}\gdef\@shortauthor{#1}}
\def\shortauthor#1{\gdef\@shortauthor{#1}}
\gdef\@shortauthor{\@author}
\gdef\@title{\mbox{}} % SFB 0.93
\def\title{\@ifnextchar [{\@titletwo}{\@titleone}}
\def\@titletwo[#1]#2{\gdef\@title{#2}\gdef\@shorttitle{#1}}
\def\@titleone#1{\gdef\@title{#1}\gdef\@shorttitle{#1}}
\def\shorttitle#1{\gdef\@shorttitle{#1}}
\gdef\@shorttitle{\@title}
\def\pagerange#1{\gdef\@pagerange{#1}}
\gdef\@pagerange{001--}
\def\journal#1{\gdef\@journal{#1}}
\gdef\@journal{{\it Acta Numerica\/}
\def\nextyear{\year}%% 
%%%%% the %% in line above ensure minimal space between title and year -- GES%%
%\advance\nextyear by 1       %%%%%%%%comment out on Jan 1 -- GES%%%%%%%
(\number\nextyear), { pp.}\ \@pagerange 
\hfill Printed in the United Kingdom}
\def\doi#1{\def\@doi{#1}}	%GES%
\def\@doi{}			%GES%



\def\ps@headings{\let\@mkboth\markboth
 \def\@oddhead{\mbox{}\hfill \small\sc \@shorttitle \hfill \rm \thepage}
 \def\@oddfoot{}
 \def\@evenhead{\small\rm \thepage \hfill \sc \@shortauthor \hfill}
 \def\@evenfoot{}
 \def\sectionmark##1{\markboth{##1}{}}
 \def\subsectionmark##1{\markright{##1}}
}
% Definition of 'myheadings' page style.
%
\def\ps@myheadings{\let\@mkboth\@gobbletwo
 \def\@oddhead{\hfill \small\sc \rightmark \hfill \rm \thepage}
 \def\@oddfoot{}
 \def\@evenhead{\small\rm \thepage \hfil \sc \leftmark \hfill}
 \def\@evenfoot{}
 \def\sectionmark##1{}
 \def\subsectionmark##1{}
}
\def\ps@titlepage{\let\@mkboth\@gobbletwo
 \def\@oddhead{\vbox to 0pt{\vss\vbox{\footnotesize\@journal \hfill \vskip 2pt  doi:10.1017/S09624929\@doi \hfill }}} %GES%
 \def\@oddfoot{\begin{minipage}{30pc}\footnotesize \copyright\ The Author(s), {\number\year}. Published by Cambridge University Press.\end{minipage}}
 \def\@evenhead{\footnotesize\@journal \hfill}
 \def\@evenfoot{}
 \def\sectionmark##1{}
 \def\subsectionmark##1{}
}

%  ****************************************
%  *         OTHER ENVIRONMENTS           *
%  ****************************************
%

%%%%%%%%%%%%%%%%%%% GES 2 Oct 02 %%%%%%%%%%%%%%%%%%%%%%%
\newcommand{\actabox}{{{\begin{picture}(10,8)%
  \put(1.5,0.5){\framebox(7,7){}}\end{picture}} }}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% THEOREM
%
\def\@begintheorem#1#2{\rm \trivlist
 \item[\hskip \labelsep{\bf #1\ #2.}\hspace*{0.5em}]}
\def\@opargbegintheorem#1#2#3{\rm \trivlist
  \item[\hskip \labelsep{\bf #1\ #2 (#3).}\hspace*{0.5em}]}
\def\@endtheorem{\endtrivlist}

\def\proof{\rm \trivlist
 \item[\hskip \labelsep{\it Proof.\hspace*{0.5em}}]}
%GES%\def\endproof{\hspace*{\fill}{$\Box$}\endtrivlist}
\def\endproof{\hspace*{\fill}{$\actabox$}\endtrivlist}
\@namedef{proof*}{\rm \trivlist
 \item[\hskip \labelsep{\it Proof.\hspace*{0.5em}}]}
\@namedef{endproof*}{\endtrivlist}


% TITLEPAGE
%
\def\titlepage{\@restonecolfalse\if@twocolumn\@restonecoltrue\onecolumn
     \else \newpage \fi \thispagestyle{empty}\c@page\z@}
\def\endtitlepage{\if@restonecol\twocolumn \else \newpage \fi}

% ARRAY AND TABULAR
%
\arraycolsep 5pt     % Half the space between columns in an array environment.
\tabcolsep 6pt       % Half the space between columns in a tabular environment.
\arrayrulewidth .5pt % Width of rules in array and tabular environment.
\doublerulesep 1.5pt % Space between adjacent rules in array or tabular env.

% TABBING
%
\tabbingsep \labelsep   % Space used by the \' command.  (See LaTeX manual.)

% MINIPAGE
%
\skip\@mpfootins = \skip\footins

% FRAMEBOX
%
\fboxsep = 3pt    % Space left between box and text by \fbox and \framebox.
\fboxrule = .5pt  % Width of rules in box made by \fbox and \framebox.

%  ****************************************
%  *              SECTIONS                *
%  ****************************************
%
\newcounter{part}
\newcounter {section} %[part] %GS% for section numbering linked to parts
\newcounter {subsection}[section]
\newcounter {subsubsection}[subsection]		
\newcounter {paragraph}[subsubsection]			
\newcounter {subparagraph}[paragraph]		

\def\thepart          {\arabic{part}}
\def\thesection       {\arabic{section}}
%GS%\def\thesection       {\thepart.\arabic{section}} %GS% for section numbering linked to parts
\def\thesubsection    {\thesection.\arabic{subsection}}
\def\thesubsubsection {\thesubsection.\arabic{subsubsection}}
\def\theparagraph     {\thesubsubsection.\arabic{paragraph}}
\def\thesubparagraph  {\theparagraph.\arabic{subparagraph}}

%  ****************************************
%  *         TABLE OF CONTENTS, ETC.      *
%  ****************************************
%
\def\@pnumwidth{1.55em}
\def\@tocrmarg {2.55em}
\def\@dotsep{4.5}
\setcounter{tocdepth}{1}

\def\@undottedtocline#1#2#3#4#5{\ifnum #1>\c@tocdepth
  \else
   \vskip \z@ plus .2pt
   {\hangindent #2\relax
    \rightskip \@tocrmarg
    \parfillskip -\rightskip
    \parindent #2\relax
    \@afterindenttrue
    \interlinepenalty\@M
    \leavevmode
    \@tempdima #3\relax
    #4\nobreak
    \hfill \nobreak
    \hbox to\@pnumwidth{\hfil\rm \ }\par}\fi}

% TABLEOFCONTENTS
%
\def\tableofcontents{%
\begin{center}\parbox{0.75\textwidth}{%AJW
\@restonecolfalse
  \if@twocolumn\@restonecoltrue\onecolumn\fi
  \section*{CONTENTS}
  \@starttoc{toc}
  \if@restonecol\twocolumn\fi
%GES%  \par\vspace{13pt}}\end{center}}
  \par\vspace{0pt}}\end{center}} %GES% 091117

\def\l@part#1#2{\addpenalty{-\@highpenalty}
%GES% \addvspace{2.25em plus 1pt}
 \addvspace{1.4em plus 1pt}%GES% 091117
 \begingroup
  \parindent \z@ \rightskip \@pnumwidth
  \parfillskip -\@pnumwidth
  {\normalsize\rm
   \leavevmode
%   \hspace*{3pc}
   #1\hfil \hbox to\@pnumwidth{\hss \ }}\par
  \nobreak
  \global\@nobreaktrue
  \everypar{\global\@nobreakfalse\everypar{}}%
 \endgroup
\addvspace{0.4em plus 1pt}%GES% 091117
}
\def\l@section#1#2{\addpenalty{\@secpenalty}
 \@tempdima 1.5em
%GS% \@tempdima 2em %GS% for section numbering linked to parts
 \begingroup
  \parindent \z@ \rightskip \@pnumwidth
  \parfillskip -\@pnumwidth
  \rm \leavevmode
  \advance\leftskip\@tempdima
  \hskip -\leftskip
  #1\nobreak\hfil \nobreak\hbox to\@pnumwidth{\hss#2}\par %AJW
 \endgroup
}
\def\l@subsection{\@undottedtocline{2}{1.5em}{2.3em}}
\def\l@subsubsection{\@undottedtocline{3}{3.8em}{3.2em}}
\def\l@paragraph{\@undottedtocline{4}{7.0em}{4.1em}}
\def\l@subparagraph{\@undottedtocline{5}{10em}{5em}}

% LIST OF FIGURES
%
\def\listoffigures{\@restonecolfalse
 \if@twocolumn\@restonecoltrue\onecolumn\fi
 \section*{LIST OF FIGURES\@mkboth{List of Figures}{List of Figures}}
 \@starttoc{lof}
 \if@restonecol\twocolumn\fi
}
\def\l@figure{\@undottedtocline{1}{1.5em}{2.3em}}

% LIST OF TABLES
%
\def\listoftables{\@restonecolfalse
 \if@twocolumn\@restonecoltrue\onecolumn\fi
 \section*{LIST OF TABLES\@mkboth{List of Tables}{List of Tables}}
 \@starttoc{lot}
 \if@restonecol\twocolumn\fi
}
\let\l@table\l@figure

%  ****************************************
%  *             BIBLIOGRAPHY             *
%  ****************************************
%
%%\newcommand\refname{References} %GS%
%%\def\@biblabel#1{#1}
    \def\newblock{\hskip .11em plus .33em minus .07em} %GS%
\def\thebibliography#1{\section*{REFERENCES}
  \addcontentsline{toc}{section}{References}
  \list{}{\labelwidth\z@
   \leftmargin \@indentskip
    \itemindent-\leftmargin}
    \small
    \parindent\z@
    \parskip\z@ plus .1pt\relax
    \def\newblock{\hskip .11em plus .33em minus .07em}
    \sloppy\clubpenalty4000\widowpenalty4000
    \sfcode`\.=1000\relax}
\let\endthebibliography=\endlist


%  ****************************************
%  *              THE INDEX               *
%  ****************************************
%
\newif\if@restonecol
\def\theindex{\section*{INDEX}
    \addcontentsline{toc}{section}{Index}
    \footnotesize
    \parindent\z@
    \parskip\z@ plus .1pt\relax
    \let\item\@idxitem}
\def\@idxitem{\par\hangindent 1pc}
\def\subitem {\par\hangindent 1pc \hspace*{1pc}}
\def\subsubitem{\par\hangindent 1pc\hspace*{1pc}}
\def\endtheindex{\if@restonecol\onecolumn\else\clearpage\fi}
\def\indexspace{\par\vskip\baselineskip \relax}

%  ****************************************
%  *             FOOTNOTES                *
%  ****************************************
%
\def\footnoterule{\kern-3\p@
  \hrule width .4\columnwidth height \z@
  \kern 3\p@}

\long\def\@makefntext#1{\@setpar{\@@par\@tempdima \hsize
  \advance\@tempdima-\@footindent
  \parshape \@ne \@footindent \@tempdima}\par
  \noindent \hbox to \z@{\hss$^{\@thefnmark}$\ }#1}

%  ****************************************
%  *         FIGURES AND TABLES           *
%  ****************************************
%
\setcounter{topnumber}{2}
\def\topfraction{.9}
\setcounter{bottomnumber}{1}
\def\bottomfraction{.9}
\setcounter{totalnumber}{3}
\def\textfraction{.1}
\def\floatpagefraction{.75}
\setcounter{dbltopnumber}{2}
\def\dbltopfraction{.9}
\def\dblfloatpagefraction{.5}
%
\long\def\@makecaption#1#2{\vskip 6.5pt
 \ifwide@float
%%  \raggedright\sloppy #1. #2\par
  \justified\sloppy #1. #2\par
 \else
%%  \raggedright\sloppy #1. #2\par
  \justified\sloppy #1. #2\par
 \fi}

% TABLE
%
\newcounter{table}
\def\thetable{\thesection.\@arabic\c@table} %% \thesection. added by GES
\def\fps@table{tbp}
\def\ftype@table{1}
\def\ext@table{lot}
\def\fnum@table{Table \thetable}
\def\table{\@float{table}}
\let\endtable\end@float
\@namedef{table*}{\@dblfloat{table}}
\@namedef{endtable*}{\end@dblfloat}
\def\fstyle@table{\small\rm}
\def\fjust@table{\raggedright}

\newcommand{\justified}{%
  \rightskip\z@skip%
  \leftskip\z@skip}
\def\fcapjust@table{\justified\sloppy}
\def\fcapsize@table{\small\rm}	
\def\fcapstyle@table{\small\rm}	

%
% FIGURE
%
\newcounter{figure}
\def\thefigure{\thesection.\@arabic\c@figure} %% \thesection. added by GES
\def\fps@figure{tbp}
\def\ftype@figure{2}
\def\ext@figure{lof}
\def\fnum@figure{Figure \thefigure}	%GES% Feb02
\def\figure{\@float{figure}}
\let\endfigure\end@float
\@namedef{figure*}{\@dblfloat{figure}}
\@namedef{endfigure*}{\end@dblfloat}
\def\fstyle@figure{\small\rm}
\def\fjust@figure{\centering}

\def\fcapjust@figure{\justified\sloppy}
\def\fcapsize@figure{\small\rm}
\def\fcapstyle@figure{\small\rm}
%
% stuff for different style float captions
%
\newif\ifwide@float
\wide@floatfalse

%% commented 18 Nov 2020

\long\def\@caption#1[#2]#3{\addcontentsline{\csname ext@#1\endcsname}{#1}%
 {\protect\numberline{\csname the#1\endcsname}%
 {\ignorespaces #2}}\par
 \begingroup
  \ifwide@float\@parboxrestore\else\@myparboxrestore\fi
  \@makecaption{\csname fcapjust@#1\endcsname
                \csname fcapsize@#1\endcsname
                \csname fnum@#1\endcsname}%
               {\csname fcapstyle@#1\endcsname \ignorespaces #3}\par
 \endgroup
}

\def\@myarrayparboxrestore{\let\par\@@par
 \let\-\@dischyph
 \let\'\@acci \let\`\@accii \let\=\@acciii
 \parindent\z@
 \everypar{}\linewidth\hsize
 \@totalleftmargin\z@ \leftskip\@leftskip
 \rightskip\@rightskip
 \parfillskip\@flushglue \lineskip\normallineskip
 \baselineskip\normalbaselineskip\sloppy
}
\def\@myparboxrestore{\@myarrayparboxrestore\let\\=\@normalcr}
%
% stuff for wide floats
%
\def\@dblfloat{\wide@floattrue\@float}
\def\end@dblfloat{\if@twocolumn\egroup
 \ifnum\@floatpenalty <\z@ \@cons\@dbldeferlist\@currbox\fi
 \ifnum \@floatpenalty =-\@Mii \@esphack\fi\else\end@float\fi
 \wide@floatfalse
}

%  ****************************************
%  *            MISCELLANEOUS             *
%  ****************************************
%
% DATE
%
\def\today{\number\day\
 \ifcase\month\or
  January\or February\or March\or April\or May\or June\or
  July\or August\or September\or October\or November\or December
 \fi \ \number\year}
%
% Equation numbering % SFB 0.94
\@addtoreset{equation}{section}
\def\theequation{\thesection.\arabic{equation}}
%
% Miscellaneous notation definitions %AJW
%
\def\R#1{$(\ref{#1})$} 	% eqno inside math-style brackets
\def\Re{\mbox{Re}\,}	% superior style `real part' command
\def\Im{\mbox{Im}\,}	% superior style `imaginary part' command
\def\D{\,{\rm d}}	% roman `d' for use in math formulae
\def\I{{\hspace{1pt}}{\rm i}}		% roman `i' for use in math formulae; GES removed space
\def\O#1{{\cal O}\!\left(#1\right)} % `oh' command, ie O(xx)
\def\Frac#1#2{{\textstyle \frac{#1}{#2}}} % to produce a
			% textstyle-style fractions in \displaystyle

\usepackage{hyperref}%
\usepackage[all]{hypcap}
\hypersetup{
draft=false,
dvips,
colorlinks=true,
linkcolor=blue,
anchorcolor=blue,
citecolor=blue,
urlcolor=blue,
filecolor=blue,
bookmarksopenlevel=3,
bookmarksopen=true,
pdfborderstyle={/S/U/W 0},
pdfstartview={FitH 800},
breaklinks=true}
\usepackage{breakurl}
\urlstyle{tt}


%  ****************************************
%  *           CUP specials               *
%  ****************************************
%
%GES\renewcommand{\thefootnote}{\mbox{$\fnsymbol{footnote}$}}

\def\hline{\noalign{\ifnum0=`}\fi
 \vskip 6pt
 \hrule \@height \arrayrulewidth
 \vskip 6pt
 \futurelet \@tempa\@xhline}

\def\@xhline{\ifx\@tempa\hline
  \vskip -12pt
  \vskip \doublerulesep
 \fi
 \ifnum0=`{\fi}}

\def\author@tabular{\def\@halignto{}\@authortable}
\let\endauthor@tabular=\endtabular
\def\author@tabularcr{{\ifnum0=`}\fi
 \@xtabularcr[-1pt]\small\it\ignorespaces}
\def\@authortable{\leavevmode \hbox \bgroup $\let\@acol\@tabacol
 \let\@classz\@tabclassz
 \let\@classiv\@tabclassiv
 \let\\\author@tabularcr
 \@tabarray}

%  ****************************************
%  *           INITIALIZATION             *
%  ****************************************
%
% Default initializations

\ps@headings                % `headings' page style
\pagenumbering{arabic}      % Arabic page numbers
\onecolumn                  % Switch to \onecolumn and disable \twocolumn.
\let\onecolumn=\relax
\def\twocolumn{\typeout{Two column mode not available with CUP styles.}}
%
\flushbottom

