%% This is file njl.cls - version 1.0 
%% Aptara Inc., dated 24th Oct. 2015
%%
%% \CharacterTable
%%  {Upper-case    \A\B\C\D\E\F\G\H\I\J\K\L\M\N\O\P\Q\R\S\T\U\V\W\X\Y\Z
%%   Lower-case    \a\b\c\d\e\f\g\h\i\j\k\l\m\n\o\p\q\r\s\t\u\v\w\x\y\z
%%   Digits        \0\1\2\3\4\5\6\7\8\9
%%   Exclamation   \!     Double quote  \"     Hash (number) \#
%%   Dollar        \$     Percent       \%     Ampersand     \&
%%   Acute accent  \'     Left paren    \(     Right paren   \)
%%   Asterisk      \*     Plus          \+     Comma         \,
%%   Minus         \-     Point         \.     Solidus       \/
%%   Colon         \:     Semicolon     \;     Less than     \<
%%   Equals        \=     Greater than  \>     Question mark \?
%%   Commercial at \@     Left bracket  \[     Backslash     \\
%%   Right bracket \]     Circumflex    \^     Underscore    \_
%%   Grave accent  \`     Left brace    \{     Vertical bar  \|
%%   Right brace   \}     Tilde         \~}
\NeedsTeXFormat{LaTeX2e}[1995/12/01]
\ProvidesClass{njl}[2015/10/14 v1.0 Standard LaTeX document class]
\newcommand\@ptsize{}
\newif\if@restonecol
\newif\if@titlepage
\@titlepagefalse
\if@compatibility\else
\DeclareOption{a4paper}
   {\setlength\paperheight {297mm}%
    \setlength\paperwidth  {210mm}}
\DeclareOption{a5paper}
   {\setlength\paperheight {210mm}%
    \setlength\paperwidth  {148mm}}
\DeclareOption{b5paper}
   {\setlength\paperheight {250mm}%
    \setlength\paperwidth  {176mm}}
\DeclareOption{letterpaper}
   {\setlength\paperheight {11in}%
    \setlength\paperwidth  {8.5in}}
\DeclareOption{legalpaper}
   {\setlength\paperheight {14in}%
    \setlength\paperwidth  {8.5in}}
\DeclareOption{executivepaper}
   {\setlength\paperheight {10.5in}%
    \setlength\paperwidth  {7.25in}}
\DeclareOption{landscape}
   {\setlength\@tempdima   {\paperheight}%
    \setlength\paperheight {\paperwidth}%
    \setlength\paperwidth  {\@tempdima}}
\fi
\if@compatibility
  \renewcommand\@ptsize{0}
\else
\DeclareOption{10pt}{\renewcommand\@ptsize{0}}
\fi
\DeclareOption{11pt}{\renewcommand\@ptsize{1}}
\DeclareOption{12pt}{\renewcommand\@ptsize{2}}
\if@compatibility\else
\DeclareOption{oneside}{\@twosidefalse\@mparswitchfalse}
\fi
\DeclareOption{twoside}{\@twosidetrue\@mparswitchtrue}
\DeclareOption{draft}{\setlength\overfullrule{5pt}}
\if@compatibility\else
\DeclareOption{final}{\setlength\overfullrule{0pt}}
\fi
\DeclareOption{titlepage}{\@titlepagetrue}
\if@compatibility\else
\DeclareOption{notitlepage}{\@titlepagefalse}
\fi
\if@compatibility\else
\DeclareOption{onecolumn}{\@twocolumnfalse}
\fi
\DeclareOption{twocolumn}{\@twocolumntrue}
\DeclareOption{leqno}{\input{leqno.clo}}
\DeclareOption{fleqn}{\input{fleqn.clo}}
\DeclareOption{openbib}{%
  \AtEndOfPackage{%
   \renewcommand\@openbib@code{%
      \advance\leftmargin\bibindent
      \itemindent -\bibindent
      \listparindent \itemindent
      \parsep \z@
      }%
   \renewcommand\newblock{\par}}%
}
\AtEndDocument{\label{lastpage}}
\ExecuteOptions{letterpaper,twoside,final}
\ProcessOptions

\def\@ixnpt{9.5}
\def\@ixpt{9}
\def\@viiipt{8}
\renewcommand\normalsize{%
   \@setfontsize\normalsize\@ixnpt{13}%\@xiipt
   \abovedisplayskip 9.2\p@ \@plus2\p@ \@minus.5\p@
   \abovedisplayshortskip \z@ \@plus3\p@
   \belowdisplayshortskip 9.2\p@ \@plus2\p@ \@minus.5\p@
   \belowdisplayskip \abovedisplayskip
   \let\@listi\@listI}
\normalsize
\newcommand\small{%
   \@setfontsize\small\@ixpt{11}%
   \abovedisplayskip 8.5\p@ \@plus3\p@ \@minus4\p@
   \abovedisplayshortskip \z@ \@plus2\p@
   \belowdisplayshortskip 4\p@ \@plus2\p@ \@minus2\p@
   \def\@listi{\leftmargin\leftmargini
               \topsep 4\p@ \@plus2\p@ \@minus2\p@
               \parsep 2\p@ \@plus\p@ \@minus\p@
               \itemsep \parsep}%
   \belowdisplayskip \abovedisplayskip
}
\newcommand\footnotesize{%
   \@setfontsize\footnotesize\@viiipt{10}%
   \abovedisplayskip 6\p@ \@plus2\p@ \@minus4\p@
   \abovedisplayshortskip \z@ \@plus\p@
   \belowdisplayshortskip 3\p@ \@plus\p@ \@minus2\p@
   \def\@listi{\leftmargin\leftmargini
               \topsep 3\p@ \@plus\p@ \@minus\p@
               \parsep 2\p@ \@plus\p@ \@minus\p@
               \itemsep \parsep}%
   \belowdisplayskip \abovedisplayskip
}
\newcommand\scriptsize{\@setfontsize\scriptsize\@viipt\@viiipt}
\newcommand\tiny{\@setfontsize\tiny\@vpt\@vipt}
\newcommand\large{\@setfontsize\large\@xiipt{14}}
\newcommand\Large{\@setfontsize\Large\@xivpt{18}}
\newcommand\LARGE{\@setfontsize\LARGE\@xviipt{22}}
\newcommand\huge{\@setfontsize\huge\@xxpt{25}}
\newcommand\Huge{\@setfontsize\Huge\@xxvpt{30}}
\if@twocolumn
  \setlength\parindent{6mm}
\else
  \setlength\parindent{6mm}
\fi
\setlength\smallskipamount{3\p@ \@plus 1\p@ \@minus 1\p@}
\setlength\medskipamount{6\p@ \@plus 2\p@ \@minus 2\p@}
\setlength\bigskipamount{12\p@ \@plus 4\p@ \@minus 4\p@}
\setlength\headheight{12\p@}
\setlength\headsep   {25\p@}
\setlength\topskip   {10\p@}
\setlength\footskip{30\p@}
\if@compatibility \setlength\maxdepth{4\p@} \else
\setlength\maxdepth{.5\topskip} \fi
\if@compatibility
  \if@twocolumn
    \setlength\textwidth{112mm}%410\p@
  \else
    \setlength\textwidth{112mm}%345\p@
  \fi
\else
   \setlength\textwidth{112mm}%345\p@
\fi
\if@compatibility\else
  \@settopoint\textwidth
\fi
\if@compatibility
  \setlength\textheight{44\baselineskip}%43\baselineskip
\else
  \setlength\textheight{44\baselineskip}%\@tempcnta\baselineskip
\fi
\addtolength\textheight{\topskip}
\if@twocolumn
 \setlength\marginparsep {10\p@}
\else
  \setlength\marginparsep{10\p@}
\fi
\setlength\marginparpush{5\p@}
\if@compatibility
  \if@twoside
     \setlength\oddsidemargin   {44\p@}
     \setlength\evensidemargin  {82\p@}
     \setlength\marginparwidth {107\p@}
  \else
     \setlength\oddsidemargin   {63\p@}
     \setlength\evensidemargin  {63\p@}
     \setlength\marginparwidth  {90\p@}
  \fi
  \if@twocolumn
     \setlength\oddsidemargin  {30\p@}
     \setlength\evensidemargin {30\p@}
     \setlength\marginparwidth {48\p@}
  \fi
\else
  \if@twoside
    \setlength\@tempdima        {\paperwidth}
    \addtolength\@tempdima      {-\textwidth}
    \setlength\oddsidemargin    {.5\@tempdima}
    \addtolength\oddsidemargin  {-1in}
    \setlength\marginparwidth   {.6\@tempdima}
    \addtolength\marginparwidth {-\marginparsep}
    \addtolength\marginparwidth {-0.4in}
  \else
    \setlength\@tempdima        {\paperwidth}
    \addtolength\@tempdima      {-\textwidth}
    \setlength\oddsidemargin    {.5\@tempdima}
    \addtolength\oddsidemargin  {-1in}
    \setlength\marginparwidth   {.5\@tempdima}
    \addtolength\marginparwidth {-\marginparsep}
    \addtolength\marginparwidth {-0.4in}
    \addtolength\marginparwidth {-.4in}
  \fi
  \ifdim \marginparwidth >2in
     \setlength\marginparwidth{2in}
  \fi
  \@settopoint\oddsidemargin
  \@settopoint\marginparwidth
  \setlength\evensidemargin  {\paperwidth}
  \addtolength\evensidemargin{-2in}
  \addtolength\evensidemargin{-\textwidth}
  \addtolength\evensidemargin{-\oddsidemargin}
  \@settopoint\evensidemargin
\fi
\if@compatibility
  \setlength\topmargin{27pt}
\else
  \setlength\topmargin{\paperheight}
  \addtolength\topmargin{-2in}
  \addtolength\topmargin{-\headheight}
  \addtolength\topmargin{-\headsep}
  \addtolength\topmargin{-\textheight}
  \addtolength\topmargin{-\footskip}     % this might be wrong!
  \addtolength\topmargin{27pt}%
  \@settopoint\topmargin
\fi
\setlength\footnotesep{6.65\p@}
\setlength{\skip\footins}{9\p@ \@plus 4\p@ \@minus 2\p@}
\setlength\floatsep    {12\p@ \@plus 2\p@ \@minus 2\p@}
\setlength\textfloatsep{20\p@ \@plus 2\p@ \@minus 4\p@}
\setlength\intextsep   {12\p@ \@plus 2\p@ \@minus 2\p@}
\setlength\dblfloatsep    {12\p@ \@plus 2\p@ \@minus 2\p@}
\setlength\dbltextfloatsep{20\p@ \@plus 2\p@ \@minus 4\p@}
\setlength\@fptop{0\p@ \@plus 1fil}
\setlength\@fpsep{8\p@ \@plus 2fil}
\setlength\@fpbot{0\p@ \@plus 1fil}
\setlength\@dblfptop{0\p@ \@plus 1fil}
\setlength\@dblfpsep{8\p@ \@plus 2fil}
\setlength\@dblfpbot{0\p@ \@plus 1fil}
\setlength\partopsep{2\p@ \@plus 1\p@ \@minus 1\p@}

\newskip\topsepi \topsepi6\p@ \@plus2\p@ \@minus1\p@
\newskip\topsepii \topsepii0pt% \@plus1\p@ 
\newskip\itemsepi \itemsepi0pt
\newskip\itemsepii \itemsepii0pt
\newdimen\LabelSep \LabelSep5pt

\def\@listi{\leftmargin\leftmargini
            \parsep 0\p@% 0\p@ \@plus2\p@ \@minus\p@
            \topsep \topsepi%8\p@ \@plus2\p@ \@minus4\p@
            \itemsep \itemsepi}%4\p@ \@plus2\p@ \@minus\p@
\let\@listI\@listi
\@listi
\def\@listii {\leftmargin\leftmarginii
              \labelwidth\leftmarginii
              \advance\labelwidth-\labelsep
              \topsep \topsepii%    4\p@ \@plus2\p@ \@minus\p@
              \parsep 0\p@%    2\p@ \@plus\p@  \@minus\p@
              \itemsep \itemsepii} %   \parsep
\def\@listiii{\leftmargin\leftmarginiii
              \labelwidth\leftmarginiii
              \advance\labelwidth-\labelsep
              \topsep 0\p@%   2\p@ \@plus\p@\@minus\p@
              \parsep    \z@
              \partopsep \p@ \@plus\z@ \@minus\p@
              \itemsep   \topsep}
\def\@listiv {\leftmargin\leftmarginiv
              \labelwidth\leftmarginiv
              \advance\labelwidth-\labelsep}
\def\@listv  {\leftmargin\leftmarginv
              \labelwidth\leftmarginv
              \advance\labelwidth-\labelsep}
\def\@listvi {\leftmargin\leftmarginvi
              \labelwidth\leftmarginvi
              \advance\labelwidth-\labelsep}

%%%%

%%%%%%%%%%%%%%%%%% Font Definition

\def\titlefont{\sffamily\fontsize{16}{20}\selectfont\raggedright}%
\def\subtitlefont{\sffamily\fontsize{14}{16}\selectfont\raggedright}
\def\authorfont{\reset@font\sffamily\fontsize{14}{16}\selectfont\raggedright}%
\def\affilfont{\reset@font\fontsize{7.5}{11}\itshape\selectfont\leftskip6mm\rightskip0pt plus1fill{}}%
\def\rhfont{\sffamily\fontsize{6}{8}\selectfont}
\def\rrhfont{\sffamily\fontsize{6}{8}\selectfont}
\def\rffont{\sffamily\fontsize{6}{8}\selectfont}
\def\sluglinefont{\fontsize{9.5}{11}\selectfont\scshape}
\def\foliofont{\sffamily\fontsize{8}{10}\selectfont}
\def\historyfont{\fontsize{7.5}{8}\selectfont}
\def\copyrightfont{\reset@font\fontsize{7}{8}\selectfont}

\def\abstractfont{\fontsize{8.5}{11}\selectfont\leftskip6mm{}}%
\def\absheadfont{\sffamily\fontsize{8.5}{11}\bfseries\selectfont\leftskip18pt{}}%

\def\keywordfont{\sffamily\fontsize{8}{11}\selectfont\leftskip6mm{}}%

\def\sectionfont{\sffamily\fontsize{10}{13}\bfseries\selectfont\raggedright}%
\def\sectionnumfont{\sffamily\fontsize{10}{13}\selectfont\raggedright}%
\def\subsectionfont{\sffamily\fontsize{10}{13}\bfseries\itshape\selectfont\raggedright}%
\def\subsectionnumfont{\sffamily\fontsize{10}{13}\bfseries\itshape\selectfont\raggedright}%
\def\subsubsectionfont{\sffamily\fontsize{10}{13}\bfseries\itshape\selectfont\raggedright}%
\def\subsubsectionnumfont{\sffamily\fontsize{10}{13}\bfseries\itshape\selectfont\raggedright}%
%
\def\paragraphfont{\sffamily\fontsize{10}{13}\bfseries\itshape\selectfont\raggedright}
\def\paragraphnumfont{\sffamily\fontsize{10}{13}\bfseries\itshape\selectfont\raggedright}
\def\subparagraphfont{\fontsize{10}{13}\itshape\selectfont}

\def\figcaptionfont{\fontsize{7.5}{10}\bfseries\selectfont\leftskip6mm\mathversion{bold}}%
\def\figcaptionnumfont{\fontsize{7.5}{10}\bfseries\selectfont\leftskip6mm\mathversion{bold}}%
%
\def\tablecaptionnumfont{\fontsize{7.5}{10}\bfseries\selectfont\mathversion{bold}}%
\def\tablecaptionfont{\fontsize{7.5}{10}\selectfont\bfseries\mathversion{bold}}%
\def\tablefont{\fontsize{9}{11}\selectfont\mathversion{normal}}%
\def\TCHfont{\fontsize{9}{11}\selectfont\mathversion{normal}}%
\def\tabnotefont{\fontsize{6}{8}\selectfont\mathversion{normal}}%
\def\exmfont{\reset@font\fontsize{9}{11}\selectfont\mathversion{normal}}%
%
%\def\deflistfont{\fontsize{10}{12}\selectfont}% 
\def\bibliofont{\fontsize{8.5}{11}\selectfont\raggedright}%
\def\extractfont{\normalfont\leftskip18pt\rightskip\leftskip}

%%%%%%%%%%%%%%%%%% 

\def\jtitle#1{\gdef\@jtitle{#1}}\jtitle{Nordic Journal of Linguistics}
\def\abbvjtitle#1{\gdef\@abbvjtitle{#1}}\abbvjtitle{Nord J Linguist}
\def\jmonth#1{\gdef\@jmonth{#1}}\jmonth{}
\def\jyear#1{\gdef\@jyear{#1}}\jyear{}

\def\oddfolio{{\foliofont\thepage}}
\def\evenfolio{{\foliofont\thepage}}
\def\endpage#1{\gdef\@endpage{#1}}\endpage{0}
\def\articledoi#1{\gdef\@articledoi{#1}}\articledoi{}
\def\volume#1{\gdef\@volume{#1}}\volume{00}
\def\issue#1{\gdef\@issue{#1}}\issue{0}
\def\title#1{\gdef\@title{#1}}\title{}
\def\articletype#1{\gdef\@articletype{#1}}\articletype{}
\def\subtitle#1{\gdef\@subtitle{#1}}\subtitle{}
\def\keywords#1{\gdef\@keywords{#1}}\keywords{}
\def\email#1{#1}
%
\newcount\authorcount
\def\author#1{\global\advance\authorcount\@ne%
    \expandafter\gdef\csname author\romannumeral\the\authorcount\endcsname{#1}%
    }

\newcount\affilcount
\def\affil#1{\global\advance\affilcount\@ne
             \expandafter\gdef\csname affil\romannumeral\the\affilcount\endcsname{#1}}


\newcount\tempcount
\def\@authors{%
  \ifnum\authorcount>\z@%
    \loop%
       \ifnum\authorcount>\z@%
         \advance\tempcount\@ne%
                 \noindent\csname author\romannumeral\the\tempcount\endcsname%
         \ifnum\authorcount>\@ne%
             \ifnum\authorcount>\tw@%
                 {,}\space%
             \else%
                 \space\&\space%
             \fi%
         \fi%
         \advance\authorcount\m@ne%
    \repeat%
  \fi%
  \global\authorcount\z@%
  \global\tempcount\z@%
}

\newcount\auafcount
\def\@affil{\affilfont%
  \ifnum\affilcount>\z@%
    \auafcount\affilcount
    \loop%
       \ifnum\affilcount>\z@%
         \advance\tempcount\@ne%
               \ifnum\auafcount>\@ne%
                  \noindent\csname author\romannumeral\the\tempcount\endcsname\unskip,\space%
               \fi%
               \csname affil\romannumeral\the\tempcount\endcsname\par%
         \advance\affilcount\m@ne%
    \repeat%
  \fi%
  \global\affilcount\z@%
  \global\tempcount\z@%
  \global\auafcount\z@%
}


\def\bookmark#1{\gdef\@bookmark{#1}}\def\@bookmark{Nor Jnl Ling}
\def\copyrightstatement#1{\gdef\@copyrightstatement{#1}}\copyrightstatement{Nordic Association of Linguists}


\def\slugline{\vbox{\parindent0pt\rhfont\hsize\textwidth%
      \hbox to \textwidth{{\@bookmark}\space{\@volume}.\@issue,\
       \thepage--\pageref{lastpage}\ \copyright\ \@copyrightstatement\space \@jyear\hfill 
      \ifx\@articledoi\@empty\else doi:\space\@articledoi\par\fi}% 
}}

\def\ps@plain{\let\@mkboth\@gobbletwo%
       \def\@oddfoot{}%  
       \let\@evenfoot\@oddfoot%{}%
       \def\@evenhead{\slugline}%
       \def\@oddhead{\slugline}}%


\def\slugauthor#1{\gdef\@slugauthor{#1}}\slugauthor{}


%%%%
\setlength\lineskip{1\p@}
\setlength\normallineskip{1\p@}
\renewcommand\baselinestretch{}
\setlength\parskip{0\p@}%
\@lowpenalty   51
\@medpenalty  151
\@highpenalty 301
\setcounter{topnumber}{2}
\renewcommand\topfraction{.7}
\setcounter{bottomnumber}{1}
\renewcommand\bottomfraction{.3}
\setcounter{totalnumber}{3}
\renewcommand\textfraction{.2}
\renewcommand\floatpagefraction{.5}
\setcounter{dbltopnumber}{2}
\renewcommand\dbltopfraction{.7}
\renewcommand\dblfloatpagefraction{.5}

\def\headrule{\smash{\raise-9pt\hbox{\vrule height30pt width.3pt depth0pt}}}

\def\rhhfont{\sffamily\fontsize{6}{10}\selectfont}
\if@twoside
  \def\ps@headings{%
      \let\@oddfoot\@empty\let\@evenfoot\@empty
    \def\@evenhead{\llap{\hbox to 6pc{\hfill\foliofont\thepage}\hskip4pt}\headrule\hskip4pt{\rhhfont\MakeUppercase\leftmark}\hfill}%
    \def\@oddhead{\hfill\hbox to \textwidth{\hfill\rhhfont\MakeUppercase\rightmark\hskip4pt}\headrule\rlap{\hbox to 6pc{\hskip4pt\foliofont\thepage}}}%
      }
\else
  \def\ps@headings{%
    \let\@oddfoot\@empty
    \def\@oddhead{{\slshape\rightmark}\hfil\thepage}%
    \let\@mkboth\markboth
    \def\sectionmark##1{%
      \markright {\MakeUppercase{%
        \ifnum \c@secnumdepth >\m@ne
          \thesection\quad
        \fi
        ##1}}}}
\fi
\def\ps@myheadings{%
    \let\@oddfoot\@empty\let\@evenfoot\@empty
    \def\@evenhead{\thepage\hfil\slshape\leftmark}%
    \def\@oddhead{{\slshape\rightmark}\hfil\thepage}%
    \let\@mkboth\@gobbletwo
    \let\sectionmark\@gobble
    \let\subsectionmark\@gobble
    }

\newcommand\maketitle{\par
  \begingroup
    \renewcommand\thefootnote{\@fnsymbol\c@footnote}%
    \def\@makefnmark{\rlap{\@textsuperscript{\normalfont\@thefnmark}}}%
    \long\def\@makefntext##1{\parindent 1em\noindent
            \hb@xt@1.8em{%
                \hss\@textsuperscript{\normalfont\@thefnmark}}##1}%
    \if@twocolumn
      \newpage
      \twocolumn[\@maketitle]%
    \else
      \newpage
      \global\@topnum\z@   % Prevents figures from going at top of page.
      \@maketitle
    \fi
    \thispagestyle{plain}\@thanks
  \endgroup
  \setcounter{footnote}{0}%
  \global\let\thanks\relax
  \global\let\maketitle\relax
  \global\let\@maketitle\relax
  \global\let\@thanks\@empty
  \global\let\@author\@empty
  \global\let\@date\@empty
  \global\let\@title\@empty
  \global\let\title\relax
  \global\let\author\relax
  \global\let\date\relax
  \global\let\and\relax
}


\def\articletypefont{\sffamily\fontsize{16}{20}\selectfont\raggedright}%

\def\@maketitle{%
  \newpage
  \null
  \parindent0pt\vskip0pt%
  \let \footnote \thanks
    \noindent\vrule height.3pt width\textwidth\par%
    \ifx\@articletype\@empty\else{\articletypefont\@articletype\par}\fi%
    \ifx\@title\@empty\else{\titlefont \@title \par}\vskip11pt\fi%
    \ifx\@subtitle\@empty\relax\else\vskip-6.5pt{\subtitlefont\@subtitle\par}\vskip11pt\fi%
    \ifx\@authors\@empty\else{\authorfont \@authors\vskip11pt\par}\fi%
    \ifvoid\abstractbox\else{\box\abstractbox\vskip11pt\par}\fi%
    \ifx\@keywords\@empty\else{\keywordfont{\bfseries Keywords}\space\@keywords\vskip11pt\par}\fi
    \ifx\@affil\@empty\else{\affilfont\@affil\par}\fi%
    \noindent\vrule height.3pt width\textwidth%
    \vskip 0pt%
  \par
}


\setcounter{secnumdepth}{4}
\newcounter {part}
\newcounter {section}
\newcounter {subsection}[section]
\newcounter {subsubsection}[subsection]
\newcounter {paragraph}[subsubsection]
\newcounter {subparagraph}[paragraph]
\renewcommand \thepart {\@Roman\c@part}
\renewcommand \thesection {\@arabic\c@section}
\renewcommand\thesubsection   {\thesection.\@arabic\c@subsection}
\renewcommand\thesubsubsection{\thesubsection .\@arabic\c@subsubsection}
\renewcommand\theparagraph    {\thesubsubsection.\@arabic\c@paragraph}
\renewcommand\thesubparagraph {\theparagraph.\@arabic\c@subparagraph}
\newcommand\part{%
   \if@noskipsec \leavevmode \fi
   \par
   \addvspace{4ex}%
   \@afterindentfalse
   \secdef\@part\@spart}

\def\@part[#1]#2{%
    \ifnum \c@secnumdepth >\m@ne
      \refstepcounter{part}%
      \addcontentsline{toc}{part}{\thepart\hspace{1em}#1}%
    \else
      \addcontentsline{toc}{part}{#1}%
    \fi
    {\parindent \z@ \raggedright
     \interlinepenalty \@M
     \normalfont
     \ifnum \c@secnumdepth >\m@ne
       \Large\bfseries \partname\nobreakspace\thepart
       \par\nobreak
     \fi
     \huge \bfseries #2%
     \markboth{}{}\par}%
    \nobreak
    \vskip 3ex
    \@afterheading}
\def\@spart#1{%
    {\parindent \z@ \raggedright
     \interlinepenalty \@M
     \normalfont
     \huge \bfseries #1\par}%
     \nobreak
     \vskip 3ex
     \@afterheading}

\def\a@head{section}
\def\@seccntformat#1{\csname the#1\endcsname}

\newcommand\section{\@startsection {section}{1}{\z@}{-26pt \@plus -2pt \@minus -.2pt}{6.5pt}{\sectionfont}}%
\newcommand\subsection{\@startsection{subsection}{2}{\z@}{-13pt \@plus -2pt \@minus -.2pt}{6.5pt}{\subsectionfont}}%
\newcommand\subsubsection{\@startsection{subsubsection}{3}{\z@}{-12pt \@plus -2pt \@minus -.2pt}{6.5pt}{\subsubsectionfont}}%
\newcommand\paragraph{\@startsection{paragraph}{4}{\z@}{-12pt \@plus -2pt \@minus -.2pt}{6.5pt}{\paragraphfont}}%
\newcommand\subparagraph{\@startsection{subparagraph}{5}{6mm}{-0.001pt}{-4.5pt}{\subparagraphfont}}%

\def\sec@@dot{.}

\def\@sect#1#2#3#4#5#6[#7]#8{%
  \ifnum #2>\c@secnumdepth
    \let\@svsec\@empty
  \else
    \refstepcounter{#1}%
    \protected@edef\@svsec{\@seccntformat{#1}\ifnum#2=1.\fi\hskip4.5pt\relax}%
  \fi
  \@tempskipa #5\relax
  \ifdim \@tempskipa>\z@
    \begingroup
      #6{%
        \@hangfrom{\hskip #3\relax\@svsec}%
          \interlinepenalty \@M #8\@@par}%
    \endgroup
    \csname #1mark\endcsname{#7}%
    \addcontentsline{toc}{#1}{%
      \ifnum #2>\c@secnumdepth \else
        \protect\numberline{\csname the#1\endcsname}%
      \fi
      #7}%
  \else
    \def\@svsechd{%
      #6{\hskip #3\relax
      \@svsec #8}%
      \sec@@dot\csname #1mark\endcsname{#7}%run in head with DOT%
      \addcontentsline{toc}{#1}{%
        \ifnum #2>\c@secnumdepth \else
          \protect\numberline{\csname the#1\endcsname}%
        \fi
        #7}}%
  \fi
  \@xsect{#5}}


\if@twocolumn
  \setlength\leftmargini  {1.3em}
\else
  \setlength\leftmargini  {1.3em}%2.5mm
\fi
\leftmargin  \leftmargini
\setlength\leftmarginii  {1em}%
\setlength\leftmarginiii {1em}
\setlength\leftmarginiv  {1.7em}
\if@twocolumn
  \setlength\leftmarginv  {.5em}
  \setlength\leftmarginvi {.5em}
\else
  \setlength\leftmarginv  {1em}
  \setlength\leftmarginvi {1em}
\fi
\setlength  \labelsep  {.5em}%
\setlength  \labelwidth{\leftmargini}
\addtolength\labelwidth{-\labelsep}
\@beginparpenalty -\@lowpenalty
\@endparpenalty   -\@lowpenalty
\@itempenalty     -\@lowpenalty
\renewcommand\theenumi{\@arabic\c@enumi}
\renewcommand\theenumii{\@alph\c@enumii}
\renewcommand\theenumiii{\@roman\c@enumiii}
\renewcommand\theenumiv{\@Alph\c@enumiv}
\newcommand\labelenumi{\theenumi.}
\newcommand\labelenumii{(\theenumii)}
\newcommand\labelenumiii{\theenumiii.}
\newcommand\labelenumiv{\theenumiv.}
\renewcommand\p@enumii{\theenumi}
\renewcommand\p@enumiii{\theenumi(\theenumii)}
\renewcommand\p@enumiv{\p@enumiii\theenumiii}
\newcommand\labelitemi{\textbullet}
\newcommand\labelitemii{\normalfont\bfseries \textendash}
\newcommand\labelitemiii{\textasteriskcentered}
\newcommand\labelitemiv{\textperiodcentered}
\newenvironment{description}
               {\list{}{\labelwidth\z@ \itemindent-\leftmargin
                        \let\makelabel\descriptionlabel}}
               {\endlist}
\newcommand*\descriptionlabel[1]{\hspace\labelsep
                                \normalfont\bfseries #1}

\newbox\abstractbox
  \newenvironment{abstract}{\abstractfont%
       \global\setbox\abstractbox\vbox\bgroup\par\noindent\ignorespaces%
      }
      {\par\egroup}

\newenvironment{verse}
               {\let\\\@centercr
                \list{}{\itemsep      \z@
                        \itemindent   -1.5em%
                        \listparindent\itemindent
                        \rightmargin  \leftmargin
                        \advance\leftmargin 1.5em}%
                \item\relax}
               {\endlist}
\newenvironment{quotation}
               {\list{}{\listparindent 1.5em%
                        \itemindent    \listparindent
                        \rightmargin   \leftmargin
                        \parsep        \z@ \@plus\p@}%
                \item\relax}
               {\endlist}
\newenvironment{quote}
               {\list{}{\rightmargin\leftmargin}%
                \item\relax}
               {\endlist}

%%%%

\newenvironment{extract}%
               {\list{}{\listparindent0em%1.5
                        \leftmargin18pt%
                        \itemindent    \listparindent
                        \rightmargin   \leftmargin
                        \parsep        \z@ \@plus\p@}%
                \item\relax}
               {\endlist}

\newenvironment{unnumlist}{%
   \list{}{%
   \itemsep0pt
   \parsep0pt
   \parskip0pt
   \itemindent-12pt
   \leftmargin30pt}
}{\endlist}%


\newenvironment{romanlist}{%
  \leftmargini2em%
  \def\theenumi{\roman{enumi}}\def\theenumii{\roman{enumii}}%
  \def\theenumiii{\roman{enumiii}}\def\theenumiv{\roman{enumiv}}%
  \renewcommand\labelenumi{(\roman{enumi})}
  \begin{enumerate}%
}{%
  \end{enumerate}}

%%

\if@compatibility
\newenvironment{titlepage}
    {%
      \if@twocolumn
        \@restonecoltrue\onecolumn
      \else
        \@restonecolfalse\newpage
      \fi
      \thispagestyle{empty}%
      \setcounter{page}\z@
    }%
    {\if@restonecol\twocolumn \else \newpage \fi
    }
\else
\newenvironment{titlepage}
    {%
      \if@twocolumn
        \@restonecoltrue\onecolumn
      \else
        \@restonecolfalse\newpage
      \fi
      \thispagestyle{empty}%
      \setcounter{page}\@ne
    }%
    {\if@restonecol\twocolumn \else \newpage \fi
     \if@twoside\else
        \setcounter{page}\@ne
     \fi
    }
\fi
\newcounter {appendix}
\renewcommand\theappendix{\@Alph\c@appendix}
\newcommand\appendix{\par
  \addtocounter{appendix}{1}%
  \section*{\appendixname}
  \setcounter{section}{0}%
  \setcounter{subsection}{0}%
  \setcounter{subsubsection}{0}%
  \setcounter{figure}{0}%
  \setcounter{table}{0}%
  \renewcommand\thetable{\theappendix\@arabic\c@table}
  \renewcommand\thefigure{\theappendix\@arabic\c@figure}
  \gdef\thesection{\@Alph\c@section}}
\setlength\arraycolsep{5\p@}
\setlength\tabcolsep{6\p@}
\setlength\arrayrulewidth{.4\p@}
\setlength\doublerulesep{2\p@}
\setlength\tabbingsep{\labelsep}
\skip\@mpfootins = \skip\footins
\setlength\fboxsep{3\p@}
\setlength\fboxrule{.4\p@}
\renewcommand \theequation {\@arabic\c@equation}
\newcounter{figure}
\renewcommand \thefigure {\@arabic\c@figure}
\def\fps@figure{tbp}
\def\ftype@figure{1}
\def\ext@figure{lof}
\def\fnum@figure{\figurename\nobreakspace\thefigure}
\newenvironment{figure}
               {\@float{figure}}
               {\end@float}
\newenvironment{figure*}
               {\@dblfloat{figure}}
               {\end@dblfloat}
\newcounter{table}
\renewcommand\thetable{\@arabic\c@table}
\def\fps@table{tbp}
\def\ftype@table{2}
\def\ext@table{lot}
\def\fnum@table{\tablename\nobreakspace\thetable}
\newenvironment{table}
               {\@float{table}}
               {\end@float}
\newenvironment{table*}
               {\@dblfloat{table}}
               {\end@dblfloat}
\newlength\abovecaptionskip
\newlength\belowcaptionskip
\setlength\abovecaptionskip{-5\p@}
\setlength\belowcaptionskip{3.1\p@}

\def\FigName{figure}
\long\def\@makecaption#1#2{%
    \ifx\FigName\@captype
      \vskip\abovecaptionskip
      \@makefigurecaption{#1}{#2}%
    \else
      \@maketablecaption{#1}{#2}%
      \vskip\belowcaptionskip
    \fi}


\def\@makefigurecaption#1#2{%
    \noindent\figcaptionfont%
    {\figcaptionnumfont#1.}\hskip3.65pt{#2}\par}%

\def\tabular{\tablefont\let\@halignto\@empty\@tabular}

\def\@maketablecaption#1#2{%
    \noindent\tablecaptionfont\leftskip6mm%
   \noindent{{\tablecaptionnumfont#1.}\hskip5pt#2\vphantom{y}\par}}%
%

\newcommand\tch[4]{\multicolumn{#1}{#2}%
   {\TCHfont\begin{tabular}[#3]{@{}#2@{}}%
    \ignorespaces#4\unskip
    \end{tabular}}}

\newenvironment{tabnote}{\par\vskip3pt\tabnotefont\leftskip6mm}{\vskip3pt\par}


\DeclareOldFontCommand{\rm}{\normalfont\rmfamily}{\mathrm}
\DeclareOldFontCommand{\sf}{\normalfont\sffamily}{\mathsf}
\DeclareOldFontCommand{\tt}{\normalfont\ttfamily}{\mathtt}
\DeclareOldFontCommand{\bf}{\normalfont\bfseries}{\mathbf}
\DeclareOldFontCommand{\it}{\normalfont\itshape}{\mathit}
\DeclareOldFontCommand{\sl}{\normalfont\slshape}{\@nomath\sl}
\DeclareOldFontCommand{\sc}{\normalfont\scshape}{\@nomath\sc}
\DeclareRobustCommand*\cal{\@fontswitch\relax\mathcal}
\DeclareRobustCommand*\mit{\@fontswitch\relax\mathnormal}
\newcommand\@pnumwidth{1.55em}
\newcommand\@tocrmarg{2.55em}
\newcommand\@dotsep{4.5}
\setcounter{tocdepth}{3}
\newcommand\tableofcontents{%
    \section*{\contentsname
        \@mkboth{%
           \MakeUppercase\contentsname}{\MakeUppercase\contentsname}}%
    \@starttoc{toc}%
    }
\newcommand*\l@part[2]{%
  \ifnum \c@tocdepth >-2\relax
    \addpenalty\@secpenalty
    \addvspace{2.25em \@plus\p@}%
    \setlength\@tempdima{3em}%
    \begingroup
      \parindent \z@ \rightskip \@pnumwidth
      \parfillskip -\@pnumwidth
      {\leavevmode
       \large \bfseries #1\hfil \hb@xt@\@pnumwidth{\hss #2}}\par
       \nobreak
       \if@compatibility
         \global\@nobreaktrue
         \everypar{\global\@nobreakfalse\everypar{}}%
      \fi
    \endgroup
  \fi}
\newcommand*\l@section[2]{%
  \ifnum \c@tocdepth >\z@
    \addpenalty\@secpenalty
    \addvspace{1.0em \@plus\p@}%
    \setlength\@tempdima{1.5em}%
    \begingroup
      \parindent \z@ \rightskip \@pnumwidth
      \parfillskip -\@pnumwidth
      \leavevmode \bfseries
      \advance\leftskip\@tempdima
      \hskip -\leftskip
      #1\nobreak\hfil \nobreak\hb@xt@\@pnumwidth{\hss #2}\par
    \endgroup
  \fi}
\newcommand*\l@subsection{\@dottedtocline{2}{1.5em}{2.3em}}
\newcommand*\l@subsubsection{\@dottedtocline{3}{3.8em}{3.2em}}
\newcommand*\l@paragraph{\@dottedtocline{4}{7.0em}{4.1em}}
\newcommand*\l@subparagraph{\@dottedtocline{5}{10em}{5em}}
\newcommand\listoffigures{%
    \section*{\listfigurename}%
      \@mkboth{\MakeUppercase\listfigurename}%
              {\MakeUppercase\listfigurename}%
    \@starttoc{lof}%
    }
\newcommand*\l@figure{\@dottedtocline{1}{1.5em}{2.3em}}
\newcommand\listoftables{%
    \section*{\listtablename}%
      \@mkboth{%
          \MakeUppercase\listtablename}%
         {\MakeUppercase\listtablename}%
    \@starttoc{lot}%
    }
\let\l@table\l@figure
\newdimen\bibindent
\setlength\bibindent{1.5em}
\newenvironment{thebibliography}[1]
     {\section*{\refname}%
      \@mkboth{\MakeUppercase\refname}{\MakeUppercase\refname}%
      \list{\@biblabel{\@arabic\c@enumiv}}%
           {\settowidth\labelwidth{\@biblabel{#1}}%
            \leftmargin\labelwidth
            \advance\leftmargin\labelsep
            \@openbib@code
            \usecounter{enumiv}%
            \let\p@enumiv\@empty
            \renewcommand\theenumiv{\@arabic\c@enumiv}}%
      \sloppy
      \clubpenalty4000
      \@clubpenalty \clubpenalty
      \widowpenalty4000%
      \sfcode`\.\@m}
     {\def\@noitemerr
       {\@latex@warning{Empty `thebibliography' environment}}%
      \endlist}
\newcommand\newblock{\hskip .11em\@plus.33em\@minus.07em}
\let\@openbib@code\@empty
\newenvironment{theindex}
               {\if@twocolumn
                  \@restonecolfalse
                \else
                  \@restonecoltrue
                \fi
                \twocolumn[\section*{\indexname}]%
                \@mkboth{\MakeUppercase\indexname}%
                        {\MakeUppercase\indexname}%
                \thispagestyle{plain}\parindent\z@
                \parskip\z@ \@plus .3\p@\relax
                \columnseprule \z@
                \columnsep 35\p@
                \let\item\@idxitem}
               {\if@restonecol\onecolumn\else\clearpage\fi}
\newcommand\@idxitem{\par\hangindent 40\p@}
\newcommand\subitem{\@idxitem \hspace*{20\p@}}
\newcommand\subsubitem{\@idxitem \hspace*{30\p@}}
\newcommand\indexspace{\par \vskip 10\p@ \@plus5\p@ \@minus3\p@\relax}
\renewcommand\footnoterule{%
  \kern-3\p@
  \hrule\@width.4\columnwidth
  \kern2.6\p@}

\newcommand\@makefntext[1]{%
    \parindent 1em%
    \noindent
    \hb@xt@1.8em{\hss\@makefnmark}#1}

\newcommand\contentsname{Contents}
\newcommand\listfigurename{List of Figures}
\newcommand\listtablename{List of Tables}
\newcommand\refname{REFERENCES}
\newcommand\indexname{Index}
\newcommand\figurename{Figure}
\newcommand\tablename{Table}
\newcommand\partname{Part}
\newcommand\appendixname{APPENDIX}
\newcommand\abstractname{Abstract}
\def\today{\ifcase\month\or
  January\or February\or March\or April\or May\or June\or
  July\or August\or September\or October\or November\or December\fi
  \space\number\day, \number\year}
\setlength\columnsep{10\p@}
\setlength\columnseprule{0\p@}
\pagestyle{headings}
\pagenumbering{arabic}
\if@twoside
\else
  \raggedbottom
\fi
\if@twocolumn
  \twocolumn
  \sloppy
  \flushbottom
\else
  \onecolumn
\fi


\RequirePackage{graphicx}

%%%%%%%%%%%%%%%%% Enunciations   %%%%%%%%%%%%%%%

\RequirePackage{amsthm}
\newtheorem{theorem}{Theorem}
\newtheorem{lemma}{Lemma}
\newtheorem{proposition}{Proposition}
\newtheorem{corollary}{Corollary}
\newtheorem{definition}{Definition}
\newtheorem{assumption}{Assumption}
\newtheorem{notation}{Notation}
\newtheorem{remark}{Remark}
\newtheorem{note}{Note}
\newtheorem{case}{Case}
\newtheorem{step}{Step}
\newtheorem{problem}{Problem}
\newtheorem{exibition}{Exibition}
\newtheorem{establish}{Establish}
\newtheorem{result}{Result}
\newtheorem{example}{Example}
\newtheorem{claim}{Claim}
\newtheorem{Conjecture}{Conjecture}
\newtheorem{Conjection}{Conjection}

%%%%%%%%%%%%%%%%%%%

%%% Ex linguistic

%\usepackage{linguex}
\AtBeginDocument{\@ifpackageloaded{linguex}{
  \renewcommand{\resetExdefaults}{%
  \setlength{\Exlabelsep}{0.3em}%diff example num & listing
  \setlength{\Extopsep}{.66\baselineskip}% vspace after end of example
  \setlength{\SubSubExleftmargin}{1.8em}%space between list label[] or 3rd level & list entry
  \setlength{\SubExleftmargin}{1.3em}%%space between list num & list entry
  \setlength{\Exindent}{0pt}%indentaion of entire example number along with list text
  \setlength{\Exlabelwidth}{4em}%
  \setlength{\alignSubExnegindent}{\Exlabelsep}%
  \ifalignSubEx\addtolength{\Exlabelsep}{.7em}%
      \addtolength{\alignSubExnegindent}{.7em}\fi
  \setlength{\Exredux}{-\baselineskip}%
 }
 }{}}

%%% End of Ex linguistic %%%
\newif\iflingexused
\AtBeginDocument{\@ifpackageloaded{linguex}{\global\lingexusedtrue%
   \glossglue = 2pt plus 2pt minus 1pt % allow stretch/shrink between words
  \gdef\GlossGlue#1{\glossglue = #1 plus 2pt minus 1pt}
  \gdef\gln{{\hskip -\glossglue}\unhbox\gline\hfill}
  \gdef\glt{\unhbox\gline}
  \gdef\glttop{\renewenvironment{flushleft}{\raggedright}{}}
  \gdef\exelist{\if@noftnote\exmfont\else\endnotefont\fi}
  \gdef\endexelist{\ExEnd}
  \newenvironment{exetree}[1][\relax]{\exmfont%
             \leftmargini1.9em%
             \addtocounter{ExNo}{1}
             \begin{enumerate}\item[\theExNo]}
             {\end{enumerate}}
}{}}

\AtBeginDocument{\@ifpackageloaded{natbib}{\setlength{\bibhang}{18pt}}{}}


\newcount\endnotecnt
\def\endnote#1{%
   \global\advance\endnotecnt\@ne%
\textsuperscript{\the\endnotecnt}
\expandafter\gdef\csname endnote\romannumeral\the\endnotecnt\endcsname{#1}}


\newif\if@noftnote\@noftnotetrue%    
\let\footnote\endnote
\def\endnotefont{\fontsize{8.5}{11}\selectfont}
\def\printendnote{%
  \endnotefont%
  \@noftnotefalse%
  \tempcount=0%
  \ifnum\endnotecnt>\z@%
     \ifnum\endnotecnt>\@ne\section*{ENDNOTES}\else\section*{ENDNOTE}\fi%
     \ifnum\endnotecnt>9\leftmargini1.7em\else\leftmargini1.3em\fi%
   \begin{enumerate}%%
   \loop%
     \ifnum\endnotecnt>\z@%
     \advance\tempcount\@ne%
     \item \csname endnote\romannumeral\the\tempcount\endcsname%
     \advance\endnotecnt\m@ne%
     \iflingexused\setcounter{FnExNo}{0}\fi%used in example
  \repeat%
  \end{enumerate}%
 \fi%
}




%%
\endinput
%%
%% End of file `njl.cls'.
