\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{jfp}[2022/06/27 V1.9 Standard LaTeX document class]
%
\newif\ifcopoddhead\global\copoddheadfalse
\newif\ifOA\global\OAfalse
\newif\ifnolineno\global\nolinenofalse
\newif\ifnatbiboff\global\natbibofffalse
\newif\ifeqnum\global\eqnumfalse
\newif\ifkeyedin\global\keyedinfalse
\newif\iffirstproof\global\firstprooffalse
\newif\ifrevises\global\revisesfalse
\newif\iffinals\global\finalsfalse
\newif\ifpreview\global\previewfalse
\newif\iffootlist\global\footlistfalse
\newif\iffigsizecheck\global\figsizecheckfalse
\newif\ifresearch\global\researchfalse
\newif\ifnoquery\global\noqueryfalse
\newif\ifguestedit\global\guesteditfalse
\newif\ifaubreakand\global\aubreakandfalse
\newif\ifnoundrule\global\noundrulefalse
\newif\if@twoauthors\global\@twoauthorsfalse
\newif\if@affsep\global\@affsepfalse
\newif\iflettersize\global\lettersizetrue%
\newif\iflegalsize\global\legalsizefalse%
\newif\iftabloidsize\global\tabloidsizefalse%
\newif\ifpuretex\global\puretexfalse%
\newif\ifsamjournal\global\samjournalfalse%
\newif\ifbkmerge\global\bkmergefalse%
\newif\ifcolorimage\global\colorimagefalse%
\newif\ifbwimage\global\bwimagefalse%
\newif\ifsinglepage\global\singlepagefalse
\newif\ifblankpage\global\blankpagefalse
\newif\ifrmqpage\global\rmqpagefalse
\newif\ifrevqpage\global\revqpagefalse
\newif\ifbklpage\global\bklpagefalse
\newif\ifbkfpage\global\bkfpagefalse
\newif\ifintrotag\global\introtagfalse
\newif\ifbotfig\global\botfigfalse
\newif\ifmono\global\monofalse
\newif\ifdraft\global\draftfalse
\newif\ifprint\global\printfalse
\newif\ifbakoma\global\bakomafalse
\newif\ifnoquery\global\noqueryfalse
\newif\ifauthft\global\authftfalse
\newif\iflist\global\listfalse
\newif\ifcback\global\cbackfalse
\newif\ifshowframe\global\showframefalse
\newif\ifbback\global\bbackfalse
\newif\ifunnumbered\global\unnumberedfalse
\newif\ifchapteronly\global\chapteronlyfalse
\newif\ifcontentonly\global\contentonlyfalse
\newif\ifchaptercontent\global\chaptercontentfalse
\newif\iftwofig\global\twofigfalse
\newif\ifsidebotfig\global\sidebotfigfalse
\newif\ifsidetopfig\global\sidetopfigfalse
\newif\iflof\global\loffalse
\newif\iflot\global\lotfalse
\newif\ifnolot
\newif\ifprintcontact\global\printcontactfalse
\newif\ifdcolalignleft\global\dcolalignleftfalse
\newif\ifrefcomma\global\refcommafalse
\newif\iffigureshow\global\figureshowfalse
\newif\iftableshow\global\tableshowfalse
\newif\ifsecnumclass\global\secnumclassfalse
\newif\iflastpagewrite\global\lastpagewritefalse
\newif\ifUnNumfigure\global\UnNumfigurefalse
\newif\ifUnNumtable\global\UnNumtablefalse
\newif\ifappendix\global\appendixfalse
\newif\ifMathRoman\global\MathRomanfalse
\newif\ifMathBold\global\MathBoldfalse
\newif\ifMathBoldIT\global\MathBoldITfalse
\newif\ifremovespaces\global\removespacesfalse
\newif\iffirstpageoff\global\firstpageofffalse
\newif\ifbkpscreate\global\bkpscreatefalse
\newif\ifnomensect\global\nomensectfalse
\newif\ifitcont\global\itcontfalse
\newif\iffigcontcheck\global\figcontcheckfalse
\newif\if@display%
\newif\if@author\global\@authortrue%
\newif\if@authoremail\global\@authoremailfalse%
\newif\if@references\global\@referencesfalse%
\newif\if@sluginfo\global\@sluginfofalse%
\newif\if@namedcontent\global\@namedcontentfalse%
\newif\if@list\global\@listfalse%%
\newif\if@numberedlist\@numberedlistfalse
\newif\if@nomenclature\@nomenclaturefalse
\newif\if@algorithm\global\@algorithmfalse
\newif\if@tablefootnote\global\@tablefootnotefalse
\newif\if@appendix\global\@appendixfalse
\newif\if@firstsection\@firstsectiontrue
\newif\if@inlinealgorithm
\newif\iffigtopcap\global\figtopcapfalse
\newif\if@rot@twoside
\newif\iflandoff\global\landofffalse
\newif\if@lastviper \@lastviperfalse
\newif\ifFoottext\global\Foottextfalse
\newif\iffootdisplay\global\footdisplayfalse
\newif\ifregistermark
\newif\ifpspdfcreate\global\pspdfcreatefalse
\newif\ifrepro\reprofalse
\newif\ifddraft
\newif\ifcontact
\newif\ifprinter
\newif\ifonline\global\onlinefalse
\newif\ifcountempty\global\countemptyfalse
\newif\ifpddata\global\pddatafalse
\newif\iffloatid\global\floatidfalse
\newif\ifmathtif\global\mathtiffalse%
\newif\ifAbstract\global\Abstractfalse
\newif\ifmergexml\global\mergexmlfalse
\newif\ifnoimage\global\noimagefalse
\newif\ifSecNo\global\SecNofalse
\newif\ifbookreview\global\bookreviewfalse%%
\newif\ifnoranges\global\norangesfalse%%
\newif\ifnodoi\global\nodoifalse%%
\newif\ifnokeyword\global\nokeywordfalse%%
\newif\ifnocopyright\global\nocopyrightfalse%%
\newif\ifnocopysymb\global\nocopysymbfalse%%
\newif\ifreviewer\global\reviewerfalse%%
\newif\ifcallpaper\global\callpaperfalse%%
\newif\iftexteditor\global\texteditorfalse%%
\newif\ifeditorial\global\editorialfalse%%
\newif\ifDhead\global\Dheadfalse%%
\newif\ifEPF\global\EPFfalse%
\newif\ifnoauthor\global\noauthorfalse%
\newif\ifdbleed\global\dbleedfalse%
\newif\ifsupertitle\global\supertitlefalse%
\newif\iffigsrcpresent\global\figsrcpresentfalse
\newif\ifcallforpaper\global\callforpaperfalse%
\newif\ifintexttbl\global\intexttblfalse
\newif\ifnoqrule\global\noqrulefalse
\newif\ifnoabstract\global\noabstractfalse%%
\newif\ifcorrigendum\global\corrigendumfalse%%
\newif\ifsupplementary\global\supplementaryfalse%
\newif\ifbkblurb\global\bkblurbfalse%%
\newif\ifsplissue\global\splissuefalse%
\newif\ifannouncement\global\announcementfalse%%
\newif\iferratum\global\erratumfalse
\newif\if@obituary\global\@obituaryfalse
\newif\if@puretex\global\@puretexfalse
\newif\if@final\@finalfalse
\newif\if@aa\global\@aafalse
\newif\if@rp\global\@rpfalse
\newif\if@issue\global\@issuefalse
\newif\if@ddraft\@ddraftfalse
\newif\if@editorial\@editorialfalse
\newif\if@puretex\global\@puretexfalse
\newif\if@colorinfo\global\@colorinfofalse
\newif\if@justnomen\global\@justnomenfalse
\newif\if@wfp\global\@wfpfalse
\newif\if@comm\global\@commfalse
\newif\if@figcenter\global\@figcenterfalse
\newif\if@smallformat\global\@smallformatfalse
\newif\if@cover\global\@coverfalse%
\newif\if@bwcover\global\@bwcoverfalse%
\newif\if@runonauthor
\newif\if@history\global\@historyfalse
\newif\if@corres\global\@corresfalse
\newif\if@reflink\global\@reflinkfalse
\newif\ifdhead\global\dheadfalse
\newif\ifauthor \authorfalse%
\newif\iffloutsidemargin\floutsidemarginfalse
\newif\ifflinsidemargin\flinsidemarginfalse
\newif\ifflleftsidemargin\flleftsidemarginfalse
\newif\ifflrightsidemargin\flrightsidemarginfalse
\newif\ifTheorem\global\Theoremfalse
\newif\iffloutsidetexttypewidthsep\floutsidetexttypewidthsepfalse
\newif\ifflinsidetexttypewidthsep\flinsidetexttypewidthsepfalse
\newif\ifflleftsidetexttypewidthsep\flleftsidetexttypewidthsepfalse
\newif\ifflrightsidetexttypewidthsep\flrightsidetexttypewidthsepfalse
\newif\ifExample\global\Examplefalse
\newif\ifrunon\runonfalse
\newif\if@thmdot\global\@thmdotfalse
\newif\ifswitchcols
\newif\ifauthor \authorfalse%
\newif\ifaffiliation \global\affiliationfalse%
\newif\if@oneoffnum\global\@oneoffnumfalse
\newif\ifunnumberedaffil\unnumberedaffilfalse
\newif\ifsymbolaffilcount\symbolaffilcountfalse
\newif\ifreview\global\reviewfalse
\newif\iflabelrightalign\labelrightaligntrue
\newif\iffnalpha\global\fnalphafalse
\newif\ifunnumlistitem\unnumlistitemfalse
\newif\ifFP\global\FPfalse
\newif\ifCO\global\COfalse
\newif\ifsidefigure\global\sidefigurefalse
\newif\ifrightsidefigure\global\rightsidefigurefalse
\newif\iftopcap\global\topcaptrue
\newif\ifbotcap\global\botcapfalse
\newif\ifcencap\global\cencapfalse
\newif\ifsidewaysfigure\sidewaysfigurefalse
\newif\ifmarginalfigure\marginalfigurefalse
\newif\ifTBhang\global\TBhangtrue
\newif\ifwithintabular\withintabularfalse
\newif\ifsidewaystable\sidewaystablefalse%
\newif\ifsidewbreak\sidewbreakfalse%
\newif\ifhangtab\global\hangtabfalse
\newif\ifremovetoprule\global\removetoprulefalse
\newif\ifremovebotrule\global\removebotrulefalse
\newif\ifunnumtable\unnumtablefalse
\newif\ifmarginaltable\marginaltablefalse
\newif\iftablewithshade\tablewithshadefalse
\newif\iftbsidecap\tbsidecapfalse
\newif\iftablerulebox\global\tableruleboxfalse%
\newif\ifkilltableabovespace\killtableabovespacefalse
\newif\ifnobotrule\global\nobotrulefalse%
\newif\ifnocaption\global\nocaptionfalse
\newif\ifframed\framedfalse
\newif\ifnotablenum
\newif\iftablefootnotenone\tablefootnotenonefalse
\newif\iftestbody\testbodytrue
\newif\ifbibchapter\global\bibchapterfalse
\newif\ifnumsqure\global\numsqurefalse
\newif\iffirstfm\global\firstfmtrue%
\newif\iffirstbm\global\firstbmfalse%
\newif\ifstartfm\global\startfmtrue%
\newif\ifdottedfmbmcontent\dottedfmbmcontentfalse%
\newif\iffixauthorcontent\fixauthorcontentfalse%
\newif\ifswitch@CH@bkm@no\global\switch@CH@bkm@nofalse%
\newif\iffixchapcontent\fixchapcontentfalse%
\newif\ifdottedchapcontent\dottedchapcontenttrue%
\newif\iffixfigurecontent\fixfigurecontentfalse%
\newif\ifdottedfigurecontent\dottedfigurecontenttrue%
\newif\iffixtablecontent\fixtablecontentfalse%
\newif\ifdottedtablecontent\dottedtablecontenttrue%
\newif\ifremoveaux\removeauxfalse%
\newif\ifspreadlong
\newif\ifcilayout\global\cilayoutfalse
\newif\ifmath\global\mathfalse
\newif\iftoptabcaption\global\toptabcaptionfalse
\newif\ifbottabcaption\global\bottabcaptiontrue
%
\@twosidetrue\@mparswitchtrue

\newcount\tempcount
\newcount\affcount\affcount0%
\newcount\afftempcount
\newcount\tempaffcount
\newcount\instcount\instcount0%
\newcount\insttempcount
\newcount\tempinstcount
\newcount\deptcount\deptcount0%
\newcount\depttempcount
\newcount\tempdeptcount
\newcount\streetcount\streetcount0%
\newcount\streettempcount
\newcount\tempstreetcount
\newcount\citycount\citycount0%
\newcount\citytempcount
\newcount\tempcitycount
\newcount\statecount\statecount0%
\newcount\statetempcount
\newcount\tempstatecount
\newcount\postcodecount\postcodecount0%
\newcount\postcodetempcount
\newcount\temppostcodecount
\newcount\countrycount\countrycount0%
\newcount\countrytempcount
\newcount\tempcountrycount
\newcount\refvaluecount
\newcount\temprefvaluecount
\newcount\refvaluetempcount
\newcount\enunheadcount
\newcount\tempenunheadcount
\newcount\enuntempcount
\newcount\algheadcount
\newcount\tempalgheadcount
\newcount\algtempcount
\newcount\authorcount\authorcount0%
\newcount\tempauthorcount\tempauthorcount0%
\newcount\authorcommacount\authorcommacount0%
\newcount\authortempcount\authortempcount0%
\newcount\keywordcount
\newcount\keytempcount
\newcount\tempkeywordcount
\newcount\minute
\newcount\hour
\newcount\authorcount \authorcount0%
\newcount\tempaffilcount
\newcount\authorcount \authorcount0%
\newcount\tempauthorcount \tempauthorcount0%
\newcount\affiliationcount \affiliationcount0%
\newcount\tempaffiliationcount \tempaffiliationcount0%
\newcount\tempcount
\newcount\affilcount
\newcount\affiltempcount
\newcount\tempaffilcount
\newcount\membercount
\newcount\membertempcount
\newcount\tempmembercount
\newcount\historycount
\newcount\historytempcount
\newcount\temphistorycount
\newcount\historycount
\newcount\historytempcount
\newcount\temphistorycount
\newcount\symtempcount
\newcount\tfootcount\global\tfootcount0
\newcount\temptfootcount%
\newcount\tbodycount\global\tbodycount0
\newcount\tgroupcount\tgroupcount0
\newcount\bcount
\newcount\ncount\ncount=1
\newcount\ccount\ccount=1
\newcount\acomcount
\newcount\tempacomcount
\newcount\acomtempcount
\newcount\TotalCharCount\TotalCharCount0
\newcount\seccount%
\newcount\authcount%
\newcount\SCOUNT
\newcount\HCOUNT
\newcount\fpcount
\newcount\viper@penalty
\newcount\AQpage\AQpage0%
\newcount\AQlpage\AQlpage0%

\newcounter{afrfilnote}
\newcounter {part}
\newcounter {chapter}
\newcounter {HLchapter}
\newcounter {section}[chapter]
\newcounter {subsection}[section]
\newcounter {subsubsection}[subsection]
\newcounter {paragraph}[subsubsection]
\newcounter {subparagraph}[paragraph]
\newcounter {HLsection}[HLchapter]%%%%
\newcounter {HLsubsection}[HLsection]%%%%
\newcounter {HLsubsubsection}[HLsubsection]%%%%
\newcounter {HLparagraph}[HLsubsubsection]%%%%
\newcounter {HLsubparagraph}[HLparagraph]%%%%
\newcounter {subsubparagraph}[subparagraph]%%%%
\newcounter {subsubsubparagraph}[subsubparagraph]%%%%
\newcounter {HLsubsubparagraph}%[HLsubparagraph]%%%%
\newcounter {HLsubsubsubparagraph}%[HLsubsubparagraph]%%%%
\newcounter{ncount}
\newcounter{figure}[chapter]
\newcounter{table}
\newcounter{samp}
\newcounter{abscount}
\newcounter{startendpage}

\newdimen\trimwidthval
\newdimen\trimwidthbleedval
\newdimen\trimheightval
\newdimen\trimheightbleedval
\newdimen\draftrule\draftrule0pt
\newdimen\trimrule\trimrule0pt
\newdimen\tempdimen%
\newdimen\normaltextheight%
\newdimen\blindfoliodrop%
\newdimen\enumdim%
\newdimen\figheight%
\newdimen\figwidth%
\newdimen\tabledim%
\newdimen\mathindent%
\newdimen\emathindent%
\newdimen\bibindent%
\newdimen\metaleftskip\metaleftskip0pt
\newdimen\metarightskip\metarightskip0pt
\newdimen\@partialpageht
\newdimen\storedboxheight
\newdimen\LabelSep \LabelSep4.7pt
\newdimen\leftmarginvii
\newdimen\leftmarginviii
\newdimen\leftmarginix
\newdimen\leftmarginx
\newdimen\enumdimwd
\newdimen\itemleftmargin
\newdimen\itemlabelsep
\newdimen\figcadimen
\newdimen\captionwidth
\newdimen\figindent
\newdimen\figwidthcapdimen
\newdimen\exfigdimwd
\newdimen\figdim
\newdimen\tabledim%
\newdimen\sidetskip\sidetskip=0pt%
\newdimen\sideverticalskip\sideverticalskip=0pt
\newdimen\tablecaptionheight
\newdimen\sidetskip\sidetskip0pt
\newdimen\sideverticalskip\sideverticalskip0pt
\newdimen\tablewidth
\newdimen\tablewidthshade
\newdimen\fboxtablewidth
\newdimen\tablewidth
\newdimen\extratableheight
\newdimen\tablebodywidth
\newdimen\tableheight
\newdimen\fboxgrtypewidth
\newdimen\toprulewidth
\newdimen\midrulewidth
\newdimen\botrulewidth
\newdimen\cmidrulewidth
\newdimen\belowrulesep
\newdimen\belowbottomsep
\newdimen\aboverulesep
\newdimen\abovetopsep
\newdimen\cmidrulesep
\newdimen\cmidrulekern
\newdimen\defaultaddspace
\newdimen\@thisrulewidth
\newdimen\foot@parindent
\newdimen\ptdraftrule
\newdimen\ptdraftrule
\newdimen\temptextheight
\newdimen\bibindent
\newdimen\bibleftmargin
\newdimen\bibitemsep
\newdimen\bibparsep
\newdimen\bibtext
\newdimen\biblabelsep
\newdimen\bibleftmargini
\newdimen\chapwidth%
\newdimen\secnwidth%
\newdimen\subsecnwidth%
\newdimen\subsubsecnwidth%
\newdimen\pldim%
\newdimen\authorcontentwidth%
\newdimen\@secmaxnumdim%
\newdimen\secnwidth%
\newdimen\@subsecmaxnumdim%
\newdimen\subsecnwidth%
\newdimen\@figuremaxnumdim%
\newdimen\figurecontwidth%
\newdimen\@tablemaxnumdim%
\newdimen\tablecontwidth%
\newdimen\tempdim
\newdimen\presentfigwidth
\newdimen\oldfigwidth
\newdimen\remainingtextwidth
\newdimen\letterwidth%
\newdimen\letterheight%
\newdimen\legalwidth%
\newdimen\legalheight%
\newdimen\tabloidwidth%
\newdimen\tabloidheight%
\newdimen\@tempdima%%
\newdimen\@tempdimb%%
\newdimen\@tempdimc%%
\newdimen\@tempdimd%%
\newdimen\@tempdime%%
\newdimen\deflistmaxskip
\newdimen\deflistskip%
\newdimen\myskip%
\newdimen\ht@viper

\newbox\hisbox
\newbox\tempbox%
\newbox\abstractbox%
\newbox\store@outputbox
\newbox\keywordbox
\newbox\subbox
\newbox\tabimagebox
\newbox\citybox
\newbox\statebox
\newbox\pscodebox
\newbox\countrybox
\newbox\addlinebox
\newbox\instbox
\newbox\instnamebox
\newbox\deptbox
\newbox\zipbox
\newbox\provincebox
\newbox\phonebox
\newbox\faxbox
\newbox\deflistbox
\newbox\boxBibH
\newbox\onlinefibox
\newbox\onlinefiibox
\newbox\v@aaa
\newbox\v@ccc
\newbox\authrun
\newbox\plainCOPbox%
\newbox\colorCOPbox%
\newbox\chap@tempbox%
\newbox\tempabox
\newbox\figcapbox
\newbox\figtempbox
\newbox\tabcapbox
\newbox\tablefootbox
\newbox\temptbox
\newbox\tempttbox
\newbox\temptttbox
\newbox\tempttttbox
\newbox\tabletempboxsecond
\newbox\tabletempboxthird
\newbox\boxcont
\newbox\titrun

\newskip\normalbaselineskip%
\newskip\tableleftskip%
\newskip\tablerightskip%
\newskip\tabnoteleftskip%
\newskip\tabnoterightskip%
\newskip\colmargin
\newskip\texttypewidthsep
\newskip\authorbelowskip
\newskip\headlineindent
\newskip\instindent
\newskip\topsepi
\newskip\topsepii
\newskip\topsepiii
\newskip\topsepiv
\newskip\topsepv
\newskip\topsepvi
\newskip\topsepvii
\newskip\topsepviii
\newskip\topsepix
\newskip\topsepx
\newskip\itemsepi
\newskip\itemsepii
\newskip\itemsepiii
\newskip\itemsepiv
\newskip\itemsepv
\newskip\itemsepvi
\newskip\itemsepvii
\newskip\itemsepviii
\newskip\itemsepix
\newskip\itemsepx
\newskip\listtextleftmargin
\newskip\listtextleftmarginii
\newskip\listtextleftmarginiii
\newskip\listtextleftmarginiv
\newskip\listtextleftmarginv
\newskip\listtextleftmarginvi
\newskip\listtextleftmarginvii
\newskip\listtextleftmarginviii
\newskip\listtextleftmarginix
\newskip\listtextleftmarginx
\newskip\listtextrightmargin
\newskip\listlabelleftskip
\newskip\listlabelleftskipii
\newskip\listlabelleftskipiii
\newskip\listlabelleftskipiv
\newskip\listlabelleftskipv
\newskip\listlabelleftskipvi
\newskip\listlabelleftskipvii
\newskip\listlabelleftskipviii
\newskip\listlabelleftskipix
\newskip\listlabelleftskipx
\newskip\abovelistskipi
\newskip\belowlistskipi
\newskip\abovelistskipii
\newskip\belowlistskipii
\newskip\abovelistskipiii
\newskip\belowlistskipiii
\newskip\abovelistskipiv
\newskip\belowlistskipiv
\newskip\abovelistskipv
\newskip\belowlistskipv
\newskip\abovelistskipvi
\newskip\belowlistskipvi
\newskip\abovelistskipvii
\newskip\belowlistskipvii
\newskip\abovelistskipviii
\newskip\belowlistskipviii
\newskip\abovelistskipix
\newskip\belowlistskipix
\newskip\abovelistskipx
\newskip\belowlistskipx
\newskip\labelsepi
\newskip\labelsepii
\newskip\labelsepiii
\newskip\labelsepiv
\newskip\labelsepv
\newskip\labelsepvi
\newskip\labelsepvii
\newskip\labelsepviii
\newskip\labelsepix
\newskip\labelsepx
\newskip\unnumlistitemindent
\newskip\unnumlisttextskip
\newskip\figcaptionleftskip
\newskip\figcaptionrightskip
\newskip\figleftskip
\newskip\figrightskip
\newskip\adjustskip
\newskip\sidetskip\sidetskip=0pt
\newskip\sideverticalskip\sideverticalskip=0pt
\newskip\fignumcapsep\fignumcapsep=5pt
\newskip\figcapdescsep\figcapdescsep=0pt
\newskip\tableleftskip%
\newskip\tablerightskip%
\newskip\tablecapleftskip%
\newskip\tablecaprightskip%
\newskip\sideverticalskip
\newskip\sidetskip
\newskip\addtotablewidth
\newskip\tablenumcapsep
\newskip\tablefootleftskip
\newskip\tablefootrightskip
\newskip\manshowtfootskip
\newskip\footnoteabovespace
\newskip\fixfmbmcontentwidth
\newskip\fixauthorcontentwidth
\newskip\fixchapcontentwidth
\newskip\enspacechapcontentwidth
\newskip\enspacefigurecontentwidth
\newskip\fixfigurecontentwidth
\newskip\fixtablecontentwidth
\newskip\enspacetablecontentwidth
\newskip\@mathmargin
\newskip\verbatimindent
\newskip\CRskip

\newlength\subtitleval
\newlength\abovecaptionskip
\newlength\belowcaptionskip
\newlength\trimwidth%
\newlength\trimheight%
\newlength\typewidth%
\newlength\typeheight%
%
\newtoks\authorrunning
\newtoks\titlerunning
\newtoks\CharCounttoks

\newwrite\@maintab%%
\newwrite\@mainndx


\DeclareOption{reviewer}{\global\reviewertrue}
\DeclareOption{OA}{\global\OAtrue}
\DeclareOption{showframe}{\global\showframetrue}
\DeclareOption{noundrule}{\global\noundruletrue}
\DeclareOption{callforpaper}{\global\callforpapertrue}
\DeclareOption{EPF}{\global\EPFtrue}
\DeclareOption{pdfcreate}{\global\pspdfcreatetrue}%
\DeclareOption{lettersize}{\lettersizetrue\legalsizefalse\tabloidsizefalse}%
\DeclareOption{legalsize}{\lettersizefalse\legalsizetrue\tabloidsizefalse}%
\DeclareOption{tabloidsize}{\lettersizefalse\legalsizefalse\tabloidsizetrue}%
\DeclareOption{registermark}{\registermarktrue}
\DeclareOption{keyedin}{\keyedintrue}
\DeclareOption{dbleed}{\global\dbleedtrue}
\DeclareOption{supertitle}{\global\supertitletrue}
\DeclareOption{bkmerge}{\global\bkmergetrue}
\DeclareOption{fp}{\global\firstprooftrue}
\DeclareOption{guestedit}{\global\guestedittrue}
\DeclareOption{research}{\global\researchtrue}
\DeclareOption{revises}{\global\revisestrue}
\DeclareOption{finals}{\global\finalstrue\global\noquerytrue}
\DeclareOption{issue}{\global\@issuetrue}
\DeclareOption{bakoma}{\global\bakomatrue\global\onlinetrue}
\DeclareOption{webpdf}{\global\onlinetrue\global\noquerytrue\global\figsizechecktrue}
\DeclareOption{colorimage}{\global\colorimagetrue\global\bwimagetrue}
\DeclareOption{bwimage}{\global\bwimagetrue}
\DeclareOption{preview}{\global\previewtrue\global\onlinetrue\global\noquerytrue}
\DeclareOption{ELD}{\global\onlinetrue\global\noquerytrue}
\DeclareOption{repro}{\reprotrue}
\DeclareOption{noquery}{\noquerytrue}
\DeclareOption{natbiboff}{\global\natbibofftrue}
\DeclareOption{eqnum}{\global\eqnumtrue}
\DeclareOption{countempty}{\countemptytrue}
\DeclareOption{draft}{\setlength\overfullrule{5pt}\draftrule.25pt\drafttrue\global\floatidtrue}
\DeclareOption{ddraft}{\setlength\overfullrule{5pt}\draftrule.25pt\drafttrue}
\DeclareOption{online}{\global\onlinetrue}
\DeclareOption{final}{\setlength\overfullrule{0pt}}
\DeclareOption{contact}{\setlength\overfullrule{0pt}\contacttrue}
\DeclareOption{nolinenum}{\global\nolinenotrue}
\DeclareOption{printer}{\setlength\overfullrule{0pt}\trimrule0pt\printertrue}
\DeclareOption{purexml}{\global\puretexfalse}
\DeclareOption{puretex}{\global\puretextrue}
\DeclareOption{mathtif}{\global\mathtiftrue\global\puretextrue}
\DeclareOption{bookreview}{\global\bookreviewtrue}
\DeclareOption{noranges}{\global\norangestrue}
\DeclareOption{nodoi}{\global\nodoitrue}
\DeclareOption{nokeyword}{\global\nokeywordtrue}
\DeclareOption{nocopyright}{\global\nocopyrighttrue}
\DeclareOption{nocopysymb}{\global\nocopysymbtrue}
\DeclareOption{singlepage}{\global\singlepagetrue}
\DeclareOption{callpaper}{\global\callpapertrue}
\DeclareOption{texteditor}{\global\texteditortrue}
\DeclareOption{editorial}{\global\editorialtrue}
\DeclareOption{noauthor}{\global\noauthortrue}
\DeclareOption{dhead}{\global\dheadtrue}
\DeclareOption{noabstract}{\global\noabstracttrue}
\DeclareOption{corrigendum}{\global\corrigendumtrue}
\DeclareOption{supplementary}{\global\supplementarytrue}
\DeclareOption{bkblurb}{\global\bkblurbtrue}
\DeclareOption{splissue}{\global\splissuetrue}
\DeclareOption{announcement}{\global\announcementtrue}
\DeclareOption{erratum}{\global\erratumtrue}

\ExecuteOptions{final}
\ProcessOptions

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%Standard Packages

\usepackage{etex}
\usepackage{amsthm}
\usepackage{soul}
\usepackage{calc}
\usepackage{color}

\usepackage{ifxetex,ifluatex}

\definecolor{shadecolor}{cmyk}{0,0,0,.12}
\definecolor{absshadecolor}{cmyk}{0,0,0,.12}

\usepackage{framed}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%Standard Packages

\newcommand\contentsname{Contents}
\newcommand\listfigurename{List of Figures}
\newcommand\listtablename{List of Tables}
\newcommand\bibname{References}
\newcommand\indexname{Index}
\newcommand\figurename{Figure}
\newcommand\tablename{Table}
\newcommand\partname{Part}
\newcommand\chaptername{Chapter}
\newcommand\appendixname{Appendix}
%
\newcommand\today{\ifcase\month\or
  January\or February\or March\or April\or May\or June\or
  July\or August\or September\or October\or November\or December\fi
  \space\number\day, \number\year}
%

\def\currenttime{%
     \minute\time
     \hour\minute
     \divide\hour60
     \the\hour:\multiply\hour60\advance\minute-\hour\the\minute}
%
%\def\jobtag{\@currname\ {\bf\uppercase{Sample Elements for Quick Reference}}}%%
%\def\jobtag{{\bf LaTeX Sample Elements for Quick Reference}}%%
%\def\@pushfilename{%
%  \xdef\@currnamestack{%
%    {\@currname}%
%    {\@currext}%
%    {\the\catcode`\@}%
%    \@currnamestack}}%
%\@onlypreamble\@pushfilename%
%\@pushfilename%
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% End Boxes & Dimensions %%%%%%%%%%%%%%%%%
%
\def\mdash{\unskip~--\ \ignorespaces}
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Fonts %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Credit Line font
\def\psplainfont{\fontsize{7.5}{9.5}\selectfont}
\def\doiplainfont{\fontsize{8.47}{10}\selectfont\rightskip0pt plus1fill}
%% headings
\def\rhfont{\fontsize{10}{10}\itshape\selectfont}
\def\foliofont{\fontsize{10}{10}\selectfont}
\def\myfoliofont{\fontsize{10.5}{10.5}\fontfamily{\sfdefault}\selectfont}
\def\dropfoliofont{\foliofont}
\def\jvolfont{\fontsize{10}{10}\bfseries\selectfont}
%% part
\def\PNfont{\fontsize{50}{50}\bfseries\selectfont\leftskip0pt plus1fill\rightskip-10pc plus1fill}
\def\PTfont{\fontsize{32}{38}\bfseries\selectfont\leftskip0pt plus1fill\rightskip-10pc plus1fill}%\leftskip.5pc plus1fill\rightskip.5pc plus1fill}
\def\PSTfont{\fontsize{13}{15}\bfseries\selectfont}%\leftskip.5pc plus1fill\rightskip.5pc plus1fill}
%% chapter
\def\abstractfont{\fontsize{9}{11}\selectfont}
\def\abstractheadfont{\fontsize{10}{12}\bfseries\selectfont\centering}
\def\keywordfont{\fontsize{9}{10}\selectfont}
\def\authorfont{\fontsize{10}{12}\selectfont\centering}
\def\continuedfont{\fontsize{8}{8}\itshape\selectfont}
%% section
\def\sectionfont{\fontsize{10}{12}\bfseries\selectfont\leftskip0pt plus1fill\rightskip0pt plus1fill}%\mathversion{sfsansbold}
\def\subsectionfont{\fontsize{10}{12}\bfseries\itshape\selectfont\leftskip0pt plus1fill\rightskip0pt plus1fill}
\def\subsubsectionfont{\fontsize{10}{12}\itshape\selectfont\leftskip0pt plus1fill\rightskip0pt plus1fill}%yet to check
\def\paragraphfont{\bfseries}%
\def\subparagraphfont{}%
\def\subsubparagraphfont{}%
%
\def\sectionnumfont{\sectionfont}
\def\subsectionnumfont{\subsectionfont}
%
%% figure
\def\figcaptionfont{\fontsize{9}{11}\selectfont}
\def\figcaptiondescfont{\fontsize{9}{11}\selectfont}
\def\figcaptionnumfont{\fontsize{9}{11}\selectfont}
\def\figattribfont{\fontsize{9}{11}\selectfont}
%% TABLE
\def\multilistfont{\fontsize{8.5}{10}\selectfont\leftskip\tableleftskip\rightskip\tablerightskip}%
\def\multilistheadfont{\fontsize{8.5}{10}\bfseries\selectfont\leftskip\tableleftskip\rightskip\tablerightskip}%
\def\tablefont{\fontsize{9}{11}\selectfont}%
\def\tablecaptionfont{\fontsize{9}{11}\selectfont}%
\def\tablecaptwofont{\fontsize{9}{11}\selectfont}%
\def\tablecaptionnumfont{\fontsize{10}{11}\selectfont\rm}%
\def\TCHfont{\fontsize{9}{11}\selectfont}%
\def\TSCHfont{}%
\def\tabnotefont{\fontsize{9}{10}\selectfont}% use plus 1fill if needed
%% Long-Table
\def\LTtablecaptionfont{\fontsize{9}{11}\itshape\selectfont}%
\def\LTtablenotefont{\fontsize{8.5}{10}\selectfont}%
%% BM
\def\indexfont{\footnotesize\raggedright}
\def\bibliofont{\fontsize{9}{11}\selectfont}
\def\appfont{\fontsize{9}{10}\selectfont}
%
\def\listfont{}
\def\listdevicefont{}
\def\extractfont{\fontsize{9}{11}\selectfont\leftskip12pt\rightskip\leftskip}
%
%
\def\supertitlefont{\fontsize{16}{18}\bfseries\selectfont\centering\mathversion{bold}}
\def\supertitleitfont{\fontsize{18}{20}\itshape\selectfont\centering\mathversion{normal}}
\def\Dheadeditorfont{\fontsize{14}{16}\itshape\selectfont\centering\mathversion{normal}}
%
\def\sixtnptfont{\fontsize{16}{20}\bfseries\selectfont}
\def\twlptfont{\fontsize{12}{12}\selectfont}
\def\twlveptfont{\fontsize{12}{14}\selectfont}
\def\twlbptfont{\fontsize{12}{12}\bfseries\selectfont}
\def\eightnfont{\fontsize{18}{20}\bfseries\selectfont}
\def\fortnfont{\fontsize{14}{16}\bfseries\selectfont}
\def\fortnrfont{\fontsize{14}{16}\selectfont}
\def\tenptfont{\fontsize{10}{10}\bfseries\selectfont}
\def\nineptfont{\fontsize{9}{9}\selectfont}
\def\ninetenfont{\fontsize{9}{10}\selectfont}
\def\ninehptfont{\fontsize{8.7}{9}\selectfont}
\def\eightptfont{\fontsize{8}{8}\selectfont}
\def\eighthptfont{\fontsize{8.5}{10}\bfseries\selectfont}
\def\sevenptfont{\fontsize{7}{8}\selectfont}
\def\sevenhptfont{\fontsize{7.5}{8.5}\selectfont}
\def\sixptfont{\fontsize{6}{7}\selectfont}
\def\sixhptfont{\fontsize{6.5}{8}\selectfont}
\def\sixedfont{\fontsize{6}{7}\selectfont\leftskip12pt\rightskip0pt plus1fill}
\def\sixhedfont{\fontsize{5.7}{7}\selectfont\leftskip12pt\rightskip0pt plus1fill}
\def\sixfont{\fontsize{6}{7}\selectfont}
\def\sevenaufont{\fontsize{7}{7}\itshape\selectfont}
\def\historyfont{\fontsize{7}{9}\fontfamily{\sfdefault}\selectfont}
\def\titlefont{\fontsize{18}{21}\selectfont\centering\itshape}%\bfseries
\def\corresfont{\fontsize{7}{9}\fontfamily{\sfdefault}\selectfont}
%\def\subtitlefont{\normalfont\iftitval\fontsize{12}{14}\selectfont\else\fontsize{18}{20}\selectfont\fi\itshape\centering}
\def\keyfont{\fontsize{8}{10}\fontfamily{\sfdefault}\selectfont}
\def\keyheadfont{\fontsize{8}{10}\fontfamily{\sfdefault}\selectfont}
\def\absheadfont{\fontsize{12}{12}\fontfamily{\sfdefault}\selectfont}
\def\acknowfont{\fontsize{7}{9}\selectfont}
\def\headifont{\fontsize{10}{12}\fontfamily{\sfdefault}\selectfont\leftskip0pt plus1fill\rightskip0pt plus1fill}
\def\refheadfont#1{#1}
\def\affilfont{\fontsize{8}{10}\selectfont\itshape\centering}
%
%%%%%%%%%%%%%%%%%%%%%%%%% Fonts %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%% Fonts %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\def\colorone{\special{color push cmyk 0.8 0.3 0.1 0}}%1
\def\colortwo{\special{color push cmyk 0.70 0 0.05 0.25}}%2
\def\colorthree{\special{color push cmyk 0.20 0.60 1.0 0}}%3
\def\colorfour{\special{color push cmyk 0 0 0.35 0}}%4%
\def\colorfive{\special{color push cmyk 1.0 0 0 0.30}}%5
\def\colorsix{\special{color push cmyk 0 0.15 0.60 0.05}}%6
\def\colorseven{\special{color push cmyk 0 1.0 0 0.40}}%7
\def\coloreight{\special{color push cmyk 0.80 0 0.70 0.35}}%8
\def\colornine{\special{color push cmyk 0.20 0 0.20 0.05}}%9
\def\colorten{\special{color push cmyk 0 1.0 1.0 0.60}}%10
\def\coloreleven{\special{color push cmyk 0.25 0 0.95 0.35}}%11
\def\colortwelve{\special{color push cmyk 1.0 0 0.35 0}}%12
\def\colorthirteen{\special{color push cmyk 0.15 0 0 0}}%13%
\def\colorfourteen{\special{color push cmyk 0 0 0.05 0.05}}%14
\def\colorfifteen{\special{color push cmyk 0 0 0.30 0.20}}%15%
\def\colorsixteen{\special{color push cmyk 0.50 0 0 0}}%16
\def\colorseventeen{\special{color push cmyk 0 0 0.12 0.08}}%17
\def\coloreighteen{\special{color push cmyk 0 0.30 1.0 0.20}}%18
%
\def\magentahundred{\special{color push cmyk 0 1.0 0 0}}%
\def\cyanhundred{\special{color push cmyk 1.0 0 0 0}}%
\def\cyanten{\special{color push cmyk 0.10 0 0 0}}%
\def\colorfourtenp{\special{color push cmyk 0 0 0.10 0}}%4%
\def\coloreighteentenp{\special{color push cmyk 0 0.03 0.10 0.02}}%18
\def\coloreighteenfiftyp{\special{color push cmyk 0 0.15 0.50 0.10}}%18
\def\colorseventenp{\special{color push cmyk 0 0.1 0 0.04}}%7
\def\colorsevenfiftyp{\special{color push cmyk 0 0.8 0 0.30}}%7
\def\coloreleventenp{\special{color push cmyk 0.025 0 0.095 0.035}}%11
\def\colorninetenp{\special{color push cmyk 0.05 0 0.05 0.010}}%9
\def\singlepagelabel{\global\singlepagetrue}
%
\def\endmark{}
%
\def\spreadout#1{%
     \gdef\temp{#1}%
  \dimen0 = \spreadoutfactor pt
  \ifdim\dimen0=\z@\temp\else                            % If the spreadoutfactor
  \expandafter\dospreadout\temp\endmark\kern-\dimen0\fi} % is zero, then we can use kern or hskip
%                                                        % with the title etc. Suppressed the extra space
%                                                        % after spreadout.
\def\dospreadout{%
  \afterassignment\findospreadout
  \let\next= }
%
\def\findospreadout{%
   \ifx\next\endmark
      \let\nextaction = \relax
   \else
      \let\nextaction = \dospreadout
      \next
      \kern\dimen0
   \fi
   \nextaction}
%
%
\def\@xipt{11}
\def\@xvpt{15}
\def\@xviiipt{18}
\def\@xxivpt{24}
%
\normalbaselineskip12\p@
%
\renewcommand\normalsize{%
   \@setfontsize\normalsize{10}{13}
   \abovedisplayskip6\p@% plus1pt minus1pt
   \abovedisplayshortskip\abovedisplayskip
   \belowdisplayshortskip\abovedisplayskip
   \belowdisplayskip \abovedisplayskip
   \let\@listi\@listI}
\def\biggg#1{{\hbox{$\left#1\vbox to20.5\p@{}\right.\n@space$}}}
\def\Biggg#1{{\hbox{$\left#1\vbox to23.5\p@{}\right.\n@space$}}}
\normalsize
%
\newcommand\small{%
\@setfontsize\small\@ixpt{11}%
   \abovedisplayskip 8.5\p@ \@plus3\p@ \@minus4\p@
   \abovedisplayshortskip \z@ \@plus2\p@
   \belowdisplayshortskip 4\p@ \@plus2\p@ \@minus2\p@
   \def\@listi{\leftmargin\leftmargini
               \topsep 4\p@ \@plus2\p@ \@minus2\p@
               \parsep 2\p@ \@plus\p@ \@minus\p@
               \itemsep \parsep}%
   \belowdisplayskip \abovedisplayskip
   \setSmallDelims
   }
%
\def\setSmallDelims{%
\def\big##1{{\hbox{$\left##1\vbox to7.5\p@{}\right.\n@space$}}}%
\def\Big##1{{\hbox{$\left##1\vbox to10.5\p@{}\right.\n@space$}}}%
\def\bigg##1{{\hbox{$\left##1\vbox to13.5\p@{}\right.\n@space$}}}%
\def\Bigg##1{{\hbox{$\left##1\vbox to16.5\p@{}\right.\n@space$}}}%
\def\biggg##1{{\hbox{$\left##1\vbox to19.5\p@{}\right.\n@space$}}}%
\def\Biggg##1{{\hbox{$\left##1\vbox to22.5\p@{}\right.\n@space$}}}%
}
%
\newcommand\footnotesize{%
   \@setfontsize\footnotesize\@viiipt{9}%
   \abovedisplayskip 6\p@ \@plus2\p@ \@minus4\p@
   \abovedisplayshortskip \z@ \@plus\p@
   \belowdisplayshortskip 3\p@ \@plus\p@ \@minus2\p@
   \def\@listi{\leftmargin\leftmargini
               \topsep 3\p@ \@plus\p@ \@minus\p@
               \parsep 2\p@ \@plus\p@ \@minus\p@
               \itemsep \parsep}%
   \belowdisplayskip \abovedisplayskip
   \setFootnotesizeDelims}
%
\def\setFootnotesizeDelims{%
\def\big##1{{\hbox{$\left##1\vbox to6.5\p@{}\right.\n@space$}}}%
\def\Big##1{{\hbox{$\left##1\vbox to9.5\p@{}\right.\n@space$}}}%
\def\bigg##1{{\hbox{$\left##1\vbox to12.5\p@{}\right.\n@space$}}}%
\def\Bigg##1{{\hbox{$\left##1\vbox to15.5\p@{}\right.\n@space$}}}%
\def\biggg##1{{\hbox{$\left##1\vbox to18.5\p@{}\right.\n@space$}}}%
\def\Biggg##1{{\hbox{$\left##1\vbox to21.5\p@{}\right.\n@space$}}}%
}
%
\newcommand\scriptsize{\@setfontsize\scriptsize\@vipt\@viipt}
\newcommand\tiny{\@setfontsize\tiny\@vpt\@vipt}
\newcommand\large{\@setfontsize\large\@xiipt{14}}
\newcommand\Large{\@setfontsize\Large\@xivpt{18}}
\newcommand\LARGE{\@setfontsize\LARGE\@xviipt{22}}
\newcommand\huge{\@setfontsize\huge\@xxpt{25}}
\newcommand\Huge{\@setfontsize\Huge\@xxvpt{30}}
%
\DeclareOldFontCommand{\rm}{\normalfont\rmfamily}{\mathrm}
\DeclareOldFontCommand{\sf}{\normalfont\sffamily}{\mathsf}
\DeclareOldFontCommand{\tt}{\normalfont\ttfamily}{\mathtt}
\DeclareOldFontCommand{\bf}{\normalfont\bfseries}{\mathbf}
\DeclareOldFontCommand{\it}{\normalfont\itshape}{\mathit}
\DeclareOldFontCommand{\sl}{\normalfont\slshape}{\@nomath\sl}
\DeclareOldFontCommand{\sc}{\normalfont\scshape}{\@nomath\sc}
\DeclareOldFontCommand{\bi}{\bfseries\itshape}{\bfseries\itshape}
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Parameters %%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
\colmargin=0pc
\texttypewidthsep=0pc
%
\setlength\trimheight{702.7pt}%9.72in
\setlength\trimwidth{495pt}%6.85in
%
\setlength\normaltextheight{\textheight}%
\setlength\textwidth{359.8pt}%
\setlength\textheight{45\baselineskip}%

\setlength\typewidth{\textwidth}%
\setlength\typeheight{\textheight}%
%
\setlength\topmargin{35.7pt}%
\setlength\oddsidemargin{59.5pt}%
\setlength\evensidemargin{75pt}%
%
\setlength\headheight{12.5\p@}%
\setlength\headsep   {14.5pt}% \typeheight - \textheight - \headheight
\setlength\topskip   {10\p@}
%
\setlength\footskip{18.5pt}
\setlength\maxdepth{45\baselineskip}
%
%\blindfoliodrop\trimheight
%\advance\blindfoliodrop-\typeheight
%\advance\blindfoliodrop-\topmargin
%\advance\blindfoliodrop-\footskip
%\advance\blindfoliodrop18pt
%
\setlength\parindent{10pt}
%
\setlength\marginparwidth {.75in}
\setlength\marginparsep{6\p@}
\setlength\marginparpush{5\p@}
%
\setlength\footnotesep{\z@}
\setlength{\skip\footins}{12\p@ \@plus 3\p@ \@minus 3\p@}% \@plus 8\p@ \@minus 8\p@}% change + based on FN font height
\skip\@mpfootins = \skip\footins
%
\setlength\floatsep    {12\p@ \@plus 2\p@ \@minus 2\p@}
\setlength\textfloatsep{10\p@ \@plus 2\p@ \@minus 4\p@}
\setlength\intextsep   {12\p@ \@plus 2\p@ \@minus 2\p@}
\setlength\dblfloatsep    {12\p@ \@plus 2\p@ \@minus 2\p@}
\setlength\dbltextfloatsep{20\p@ \@plus 2\p@ \@minus 4\p@}
\setlength\@fptop{0\p@}
\setlength\@fpsep{8\p@ \@plus 1fil}
\setlength\@fpbot{0\p@ \@plus 1fil}
\setlength\@dblfptop{0\p@}
\setlength\@dblfpsep{8\p@ \@plus 1fil}
\setlength\@dblfpbot{0\p@ \@plus 1fil}
%
\setlength\partopsep{0pt}
\setlength\lineskip{1\p@}% check if it can be flexible
\setlength\normallineskip{1\p@}%
\renewcommand\baselinestretch{}
\setlength\parskip{\z@}%{0\p@ \@plus \p@}
\@lowpenalty   51
\@medpenalty  151
\@highpenalty 301
%
\@beginparpenalty -\@lowpenalty
\@endparpenalty   -\@lowpenalty
\@itempenalty     -\@lowpenalty
%
\trimwidthval\the\trimwidth
\trimheightval\the\trimheight

\trimwidthbleedval\trimwidthval
\advance\trimwidthbleedval.25in
\trimheightbleedval\trimheightval
\advance\trimheightbleedval.25in

\def\thepaperwidth{\the\trimwidthval}
\def\thepaperheight{\the\trimheightval}

\def\thebleedpaperwidth{\the\trimwidthbleedval}
\def\thebleedpaperheight{\the\trimheightbleedval}

\def\papwidth{\ifdbleed\thebleedpaperwidth\else\thepaperwidth\fi}

\def\papheight{\ifdbleed\thebleedpaperheight\else\thepaperheight\fi}

\ifx\ifxetex\ifluatex
\ifnum\pdfoutput=0
\AtBeginDvi{\special{papersize=\papwidth,\papheight}}
\else%
  \pdfpagewidth=\papwidth  \pdfpageheight=\papheight%
\fi%
\else
  \paperwidth=\papwidth  \paperheight=\papheight%
\fi
%
\newsavebox{\JFP@linecount@bx}
\newlength\JFP@linecount@bxht
\newcount\JFP@linecount
\JFP@linecount\@ne\relax

\def\JFP@mk@linecount{%
  \savebox{\JFP@linecount@bx}[4em][t]{\parbox[t]{4em}{%
      \normalsize%
      \setlength{\JFP@linecount@bxht}{0pt}%
      \loop{\color{black}\scriptsize\the\JFP@linecount}\\
      \global\advance\JFP@linecount by \@ne
      \addtolength{\JFP@linecount@bxht}{\baselineskip}%
      \ifdim\JFP@linecount@bxht<\textheight\repeat
      {\color{black}\scriptsize\the\JFP@linecount}\hfill
      \global\advance\JFP@linecount by \@ne}}}

\def\JFP@linecountL{\ifnolineno\else%
  \JFP@mk@linecount%\newsavebox{\JFP@linecount@bx}
  \begin{picture}(0,0)%\newlength\JFP@linecount@bxht
    \put(-35,-27){\usebox{\JFP@linecount@bx}}%\newcount\JFP@linecount
  \end{picture}\fi}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% End Parameters %%%%%%%%%%%%%%%%%%%%%%%%%
%
\def\mycolor#1{#1\special{color pop}}
%
\def\cyan{\special{color push cmyk 1.0 0 0 0}}
\def\magenta{\special{color push cmyk 0 1.0 0 0}}
%%
\def\grayten{\special{color push cmyk 0 0 0 .10}}
%
\def\@addmarginpar{\@next\@marbox\@currlist{\@cons\@freelist\@marbox
    \@cons\@freelist\@currbox}\@latexbug\@tempcnta\@ne
    \if@twocolumn
        \if@firstcolumn \@tempcnta\m@ne \fi
    \else
      \if@mparswitch
         \ifodd\c@page \else\@tempcnta\m@ne \fi
      \fi
      \if@reversemargin \@tempcnta -\@tempcnta \fi
    \fi
    \ifnum\@tempcnta <\z@  \global\setbox\@marbox\box\@currbox \fi
    \@tempdima\@mparbottom
    \advance\@tempdima -\@pageht
    \advance\@tempdima\ht\@marbox
    \ifdim\@tempdima >\z@
      \@latex@warning@no@line {Marginpar on page \thepage\space moved}%
    \else
      \@tempdima\z@
    \fi
    \global\@mparbottom\@pageht
    \global\advance\@mparbottom\@tempdima
    \global\advance\@mparbottom\dp\@marbox
    \global\advance\@mparbottom\marginparpush
    \advance\@tempdima -\ht\@marbox
    \global\setbox \@marbox
                   \vbox {\vskip \@tempdima
                          \box \@marbox}%
    \global \ht\@marbox \z@
    \global \dp\@marbox \z@
    \kern -\@pagedp
    \nointerlineskip
    \hb@xt@\columnwidth
      {\ifnum \@tempcnta >\z@
%          \hskip\columnwidth \hskip20pt\hskip\marginparsep
           \hskip\typewidth\hskip6pt
       \else
           \hskip -\marginparsep \hskip -\marginparwidth
           \hskip-\colmargin\hskip-\texttypewidthsep\hskip-6pt
       \fi
       \box\@marbox \hss}%
    \nointerlineskip
    \hbox{\vrule \@height\z@ \@width\z@ \@depth\@pagedp}}
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  Macro 2: TheoremLike Env. %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%
%\renewcommand\thetheorem{\thechapter.\arabic{theorem}}
%%
%\def\newtheorem#1{\@starthm{#1}\@ifnextchar[{\@othm{#1}}{\@nthm{#1}}}
%\def\@starthm#1{\@namedef{#1*}{\@beginstarthm{#1}}%
%\@namedef{end#1*}{\@endstarthm{#1}}}
%%
%\def\@starthm#1{\@namedef{#1*}{\@beginstarthm{#1}}%
%\@namedef{end#1*}{\@endstarthm}}
%%
%\def\@beginstarthm#1{\@ifnextchar[{\@opargbeginstarthm{#1}}{\@opargbeginstarthm{#1}[]}}
%%
%\def\@opargbeginstarthm#1[#2]{\list{}{\topsep12pt plus2pt
% \def\@tempaa{#2}%
%	\labelwidth0pt\labelsep9.5pt
%	\leftmargin0pt
%	\listparindent\parindent
% \edef\@Tempa{\csname #1name\endcsname}
%	\def\makelabel##1{##1.}}
%      \item[\hskip \labelsep{\csname#1headfont\endcsname \@Tempa{}\ifx\@tempaa\@empty\else\ (#2)\fi}]\csname#1font\endcsname}
%%
%\def\@endstarthm{\endlist}
%%
%\def\@xnthm#1#2[#3]{%
%  \expandafter\@ifdefinable\csname #1\endcsname
%    {\@definecounter{#1}\@newctr{#1}[#3]%
%     \expandafter\xdef\csname the#1\endcsname{%
%       \expandafter\noexpand\csname the#3\endcsname \@thmcountersep
%          \@thmcounter{#1}}%
%     \global\@namedef{#1}{\@thm{#1}{#2}{#1}}%
%     \global\@namedef{end#1}{\@endtheorem}}}
%\def\@ynthm#1#2{%
%  \expandafter\@ifdefinable\csname #1\endcsname
%    {\@definecounter{#1}%
%     \expandafter\xdef\csname the#1\endcsname{\@thmcounter{#1}}%
%     \global\@namedef{#1}{\@thm{#1}{#2}{#1}}%
%     \global\@namedef{end#1}{\@endtheorem}}}
%\def\@othm#1[#2]#3{%
%  \@ifundefined{c@#2}{\@nocounterr{#2}}%
%    {\expandafter\@ifdefinable\csname #1\endcsname
%    {\global\@namedef{the#1}{\@nameuse{the#2}}%
%  \global\@namedef{#1}{\@thm{#2}{#3}{#1}}%
%  \global\@namedef{end#1}{\@endtheorem}}}}
%\def\@thm#1#2#3{%
%  \refstepcounter{#1}%
%  \@ifnextchar[{\@ythm{#1}{#2}{#3}}{\@xthm{#1}{#2}{#3}}}
%%
%\def\@xthm#1#2#3{%
%  \@opargbegintheorem{#2}{\csname the#1\endcsname}{}{#3}\ignorespaces}
%\def\@ythm#1#2#3[#4]{%
%  \@opargbegintheorem{#2}{\csname the#1\endcsname}{#4}{#3}\ignorespaces}
%%
%\def\@endtheorem{\par\addvspace{12pt plus2pt}\endlist}%
%%
%\def\@opargbegintheorem#1#2#3#4{\par\addvspace{6pt plus2pt}%
%%   \renewcommand\labelenumi{{\itshape(\theenumi)}}%
%%   \def\labelenumii{{\upshape(\theenumii)}}%
%   \def\@tempa{#3}%
%   \noindent{\csname #4headfont\endcsname\ifx\@tempa\empty#1\ #2\hskip9.9pt\else#1\ #2\hskip4pt({\reset@font{\itshape\bfseries#3}})\hskip9.7pt\fi}%
%   \csname #4font\endcsname\ignorespaces}%
%%
%\def\@endtheorem{\par\addvspace{6pt plus2pt}}%
%%
%\def\examplename{Example}
%\newtheorem{example}{\examplename}%[chapter]
%\def\theexample{\thechapter.\arabic{example}}
%\def\examplefont{\itshape}
%\def\exampleheadfont{\bfseries}
%%
%\def\theoremname{Theorem}
%\newtheorem{theorem}{\theoremname}%[chapter]
%\def\thetheorem{\thechapter.\arabic{theorem}}
%\def\theoremfont{\itshape}
%\def\theoremheadfont{\bfseries}
%%
%\def\lemmaname{Proposition}
%\newtheorem{lemma}[theorem]{Proposition}
%%\newtheorem{lemma}{\lemmaname}[chapter]
%\def\thelemma{\thechapter.\arabic{lemma}}
%\def\lemmafont{\itshape}
%\def\lemmaheadfont{\bfseries}
%%
%\def\th@plain{%
%  \let\thm@indent\noindent % no indent
%  \thm@headfont{\bfseries}% heading font is bold
%  \thm@preskip0pt
%  \thm@postskip0pt}

\renewenvironment{proof}{\par\addvspace{6pt}\noindent\textbf{Proof}\hskip5.5pt}{\hfill$\blacksquare$\par\addvspace{6pt}}

\def\doitext{doi:}
\def\voltext{vol.}

\def\journaltitle#1{\gdef\journal@title{#1}}%

\def\jnlPage#1#2{\gdef\first@page{\thepage}\gdef\last@page{#2}}

\def\cpr#1{\gdef\@copyline{#1}}

\def\doival#1{\gdef\@doi{\doilink{#1}}}

\def\jnlDoiYr#1{\gdef\@cpyear{#1}}

\def\volno#1{\gdef\volume@no{#1}}

\def\isstext{No.}
\def\edtext{e}

\def\edno#1{\gdef\@edno{#1}}\edno{}%

\def\totalpg#1{\gdef\@totalpg{#1}}\totalpg{}%

%\def\ps@myplain{\spaceskip0pt\let\@mkboth\@gobbletwo%
%       \let\@evenfoot\@empty
%       \let\@oddfoot\@empty
%       \def\@evenhead{%
%            \hbox to 0pt{\vbox{\vspace*{4pt}%
%            {{\psplainfont {\itshape\ifx\jshorttitle\undefined\journal@title\else\jshorttitle\fi}\kern3pt(\cpyear), \textit{\voltext}\ \volume@no,\ \textit{pp.}\ \first@page\ifsinglepage\else--\last@page\fi.\quad {\copyright}\ \copyright@owner}\ \cpyear\hfill\thepage}\vskip2pt\vbox{\psplainfont     \doitext\ \@doi}}}}%
%       \def\@oddhead{%
%            \hbox to 0pt{\vbox{\vspace*{4pt}%
%            {\psplainfont {\itshape\ifx\jshorttitle\undefined\journal@title\else\jshorttitle\fi}\kern3pt(\cpyear), \textit{\voltext}\ \volume@no,\ \textit{pp.}\ \first@page\ifsinglepage\else--\last@page\fi.\quad {\copyright}\ \copyright@owner\ \cpyear\hfill\thepage}\vskip2pt\vbox{\psplainfont\doitext\ \@doi}}}}}

\def\ps@myplain{\let\@mkboth\@gobbletwo%
       \def\@evenfoot{}%
       \def\@oddfoot{}%
       \def\@evenhead{\JFP@linecountL%
            \hbox to 0pt{\vbox to 0pt{\vspace*{4.9pt}%
            {{\psplainfont\global\copoddheadtrue{\it\journal@title},\ \@totalpg\ pages,\ \@cpyear.\hspace{5.5pt}{{{\rhcopyright}\ \@copyline\ \@cpyear}}\hfill{\raisebox{-1.9pt}{\foliofont\thepage}}\par\vskip2.5pt{\vbox{\psplainfont\doitext\@doi}}}}\vss}\hss}}% %JG
       \def\@oddhead{\JFP@linecountL%
            \hbox to 0pt{\vbox to 0pt{\vspace*{4.9pt}%
            {{\psplainfont\global\copoddheadtrue{\it\journal@title}\if@issue\ {\bf\volume@no},\ {\edtext\@edno}\else\fi,\ \@totalpg\ pages,\ \@cpyear.\hspace{5.5pt}{{{\rhcopyright}\ \@copyline\ \@cpyear}}\hfill{\raisebox{-1.9pt}{\foliofont\thepage}}\par\vskip2.5pt{\vbox{\psplainfont\doitext\@doi}}}}\vss}\hss}}%JG
            }%


\def\OAtext{the terms of the Creative Commons Attribution licence (\href{http://creativecommons.org/licenses/by/4.0/}{http://creativecommons.org/licenses/by/4.0/}), which permits\newline
unrestricted re-use, distribution, and reproduction in any medium, provided the original work is properly cited.}

\def\ps@openaccess{\let\@mkboth\@gobbletwo%
       \def\@oddhead{%
            \hbox to 0pt{\vbox{\vspace*{4.9pt}%
            {{\psplainfont\global\copoddheadtrue{\it\journal@title}\if@issue\ {\bf\volume@no},\ {\edtext\@edno}\else\fi,\ \@totalpg\ pages,\ \@cpyear.\hspace{5.5pt}{{{\rhcopyright}\ \@copyline\ \@cpyear}}. This is an Open Access article, distributed under\hfill{\raisebox{-1.9pt}{\foliofont\thepage}}\par{\psplainfont\OAtext\@par}{\vbox{\psplainfont\doitext\@doi}}}}}}}
            \let\@evenfoot\@empty%
        \let\@oddfoot\@empty%
       \let\@evenhead\@oddhead}


\def\labelstyle#1{\reset@font\textrm{#1}}

\def\statementfont{\itshape}

\def\statementhead#1{\noindent\textsc{\@statelab}\reset@font\textrm{#1}}

\def\enunhead#1{\unskip%
    \global\advance\enunheadcount1%
    \expandafter\protected@xdef\csname enunhead\the\enunheadcount\endcsname{#1}}%
%
%\def\@begintheorem#1#2[#3]{%
%  \deferred@thm@head{\the\thm@headfont \thm@indent%
%    \@ifempty{#1}{\let\thmname\@gobble}{\let\thmname\@iden}%
%    \@ifempty{#2}{\let\thmnumber\@gobble}{\let\thmnumber\@iden}%
%    \@ifempty{#3}{\let\thmnote\@gobble}{\let\thmnote\@iden}%
%    \thm@swap\swappedhead\thmhead{#1}{}{#3}%
%    \thmheadnl\ignorespaces\unskip\enskip}%
%    \ignorespaces}
%
%\newtheorem{bfenun}{\csname enunhead\the\enuntempcount\endcsname}
%
%\def\thmdot{\global\@thmdottrue}
%\gdef\theoremdot{\global\@thmdottrue}
%\gdef\thmop{\if@thmdot .\else:\fi}
%
%\newtheoremstyle{mytheorem}% <name>
%  {0pt}% <Space above>
%  {0pt}% <Space below>
%  {}% <Body font>
%  {1em}% <Indent amount>
%  {\itshape}% <Theorem head font>
%  {}% <Punctuation after theorem head>
%  {.5em}% <Space after theorem heading>
%  {\thmname{#1}\thmnumber{\@ifnotempty{#1}{ }}%
%   \thmnote{ {\the\thm@notefont\textit{(#3)}}}}%
%
%\theoremstyle{mytheorem}
%\newtheorem{itenun}{\csname enunhead\the\enuntempcount\endcsname}

\def\alghead#1{\unskip%
    \global\advance\algheadcount1%
    \expandafter\protected@xdef\csname alghead\the\algheadcount\endcsname{#1}}%

\let\save@clearpage\clearpage
\let\save@outputpage\@outputpage

\def\store@outputpage{%
  \global\setbox\store@outputbox \vbox to \storedboxheight{%
      \leftline{\box\@outputbox}\vss}%
   \noindent%\fbox
   {\box\store@outputbox}%
   \par%\vrule width\textwidth height1pt
   \global\let\@outputpage\save@outputpage}
%
\def\balancepage{\@ifnextchar[{\balancecolpagebreak}{\balancecolpagebreak[0pt]}}
\def\balancecolpagebreak[#1]{\ifvmode\vadjust\fi{\vskip-\baselineskip%\vskip-12pt
\leftline{\vrule width\typewidth height\draftrule depth0pt}%
\expandafter\ifdim#1=0pt\vfill\else\vskip#1\fi}\pagebreak}
%
\def\balanceandcontinue{%
   \par
   \ifdim\pagegoal=\maxdimen
   \else
      \global\let\@outputpage\store@outputpage
      \ifdim\@colht=\pagegoal
         \global\storedboxheight\pagetotal
      \else
         \global\storedboxheight\@colht
         \global\advance\storedboxheight-\pagegoal
         \global\advance\storedboxheight\pagetotal
%         \global\advance\storedboxheight12pt
      \fi
   \fi
   \onecolumn
   \global\switchcolstrue}
%
\def\TwoColumn{\@ifnextchar[{\@TwoColumn}{\@TwoColumn[]}}
\def\@TwoColumn[#1]{%
   \balanceandcontinue
   \let\clearpage\relax
   \def\@tempa{#1}%
   \ifx\@tempa\@empty
      \twocolumn
   \else
      #1\global\@partialpageht\pagetotal\twocolumn
   \fi
   \let\clearpage\save@clearpage}
%
\def \TTwocolumn {%
  \clearpage
  \global\columnwidth\textwidth
  \global\advance\columnwidth-\columnsep
  \global\divide\columnwidth\tw@
  \global\hsize\columnwidth
  \global\linewidth\columnwidth
  \global\@twocolumntrue
  \global\@firstcolumntrue
  \col@number \tw@
  \@ifnextchar [\@topnewpage\@floatplacement}
%
\def\OOnecolumn{%
%  \clearpage
  \global\columnwidth\textwidth
  \global\hsize\columnwidth
  \global\linewidth\columnwidth
  \global\@twocolumnfalse
  \col@number \@ne
  \@floatplacement}
%
\def\twotoonecol#1{\TwoColumn[#1]}
%
\newcommand\abstractname{Abstract}

\newenvironment{abstract}{\@afterheading\@afterindentfalse%
   \global\setbox\abstractbox\vbox
   \bgroup%
   \ifnoabstract\else%{\affilfont\printaffil\@par\printmember\vskip64.5pt}%
   \vskip1.5pt\vbox{\hrule \@height .25pt \@width 30.05pc\vskip8.5pt
   {\abstractheadfont\abstractname\vskip9.5pt}}\fi
   \abstractfont\@afterheading\@afterindentfalse}
   {\ifnoabstract\else\par\vspace{17.5pt}\hrule \@height .25pt \@width 30.05pc\fi\egroup}
%
\def\abstractsource#1{%
    \vskip3pt\rightline{\upshape#1}}
%
\def\introhead#1{\section*{#1}}%
%
\def\subchapter#1{\gdef\@subchapter{#1}}
\subchapter{}%
%
\newcommand{\aunote}[1]{\unskip%
\ifx\printcorres\undefined\else\printcorres\fi%
\protect\footnotetext{\corresfont$\protect\linktarget{auddag}{\ddagger}$\,#1}%
\textsuperscript{\protect\linkref{au\auid}{\textrm{\auid}}\textrm{,}}$\protect\linkref{auddag}{\ddagger}$}

\def\authorand{\unskip\unskip\ignorespaces{}and\ }%

%\newif\ifsubtitle\global\subtitlefalse
%\newbox\subtbox
%\newcommand{\subtitle}[1]{\global\subtitletrue\global\setbox\subtbox\vbox{\subtitlefont#1\vskip21.3pt}
%\protected@write\@auxout{}{\gdef\string\subtcheck{}}}

\newbox\authbox
\newenvironment{authgrp}{\global\setbox\authbox\vbox\bgroup\authorfont}{\vskip11pt\egroup}

\newbox\affbox
\newenvironment{affgrp}{\global\setbox\affbox\vbox\bgroup\affilfont }{\vskip22pt\egroup}

\newcommand{\AUSP}[1]{\def\spreadoutfactor{1.3}\spreadout{#1}}

\def\sn#1{\AUSP{#1}\ }
\def\gn#1{\AUSP{#1}}
\def\aff#1{\protect\textsuperscript{#1}}

\newbox\hisbox

\newcommand{\history}[1]{\global\setbox\hisbox\vbox{\historyfont#1\vskip24.5pt}}

\def\rec#1{\textit{Received\ #1}}
\def\rev#1{\textit{revised\ #1}}
\def\acc#1{\textit{accepted\ #1}}

\def\author#1{\uppercase{#1}\ }

\newcommand{\affiliation}[1]{{\vskip3pt\affilfont#1\vskip8pt}}

%\def\titaltval{O}
%\renewcommand{\title}[2][]{\xdef\@titalt{#1}\ifx\@titalt\titaltval\global\titvaltrue\else\global\titvalfalse\fi\gdef\@title{#2}}

\newbox\keybox

\def\keyhead{\noindent Key Words:\ }

\newenvironment{keywords}
           {\global\setbox\keybox\vbox\bgroup\leftskip30pt
            {\keyheadfont\keyhead}\keyfont}
            {\@@par\egroup}

\newbox\jclassbox

\def\jclasshead{\noindent 2010 Mathematics Subject Classification:\ }

\newenvironment{jclass}
           {\global\setbox\jclassbox\vbox\bgroup\leftskip30pt\vskip8.5pt
            {\keyheadfont\jclasshead}\keyfont}
            {\@@par\egroup}


\def\corresp#1{\gdef\printcorresp{{\reset@font\corsymi\char121}\kern4pt#1}}

\newcommand\ls{\kern.15em\relax}
\newcommand\ns{\kern.55em\relax}

\newcommand\maketitle{\@ifnextchar [{\m@ketitleone}{\m@ketitleone[n]}}

%\newcommand{\maketitle}[1][]{\MakeTitle}

\def\m@ketitleone[#1]{\par\ifOA\thispagestyle{openaccess}\else\thispagestyle{myplain}\fi%%
  \begingroup%
  \parindent0pt%
    \renewcommand\thefootnote{\@fnsymbol\c@footnote}%
    \def\@makefnmark{\rlap{\@textsuperscript{\normalfont\@thefnmark}}}%
    %\long\def\@makefntext##1{##1}%
     \@maketitle{#1}%
  \renewcommand\thefootnote{}%
  \footnotetext{{\corresfont\ifx\printcorresp\undefined\else\printcorresp\fi}}%
 % \footnotetext{\centerline{\corresfont\vbox to -3.5pt{\printcorres}}}%
  \endgroup%
  \setcounter{footnote}{0}%
  \global\let\@maketitle\relax
  \global\let\maketitle\relax
\advance\keywordcount0%
\advance\authorcount0}

\def\pe@rl#1{\centering%
  \if t#1 {\tpe@rl}\else
    \if T#1 {\Tpe@rl}\else
      \if f#1 {\fpe@rl}\else
        \if F#1 {\Fpe@rl}\else
          \if e#1 {\edpe@rl}\else
            \if E#1 {\Edpe@rl}\else
              \if o#1 {\otherpearl}\else
              \fi
            \fi
          \fi
        \fi
      \fi
    \fi
  \fi}%

\def\spe@rl{\normalfont\LARGE\rmfamily}
\def\epe@rl#1{\par\vspace*{16\p@}\xdef\@shorttitle{#1}}

\def\tpe@rl{\spe@rl T\ls H\ls E\ls O\ls R\ls E\ls T\ls
  I\ls C\ls A\ls L\ns  P\ls E\ls A\ls R\ls L\ls S%
  \epe@rl{Theoretical pearls}%
}

\def\Tpe@rl{\spe@rl T\ls H\ls E\ls O\ls R\ls E\ls T\ls
  I\ls C\ls A\ls L\ns  P\ls E\ls A\ls R\ls L%
  \epe@rl{Theoretical pearl}%
}

\def\fpe@rl{\spe@rl F\ls U\ls N\ls C\ls T\ls I\ls O\ls
  N\ls A\ls L\ns  P\ls E\ls A\ls R\ls L\ls S%
  \epe@rl{Functional pearls}%
}

\def\Fpe@rl{\spe@rl F\ls U\ls N\ls C\ls T\ls I\ls O\ls
  N\ls A\ls L\ns  P\ls E\ls A\ls R\ls L%
  \epe@rl{Functional pearl}%
}

\def\edpe@rl{\spe@rl E\ls D\ls U\ls C\ls A\ls T\ls I\ls O\ls N\ls A\ls L\ns
  P\ls E\ls A\ls R\ls L\ls S%
  \epe@rl{Educational pearls}%
}

\def\Edpe@rl{\spe@rl E\ls D\ls U\ls C\ls A\ls T\ls I\ls O\ls N\ls A\ls L\ns
  P\ls E\ls A\ls R\ls L%
  \epe@rl{Educational pearl}%
}

\def\otherpearl{\spe@rl
  \@ifundefined{othrpearl}
    {Please define {\normalfont\ttfamily\char92 othrpearl} to obtain\\ the correct title!}
    {\othrpearl}%
  \epe@rl{Short title--please redefine with {\normalfont\ttfamily\char92 shorttitle}}%
}


\sodef\titleso{}{3pt}{9pt}{0pt}%

\def\@maketitle#1{\@@par\ifbookreview\vspace*{10.5pt}\else\ifOA\vspace*{32pt}\else\vspace*{15pt}\fi\fi%
\setbox\tempbox\vbox{%
\pe@rl{#1}%
\titlefont\@title%
\vphantom{y}\ifonline\pdfbookmark{\@title}{HLtitle}\else\fi\@@par%
\ifbookreview\vskip30pt\else\vskip17.5pt\fi%
%{\unvbox\subtbox}
{\unvbox\authbox}%
%{\unvbox\hisbox}%
{\unvbox\abstractbox}%
{\unvbox\keybox}%
{\unvbox\jclassbox}}%
\unvbox\tempbox%
\vskip25pt%
\@afterheading%
\@afterindentfalse%
\setcounter{section}{0}}

\headlineindent=2.5cc


%%%%%%%%%%%%%%%%%%%%% Copyright %%%%%%%%%%%%%%%%%%%%
%
\def\Copyright#1{\gdef\@Copyright{#1}}
\Copyright{}%
%
%%%%%%%%%%%%%%%%%%%% Chapter Head %%%%%%%%%%%%%%%%%%%%
%
\def\dummycharacter{\vphantom{ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz}}
%
\def\chapfig#1{\gdef\@chapfig{\epsfbox{#1}}}\chapfig{Chap-01.eps}
%
\def\ai#1{\gdef\@ai{$^{\text{#1}}$}}\ai{}
\def\aii#1{\gdef\@aii{$^{\text{#1}}$}}\aii{}
\def\aiii#1{\gdef\@aiii{$^{\text{#1}}$}}\aiii{}
\def\aiv#1{\gdef\@aiv{$^{\text{#1}}$}}\aiv{}
\def\av#1{\gdef\@av{$^{\text{#1}}$}}\av{}
\def\avi#1{\gdef\@avi{$^{\text{#1}}$}}\avi{}
\def\avii#1{\gdef\@avii{$^{\text{#1}}$}}\avii{}
\def\aviii#1{\gdef\@aviii{$^{\text{#1}}$}}\aviii{}
\def\aix#1{\gdef\@aix{$^{\text{#1}}$}}\aix{}
\def\ax#1{\gdef\@ax{$^{\text{#1}}$}}\ax{}
%
\newcommand\theaffilnote{\arabic{afrfilnote}}
%
\setcounter{secnumdepth}{5}
\renewcommand\thepart          {\Roman{part}}
\renewcommand\thechapter       {\arabic{chapter}}
\renewcommand\thesection       {\arabic{section}}
\renewcommand\thesubsection    {\thesection.\arabic{subsection}}
\renewcommand\thesubsubsection {\thesubsection .\arabic{subsubsection}}
\renewcommand\theparagraph     {\thesubsubsection.\arabic{paragraph}}
\renewcommand\thesubparagraph  {\theparagraph.\arabic{subparagraph}}
%
\setcounter{HLsection}{1}%%%%
\setcounter{HLsubsection}{1}%%%
\setcounter{HLsubsubsection}{1}%
\renewcommand\theHLsection{\ifnum\c@secnumdepth=0\else\theHLchapter.\arabic{HLsection}\fi}%%%%
\renewcommand\theHLsubsection{\ifnum\c@secnumdepth=0\else\theHLsection.\arabic{HLsubsection}\fi}%%%%
\renewcommand\theHLsubsubsection{\ifnum\c@secnumdepth=0\else\theHLsubsection.\arabic{HLsubsubsection}\fi}%%%%
%
\def\@seccntformat#1{\csname the#1\endcsname\hspace*{4pt}}
%
\def\subsubsectionsymfont{\fontfamily{\zpdefault}\fontsize{10}{12}\selectfont}
\def\subsubsectionsym{\ignorespaces\hspace*{4pt}{\subsubsectionsymfont\mycolor{\colorfive n}}}
%
\def\reviewsymfont{\fontfamily{\zpdefault}\fontsize{12}{12}\selectfont}
\def\reviewsym{\mycolor{\colorseven\raise.65pt\hbox to 0pt{\vrule height7pt width1pt\hspace*{.5pt}\vrule height7pt width2pt\hspace*{.5pt}\vrule height7pt width3pt\hspace*{.5pt}\vrule height7pt width6pt}\hspace*{12pt}\reviewsymfont\char'347\hspace*{12pt}}}
\def\probhrulefill{\mycolor{\colorseven\leavevmode\leaders\hrule height1pt\hfill\kern\z@}}
%
\def\acknoheadfont{\sectionfont}
%
\newcommand\section{\@startsection {section}{1}{\z@}{-26pt \@plus -2pt \@minus -.2pt}{6.7pt}{\sectionfont}}%
\newcommand\subsection{\@startsection{subsection}{2}{\z@}{-21.5pt}{6.7pt}{\subsectionfont}}%
\newcommand\subsubsection{\@startsection{subsubsection}{3}{\z@}{-12pt}{6.7pt}{\subsubsectionfont}}%
\newcommand\paragraph{\@startsection{paragraph}{4}{\z@}{-13pt}{-1.5pt}{\paragraphfont}}%
\newcommand\subparagraph{\@startsection{subparagraph}{5}{\parindent}{-19pt \@plus -2pt \@minus -.2pt}{-1em}{\subparagraphfont}}%
\newcommand\subsubparagraph{\@startsection{subsubparagraph}{6}{\parindent}{-19pt \@plus -2pt \@minus -.2pt}{-1em}{\subsubparagraphfont}}%
%
\newcommand\referencehead{\@startsection {paragraph}{4}{\z@}{-24pt \@plus -2pt \@minus -.2pt}{6pt}{\referenceheadfont}}%
\newcommand\acknohead{\@startsection {section}{1}{\z@}{-24pt \@plus -2pt \@minus -.2pt}{6pt}{\acknoheadfont}}%

\def\secdot{\hspace*{2pt}}

\def\@seccntformat#1{\csname the#1\endcsname\secdot\ }

\newif\ifsecindent\global\secindentfalse

\def\@sect#1#2#3#4#5#6[#7]#8{%
    \ifnum #2>\c@secnumdepth%
     \let\@svsec\@empty%
     \else%
     \refstepcounter{#1}%
     %\refstepcounter{HL#1}%
        \protected@edef\@svsec{\@seccntformat{#1}\relax}%
     \fi%
     \@tempskipa #5\relax
      \ifdim \@tempskipa>\z@
        \begingroup #6\relax
        \ifnum#2=1\global\secindenttrue%
              \@hangfrom{\hskip #3\relax\@svsec}% {\csname #1numfont\endcsname\@svsec}
                    {\interlinepenalty \@M #8\par}%
        \else
        \ifnum#2=2\centering%
              \@hangfrom{\hskip #3\relax\@svsec}% {\csname #1numfont\endcsname\@svsec}
                    {\interlinepenalty \@M #8\par}%
        \else
        \ifnum#2=3%
              \@hangfrom{\hskip #3\relax\@svsec}% {\csname #1numfont\endcsname\@svsec}
                    {\interlinepenalty \@M #8\par}%
        \else%
              \@hangfrom{\hskip #3\relax\@svsec}% {\csname #1numfont\endcsname\@svsec}
                    {\interlinepenalty \@M #8\par}%
        \fi\fi\fi
        \endgroup%
               \csname #1mark\endcsname{#7}\addcontentsline{toc}{#1}{\ifnum #2>\c@secnumdepth \else\protect\numberline{\csname the#1\endcsname}\fi#7}
        \else
        \def\@svsechd{#6\hskip #3\relax\@svsec #8.\kern3.5pt\csname #1mark\endcsname{#7}}
        \fi
               \@xsect{#5}}
%
\def\@ssect#1#2#3#4#5{%
  \@tempskipa #3\relax
  \ifdim \@tempskipa>\z@
    \begingroup
      #4{%
        \@hangfrom{\hskip #1}%
          \interlinepenalty \@M {#5}\@@par}%
    \endgroup
  \else
    \def\@svsechd{#4{\hskip #1\relax #5}}%
  \fi
  \@xsect{#3}}
%
\def\@startsection#1#2#3#4#5#6{%
  \if@noskipsec \leavevmode \fi
  \par
  \@tempskipa #4\relax
  \@afterindentfalse
  \ifdim \@tempskipa <\z@
    \@tempskipa -\@tempskipa
  \fi
  \if@nobreak
     \ifnum#2=2
     \vskip-1pt
     \fi
     \ifnum#2=3
     \vskip-1pt
     \fi
    \everypar{}%
  \else
    \addpenalty\@secpenalty\addvspace\@tempskipa
  \fi
  \@ifstar
    {\@ssect{#3}{#4}{#5}{#6}}%
    {\@dblarg{\@sect{#1}{#2}{#3}{#4}{#5}{#6}}}}
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  End Sectioning commands  %%%%%%%%%%%%%%%%
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  Lists %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
\topsepi12\p@ \@plus2\p@% \@minus.5\p@
\topsepii2pt% \@plus1\p@
\topsepiii2pt% \@plus1\p@
\topsepiv2pt% \@plus1\p@
\topsepv2pt% \@plus1\p@
\topsepvi2pt% \@plus1\p@
\topsepvii2pt% \@plus1\p@
\topsepviii2pt% \@plus1\p@
\topsepix2pt% \@plus1\p@
\topsepx2pt% \@plus1\p@
\itemsepi0pt
\itemsepii0pt
\itemsepiii0pt
\itemsepiv0pt
\itemsepv0pt
\itemsepvi0pt
\itemsepvii0pt
\itemsepviii0pt
\itemsepix0pt
\itemsepx0pt
%
\def\list#1#2{%
  \ifnum \@listdepth >10\relax
    \@toodeep
  \else
    \global\advance\@listdepth\@ne
  \fi
  \rightmargin\z@
  \listparindent\z@
  \itemindent\z@
  \csname @list\romannumeral\the\@listdepth\endcsname
  \def\@itemlabel{#1}%
  \let\makelabel\@mklab
  \@nmbrlistfalse
  #2\relax
  \@trivlist
  \parskip\parsep
  \parindent\listparindent
  \advance\linewidth -\rightmargin
  \advance\linewidth -\leftmargin
  \advance\@totalleftmargin \leftmargin
  \parshape \@ne \@totalleftmargin \linewidth
  \ignorespaces}
%
\def\@listI{\leftmargin\leftmargini
            \labelwidth\leftmargini
            \advance\labelwidth-\labelsep
            \parsep 0\p@%
            \topsep \topsepi
            \itemsep\itemsepi}%
\let\@listi\@listI
\@listi
\def\@listii {\leftmargin\leftmarginii
              \labelwidth\leftmarginii
              \advance\labelwidth-\labelsep
              \topsep\topsepii
              \parsep 0pt
              \itemsep\itemsepii}
\def\@listiii {\leftmargin\leftmarginiii
              \labelwidth\leftmarginiii
              \advance\labelwidth-\labelsep
              \topsep\topsepiii
              \parsep 0pt
              \itemsep\itemsepiii}
\def\@listiv {\leftmargin\leftmarginiv
              \labelwidth\leftmarginiv
              \advance\labelwidth-\labelsep}
\def\@listv  {\leftmargin\leftmarginv
              \labelwidth\leftmarginv
              \advance\labelwidth-\labelsep}
\def\@listvi {\leftmargin\leftmarginvi
              \labelwidth\leftmarginvi
              \advance\labelwidth-\labelsep}
\def\@listvii {\leftmargin\leftmarginvii
              \labelwidth\leftmarginvii
              \advance\labelwidth-\labelsep}
\def\@listviii {\leftmargin\leftmarginviii
              \labelwidth\leftmarginviii
              \advance\labelwidth-\labelsep}
\def\@listix {\leftmargin\leftmarginix
              \labelwidth\leftmarginix
              \advance\labelwidth-\labelsep}
\def\@listx {\leftmargin\leftmarginx
              \labelwidth\leftmarginx
              \advance\labelwidth-\labelsep}
%
\setlength\leftmargini  {2.5em}
\setlength\leftmarginii  {2.2em}
\setlength\leftmarginiii {1.87em}
\setlength\leftmarginiv  {1.7em}
\setlength\leftmarginv  {1em}
\setlength\leftmarginvi {1em}
\setlength\leftmarginvii {1em}
\setlength\leftmarginviii {1em}
\setlength\leftmarginix {1em}
\setlength\leftmarginx {1em}
\setlength\leftmargin    {\leftmargini}
%
\setlength  \labelsep  {\LabelSep}
\setlength  \labelwidth{\leftmargini}
\addtolength\labelwidth{-\labelsep}
%
\newcommand\theenumv{\Alph{enumv}}
\newcommand\theenumvi{\Alph{enumvi}}
\newcommand\theenumvii{\roman{enumvii}}
\newcommand\theenumviii{\Alph{enumviii}}
\newcommand\theenumix{\Alph{enumix}}
\newcommand\theenumx{\roman{enumx}}
\renewcommand\theenumi{\arabic{enumi}}
\renewcommand\theenumii{\alph{enumii}}
\renewcommand\theenumiii{\roman{enumiii}}
\renewcommand\theenumiv{\Alph{enumiv}}
\renewcommand\theenumv{\Alph{enumv}}
\renewcommand\theenumvi{\Alph{enumvi}}
\renewcommand\theenumvii{\Alph{enumvii}}
\renewcommand\theenumviii{\Alph{enumviii}}
\renewcommand\theenumix{\Alph{enumix}}
\renewcommand\theenumx{\Alph{enumx}}
\newcommand\labelenumi{\theenumi.}
\newcommand\labelenumii{\theenumii.}
\newcommand\labelenumiii{\theenumiii.}
\newcommand\labelenumiv{\theenumiv.}
\newcommand\labelenumv{\theenumv.}
\newcommand\labelenumvi{\theenumvi.}
\newcommand\labelenumvii{\theenumvii.}
\newcommand\labelenumviii{\theenumviii.}
\newcommand\labelenumix{\theenumix.}
\newcommand\labelenumx{\theenumx.}
\renewcommand\p@enumii{\theenumi}
\renewcommand\p@enumiii{\theenumi(\theenumii)}
\renewcommand\p@enumiv{\p@enumiii\theenumiii}
\font\lcir = lcircle10 at 12pt
\newcommand\bulls{\raise1.5pt\hbox{\lcir\char'162}}
\def\textbullet{\leavevmode\raise2pt\hbox{\hskip2pt\bulls}}
\def\textendash{{\bf--}}
\def\textasteriskcentered{\leavevmode\raise-1.5pt\hbox{*}}
\def\textperiodcentered{\leavevmode\raise1.5pt\hbox{\bulls}}
\newcommand\labelitemi{\textbullet}
\newcommand\labelitemii{\normalfont\bfseries \textendash}
\newcommand\labelitemiii{\textasteriskcentered}
\newcommand\labelitemiv{\textperiodcentered}
\newcommand\labelitemv{\textperiodcentered}
\newcommand\labelitemvi{\textbullet}
\newcommand\labelitemvii{\normalfont\bfseries \textendash}
\newcommand\labelitemviii{\textasteriskcentered}
\newcommand\labelitemix{\textperiodcentered}
\newcommand\labelitemx{\textperiodcentered}
%
\newenvironment{description}
               {\list{}{\labelwidth\z@ \itemindent-\leftmargin
                        \let\makelabel\descriptionlabel}}
               {\endlist}
\newcommand\descriptionlabel[1]{\hspace\labelsep
                                \normalfont\bfseries #1}
%
\newenvironment{verse}
               {\let\\=\@centercr
                \list{}{\itemsep      \z@
                        \itemindent   -1.5em%
                        \listparindent\itemindent
                        \rightmargin  \leftmargin
                        \advance\leftmargin 1.5em}%
                \item[]}
               {\endlist}
%
\newenvironment{OL}{\par\addvspace{9pt plus2pt}%

\def\listdevicefonti{\bf}
\def\listdevicefontii{\bf}
\def\listdevicefontiii{\bf}
\def\listdevicefontiv{\bf}
\def\listdevicefontv{\bf}
\def\listdevicefontvi{\bf}
\def\listdevicefontvii{\bf}
\def\listdevicefontviii{\bf}
\def\listdevicefontix{\bf}
\def\listdevicefontx{\bf}
\let\eqnarray\oleqnarray
%\let\[\eq

\mathindent\itemleftmargin
\renewcommand\labelenumv{(\theenumv)}
\renewcommand\labelenumvi{(\theenumvi)}
\renewcommand\labelenumvii{(\theenumvii)}
   \labelsepi3.8pt
   \labelsepii3.8pt
   \labelsepiii3.8pt
   \labelsepiv3.8pt
   \labelsepv3.8pt
   \labelsepvi3.8pt
   \labelsepvii3.8pt
   \abovelistskipi0pt%
   \belowlistskipi0pt%
   \abovelistskipii0pt%
   \belowlistskipii0pt%
   \abovelistskipiii0pt%
   \belowlistskipiii0pt%
   \abovelistskipiv0pt%
   \belowlistskipiv0pt%
   \abovelistskipv0pt%
   \belowlistskipv0pt%
   \abovelistskipvi0pt%
   \belowlistskipvi0pt%
   \abovelistskipvii0pt%
   \belowlistskipvii0pt%
   \abovelistskipviii0pt%
   \belowlistskipviii0pt%
   \abovelistskipix0pt%
   \belowlistskipix0pt%
   \abovelistskipx0pt%
   \belowlistskipx0pt%
}{
\par\addvspace{9pt plus2pt}}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  End Lists %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  Enumerate list %%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
\listtextleftmargin 0pt%24pt
\listtextleftmarginii0pt% 24pt
\listtextleftmarginiii0pt% 24pt
\listtextleftmarginiv0pt% 24pt
\listtextleftmarginv0pt% 24pt
\listtextleftmarginvi0pt% 24pt
\listtextleftmarginvii0pt% 24pt
\listtextleftmarginviii0pt% 24pt
\listtextleftmarginix0pt% 24pt
\listtextleftmarginx0pt% 24pt
\listtextrightmargin0pt%.5pc
\listlabelleftskip0pt%3.3pt
\listlabelleftskipii0pt%3.3pt
\listlabelleftskipiii0pt%3.3pt
\listlabelleftskipiv0pt%3.3pt
\listlabelleftskipv0pt%3.3pt
\listlabelleftskipvi0pt%3.3pt
\listlabelleftskipvii0pt%3.3pt
\listlabelleftskipviii0pt%3.3pt
\listlabelleftskipix0pt%3.3pt
\listlabelleftskipx0pt%3.3pt
\abovelistskipi0pt%
\belowlistskipi6pt%
\abovelistskipii0pt% plus2pt
\belowlistskipii0pt% plus2pt
\abovelistskipiii0pt% plus2pt
\belowlistskipiii0pt% plus2pt
\abovelistskipiv0pt% plus2pt
\belowlistskipiv0pt% plus2pt
\abovelistskipv0pt% plus2pt
\belowlistskipv0pt% plus2pt
\abovelistskipvi0pt% plus2pt
\belowlistskipvi0pt% plus2pt
\abovelistskipvii0pt% plus2pt
\belowlistskipvii0pt% plus2pt
\abovelistskipviii0pt% plus2pt
\belowlistskipviii0pt% plus2pt
\abovelistskipix0pt% plus2pt
\belowlistskipix0pt% plus2pt
\abovelistskipx0pt% plus2pt
\belowlistskipx0pt% plus2pt
\labelsepi5.4pt
\labelsepii5.2pt
\labelsepiii\z@
\labelsepiv\z@
\labelsepv\z@
\labelsepvi\z@
\labelsepvii\z@
\labelsepviii\z@
\labelsepix\z@
\labelsepx\z@
%
\def\listdevicefonti{}
\def\listdevicefontii{}
\def\listdevicefontiii{}
\def\listdevicefontiv{}
\def\listdevicefontv{}
\def\listdevicefontvi{}
\def\listdevicefontvii{}
\def\listdevicefontviii{}
\def\listdevicefontix{}
\def\listdevicefontx{}
\def\listfont{}
\def\textlistlabel{}
%
\@definecounter{enumv}
\@definecounter{enumvi}
\@definecounter{enumvii}
\@definecounter{enumviii}
\@definecounter{enumix}
\@definecounter{enumx}
%
\def\enummax#1{%
  \labelsep\csname labelsep\romannumeral\the\@enumdepth\endcsname
  \ifdim\listtextleftmargin>\z@\labelsepi0pt\fi
  \ifdim\listtextleftmarginii>\z@\labelsepii0pt\fi
  \ifdim\listtextleftmarginiii>\z@\labelsepiii0pt\fi
  \setbox\tempbox\hbox{\csname listdevicefont\romannumeral\the\@enumdepth\endcsname#1\hskip\labelsep}%
  \enumdim\wd\tempbox
  \setbox\tempbox\hbox{\csname listdevicefont\romannumeral\the\@enumdepth\endcsname#1}%
  \enumdimwd\wd\tempbox
  \expandafter\global\csname leftmargin\romannumeral\the\@enumdepth\endcsname\enumdim
  \ifdim\listtextleftmargin>\z@
     \leftmargini\listtextleftmargin
     \ifdim\listlabelleftskip>\z@
        \advance\leftmargini-\listlabelleftskip
     \fi
  \fi
  \ifdim\listtextleftmarginii>\z@
     \leftmarginii\listtextleftmarginii
     \ifdim\listlabelleftskipii>\z@
        \advance\leftmarginii-\listlabelleftskipii
     \fi
  \fi
  \ifdim\listtextleftmarginiii>\z@
     \leftmarginiii\listtextleftmarginiii
     \ifdim\listlabelleftskipiii>\z@
        \advance\leftmarginiii-\listlabelleftskipiii
     \fi
  \fi
  \ifdim\listtextleftmarginiv>\z@
     \leftmarginiv\listtextleftmarginiv
     \ifdim\listlabelleftskipiv>\z@
        \advance\leftmarginiv-\listlabelleftskipiv
     \fi
  \fi
  \ifdim\listtextleftmarginv>\z@
     \leftmarginv\listtextleftmarginv
     \ifdim\listlabelleftskipv>\z@
        \advance\leftmarginv-\listlabelleftskipv
     \fi
  \fi
  \ifdim\listtextleftmarginvi>\z@
     \leftmarginvi\listtextleftmarginvi
     \ifdim\listlabelleftskipvi>\z@
        \advance\leftmarginvi-\listlabelleftskipvi
     \fi
  \fi
  \ifdim\listtextleftmarginvii>\z@
     \leftmarginvii\listtextleftmarginvii
     \ifdim\listlabelleftskipvii>\z@
        \advance\leftmarginvii-\listlabelleftskipvii
     \fi
  \fi
  \ifdim\listtextleftmarginviii>\z@
     \leftmarginviii\listtextleftmarginviii
     \ifdim\listlabelleftskipviii>\z@
        \advance\leftmarginviii-\listlabelleftskipviii
     \fi
  \fi
  \ifdim\listtextleftmarginix>\z@
     \leftmarginix\listtextleftmarginix
     \ifdim\listlabelleftskipix>\z@
        \advance\leftmarginix-\listlabelleftskipix
     \fi
  \fi
  \ifdim\listtextleftmarginx>\z@
     \leftmarginx\listtextleftmarginx
     \ifdim\listlabelleftskipx>\z@
        \advance\leftmarginx-\listlabelleftskipx
     \fi
  \fi
  \ifdim\listlabelleftskip>\z@
     \advance\leftmargini\listlabelleftskip
  \fi
  \ifdim\listlabelleftskipii>\z@
     \advance\leftmarginii\listlabelleftskipii
  \fi
  \ifdim\listlabelleftskipiii>\z@
     \advance\leftmarginiii\listlabelleftskipiii
  \fi
  \ifdim\listlabelleftskipiv>\z@
     \advance\leftmarginiv\listlabelleftskipiv
  \fi
  \ifdim\listlabelleftskipv>\z@
     \advance\leftmarginv\listlabelleftskipv
  \fi
  \ifdim\listlabelleftskipvi>\z@
     \advance\leftmarginvi\listlabelleftskipvi
  \fi
  \ifdim\listlabelleftskipvii>\z@
     \advance\leftmarginvii\listlabelleftskipvii
  \fi
  \ifdim\listlabelleftskipviii>\z@
     \advance\leftmarginviii\listlabelleftskipviii
  \fi
  \ifdim\listlabelleftskipix>\z@
     \advance\leftmarginix\listlabelleftskipix
  \fi
  \ifdim\listlabelleftskipx>\z@
     \advance\leftmarginx\listlabelleftskipx
  \fi
  }
%
\enummax{1.}
%
\def\enumerate{\@ifnextchar[{\@enumerate}{\@enumerate[\csname label\@enumctr\endcsname]}}%%
%
\def\@enumerate[#1]{\par
      \ifnum \@enumdepth >10 \@toodeep
      \else
         \advance\@enumdepth\@ne
         \edef\@enumctr{enum\romannumeral\the\@enumdepth}%
         \setcounter{\@enumctr}{1}\enummax{#1}%
         \list
            {\csname label\@enumctr\endcsname}{\usecounter{\@enumctr}%
         \topsep6.5pt%\csname abovelistskip\romannumeral\the\@enumdepth\endcsname
         \itemsep\csname itemsep\romannumeral\the\@enumdepth\endcsname
         \listfont %\listparindent18.25pt
         \ifnum \@enumdepth=1
            \rightmargin\listtextrightmargin
            \advance\rightmargin\rightskip
            \advance\leftmargin\leftskip
           \advance\csname leftmargin\romannumeral\the\@itemdepth\endcsname\itemleftmargin
            \tempdimen\leftmargini
            \advance\tempdimen-\labelsep
           \iffnalpha
            \def\makelabel##1{{\hskip\listlabelleftskip{\csname listdevicefont\romannumeral\the\@enumdepth\endcsname{\iflabelrightalign\hss\fi\textlistlabel##1}}}}%
            \global\fnalphafalse
           \else
            \def\makelabel##1{\hbox to \tempdimen{\hskip\listlabelleftskip{\csname listdevicefont\romannumeral\the\@enumdepth\endcsname\hbox to \enumdimwd{\iflabelrightalign\hss\fi\textlistlabel##1}}}}%
           \fi
         \else
            \ifnum \@enumdepth=2
               \tempdimen\leftmarginii
               \advance\tempdimen-\labelsep
               \def\makelabel##1{\hbox to \tempdimen{\hskip\listlabelleftskipii{\csname listdevicefont\romannumeral\the\@enumdepth\endcsname\hbox to \enumdimwd{\iflabelrightalign\hss\fi##1}}}}%
            \else
               \ifnum \@enumdepth=3
                  \tempdimen\leftmarginiii
                  \advance\tempdimen-\labelsep
                  \def\makelabel##1{\hbox to \tempdimen{\hskip\listlabelleftskipiii{\csname listdevicefont\romannumeral\the\@enumdepth\endcsname\hbox to \enumdimwd{\iflabelrightalign\hss\fi##1}}}}%
              \else
                 \ifnum \@enumdepth=4
                    \tempdimen\leftmarginiv
                    \advance\tempdimen-\labelsep
                    \def\makelabel##1{\hbox to \tempdimen{\hskip\listlabelleftskipiv{\csname listdevicefont\romannumeral\the\@enumdepth\endcsname\hbox to \enumdimwd{\iflabelrightalign\hss\fi##1}}}}%
                 \else
                    \ifnum \@enumdepth=5
                       \tempdimen\leftmarginv
                       \advance\tempdimen-\labelsep
                       \def\makelabel##1{\hbox to \tempdimen{\hskip\listlabelleftskipv{\csname listdevicefont\romannumeral\the\@enumdepth\endcsname\hbox to \enumdimwd{\iflabelrightalign\hss\fi##1}}}}%
                    \else
                       \ifnum \@enumdepth=6
                          \tempdimen\leftmarginvi
                          \advance\tempdimen-\labelsep
                          \def\makelabel##1{\hbox to \tempdimen{\hskip\listlabelleftskipvi{\csname listdevicefont\romannumeral\the\@enumdepth\endcsname\hbox to \enumdimwd{\iflabelrightalign\hss\fi##1}}}}%
                       \else
                          \ifnum \@enumdepth=7
                             \tempdimen\leftmarginvii
                             \advance\tempdimen-\labelsep
                             \def\makelabel##1{\hbox to \tempdimen{\hskip\listlabelleftskipvii{\csname listdevicefont\romannumeral\the\@enumdepth\endcsname\hbox to \enumdimwd{\iflabelrightalign\hss\fi##1}}}}%
                          \else
                             \ifnum \@enumdepth=8
                                \tempdimen\leftmarginviii
                                \advance\tempdimen-\labelsep
                                \def\makelabel##1{\hbox to \tempdimen{\hskip\listlabelleftskipviii{\csname listdevicefont\romannumeral\the\@enumdepth\endcsname\hbox to \enumdimwd{\iflabelrightalign\hss\fi##1}}}}%
                             \else
                                 \ifnum \@enumdepth=9
                                    \tempdimen\leftmarginix
                                    \advance\tempdimen-\labelsep
                                    \def\makelabel##1{\hbox to \tempdimen{\hskip\listlabelleftskipix{\csname listdevicefont\romannumeral\the\@enumdepth\endcsname\hbox to \enumdimwd{\iflabelrightalign\hss\fi##1}}}}%
                                 \else
                                    \ifnum \@enumdepth=10
                                       \tempdimen\leftmarginx
                                       \advance\tempdimen-\labelsep
                                       \def\makelabel##1{\hbox to \tempdimen{\hskip\listlabelleftskipx{\csname listdevicefont\romannumeral\the\@enumdepth\endcsname\hbox to \enumdimwd{\iflabelrightalign\hss\fi##1}}}}%
                                    \else
                                       \def\makelabel##1{\hss\llap{\csname listdevicefont\romannumeral\the\@enumdepth\endcsname##1}}%
                                    \fi
                                 \fi
                             \fi
                          \fi
                       \fi
                    \fi
                 \fi
              \fi
            \fi
         \fi}
      \fi}
%
\def\endenumerate{\@topsepadd\csname belowlistskip\romannumeral\the\@enumdepth\endcsname\endlist}%
%
\newenvironment{arabiclist}{%
\abovelistskipi6\p@ plus2pt
\belowlistskipi6\p@ plus2pt
\labelsepi5pt
\def\theenumi{\arabic{enumi}}
\def\theenumii{\arabic{enumii}}%
\def\theenumiii{\arabic{enumiii}}%
\def\theenumiv{\arabic{enumiv}}%
\def\theenumv{\arabic{enumv}}%
\def\theenumvi{\arabic{enumvi}}%
\def\theenumvii{\arabic{enumvii}}%
\def\theenumviii{\arabic{enumviii}}%
\def\theenumix{\arabic{enumix}}%
\def\theenumx{\arabic{enumx}}%
\renewcommand\labelenumi{\theenumi.}
\renewcommand\labelenumii{\theenumii.}
\renewcommand\labelenumiii{\theenumiii.}
  \begin{enumerate}}
  {\end{enumerate}}
%
\def\bullsymfont{\fontfamily{\zpdefault}\fontsize{10}{12}\selectfont}
\def\bullsym{\raise-0.02pt\hbox{\bullsymfont\mycolor{\colorthree o}}}
%
\newenvironment{bulletlist}{%
\labelsepi6pt
\def\theenumi{\arabic{enumi}}
  \def\theenumii{\alph{enumii}}%
  \def\theenumiii{\arabic{enumiii}}%
  \def\theenumiv{\arabic{enumiv}}%
  \def\theenumv{\alph{enumv}}%
  \def\theenumvi{\arabic{enumvi}}%
  \def\theenumvii{\arabic{enumvii}}%
  \def\theenumviii{\alph{enumviii}}%
  \def\theenumix{\arabic{enumix}}%
  \def\theenumx{\arabic{enumx}}%
  \renewcommand\labelenumi{\textbullet}
  \renewcommand\labelenumii{\textbullet}
  \renewcommand\labelenumiii{\textbullet}
  \begin{enumerate}\leftskip18pt}
  {\end{enumerate}}
%
\def\learnsymfont{\fontfamily{ams}\fontsize{10}{12}\selectfont}
\def\learnsym{{\learnsymfont\mycolor{\colorseven I}}}
%
\newenvironment{learnbulletlist}{\par\raggedright%
\hsize\colmargin\linewidth\colmargin
\labelsepi5pt
\def\theenumi{\arabic{enumi}}
  \def\theenumii{\alph{enumii}}%
  \def\theenumiii{\arabic{enumiii}}%
  \def\theenumiv{\arabic{enumiv}}%
  \def\theenumv{\alph{enumv}}%
  \def\theenumvi{\arabic{enumvi}}%
  \def\theenumvii{\arabic{enumvii}}%
  \def\theenumviii{\alph{enumviii}}%
  \def\theenumix{\arabic{enumix}}%
  \def\theenumx{\arabic{enumx}}%
  \renewcommand\labelenumi{\learnsym}
  \renewcommand\labelenumii{\learnsym}
  \renewcommand\labelenumiii{\learnsym}
  \begin{enumerate}}
  {\end{enumerate}}
%
\newenvironment{wherelist}{%
  \def\listdevicefonti{\upshape}
  \listtextleftmargin 0pt
  \abovelistskipi13\p@ plus2pt
  \belowlistskipi13\p@ plus2pt
  \begin{enumerate}}
  {\end{enumerate}}
  %
\newenvironment{romanlist}{%
  \def\theenumi{\roman{enumi}}\def\theenumii{\roman{enumii}}%
  \def\theenumiii{\roman{enumiii}}\def\theenumiv{\roman{enumiv}}%
  \def\theenumv{\roman{enumv}}\def\theenumvi{\roman{enumvi}}%
  \def\theenumvii{\roman{enumvii}}\def\theenumviii{\roman{enumviii}}%
  \def\theenumix{\roman{enumix}}\def\theenumx{\roman{enumx}}%
  \begin{enumerate}\leftskip8pt}
  {\end{enumerate}}
%
\newenvironment{alphalist}{%
\itemsepi0pt
\labelsepi5pt
\labelsepii5pt
\labelsepiii5pt
%\labelrightalignfalse
  \def\theenumi{\alph{enumi}}\def\theenumii{\alph{enumii}}%
  \def\theenumiii{\alph{enumiii}}\def\theenumiv{\alph{enumiv}}%
  \def\theenumv{\roman{enumv}}\def\theenumvi{\roman{enumvi}}%
  \def\theenumvii{\roman{enumvii}}\def\theenumviii{\roman{enumviii}}%
  \def\theenumix{\roman{enumix}}\def\theenumx{\roman{enumx}}%
  \renewcommand\labelenumi{\theenumi.}
  \renewcommand\labelenumii{\theenumii.}
  \renewcommand\labelenumiii{\theenumiii.}
  \begin{enumerate}\leftskip8pt}
  {\end{enumerate}}

%
\newenvironment{fnalphalist}{%
\abovelistskipi0pt plus2pt
\belowlistskipi0pt plus2pt
\itemsepi-2pt
\labelsepi3.6pt
\global\fnalphatrue
\listlabelleftskip\fskip
  \def\theenumi{\alph{enumi}}\def\theenumii{\alph{enumii}}%
  \def\theenumiii{\alph{enumiii}}\def\theenumiv{\alph{enumiv}}%
  \def\theenumv{\roman{enumv}}\def\theenumvi{\roman{enumvi}}%
  \def\theenumvii{\roman{enumvii}}\def\theenumviii{\roman{enumviii}}%
  \def\theenumix{\roman{enumix}}\def\theenumx{\roman{enumx}}%
  \renewcommand\labelenumi{(\theenumi)}
  \begin{enumerate}}
  {\end{enumerate}}
%
\newenvironment{Romanlist}{%
  \def\theenumi{\Roman{enumi}}\def\theenumii{\Roman{enumii}}%
  \def\theenumiii{\Roman{enumiii}}\def\theenumiv{\Roman{enumiv}}%
  \def\theenumv{\roman{enumv}}\def\theenumvi{\roman{enumvi}}%
  \def\theenumvii{\roman{enumvii}}\def\theenumviii{\roman{enumviii}}%
  \def\theenumix{\roman{enumix}}\def\theenumx{\roman{enumx}}%
  \begin{enumerate}}
  {\end{enumerate}}

\newenvironment{Alphalist}{%
  \def\theenumi{\Alph{enumi}}\def\theenumii{\Alph{enumii}}%
  \def\theenumiii{\Alph{enumiii}}\def\theenumiv{\Alph{enumiv}}%
  \def\theenumv{\roman{enumv}}\def\theenumvi{\roman{enumvi}}%
  \def\theenumvii{\roman{enumvii}}\def\theenumviii{\roman{enumviii}}%
  \def\theenumix{\roman{enumix}}\def\theenumx{\roman{enumx}}%
  \begin{enumerate}\leftskip8pt}
  {\end{enumerate}}
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  unnumlist %%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
\unnumlistitemindent=-18pt
%
\def\@item[#1]{%
  \if@noparitem
    \@donoparitem
  \else
    \if@inlabel
      \indent \par
    \fi
    \ifhmode
      \unskip\unskip \par
    \fi
    \if@newlist
      \if@nobreak
        \@nbitem
      \else
        \addpenalty\@beginparpenalty
        \addvspace\@topsep
        \addvspace{-\parskip}%
      \fi
    \else
      \addpenalty\@itempenalty
      \addvspace\itemsep
    \fi
    \global\@inlabeltrue
  \fi
  \everypar{%
    \@minipagefalse
    \global\@newlistfalse
    \if@inlabel
      \global\@inlabelfalse
      {\setbox\z@\lastbox
       \ifvoid\z@
         \kern-\itemindent
       \fi}%
      \ifunnumlistitem\hspace*{\unnumlistitemindent}\fi\box\@labels
      \penalty\z@
    \fi
    \if@nobreak
      \@nobreakfalse
      \clubpenalty \@M
    \else
      \clubpenalty \@clubpenalty
      \everypar{}%
    \fi}%
  \if@noitemarg
    \@noitemargfalse
    \if@nmbrlist
      \refstepcounter\@listctr
    \fi
  \fi
  \sbox\@tempboxa{\makelabel{#1}}%
  \global\setbox\@labels\hbox{%
    \unhbox\@labels
    \hskip \itemindent
    \hskip -\labelwidth
    \hskip -\labelsep
    \ifdim \wd\@tempboxa >\labelwidth
      \box\@tempboxa
    \else
      \hbox to\labelwidth {\unhbox\@tempboxa}%
    \fi
    \hskip \labelsep}%
  \ignorespaces}
%
\unnumlisttextskip=18pt
\newenvironment{unnumlist}{%
\unnumlistitemtrue
\listtextleftmargin\unnumlisttextskip
\listtextleftmarginii\unnumlisttextskip
\listtextleftmarginiii\unnumlisttextskip
\listtextleftmarginiv\unnumlisttextskip
\listtextleftmarginv\unnumlisttextskip
\listtextleftmarginvi\unnumlisttextskip
\listtextleftmarginvii\unnumlisttextskip
\listtextleftmarginviii\unnumlisttextskip
\listtextleftmarginix\unnumlisttextskip
\listtextleftmarginx\unnumlisttextskip
\labelsepi0pt
\labelsepii0pt
\labelsepiii0pt
\labelsepiv0pt
\labelsepv0pt
\labelsepvi0pt
\labelsepvii0pt
\labelsepviii0pt
\labelsepix0pt
\labelsepx0pt
\def\theenumi{\arabic{enumi}}
  \def\theenumii{\alph{enumii}}%
  \def\theenumiii{\arabic{enumiii}}%
  \def\theenumiv{\arabic{enumiv}}%
  \def\theenumv{\alph{enumv}}%
  \def\theenumvi{\arabic{enumvi}}%
  \def\theenumvii{\arabic{enumvii}}%
  \def\theenumviii{\alph{enumviii}}%
  \def\theenumix{\arabic{enumix}}%
  \def\theenumx{\arabic{enumx}}%
  \renewcommand\labelenumi{}
  \renewcommand\labelenumii{}
  \renewcommand\labelenumiii{}
  \renewcommand\labelenumiv{}
  \renewcommand\labelenumv{}
  \renewcommand\labelenumvi{}
  \renewcommand\labelenumvii{}
  \renewcommand\labelenumviii{}
  \renewcommand\labelenumix{}
  \renewcommand\labelenumx{}
  \begin{enumerate}}
  {\end{enumerate}
  \global\unnumlistitemfalse}
%
\def\webadd#1{\par\addvspace{3pt}{\fontfamily{Courier}\fontsize{9}{12}\selectfont\hskip18pt#1}}
%
\itemleftmargin15.5\p@ % won't be active in enumerate
\itemlabelsep6\p@ % labelsep in itemize for all levels

\def\itemize{%
  \ifnum \@itemdepth >3 \@toodeep\else\ifnum\@enumdepth>0\@itemdepth\@enumdepth\fi \advance\@itemdepth \@ne
     \edef\@itemitem{labelitem\romannumeral\the\@itemdepth}%
     \list{\csname\@itemitem\endcsname}%
        {%
        \topsep8pt%\csname abovelistskip\romannumeral\the\@itemdepth\endcsname%\fi
        \itemsep\csname itemsep\romannumeral\the\@itemdepth\endcsname
        \labelsep\itemlabelsep
        \listfont
        \setbox\tempbox\hbox{\csname\@itemitem\endcsname}
        \csname leftmargin\romannumeral\the\@itemdepth\endcsname\wd\tempbox
        \advance\csname leftmargin\romannumeral\the\@itemdepth\endcsname\itemlabelsep
        \ifnum\@itemdepth=\@ne\ifnum\@enumdepth=0 % if not inside an enumerate
           \rightmargin\listtextrightmargin
           \advance\rightmargin\rightskip
           \advance\csname leftmargin\romannumeral\the\@itemdepth\endcsname\itemleftmargin
           \advance\leftmargini\leftskip
        \else
        \advance\csname leftmargin\romannumeral\the\@itemdepth\endcsname\itemleftmargin
           \advance\leftmarginii\leftskip
        \fi\fi
        \leftmargin\csname leftmargin\romannumeral\the\@itemdepth\endcsname
        \def\makelabel##1{\hss\llap{##1}}}
   \fi}%
%
\def\enditemize{%
\@topsepadd\csname belowlistskip\romannumeral\the\@itemdepth\endcsname%\fi
\endlist}
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%% enumroman (i) %%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
\newenvironment{xbllist}{%
   \abovelistskipii9pt plus2pt%
   \belowlistskipii9pt plus2pt%
   \itemlabelsep12.5\p@%
   \itemsepi0pt
   \def\listfont{}
   \renewcommand\labelitemi{\textbullet}%
   \renewcommand\labelitemii{\textbullet}%
   \renewcommand\labelitemiii{\textbullet}%
   \renewcommand\labelitemiv{\textbullet}%
   \begin{itemize}}
   {\end{itemize}}

\newenvironment{hyphenlist}{%
   \renewcommand\labelitemi{\normalfont\bfseries \textendash}%
   \renewcommand\labelitemii{\normalfont\bfseries \textendash}%
   \renewcommand\labelitemiii{\normalfont\bfseries \textendash}%
   \renewcommand\labelitemiv{\normalfont\bfseries \textendash}%
   \begin{itemize}}
   {\end{itemize}}
%
\newenvironment{asterisklist}{%
   \renewcommand\labelitemi{\textasteriskcentered}%
   \renewcommand\labelitemii{\textasteriskcentered}%
   \renewcommand\labelitemiii{\textasteriskcentered}%
   \renewcommand\labelitemiv{\textasteriskcentered}%
   \begin{itemize}}
   {\end{itemize}}
%
\newenvironment{caselist}{%
   \def\textlistlabel{Case\ }%
   \begin{enumerate}}
   {\end{enumerate}}
%
\newenvironment{steplist}{%
   \def\textlistlabel{Step\ }%
   \begin{enumerate}}
   {\end{enumerate}}
%
\newenvironment{labellist}{%
   \begin{description}}
   {\end{description}}
%
\def\setitemindent#1{\settowidth{\labelwidth}{#1}%
        \let\setit@m=Y%
        \leftmargini\labelwidth
        \advance\leftmargini\labelsep
   \def\@listi{\leftmargin\leftmargini
        \labelwidth\leftmargini\advance\labelwidth by -\labelsep
        \parsep=\parskip
        \topsep=\medskipamount
        \itemsep=\parskip \advance\itemsep by -\parsep}}
\def\setitemitemindent#1{\settowidth{\labelwidth}{#1}%
        \let\setit@m=Y%
        \leftmarginii\labelwidth
        \advance\leftmarginii\labelsep
\def\@listii{\leftmargin\leftmarginii
        \labelwidth\leftmarginii\advance\labelwidth by -\labelsep
        \parsep=\parskip
        \topsep=6\p@
        \itemsep=\parskip \advance\itemsep by -\parsep}}

\def\description{\@ifnextchar[{\@describe}{\list{}{\labelwidth\z@
\let\makelabel\descriptionlabel}}}

\def\describelabel#1{#1\hfil}
\def\@describe[#1]{
\def\@mklab##1{##1\hfill}
\labelsep=12pt
\ifnum\@listdepth=0
\setitemindent{#1}
\else
\ifnum
\@listdepth=1
\setitemitemindent{#1}
\fi\fi
\list{}{\let\makelabel\describelabel}}
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%% npara %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
\def\NPARfont{}
\newenvironment{npara}{\par%\addvspace{9pt plus2pt}%
   \NPARfont
%   \hsize\textwidth%27pc
   \setcounter{ncount}{0}%
   \def\item{\par\addtocounter{ncount}{1}\arabic{ncount}.\hskip2.6pt\ignorespaces}}
   {\par}%\addvspace{9pt plus2pt}\@endparenv}%
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%% splist %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
\def\marginfont{\fontsize{9}{10}\selectfont\bfseries\raggedright}
\newcommand{\comment}[1]{%
 \setlength\overfullrule{0pt}%
 \ifodd\c@page
    \marginpar{%
    \parbox{8pc}{\par\vskip-1.5pt\marginfont please check.\par}}%
    \fboxsep.1pt\fbox{#1}%
 \else
    \marginpar{%
    \parbox{8pc}{\par\vskip-1.5pt\marginfont please check.\par}}
    \fboxsep.1pt\fbox{#1}\fi}
%
\setlength{\intextsep}{20\p@ \@plus 2\p@ \@minus 2\p@}
%
\setcounter{topnumber}{5}
\renewcommand\topfraction{.9}
\setcounter{bottomnumber}{5}
\renewcommand\bottomfraction{.9}
\setcounter{totalnumber}{5}
\renewcommand\textfraction{.09}
\renewcommand\floatpagefraction{.901}
\setcounter{dbltopnumber}{1}
\renewcommand\dbltopfraction{.9}
\renewcommand\dblfloatpagefraction{.901}
%
\setlength\abovecaptionskip{4\p@}
\setlength\belowcaptionskip{\z@}
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  Figures %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
\def\figcaptiondesc#1{\gdef\@figcaptiondesc{#1}}
\figcaptiondesc{}
%
\renewcommand\thefigure{\@arabic\c@figure}
\def\fps@figure{tbp}
\def\ftype@figure{1}
\def\ext@figure{lof}

\def\figurehead#1{\gdef\@figurehead{#1}}\figurehead{}
\def\fnum@figure{Fig. \thefigure}
\newenvironment{figure}
               {\global\figureshowtrue\@float{figure}}
               {\end@float%
               \global\figureshowfalse%
               \global\webcolorfalse%
               \global\sidefigurefalse%
               \global\rightsidefigurefalse}

\def\@float#1{%
  \@ifnextchar[%
    {\@xfloat{#1}}%
    {\edef\reserved@a{\noexpand\@xfloat{#1}[\csname fps@#1\endcsname]}%
     \reserved@a}}
\newenvironment{figure*}
               {\@dblfloat{figure}}
               {\end@dblfloat}
%
\newenvironment{Figure}
               {\par\addvspace{12pt plus2pt}\def\@captype{figure}}
               {\par\addvspace{12pt plus2pt}}
%
\newenvironment{Figure*}
               {\par\addvspace{12pt plus2pt}\def\@captype{figure}}
               {\par\addvspace{12pt plus2pt}}

%
\def\figlabelfont{\fontsize{10}{12}\selectfont}
\def\figlabel#1{\gdef\@figlabel{#1}}
\figlabel{}
%
\figcaptionleftskip0pt
\figcaptionrightskip0pt
\figindent0pt
\figwidthcapdimen12pt
\figleftskip0pt
\figrightskip0pt
\adjustskip0pt
%
\def\figpunct{.}

\providecommand\centerfirst{%
  \let\\\@centercr
  \edef\caption@normaladjust{%
    \leftskip\the\leftskip
    \rightskip\the\rightskip
    \parfillskip\the\parfillskip\relax}%
  \leftskip\z@\@plus -1fil%
  \rightskip\z@\@plus 1fil%
  \parfillskip\z@skip
  \noindent\hskip\z@\@plus 2fil%
  \@setpar{\@@par\@restorepar\caption@normaladjust}}
\providecommand\centerlast{%
  \let\\\@centercr
  \leftskip\z@\@plus 1fil%
  \rightskip\z@\@plus -1fil%
  \parfillskip\z@\@plus 1.96fil\relax}


\def\@makefigurecaption#1#2{\figcaptionfont%
\global\setbox\figcapbox\hbox{{{\figcaptionnumfont#1\figpunct\hskip\fignumcapsep}\hskip\figcapdescsep#2\par}}
\ifdim\wd\figcapbox>\hsize
{{\figcaptionnumfont#1\figpunct\hskip\fignumcapsep}\hskip\figcapdescsep#2\par}%
\else
\hfil{{\figcaptionnumfont#1\figpunct\hskip\fignumcapsep}\hskip\figcapdescsep#2\par}\hfil%
\fi}

\def\ArtPiece#1{\epsfbox{#1}}%
%
\def\figurebox#1#2#3{%
    \@ifnextchar[{\@figurebox{#1}{#2}{#3}}{\@figurebox{#1}{#2}{#3}[]}}
%
\def\@figurebox#1#2#3[#4]{%
      \gdef\CO{CO}
      \gdef\FP{FP}
      \gdef\@thirdarg{#3}%
      \gdef\@frtharg{#4}%
      \ifx\@frtharg\empty
         \global\figheight=#1
         \global\figwidth=#2
         \ifx\@thirdarg\empty \FPfalse\COfalse\fi
      \else
%%% for CO and FPO figure conditions
         \ifx\@thirdarg\empty \FPfalse\COfalse
         \else
           \ifx\@thirdarg\FP \FPtrue
           \else
             \ifx\@thirdarg\CO \COtrue
             \else
             \fi
           \fi
         \fi
%%%
%         \setbox\figtempbox=\hbox{\epsfbox{\ArtDir \ifCO #3-\else\ifFP#3-\fi\fi#4}}%
         \setbox\figtempbox=\hbox{\includegraphics{#4}}%
         \global\figwidth=\wd\figtempbox
         \global\figheight=\ht\figtempbox
       \fi
    \ifsidewaysfigure
          \figrightskip0pt plus1fill\figleftskip0pt plus1fill%%%centering figure
          \vbox to 0pt{\rightskip\figrightskip\leftskip\figleftskip{\figbox}}
    \else
       \ifsidefigure
         \ifrightsidefigure
            \figleftskip0pt plus1fill
            \vbox to 0pt{\rightskip\figrightskip\leftskip\figleftskip{\figbox}}
         \else
            \vbox to 0pt{\rightskip\figrightskip\leftskip\figleftskip{\figbox}}
         \fi
       \else
         \ifdim\figwidth > \textwidth
           \ifrightsidefigure
              \vbox to 0pt{\centerline{\figbox}}%%\figleftskip or \figrightskip is for figurebox movement%%
           \else
              \vbox to 0pt{\centerline{\figbox}}%%\figleftskip or \figrightskip is for figurebox movement%%
           \fi
         \else
            \vbox to 0pt{\centerline{\figbox}}%%\figleftskip or \figrightskip is for figurebox movement%%
         \fi
       \fi
   \fi
%    \vbox to 0pt{\centerline{\figbox}}%
%%% for marginal note
     \vskip-\baselineskip
     \ifodd\c@page
       \vtop to \figheight{\vfill\llap{\marginfont\ifFP 4-Color Artwork
                                                  \else\ifCO 4-Color Artwork
                                                  \else\fi\fi\hskip0.5pc}\vfill}%
     \else
       \vtop to \figheight{\vfill\llap{\marginfont\ifFP 4-Color Artwork
                                                  \else\ifCO 4-Color Artwork
                                                  \else\fi\fi\hskip0.5pc}\vfill}%
     \fi
%%%
}%
%%%%
\def\fpofigbox#1{\FPtrue\def\@fpo{#1}}
%
\def\whiteink{\special{color push cmyk 0 0 0 0.0}}
\def\blackink{\special{color push cmyk 0 0 0 1.0}}
%
\def\@startpbox#1{\vtop\bgroup \setlength\hsize{#1}\@arrayparboxrestore}
\def\@endpbox{\@finalstrut\@arstrutbox\par\vspace*{-\baselineskip}\egroup\hfil}
\let\@@startpbox=\@startpbox
\let\@@endpbox=\@endpbox
%
\def\figbox{%
     \ifx\@frtharg\empty%
       \noindent\vbox{\mycolor{\grayten\hsize\figwidth%
	      \hrule height\figheight\hbox to\figwidth{\hfill\vbox to\figheight{\hsize\figwidth\vfill}}}}%
%       \noindent\vbox{\hsize\figwidth%
%	      \hrule\hbox to\figwidth{\vrule\hfill\vbox to\figheight{\hsize\figwidth\vfill}\vrule}\hrule}%
     \else%
        \noindent\vbox{\vskip.8pt\hsize\figwidth%
 	    \hbox to\figwidth{\vbox to\figheight{\hsize\figwidth\box\figtempbox}}}%
     \fi%
     \ifCO\else\ifFP\vbox to 0pt{\vskip-.6\figheight\llap{\hbox to \figwidth{%
             \hfill\blackink\vrule height20pt width220pt depth5pt\whiteink
             \llap{\fontsize{26}{26}\selectfont\bfseries FPO scaled at \@fpo\%}\blackink\hfill}}}%
     \FPfalse\fi\fi%
}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Styles of Figures
%
\sideverticalskip=0pt
\sidetskip=0pt
%
\def\FigName{figure}
%

\newif\ifwebcolor\global\webcolorfalse

\def\webcolr{\global\webcolortrue}

\def\webcolortext{(Colour online)\ }

\long\def\@makecaption#1#2{%
    \ifx\FigName\@captype
      \vskip\abovecaptionskip
      \@makefigurecaption{#1}{\ifwebcolor\webcolortext\else\fi#2}%
      \vskip0pt
    \else
      \@maketablecaption{#1}{#2}%
      \vskip\belowcaptionskip
    \fi}
%
\renewcommand\thetable{\arabic{table}}
%
\def\fps@table{tbp}
\def\ftype@table{2}
\def\ext@table{lot}
\def\fnum@table{\tablename\ \thetable}
%
\def\tablefootnote#1{
        \global\advance\tfootcount1\expandafter\gdef\csname tablefootnote\the\tfootcount\endcsname{#1}}
%
%\newenvironment{table}
%               {\global\tableshowtrue\@float{table}}
%               {\@@tabcap\vskip9.5pt\hrule\end@float\global\tableshowfalse}

\newenvironment{table}
               {\global\tableshowtrue\@float{table}}
               {\end@float\global\tableshowfalse}
%
\def\tablebelowspace#1{\gdef\@tablebelowspace{#1}}\tablebelowspace{}
%
\newenvironment{table*}
               {\let\footnote\tablefootnote%%
               \@dblfloat{table}}
               {%
                  \ifx\@tablebelowspace\@empty%
                  \else%
                    \vspace*{\@tablebelowspace}\tablebelowspace{}%
                  \fi%
               \end@dblfloat\global\tablefootnotenonefalse\global\killtableabovespacefalse}
%
\newenvironment{intexttable}
               {\begin{table}[h]}
               {\end{table}}
%
\gdef\base{10pt}
\gdef\colbase{10pt}
%
\newenvironment{Table}
               {\par\addvspace{12pt plus2pt}\def\@captype{table}}
               {\par\addvspace{12pt plus2pt}}
%
\newenvironment{boxtextTable}[1][\relax]%
               {\par\addvspace{12pt plus2pt}\def\@captype{table}}
               {\par\addvspace{12pt plus2pt}}
%
\newenvironment{Table*}
               {\par\addvspace{12pt plus2pt}\def\@captype{table}}
               {\par\addvspace{12pt plus2pt}}
%
\def\tableabovespace#1{\gdef\@tableabovespace{#1}}\tableabovespace{}
%
\def\tnumspace{\hbox{\ }}
\def\tspace{}
%
\def\tablecontinued{{\fontsize{7.5}{10}\bfseries\itshape\selectfont (Continued)}}
\def\tableexplanation#1{\itshape\selectfont #1}
\def\tableexplanationskip{\hskip8.5pt}
%
\def\tablefig#1{\gdef\@tablefig{#1}}\tablefig{des-tableshade}
%
\overfullrule0pt
%
\tablenumcapsep=-3.5pt
%
\def\tablecolshade#1#2#3#4{%
  \vbox to 0pt{\parindent0pt\vspace*{#2pt}\vspace*{-7.8pt}\hbox to 0pt{\vbox{\hspace*{#1pt}\hspace*{-6pt}\hbox{\vcolor{\grayten\vrule height#3pt width#4pt depth0pt}}}}}}%
%
\def\tableshade#1{\gdef\@tableshade{#1}}\tableshade{0pt}%
\def\tableruleheight#1{\gdef\@tableruleheight{#1}}\tableruleheight{138pt}%
%
\newbox\tabbox

\def\rowsepspace{\\[-15pt]\\}
%
\def\mextraskip#1{\gdef\@mextraskip{#1}}\mextraskip{0pt}
%
\extratableheight0pt
%
\def\adjusttableboxheight#1{\global\extratableheight#1}\adjusttableboxheight{0pt}
\def\tableboxheight#1{\gdef\@tableboxheight{#1}}\tableboxheight{0pt}
%
\tablebodywidth0pt
\tableheight0pt
%
\def\tablebodystartleftskip#1{\gdef\@tablebodystartleftskip{#1}}\tablebodystartleftskip{0pt}
\def\tablebodystartrightskip#1{\gdef\@tablebodystartrightskip{#1}}\tablebodystartrightskip{0pt}
%
\def\@maketablecaption#1#2{%
\global\setbox\tabbox\hbox{\tablecaptionfont\ifunnumtable\else{\tablecaptionnumfont#1}\fi\figpunct\kern4pt #2\vphantom{y}}%
\unhbox\tabbox}
%
\def\tbl#1#2{%
\global\setbox\tempbox\hbox{\tablefont#2}%
\global\setbox\temptbox\hbox{\tablecaptionfont#1}%
\global\setbox\temptbox\hbox{{\tablecaptionfont\ifunnumtable\else\noindent{\tablecaptionnumfont\fnum@table\hskip\tablenumcapsep}\fi#1\vphantom{y}\par}}%
\global\tablewidth\wd\tempbox%
{\box\tempbox}%
\caption{#1}}%
%
\def\TCH#1{\TCHfont#1}%
%
\def\x{@{\extracolsep{\fill}}}
%
\def\hhrulefill{\hbox\bgroup\leavevmode\leaders\hrule\hfill\kern\z@\egroup}
%
\long\def\multicolumn#1#2#3{\multispan{#1}\begingroup
  \@mkpream{#2}%
  \def\@sharp{#3}%\setbox\tempbox\hbox{#3}\raise-5pt\hbox to 0pt{\hfill\hbox{\vrule height.5pt width\wd\tempbox depth0pt}}
  \set@typeset@protect
  \let\@startpbox\@@startpbox\let\@endpbox\@@endpbox
  \@arstrut \@preamble\hbox{}\endgroup\ignorespaces}
%
\def\@cline#1-#2\@nil{%
  \omit
  \@multicnt#1%
  \advance\@multispan\m@ne
  \ifnum\@multicnt=\@ne\@firstofone{&\omit}\fi
  \@multicnt#2%
  \advance\@multicnt-#1%
  \advance\@multispan\@ne
  \leaders\hrule\@height\arrayrulewidth\hfill
  \cr
  \noalign{\vskip-\arrayrulewidth}}
%
%%%%%%%%%%%%%%% B-Table Rules %%%%%%%%%%%%%%
%
\usepackage{booktabs}

\newenvironment{tabnote}{\tabnotefont\par}
    {\par\global\manshowtfootskip=0pt}
%
\def\vcolor#1{#1\special{color pop}}
\def\grayten{\special{color push cmyk 0 0 0 0.1}}
%
\def\TBCOLSH#1#2#3#4{\vbox to 0pt{\vspace*{#1pt}\vspace*{-12pt}\hbox to 0pt{\hspace*{#2pt}\vbox{\hbox{\vcolor{\grayten\vrule height#3pt width#4pt depth0pt}}}}}}
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  Math %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
\setlength\arraycolsep{5\p@}
\setlength\tabcolsep{6\p@}
\setlength\arrayrulewidth{.4\p@}
\setlength\doublerulesep{2\p@}
\setlength\tabbingsep{\labelsep}
\setlength\fboxsep{3\p@}
\setlength\fboxrule{.4\p@}
%
\setlength\columnsep{24\p@}
\setlength\columnseprule{0\p@}
%
\newdimen\belowtoprulesep

\heavyrulewidth=.5pt
\lightrulewidth=.25pt
\cmidrulewidth=.25pt
\belowrulesep=4pt
\belowtoprulesep=2pt
\belowbottomsep=0pt
\aboverulesep=3.2pt
\abovetopsep=0pt
\cmidrulesep=\doublerulesep
\doublerulesep=2pt
%
\def\toprule{\noalign{\ifnum0=`}\fi
  \@aboverulesep=\abovetopsep
  \global\@belowrulesep=\belowtoprulesep %global cos for use in the next noalign
  \global\@thisruleclass=\@ne
  \@ifnextchar[{\@BTrule}{\@BTrule[\heavyrulewidth]}}

\def\topline{\toprule}
\def\botline{\bottomrule}

\ifeqnum
\renewcommand\theequation{\arabic{equation}}
\else
\@addtoreset{equation}{section}
\renewcommand\theequation{\thesection.\arabic{equation}}
\fi
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  Footnote %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\renewcommand\footnoterule{%
  \kern-3\p@
  \hrule\@width0pt
  \kern2.6\p@}

\@addtoreset{footnote}{chapter}

\foot@parindent18pt

\newcommand\@makefntext[1]{%
    \ifpddata%
    \else%
    \ifFoottext%
    \else%
    \rule{6pc}{.5pt}\vskip5pt
    \fi\fi%
    \noindent
    \hb@xt@\foot@parindent{\hss\@makefnmark}#1}

\def\@makefnmark{%
\ifpddata%
\setcounter{footnote}{0}%
\else%
\hbox{\@textsuperscript{\normalfont\@thefnmark}}%
\fi}
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  End Footnote %%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  Page styles  %%%%%%%%%%%%%%%%%%%%%%%%%%%%
\def\oddfolio{{\foliofont\thepage}}
\def\evenfolio{{\foliofont\thepage}}
%
\def\lefttitle#1{\gdef\@versorh{#1}}\lefttitle{}
\def\righttitle#1{\gdef\@rectorh{#1}}\righttitle{}
%
\def\ps@headings{%
    \let\@oddfoot\@empty%
    \let\@evenfoot\@empty%
    \def\@oddhead{\JFP@linecountL%
        \hbox to \typewidth{\hfill{\rhfont\@rectorh}\hfill{\oddfolio}}%
        }%
    \def\@evenhead{\JFP@linecountL%
        \hbox to \textwidth{{\evenfolio}\hfill{\rhfont\@versorh}\hfill}%
        }%
    \let\@mkboth\markboth
    \def\chaptermark##1{\markboth{\@versorh}{\@rectorh}}%
%    \def\sectionmark##1{\markright{##1}}%
    }%
\def\mrhfont{\fontfamily{\sfdefault}\fontsize{9}{9}\bfseries\selectfont}

\def\mfoliofont{\fontfamily{\sfdefault}\fontsize{9}{9}\bfseries\selectfont}

\def\moddfolio{{\mfoliofont\thepage}}

\def\mevenfolio{{\mfoliofont\thepage}}

\def\ps@empty{%
      \def\@oddfoot{}%
      \let\@evenfoot\@oddfoot
      \def\@evenhead{}%
      \def\@oddhead{}%
      \let\@mkboth\markboth
      \let\chaptermark\@gobble
      \let\sectionmark\@gobble}

\def\ps@rotatepage{%
      \def\@oddfoot{\hfill\oddfolio\hfill}%
      \def\@evenfoot{\hfill\evenfolio\hfill}
      \def\@evenhead{}%
      \def\@oddhead{}%
      \let\@mkboth\markboth
      \let\chaptermark\@gobble
      \let\sectionmark\@gobble}

%
\def\logo@Image@path{../Figures/Logo/LaTeX-Logo/}
%%%%%%%%%%%%%%%%%%%%%%%% Proof Readers Template  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\font\QEDlogofont=msam10 at 10.7pt
\def\QEDlogo{\hbox{\QEDlogofont\char'003}}
\def\QEDblogo{\hbox{\QEDlogofont\char'004}}
\def\sqbox{{\QEDlogofont\char'004}}
\def\prbox{\unskip\hskip4.5pt\ignorespaces{\fboxsep0pt\fbox{\vrule width5pt height5pt depth0pt}}\global\logofalse}
\def\@proof[#1]{\noindent{\itshape#1.\hskip9.5pt}\ignorespaces}
\ptdraftrule0pt
%%%%%%%%%%%%%%%%%%%%%%%% Proof Readers Template  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
\ptdraftrule0pt
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  Bibliography Section   %%%%%%%%%%%%%%%%%%

\def\surname#1{#1}
\def\givenname#1{#1}
\def\middlename#1{#1}
\def\pubname#1{#1}
\def\corporate#1{#1}
\def\booktitle#1{#1}
\def\jmonth#1{#1}
\def\articletitle#1{#1}
\def\edition#1{#1}
\def\firstpage#1{#1}
\def\lastpage#1{#1}
\def\issue#1{#1}
\def\volume#1{#1}
\def\bibyear#1{#1}
\def\jaddress{\unskip,\ }

\def\comma{,}
\def\semicolon{;}
\def\fullstop{.}
\def\nocomma{\def\comma{\unskip\ignorespaces}}
\def\nofullstop{\def\fullstop{}}

%%%%% TRUE FOR CHAPTER TITLE AND FALSE FOR SECTION TITLE %%%%%%%%
%%%%%%%% Unnumberd References %%%%%%%%%%%
\setlength\bibleftmargin  {9pt}
\setlength\bibitemsep  {2pt}
\setlength\bibparsep  {0pt}
%%%%%%%% Numbered Within Squre Bracket %%%%%%%%%%%
\setlength\biblabelsep  {10pt}
\setlength\bibleftmargini  {5.75pt}
%%%%%%%% Numbered With Dot %%%%%%%%%%%%%%%
\def\firstsectionhead{\vspace*{8.7pt}\bibitem{}\ \vspace*{-20pt}}
\setlength\bibtext  {5pt}
%
\def\referenceheadfont{\fontsize{10}{12}\bfseries\selectfont\leftskip0pt plus1fill\rightskip11pt plus1fill}
%
\newenvironment{thebibliography}[1]
    {\let\section\referencehead
     \bibliofont
     \pdfbookmark{References}{HL\bibname}
     \def\@tempa{#1}%
     \if@unnumref
     	   \list{}%
           {\labelwidth0pt\labelsep0pt
           \leftmargin\bibleftmargin%12
           \itemindent-\bibleftmargin
           \itemsep\bibitemsep
           \parsep\bibparsep
           \usecounter{enumiv}%
           \let\p@enumiv\@empty
           \renewcommand\theenumiv{\arabic{enumiv}}}%
      \else
          \setbox\tempbox\hbox{\@tempa.}
          \tempdimen\wd\tempbox
          \advance\bibtext\tempdimen
          \ifnumsqure
          \else
          \def\@biblabel##1{\hbox to \bibtext{\hbox to \tempdimen{\hfill##1.}\hfil}}\fi%
          \list{\@biblabel{\arabic{enumiv}}}%
          {\settowidth\labelwidth{\@biblabel{#1}}%
          \labelsep0pt\leftmargin\labelsep
          \advance\leftmargin\bibtext
          \ifnumsqure
          \advance\leftmargin\bibleftmargini
          \labelsep\biblabelsep\fi
          \itemindent0pt
          \itemsep\bibitemsep
          \parsep\bibparsep
          \usecounter{enumiv}%
          \let\p@enumiv\@empty
          \renewcommand\theenumiv{\arabic{enumiv}}}%
     \fi
     \sloppy\clubpenalty10000\widowpenalty10000%
     \sfcode`\.=\@m}
     {\def\@noitemerr
     {\@latex@warning{Empty `thebibliography' environment}}%
     \endlist}
\newcommand\newblock{}
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  End Bibliography Section %%%%%%%%%%%%%%%%

\usepackage[authoryear]{natbib}
\bibpunct{(}{)}{;}{a}{,}{,}
\setlength{\bibsep}{0.3mm}

\def\bibfont{\bibliofont}

\renewenvironment{thebibliography}[1]{%
 \bibsection
 \parindent\z@
 \bibpreamble
 \bibfont
 \list{\@biblabel{\the\c@NAT@ctr}}{\@bibsetup{#1}\global\c@NAT@ctr\z@}%
 \ifNAT@openbib
   \renewcommand\newblock{\par}%
 \else
   \renewcommand\newblock{\hskip .11em \@plus.33em \@minus.07em}%
 \fi\itemindent-9pt\leftskip-1pt\itemsep0pt
 \sloppy\clubpenalty4000\widowpenalty4000
 \sfcode`\.\@m
 \let\NAT@bibitem@first@sw\@firstoftwo
    \let\citeN\cite \let\shortcite\cite
    \let\citeasnoun\cite
}{%
 \bibitem@fin
 \bibpostamble
 \def\@noitemerr{%
  \PackageWarning{natbib}{Empty `thebibliography' environment}%
 }%
 \endlist
 \bibcleanup
}%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  End Bibliography Section %%%%%%%%%%%%%%%%
%
\newcommand\@pnumwidth{.5pc}%
\newcommand\@tocrmarg{2em}%
\newcommand\@minitocrmarg{1.5pc}%
\newcommand\@dotsep{4.5}%
\setcounter{tocdepth}{3}%

\newcommand\tableofcontents{%
   \title{\contentsname}%
   \markboth{\contentsname}{\contentsname}%
   \@starttoc{toc}}%

\newcommand*\l@title[2]{%
  \ifnum \c@tocdepth >\m@ne
    \addpenalty{-\@highpenalty}%
    \vskip 1.0em \@plus\p@
    \setlength\@tempdima{1.5em}%
    \begingroup
      \parindent \z@ \rightskip \@pnumwidth
      \parfillskip -\@pnumwidth
      \leavevmode \bfseries
      \advance\leftskip\@tempdima
      \hskip -\leftskip
      #1\nobreak\hfil \nobreak\hb@xt@\@pnumwidth{\hss #2}\par
      \penalty\@highpenalty
    \endgroup
  \fi}
\newcommand*\l@section{\@dottedtocline{1}{1.5em}{2.3em}}
\newcommand*\l@subsection{\@dottedtocline{2}{3.8em}{3.2em}}
\newcommand*\l@subsubsection{\@dottedtocline{3}{7.0em}{4.1em}}
\newcommand*\l@paragraph{\@dottedtocline{4}{10em}{5em}}
\newcommand*\l@subparagraph{\@dottedtocline{5}{12em}{6em}}

%
\def\Copyright{\leavevmode\fontsize{6.5}{11}\selectfont{\ooalign{\hfil\raise-.25pt\hbox{\fontsize{5}{11}\selectfont C\hskip.5pt}%
                \hfil\crcr\mathhexbox20D}}}
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  Appendix  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
\newcommand\appendix{\par
  \setcounter{chapter}{0}%
  \setcounter{section}{0}%
  %\renewcommand\@chapapp{\appendixname}%
  \renewcommand\thechapter{\Alph{chapter}}}
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% End Appendix %%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  Index  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
\def\alphabet#1{\par\vskip.5\baselineskip{\bf#1}\par\vskip.5\baselineskip}
%
\def\indmatter#1{\gdef\@indmatter{#1}}
\indmatter{}
%
\newenvironment{theindex}{\cleardoublepage%
      \columnseprule \z@
      \columnsep 12\p@
      \markboth{\indexname}{\indexname}
      \tempdimen\normalbaselineskip
      \advance\tempdimen-\baselineskip
      \twocolumn[\@makeschapterhead{\indexname}\vskip\tempdimen\vskip3pt
      \ifx\@indmatter\@empty\else\noindent{\indexfont\@indmatter\par\vskip\baselineskip}\fi%
      ]%
      \thispagestyle{plain}
      \parindent\z@\indexfont
      \let\item\@idxitem}
      {\par\indmatter{}}
\newcommand\@idxitem  {\par\hangindent3em}
\newcommand\subitem   {\par\hangindent3em\hspace*{1em}}
\newcommand\subsubitem{\par\hangindent3em\hspace*{2em}}
\newcommand\indexspace{\par \vskip\baselineskip}
%%%%%%%%%%%%%%%%%%%% File Version  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\ifprinter
   \def\draftnote{\vphantom{\vbox to 0pt{\vskip-12pt
   \hbox{\ \footnotesize\jobname\vphantom{pq}\qquad\jobtag\qquad\today\qquad\currenttime\qquad Char Count= \@TotalChars
   \ifmathtif\else\@questionmark\fi\hfil}}}%
  \def\comment{}
  \def\Qauthor#1{}
   \def\QtoAuthor#1{}
   \def\QtoClient#1{}
   \def\QtoQC#1{}
   \def\QtoGL#1{}
   \def\qtoa#1{}
\else
\def\draftnote{\vbox to 0pt{\vskip-12pt}}%
   \def\Qauthor#1{\marginpar{{\raggedright\footnotesize\bf #1\endgraf}}}
\fi
\let\qtoa\Qauthor
%%%%%%%%%%%%%%%%%%%% Character count  %%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
\def\gray{\special{color push cmyk 0 0 0 0.5}}
\def\@questionmark{\vbox to 0pt{\rotatebox{40}{\hbox to \textwidth{
                  \begin{picture}(0,0)\put(-340,-50){
                  \fontsize{90}{90}\selectfont Compile Again}\end{picture}\hss}}}}
\def\questionmark#1{\xdef\@questionmark{#1}}%
%
\def\@TotalChars{}
\def\TotalChars#1{\xdef\@TotalChars{#1}}%
%
\def\cropmarks{\nointerlineskip\vbox to 0pt{\offinterlineskip\vss
  \hbox to \trimwidth{\vbox to 0pt{\draftnote}\hfill}}}%

\def\croprules{%
		\nointerlineskip\vbox to 0pt{\offinterlineskip
  \vskip4pt\cropmarks
		\vskip\topmargin
  \hbox to \trimwidth{\hskip\@themargin\hbox to \textwidth{\hss%
    \vrule height0pt depth\typeheight width.1pt%
    \vrule height.1pt depth0pt width\textwidth
    \vrule height0pt depth\typeheight width.1pt\hss}}%
  \hbox to \trimwidth{\hskip\@themargin\hbox to \textwidth{\hss%
    \vrule height.1pt depth0pt width\textwidth\hss}\hss}}}
%
\gdef\@placewidthart{}
%
\figwidth0pt
\figheight0pt
%
\def\authorname{}
\def\jobno{}
\def\chapno{}
%
\def\changeh#1.#2pt{}
%
\def\ArtPiece#1#2#3{%
\fboxrule.1pt
\fboxsep0pt
 \oldfigwidth\figwidth
  \gdef\figtemp{#1}%
%  \addtocounter{figure}{1}
%%%% for scaling
 \gdef\figtempscale{#3}%\ifx\figtempscale\empty\figtempcount100\else\figtempcount\figtempscale\fi\multiply\figtempcount10
%%%% to add to figheight
 \setbox\tempbox=\vbox{\epsfbox{#1}}%
	\figheight\ht\tempbox
%%%% to add to figwidth
 \setbox\tempbox=\hbox{\epsfbox{#1}}%
 \advance\figwidth\wd\tempbox
 \presentfigwidth\wd\tempbox
 \remainingtextwidth\textwidth
 \advance\remainingtextwidth-\oldfigwidth
 \advance\remainingtextwidth-\presentfigwidth
 \tempdim\oldfigwidth\advance\tempdim\presentfigwidth
   %\ifdim\tempdim>\textwidth\par\vskip6pt \figwidth0pt
 \ifdim\remainingtextwidth<0pt\par\vskip6pt %\figwidth0pt
 \else
%%%% testing whether line is full
 \fi
 \setbox\tempbox=\hbox{\fbox{\epsfbox{#1}\hss}}%
\xdef\@placewidthart{\@placewidthart\unhbox\tempbox}%
  \leavevmode\vbox{\hsize\presentfigwidth\parindent0pt\leftskip0pt plus1fill\rightskip\leftskip{}
      \@placewidthart\par
      \vskip3pt
%      Fig. #2\par
      Figure: \figtemp\par
      Reduction: \figtempscale\%\par
						Height:\the\figheight\par
						Width: \the\presentfigwidth\par
     \jobno\quad \chapno \quad\authorname}\unskip\hskip10pt}
%
%%%%%%%%%%%%%%%%%%% End File Version %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Trimmarks  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%\def\trimmarks{%
%  \vbox to 0pt{%
%     \vskip-25pt\parindent0pt
%     \draftnote\offinterlineskip}%
%  \ifdraft
%    \vbox to 0pt{\hsize\trimwidth\offinterlineskip
%    \parindent0pt\leftskip0pt\rightskip0pt
%    \fboxsep0pt\fboxrule\draftrule
%    \fbox{\vbox{\vskip\trimheight\hskip\trimwidth}}}%
%%
%    \vbox to 0pt{\hsize\trimwidth\offinterlineskip
%    \parindent0pt\leftskip0pt\rightskip0pt
%    \vbox to \trimheight{\offinterlineskip\parindent0pt
%    \hbox to \trimwidth{\vbox to 2pc{\vskip-3.5pc\hbox{\vrule height2pc width\trimrule}}\raisebox{2pc}{\hbox{\hskip-3.5pc\vrule width2pc height\trimrule}}\hfill
%      \raisebox{2pc}{\vrule width2pc height\trimrule\hskip-3.75pc}
%      \vbox to 2pc{\vskip-3.5pc\hbox{\vrule height2pc width\trimrule}}%
%    }\vfill
%    \hbox to \trimwidth{\hbox{\hskip-3.5pc\vrule height\trimrule width2pc}\vbox to 3pc{\vspace*{4.5pc}\hbox{\hskip1.5pc\vrule width\trimrule height2pc}}\hfill
%    \vbox to 3.5pc{\vskip5pc\hbox{\vrule height2pc width\trimrule}}\rlap{\hskip1.5pc\vrule width2pc height\trimrule}}}}%
%%
%  \else
%    \vbox to 0pt{\hsize\trimwidth\offinterlineskip
%    \parindent0pt\leftskip0pt\rightskip0pt
%    \vbox to \trimheight{\offinterlineskip\parindent0pt
%    \ifregistermark
%    \vbox to 0pt{\vspace*{-43.35pt}\hbox to \trimwidth{\hss\epsfbox{logo-02.eps}\hss}}
%    \fi
%    \hbox to \trimwidth{\vbox to 2pc{\vskip-3.5pc\hbox{\vrule height2pc width\trimrule}}\raisebox{2pc}{\hbox{\hskip-3.5pc\vrule width2pc height\trimrule}}\hfill
%      \raisebox{2pc}{\vrule width2pc height\trimrule\hskip-3.75pc}
%            \vbox to 2pc{\vskip-3.5pc\hbox{\vrule height2pc width\trimrule}}%
%    }\vfill
%     \ifregistermark{\hbox to \trimwidth{\hskip-43pt\epsfbox{logo-01.eps}\hfill\epsfbox{logo-01.eps}\hskip-43pt}}\fi
%    \vfill
%    \hbox to \trimwidth{\hbox{\hskip-3.5pc\vrule height\trimrule width2pc}%
%    \vbox to 3pc{\vspace*{4.5pc}\hbox{\hskip1.5pc\vrule width\trimrule height2pc}}\hfill
%    \vbox to 3.5pc{\vskip5pc\hbox{\vrule height2pc width\trimrule}}\rlap{\hskip1.5pc\vrule width2pc height\trimrule}}
%    \ifregistermark\vbox to 0pt{\vspace*{18.15pt}\hbox to \trimwidth{\hss\epsfbox{logo-02.eps}\hss}}\fi}}
%\fi
%\insidedraftrules}
%
\def\insidedraftrules{\vbox to 0pt{%
  \offinterlineskip\parindent0pt
  \vskip \topmargin
  \tempdimen\normaltextheight
  \advance\tempdimen\headheight
  \advance\tempdimen\headsep
  \moveright\@themargin
  \vbox{\vbox to 0pt{\vskip\headheight\vskip\headsep
   \vrule height\draftrule width\textwidth}
   \hbox{\fboxsep0pt\fboxrule\draftrule
        \fbox{\vbox to \tempdimen
                    {\hsize\textwidth\hskip\textwidth}}}}}}%
%
\def\insidedraftrules{\overfullrule0pt%
   \iffloutsidemargin
   %  \addtolength\evensidemargin{-\colmargin}
     \addtolength\oddsidemargin{0pt}
   \fi
   \ifflinsidemargin
     \addtolength\evensidemargin{-\colmargin}
     \addtolength\oddsidemargin{\colmargin}
   \fi
     \ifflinsidetexttypewidthsep
        \addtolength\oddsidemargin{\texttypewidthsep}
        \addtolength\evensidemargin{-\texttypewidthsep}
     \fi
   \ifflleftsidemargin
   %  \addtolength\evensidemargin{-2pc}
     \addtolength\oddsidemargin{\colmargin}
   \fi
   \ifflleftsidetexttypewidthsep
   %  \addtolength\evensidemargin{-2pc}
     \addtolength\oddsidemargin{\texttypewidthsep}
   \fi
   \ifflrightsidemargin
     \addtolength\evensidemargin{-\colmargin}
   \fi
   \ifflrightsidetexttypewidthsep
     \addtolength\evensidemargin{-\texttypewidthsep}
   \fi
\vbox to 0pt{%
  \offinterlineskip\parindent0pt
  \vskip \topmargin
  \tempdimen\normaltextheight
  \advance\tempdimen\headheight
  \advance\tempdimen\headsep
  \advance\tempdimen-0.4pt
  \moveright\@themargin
      \ifodd\c@page
         \hbox to \textwidth{\hss\hbox to \typewidth{%
         \vbox to \tempdimen{\hrule height\draftrule
         \vbox to 0pt{\vskip\headheight\vskip\headsep%\vskip-6pt
                %\hbox{\vrule height\draftrule width\typewidth}
                }%
         \hbox to \typewidth{\vrule width\draftrule
         \hfill\vrule height\tempdimen width\draftrule%
      \iffloutsidetexttypewidthsep%
         \hskip\texttypewidthsep\vrule height\tempdimen width\draftrule\hskip-.3pt%
      \fi%
      \iffloutsidemargin%
        \hskip\colmargin\vrule height\tempdimen width\draftrule\hskip-.3pt%
      \fi%
      \ifflinsidetexttypewidthsep%
         \hskip\texttypewidthsep\vrule height\tempdimen width\draftrule%
      \fi%
      \ifflinsidemargin%
         \hskip\textwidth\hskip-.5pt\vrule height\tempdimen width\draftrule%
      \fi%
      \ifflleftsidetexttypewidthsep%
         \hskip\texttypewidthsep\hskip0pt\vrule height\tempdimen width\draftrule%
      \fi%
      \ifflleftsidemargin%
         \hskip\textwidth\hskip-.5pt\vrule height\tempdimen width\draftrule%
      \fi%
      \ifflrightsidetexttypewidthsep%
         \hskip\texttypewidthsep\vrule height\tempdimen width\draftrule\hskip-.5pt%
      \fi%
      \ifflrightsidemargin%
         \hskip\colmargin\vrule height\tempdimen width\draftrule\hskip-.3pt%
      \fi%
         }%
         \hrule height\draftrule}}%
      \iffloutsidemargin%
        \hskip-\colmargin%
      \fi%
      \iffloutsidetexttypewidthsep%
        \hskip-\texttypewidthsep%
      \fi%
      \ifflinsidemargin%
%        \hskip-\colmargin%
      \fi%
      \ifflleftsidemargin%
%        \hskip-\colmargin%
      \fi%
      \ifflrightsidemargin%
        \hskip-\colmargin%
      \fi%
      \ifflrightsidetexttypewidthsep%
        \hskip-\texttypewidthsep%
      \fi%
         }%
\else%
         \hbox to \textwidth{\hss\hbox to \typewidth{%
         \vbox to \tempdimen{\hrule height\draftrule%
         \vbox to 0pt{\vskip\headheight\vskip\headsep%\vskip-6pt
                %\hbox{\vrule height\draftrule width\typewidth}%
                }%
         \hbox to \typewidth{\vrule width\draftrule%
         \hfill\vrule height\tempdimen width\draftrule%
     \iffloutsidetexttypewidthsep%
        \hskip\texttypewidthsep\vrule height\tempdimen width\draftrule%
     \fi%
     \iffloutsidemargin%
        \hskip\textwidth\hskip-.5pt\vrule height\tempdimen width\draftrule%
     \fi%
     \ifflinsidetexttypewidthsep%
        \hskip\texttypewidthsep\vrule height\tempdimen width\draftrule%
     \fi%
     \ifflinsidemargin%
        \hskip\colmargin\ifflinsidetexttypewidthsep\hskip-.3pt\fi\vrule height\tempdimen width\draftrule\hskip-.3pt%
     \fi%
     \ifflleftsidetexttypewidthsep%
        \hskip\texttypewidthsep\hskip0pt\vrule height\tempdimen width\draftrule%
     \fi%
     \ifflleftsidemargin%
        \hskip\textwidth\hskip-.5pt\vrule height\tempdimen width\draftrule%
     \fi%
     \ifflrightsidetexttypewidthsep%
        \hskip\texttypewidthsep\vrule height\tempdimen width\draftrule\hskip-.5pt%
     \fi%
     \ifflrightsidemargin%
        \hskip\colmargin\vrule height\tempdimen width\draftrule\hskip-.3pt%
     \fi%
        }%
         \hrule height\draftrule}}%
      \iffloutsidemargin%
%        \hskip-\colmargin%
      \fi%
      \ifflinsidemargin%
        \hskip-\colmargin%
      \fi%
      \ifflinsidetexttypewidthsep
         \hskip-\texttypewidthsep%
      \fi
      \ifflleftsidemargin%
%        \hskip-\colmargin%
      \fi%
      \ifflrightsidemargin%
        \hskip-\colmargin%
      \fi%
      \ifflrightsidetexttypewidthsep%
        \hskip-\texttypewidthsep%
      \fi%
     }%
      \fi}}%
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% End Trimmarks  %%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Output Routine  %%%%%%%%%%%%%%%%%%%%%%%%%%
%
\def\@outputpage{%
\begingroup           % the \endgroup is put in by \aftergroup
  \let \protect \noexpand
  \@resetactivechars
  \@parboxrestore
  \shipout \vbox{%
    \set@typeset@protect
    \aftergroup \endgroup
    \aftergroup \set@typeset@protect
                                % correct? or just restore by ending
                                % the group?
  \if@specialpage
    \global\@specialpagefalse\@nameuse{ps@\@specialstyle}%
  \fi
  \if@twoside
    \ifodd\count\z@ \let\@thehead\@oddhead \let\@thefoot\@oddfoot
         \let\@themargin\oddsidemargin
    \else \let\@thehead\@evenhead
       \let\@thefoot\@evenfoot \let\@themargin\evensidemargin
    \fi
  \fi
  \reset@font
  \normalsize
  \normalsfcodes
  \let\label\@gobble
  \let\index\@gobble
  \let\glossary\@gobble
  \baselineskip\z@skip \lineskip\z@skip \lineskiplimit\z@
    \@begindvi%\trimmarks
    \vskip \topmargin
    \moveright\@themargin \vbox {%
      \setbox\@tempboxa \vbox to\headheight{%
        \vfil
        \color@hbox
          \normalcolor
          \hb@xt@\textwidth{\@thehead}%
        \color@endbox
        }%                        %% 22 Feb 87
      \dp\@tempboxa \z@
      \box\@tempboxa
      \vskip \headsep
      \box\@outputbox
      \baselineskip \footskip
      \color@hbox
        \normalcolor
        \hb@xt@\textwidth{\@thefoot}%
      \color@endbox
      }%
    }%
  \global \@colht \textheight
  \stepcounter{page}%
  \let\firstmark\botmark
}
%
%%%%%%%%%%%%%%%%%%%%%%%% Misc. %%%%%%%%%%%%%%%%%%%%%%%
%
\def\@@question#1{\hbox to \hsize{\hfill
                   \rlap{\hskip\marginparsep
                         \vbox to 0pt{\hsize\marginparwidth
                                      \footnotesize
                                      \raggedright#1\endgraf\vss}}}}
\def\@question#1{\ifvmode
                    \@@question{#1}%
                 \else
                     \vadjust{\vbox to 0pt{%
                     \vskip-7.5pt\@@question{#1}\vskip7.5pt}}
                 \fi}
%
\def\QtoAuthor#1{\@question{{\bf Author:\ #1}}}
\def\QtoClient#1{\@question{{\bf Client/PM:\ #1}}}
\def\QtoQC#1{\@question{{\bf QC:\ #1}}}
\def\QtoGL#1{\@question{{\bf GL:\ #1}}}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% End Output Routine  %%%%%%%%%%%%%%%%%%%%%%
%
\def\spreadlong#1{\ifodd\c@page\wlog{Ignoring spreadlong}
                  \else
                     \spreadlongtrue\gdef\@spreadlong{#1}%
                     \enlargethispage{#1}%
                  \fi}
%
\advance\voffset-82pt%
\advance\hoffset-72.1pt%

\def\endash{--}
%
\let\paperheight\trimheight %JG
\usepackage{hyperref}%
\hypersetup{
colorlinks=true,
linkcolor=blue,
anchorcolor=blue,
citecolor=blue,
urlcolor=blue,
filecolor=blue,
bookmarksopenlevel=3,
bookmarksopen=true,
pdfborderstyle={/S/U/W 0},
pdfstartview={FitH 800},
breaklinks=true}
\usepackage{bookmark}[2011/12/02]
\usepackage{etoolbox}

\ifnatbiboff\else
\patchcmd{\NAT@citex}
  {\@citea\NAT@hyper@{%
     \NAT@nmfmt{\NAT@nm}%
     \hyper@natlinkbreak{\NAT@aysep\NAT@spacechar}{\@citeb\@extra@b@citeb}%
     \NAT@date}}
  {\@citea\NAT@nmfmt{\NAT@nm}%
   \NAT@aysep\NAT@spacechar\NAT@hyper@{$\NAT@date$}}{}{}
\fi
%
%% Patch case where name and year are separated by opening bracket
\patchcmd{\NAT@citex}
  {\@citea\NAT@hyper@{%
     \NAT@nmfmt{\NAT@nm}%
     \hyper@natlinkbreak{\NAT@spacechar\NAT@@open\if*#1*\else#1\NAT@spacechar\fi}%
       {\@citeb\@extra@b@citeb}%
     \NAT@date}}
  {\@citea\NAT@nmfmt{\NAT@nm}%
   \NAT@spacechar\NAT@@open\if*#1*\else#1\NAT@spacechar\fi\NAT@hyper@{$\NAT@date$}}
  {}{}
%\fi

\usepackage{amsmath}
\usepackage[nameinlink,capitalize]{cleveref}

\newcommand*{\eqautoref}[2][Equation]{%
  \hyperref[{#2}]{#1 (\ref*{#2})}%
    \protected@write\@auxout{}{\gdef\string\geteqautoref{\string\autoval[#2]<linkname>#1</linkname>(<linkval>\csname r@#2\endcsname</linkval>)}}}
\newcommand*{\qautoref}[2][]{%
  \hyperref[{#2}]{#1 \ref*{#2}}%
     \protected@write\@auxout{}{\gdef\string\getqautoref{\string\autoval[#2]<linkname>#1</linkname><linkval>\csname r@#2\endcsname</linkval>}}}
\renewcommand{\sectionautorefname}{Section}
\renewcommand{\subsectionautorefname}{\sectionautorefname}
\renewcommand{\subsubsectionautorefname}{\sectionautorefname}

\renewcommand\footnoterule{%
  \kern-3\p@
  \hrule \@width .4\columnwidth height \z@
  \kern 3\p@}

\newif\iftitlefn

%%
\newbox\tempbox
\newdimen\@footmax
\def\footmax#1{%
  \setbox\tempbox\hbox{\footnotesize$^{#1}$}%
  \global\@footmax\wd\tempbox\global\advance\@footmax.5em}
%
\footmax{0}
%%
\renewcommand\@makefntext[1]{%
  \leavevmode\@hangfrom{\hb@xt@ \@footmax{\hss$^{\@thefnmark}\ \ $}}\footnotesize#1}
%%

\def\tbnlreffont{}

\def\tnlref#1{\ifonline\textcolor{blue}{\hyperlink{tbn-\thetable}{\hbox{\tbnlreffont#1}}}\else\tbnlreffont#1\fi}
\def\tnlget#1{\ifonline\hypertarget{tbn-\thetable}{\scriptscriptstyle#1}\else#1\fi}

\def\linkref#1#2{\ifonline\textcolor{blue}{\hyperlink{#1}{#2}}\else#2\fi}
\def\linktarget#1#2{\ifonline\hypertarget{#1}{#2}\else#2\fi}

\newif\ifsingleeqn\global\singleeqnfalse
%
\hbadness=10000
\vbadness=10000
\brokenpenalty=10000
\doublehyphendemerits=1000000
\finalhyphendemerits=1000000
\clubpenalty=10000
\widowpenalty=10000
\hyphenpenalty=50
\lefthyphenmin=3
\righthyphenmin=3
\uchyph=0
\clubpenalty10000
\widowpenalty10000
\tolerance=1
\emergencystretch=\maxdimen
\pagestyle{headings}%
\pagenumbering{arabic}      % Arabic page numbers
\frenchspacing
\jot=2.5pt
\medmuskip=3.5mu
\thickmuskip=3.5mu
\thinmuskip=3.5mu
\sloppy%

\ifx\ifxetex\ifluatex
\renewcommand{\sfdefault}{phv}%
\def\rhcopyright{\copyright}
\usepackage{breakurl}
\else
\usepackage{fontspec}%
\DeclareTextCommand{\nobreakspace}{T1}{\leavevmode\nobreak\ }
\def\rhcopyright{\textcopyright}
\fi

\usepackage{newtxtext,newtxmath}

\def\abstractindent{18pt}

\def\spanrule#1{\\[-7pt]#1\\[-5pt]}
%
\def\LT@makecaption#1#2#3{%%
   \LT@mcol\LT@cols c{\addtocounter{table}{-1}%
      \hbox to\z@{%
         \hss\parbox[t]\LTcapwidth{%%
            \sbox\@tempboxa{\Set@LT@caption{#1}{#2}{#3}}%%
	    \ifdim\wd\@tempboxa>\hsize%%
	       \Set@LT@caption{#1}{#2}{#3}%%
	    \else%%
  	       %\hbox to\hsize{\hss\box\@tempboxa\hss}%%
           \Set@LT@caption{#1}{#2}{\centering#3}
	    \fi%%
	    \endgraf%
	    \vskip\belowcaptionskip%
	    \vskip-2\p@}\hss}}}%
%%
\gdef\do@cont@cap{{\tablecaptionnumfont \tablename\ \thetable}\break \LTtablecaptionfont {Continued}}%

%%%%%%%%%%% Font Definition Begin %%%%%%%%%%%%%%%%%%%%%%%
%
\gdef\do@cont@cap{{\tablecaptionnumfont \tablename\ \thetable}\break \LTtablecaptionfont ({\it Continued})}%
%
\def\Dheadeditor#1{\gdef\@Dheadeditor{#1}}\Dheadeditor{}
%
\def\@TiTle{}
%%%
\def\aulabel{Au:\ }

%%%%%%%%%%%%%%%% For continued Table %%%%%%%%%
%
\renewenvironment{tabnote}{\tabnotefont\par}
    {\par\global\manshowtfootskip=0pt}
%

\ifpuretex
\def\gt{>}
\def\lt{<}
\else
\fi

\newcounter{cor}

\font\corsym=cmsy10 at 18pt
\font\corsymi=cmsy9 at 9pt

\def\cor{{\reset@font\corsym\char121}}

\ifbakoma\else
\patchcmd{\@mn@margintest}{\@tempswafalse}{\@tempswatrue}{}{}
\patchcmd{\@mn@margintest}{\@tempswafalse}{\@tempswatrue}{}{}
\fi

\def\elink#1{\ifonline\textcolor{blue}{\href{mailto:#1}{\color{blue}#1}}\else#1\fi}

%\newcommand{\email}{\textit{email address:}\ }%
\newcommand{\email}{\textit{e-mail:}\ }%

\def\doilink#1{\ifonline\href{https://doi.org/#1}{\textcolor{blue}{#1}}\else#1\fi}
\def\arxlink#1{\ifonline\href{https://arxiv.org/abs/#1}{\textcolor{blue}{#1}}\else#1\fi}
\def\emaillink#1{\ifonline\href{mailto:#1}{\textcolor{blue}{#1}}\else#1\fi}
\def\httplink#1{\ifonline\href{#1}{\textcolor{blue}{\refuri #1}}\else{\refuri #1}\fi}

\definecolor{snamecol}{rgb}{1,.64,1}

\def\LDAUTH#1{\ifnoquery{#1}\else\fboxsep0pt\fboxrule0pt\fcolorbox{snamecol}{snamecol}{#1}\fi}%

\newcounter{bibetem}
\def\thebibetem{\arabic{bibetem}}

\def\bibitem@fin{\refstepcounter{bibetem}%
 \@ifxundefined\@bibstop{}{\csname bibitem@\@bibstop\endcsname}%
}%

\newenvironment{quote}
  {\par\addvspace{5pt plus2pt}\itshape\leftskip0pt plus1fill\rightskip0pt plus 0fill}
  {\par\addvspace{5pt plus2pt}}

%\newenvironment{quote}
%  {\par\vskip5pt\itshape\leftskip0pt plus1fill\rightskip0pt plus 0fill}
%  {\par}

\newenvironment{quotation}
  {\list{}{\listparindent\parindent
   \topsep6pt plus2pt\itemindent\listparindent
   \leftmargin\z@ \rightmargin\leftmargin
   \parsep \z@ \@plus 1\p@}\item[]%
   \normalfont\small\rmfamily}
  {\endlist}

%\newenvironment{quotation}
%  {\list{}{\vskip6pt\listparindent\parindent
%   \topsep6pt\itemindent\listparindent
%   \leftmargin\z@ \rightmargin\leftmargin
%   \parsep \z@ \@plus 1\p@}\item[]%
%   \normalfont\small\rmfamily}
%  {\endlist}

\newcommand{\citeb}[2][]{\hyperref[#1]{#2}}

%%%%%%%%%%%%%%%%%%%PHD-Abstract%%%%%%%%%%%%%%%%%%
\def\phdabsheadfont{\fontsize{12}{13}\itshape\selectfont}
\newcommand{\phdheader}{\newpage\hrule\@par\addvspace{10pt}\begin{center}}
\newcommand{\phdtitle}[1]{\phdheader {\phdabsheadfont{#1}}\\[10pt]}
\def\phdstudent#1{\authorfont{#1}\@par}
\def\phdinstitution#1{\authorfont{#1}\@par\vspace*{10pt}}
\newcommand{\phddate}[1]{\scriptsize{Date: #1}; }
\newcommand{\phdadvisor}[1]{\scriptsize{Advisor: #1} \\}
\newcommand{\phdurl}[1]{\scriptsize{URL: \url{#1}}\end{center}}
\newenvironment{phdabstract}{\@par\addvspace{5pt}}{\@par\addvspace{20pt}\hrule}

\endinput%

%%% Changes History

%%% V1.1

%%%% Changes done based on the update mentioned by Charlotte mail dated Tuesday, January 21, 2020 17:32

%%% arraycolsep changed to 1.5pt to 5pt
%%% Line Numbering activated
%%% Section Numbering activated till paragraph
%%% Quotation environment declared

%%% V1.2

%%%% Changes done based on the update mentioned by Charlotte mail dated Thursday, May 28, 2020 18:39

%%% \maketitle command modified to get the heading like "Functional Pearl" and similarly for other special categories of paper

%%% V1.3

%%%% Changes done based on the update mentioned by Charlotte mail dated Wednesday, 10 June 2020 20:01

%%% \email address text and spacing around the “quote" and “quotation" environments is stretchable at the top and fixed at the bottom

%%% V1.4

%%%% Changes done based on the update mentioned by Charlotte mail dated Thursday, 12 July 2020 15:24

%%% \@pushfilename command was commented to support JFP class file in Ubuntu 20.04
%%% amsmath package used before cleveref package to avoid compilation error generating from TeXLive 2019 and later.
%%%
%%% V1.5

%%%% Changes done based on the update mentioned by Charlotte mail dated July 28, 2021 4:47 PM

%%% \subtitle command was commented
%%% \title command was modified with single argument.

%%% V1.6
%%%% Changes done based on the update mentioned by Charlotte mail dated November 8, 2021 8:57 PM

%%% nolinenum class option defined to remove the linenumbers

%%% V1.7
%%%% Changes done based on the update mentioned by Charlotte mail dated 28 January 2022 19:44 PM

%%% bst file updated for software and online entry in bib
%%% full stop updated after the title in incollection entries

%%% V1.8
%%%% Changes done based on the update mentioned by Charlotte mail dated 23 June 2022 19:26 PM

%%% Table of Contents macro modified to remove \UnicodeCharacter and the "occupational therapy" head (hardwired into the class file)

%%% V1.9
%%%% Changes done based on the update mentioned by Charlotte mail dated 07 March 2023 9:42 PM

%%% Class file to support for LuaLaTex/XeLaTeX manuscript preparation.
