%%
%% This is file `CUP-JNL-QRD.cls',
%% generated with the docstrip utility.
%%
%% The original source files were:
%%
%% classes.dtx  (with options: `CUP-JNL-QRD')
%%
%% This is a generated file.
%%
%% Copyright 1993 1994 1995 1996 1997 1998 1999 2000 2001 2002 2003 2004 2005 2006 2007 2008 2009
%% The LaTeX3 Project and any individual authors listed elsewhere
%% in this file.
%%
%% This file was generated from file(s) of the LaTeX base system.
%% --------------------------------------------------------------
%%
%% It may be distributed and/or modified under the
%% conditions of the LaTeX Project Public License, either version 1.3c
%% of this license or (at your option) any later version.
%% The latest version of this license is in
%%    http://www.latex-project.org/lppl.txt
%% and version 1.3c or later is part of all distributions of LaTeX
%% version 2005/12/01 or later.
%%
%% This file has the LPPL maintenance status "maintained".
%%
%% This file may only be distributed together with a copy of the LaTeX
%% base system. You may however distribute the LaTeX base system without
%% such generated files.
%%
%% The list of all files belonging to the LaTeX base distribution is
%% given in the file `manifest.txt'. See also `legal.txt' for additional
%% information.
%%
%% The list of derived (unpacked) files belonging to the distribution
%% and covered by LPPL is defined by the unpacking scripts (with
%% extension .ins) which are part of the distribution.
%% \CharacterTable
%%  {Upper-case    \A\B\C\D\E\F\G\H\I\J\K\L\M\N\O\P\Q\R\S\T\U\V\W\X\Y\Z
%%   Lower-case    \a\b\c\d\e\f\g\h\i\j\k\l\m\n\o\p\q\r\s\t\u\v\w\x\y\z
%%   Digits        \0\1\2\3\4\5\6\7\8\9
%%   Exclamation   \!     Double quote  \"     Hash (number) \#
%%   Dollar        \$     Percent       \%     Ampersand     \&
%%   Acute accent  \'     Left paren    \(     Right paren   \)
%%   Asterisk      \*     Plus          \+     Comma         \,
%%   Minus         \-     Point         \.     Solidus       \/
%%   Colon         \:     Semicolon     \;     Less than     \<
%%   Equals        \=     Greater than  \>     Question mark \?
%%   Commercial at \@     Left bracket  \[     Backslash     \\
%%   Right bracket \]     Circumflex    \^     Underscore    \_
%%   Grave accent  \`     Left brace    \{     Vertical bar  \|
%%   Right brace   \}     Tilde         \~}
\NeedsTeXFormat{LaTeX2e}[1995/12/01]
\ProvidesClass{CUP-JNL-QRD}[2022/04/28 v0.1: An authoring template for CUP QRD articles]

\newif\if@restonecol
\newif\if@titlepage   \@titlepagefalse
\newif\if@cropmarkson \@cropmarksonfalse
\newif\if@draftruleson\@draftrulesonfalse
\newif\if@ruleron\global\@ruleronfalse

%% Template Options
\DeclareOption{a4paper}{\PassOptionsToPackage{a4}{crop}}
\DeclareOption{a3paper}{\PassOptionsToClass{a3paper}{article}\PassOptionsToPackage{a3}{crop}}
\DeclareOption{centre}{\PassOptionsToPackage{center}{crop}}
\DeclareOption{crop}{\PassOptionsToPackage{frame}{crop}\global\@cropmarksontrue}
\DeclareOption{nocrop}{\PassOptionsToPackage{off}{crop}\global\@cropmarksontrue}
\DeclareOption{info}{\PassOptionsToPackage{info}{crop}}
\DeclareOption{noinfo}{\PassOptionsToPackage{noinfo}{crop}}
\DeclareOption{draftrules}{\global\@draftrulesontrue}
\DeclareOption{ruler}{\global\@rulerontrue}%

%% Classfile Options
\DeclareOption{oneside}{\@twosidefalse \@mparswitchfalse}
\DeclareOption{twoside}{\@twosidetrue  \@mparswitchtrue}
\DeclareOption{draft}{\setlength\overfullrule{5pt}}
\DeclareOption{titlepage}{\@titlepagetrue}
\DeclareOption{notitlepage}{\@titlepagefalse}
\DeclareOption{onecolumn}{\@twocolumnfalse}
\DeclareOption{twocolumn}{\@twocolumntrue}
\DeclareOption{openbib}{\let\if@openbib\iftrue}

\ExecuteOptions{twosidecrop,crop,centre,info,croppage}
\ProcessOptions
\LoadClass[twoside,fleqn]{article}

%% General Packages Used
\RequirePackage{ifpdf}
\RequirePackage{url}
\RequirePackage{soul}
\RequirePackage[table]{xcolor}
\RequirePackage{textcomp}%
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%% Color Defs %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%% rgb colors
\definecolor{Black}{cmyk}{0.0,0.0,0.0,1}
\definecolor{White}{cmyk}{0.0,0.0,0.0,0.0}
\definecolor{gray}{cmyk}{0,0,0,0.2}%
\definecolor{hndrdprcntcolor}{cmyk}{0.69,0.67,0.63,0.74}%{0.65,0.91,0.31,0.18}
\definecolor{twntyprcntcolor}{cmyk}{0.13,0.13,0.12,0.14}% 20%
\definecolor{tenprcntcolor}{cmyk}{0.069,0.067,0.063,0.074}% 10%
\definecolor{shadecolor}{cmyk}{0.069,0.067,0.063,0.074}% 10%

%
%%%%%%%%%%%%%%%%%%%%%%%%%%%% Fonts & Sizes %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%% Fonts Used
\RequirePackage[T1]{fontenc}%
\RequirePackage[type1]{crimson}%
\RequirePackage{sourcesanspro}
%\renewcommand{\sfdefault}{qpl}%
\renewcommand{\ttdefault}{pcr}
\AtBeginDocument{%
\RequirePackage{newtxmath}%
\RequirePackage{datetime}%

\DeclareSymbolFont{numbers}{\encodingdefault}{\rmdefault}{m}{n}
\DeclareSymbolFont{alphabets}{\encodingdefault}{\rmdefault}{m}{it}

\SetSymbolFont{alphabets}{normal}{\encodingdefault}{\rmdefault}{m}{it}
\SetSymbolFont{numbers}{normal}{\encodingdefault}{\rmdefault}{m}{n}

\SetSymbolFont{alphabets}{bold}{\encodingdefault}{\rmdefault}{b}{it}
\SetSymbolFont{numbers}{bold}{\encodingdefault}{\rmdefault}{b}{n}

\DeclareMathSymbol{0}{\mathalpha}{numbers}{"30}
\DeclareMathSymbol{1}{\mathalpha}{numbers}{"31}
\DeclareMathSymbol{2}{\mathalpha}{numbers}{"32}
\DeclareMathSymbol{3}{\mathalpha}{numbers}{"33}
\DeclareMathSymbol{4}{\mathalpha}{numbers}{"34}
\DeclareMathSymbol{5}{\mathalpha}{numbers}{"35}
\DeclareMathSymbol{6}{\mathalpha}{numbers}{"36}
\DeclareMathSymbol{7}{\mathalpha}{numbers}{"37}
\DeclareMathSymbol{8}{\mathalpha}{numbers}{"38}
\DeclareMathSymbol{9}{\mathalpha}{numbers}{"39}

\DeclareMathSymbol{A}{\mathalpha}{alphabets}{"41}
\DeclareMathSymbol{B}{\mathalpha}{alphabets}{"42}
\DeclareMathSymbol{C}{\mathalpha}{alphabets}{"43}
\DeclareMathSymbol{D}{\mathalpha}{alphabets}{"44}
\DeclareMathSymbol{E}{\mathalpha}{alphabets}{"45}
\DeclareMathSymbol{F}{\mathalpha}{alphabets}{"46}
\DeclareMathSymbol{G}{\mathalpha}{alphabets}{"47}
\DeclareMathSymbol{H}{\mathalpha}{alphabets}{"48}
\DeclareMathSymbol{I}{\mathalpha}{alphabets}{"49}
\DeclareMathSymbol{J}{\mathalpha}{alphabets}{"4A}
\DeclareMathSymbol{K}{\mathalpha}{alphabets}{"4B}
\DeclareMathSymbol{L}{\mathalpha}{alphabets}{"4C}
\DeclareMathSymbol{M}{\mathalpha}{alphabets}{"4D}
\DeclareMathSymbol{N}{\mathalpha}{alphabets}{"4E}
\DeclareMathSymbol{O}{\mathalpha}{alphabets}{"4F}
\DeclareMathSymbol{P}{\mathalpha}{alphabets}{"50}
\DeclareMathSymbol{Q}{\mathalpha}{alphabets}{"51}
\DeclareMathSymbol{R}{\mathalpha}{alphabets}{"52}
\DeclareMathSymbol{S}{\mathalpha}{alphabets}{"53}
\DeclareMathSymbol{T}{\mathalpha}{alphabets}{"54}
\DeclareMathSymbol{U}{\mathalpha}{alphabets}{"55}
\DeclareMathSymbol{V}{\mathalpha}{alphabets}{"56}
\DeclareMathSymbol{W}{\mathalpha}{alphabets}{"57}
\DeclareMathSymbol{X}{\mathalpha}{alphabets}{"58}
\DeclareMathSymbol{Y}{\mathalpha}{alphabets}{"59}
\DeclareMathSymbol{Z}{\mathalpha}{alphabets}{"5A}

\DeclareMathSymbol{a}{\mathalpha}{alphabets}{"61}
\DeclareMathSymbol{b}{\mathalpha}{alphabets}{"62}
\DeclareMathSymbol{c}{\mathalpha}{alphabets}{"63}
\DeclareMathSymbol{d}{\mathalpha}{alphabets}{"64}
\DeclareMathSymbol{e}{\mathalpha}{alphabets}{"65}
\DeclareMathSymbol{f}{\mathalpha}{alphabets}{"66}
\DeclareMathSymbol{g}{\mathalpha}{alphabets}{"67}
\DeclareMathSymbol{h}{\mathalpha}{alphabets}{"68}
\DeclareMathSymbol{i}{\mathalpha}{alphabets}{"69}
\DeclareMathSymbol{j}{\mathalpha}{alphabets}{"6A}
\DeclareMathSymbol{k}{\mathalpha}{alphabets}{"6B}
\DeclareMathSymbol{l}{\mathalpha}{alphabets}{"6C}
\DeclareMathSymbol{m}{\mathalpha}{alphabets}{"6D}
\DeclareMathSymbol{n}{\mathalpha}{alphabets}{"6E}
\DeclareMathSymbol{o}{\mathalpha}{alphabets}{"6F}
\DeclareMathSymbol{p}{\mathalpha}{alphabets}{"70}
\DeclareMathSymbol{q}{\mathalpha}{alphabets}{"71}
\DeclareMathSymbol{r}{\mathalpha}{alphabets}{"72}
\DeclareMathSymbol{s}{\mathalpha}{alphabets}{"73}
\DeclareMathSymbol{t}{\mathalpha}{alphabets}{"74}
\DeclareMathSymbol{u}{\mathalpha}{alphabets}{"75}
\DeclareMathSymbol{v}{\mathalpha}{alphabets}{"76}
\DeclareMathSymbol{w}{\mathalpha}{alphabets}{"77}
\DeclareMathSymbol{x}{\mathalpha}{alphabets}{"78}
\DeclareMathSymbol{y}{\mathalpha}{alphabets}{"79}
\DeclareMathSymbol{z}{\mathalpha}{alphabets}{"7A}

\DeclareMathVersion{sans}
\SetSymbolFont{operators}{sans}{\tx@enc}{\rmdefaultB}{\bold@wt}{n}
\SetSymbolFont{largesymbols}{sans}{LMX}{ntxexx}{m}{n}
\SetSymbolFont{symbols}{sans}{LMS}{ntxsy}{m}{n}
\SetSymbolFont{alphabets}{sans}{\encodingdefault}{\sfdefault}{m}{it}
\SetSymbolFont{numbers}{sans}{\encodingdefault}{\sfdefault}{m}{n}
\SetMathAlphabet\mathrm{sans}{\encodingdefault}{\sfdefault}{m}{n}
\SetMathAlphabet\mathbf{sans}{\encodingdefault}{\sfdefault}{b}{n}
\SetMathAlphabet\mathsf{sans}{\encodingdefault}{\sfdefault}{m}{n}
\SetMathAlphabet\mathit{sans}{\encodingdefault}{\sfdefault}{m}{it}

}
%
\DeclareOldFontCommand{\rm}{\normalfont\rmfamily}{\mathrm}
\DeclareOldFontCommand{\sf}{\normalfont\sffamily}{\mathsf}
\DeclareOldFontCommand{\tt}{\normalfont\ttfamily}{\mathtt}
\DeclareOldFontCommand{\bf}{\normalfont\bfseries}{\mathbf}
\DeclareOldFontCommand{\it}{\normalfont\itshape}{\mathit}
\DeclareOldFontCommand{\sl}{\normalfont\slshape}{\@nomath\sl}
\DeclareOldFontCommand{\sc}{\normalfont\scshape}{\@nomath\sc}
\DeclareRobustCommand*\cal{\@fontswitch\relax\mathcal}
\DeclareRobustCommand*\mit{\@fontswitch\relax\mathnormal}

\renewcommand\normalsize{%
   \@setfontsize\normalsize{9.5bp}{11bp}
   \abovedisplayskip 6\p@ \@plus2\p@ \@minus0\p@
   \abovedisplayshortskip 6\p@ \@plus3\p@
   \belowdisplayshortskip 6\p@ \@plus3\p@ \@minus3\p@
   \belowdisplayskip \abovedisplayskip
   \let\@listi\@listI}%
\normalsize
\newcommand\medsize{%
   \@setfontsize\small{8bp}{10bp}%
   \abovedisplayskip 5\p@ \@plus3\p@ \@minus4\p@
   \abovedisplayshortskip \z@ \@plus2\p@
   \belowdisplayshortskip 5\p@ \@plus2\p@ \@minus2\p@
   \def\@listi{\leftmargin\leftmargini
               \topsep 4\p@ \@plus2\p@ \@minus2\p@
               \parsep 2\p@ \@plus\p@ \@minus\p@
               \itemsep \parsep}%
   \belowdisplayskip \abovedisplayskip
}
\renewcommand\small{%
   \@setfontsize\small{8bp}{10bp}%
   \abovedisplayskip 5\p@ \@plus3\p@ \@minus4\p@
   \abovedisplayshortskip \z@ \@plus2\p@
   \belowdisplayshortskip 5\p@ \@plus2\p@ \@minus2\p@
   \def\@listi{\leftmargin\leftmargini
               \topsep 4\p@ \@plus2\p@ \@minus2\p@
               \parsep 2\p@ \@plus\p@ \@minus\p@
               \itemsep \parsep}%
   \belowdisplayskip \abovedisplayskip
}
\renewcommand\footnotesize{%
   \@setfontsize\footnotesize{8bp}{10bp}%
   \abovedisplayskip 5\p@ \@plus2\p@ \@minus4\p@
   \abovedisplayshortskip \z@ \@plus\p@
   \belowdisplayshortskip 3\p@ \@plus\p@ \@minus2\p@
   \def\@listi{\leftmargin\leftmargini
               \topsep 3\p@ \@plus\p@ \@minus\p@
               \parsep 2\p@ \@plus\p@ \@minus\p@
               \itemsep \parsep}%
   \belowdisplayskip \abovedisplayskip
}
%
\renewcommand\scriptsize{\@setfontsize\scriptsize\@ixpt\@ixpt}
\newcommand\scrisize{\@setfontsize\scrisize{9.3}{9}}
\renewcommand\tiny{\@setfontsize\tiny\@vpt\@vipt}
\renewcommand\large{\@setfontsize\large{12}{14}}
\newcommand\larg{\@setfontsize\larg{11}{13}}
\renewcommand\Large{\@setfontsize\Large{16}{18}}
\renewcommand\LARGE{\@setfontsize\LARGE\@xviipt{22}}
\renewcommand\huge{\@setfontsize\huge\@xxpt{25}}
\renewcommand\Huge{\@setfontsize\Huge\@xxvpt{30}}
%
\DeclareMathSizes{\@ixpt}{\@ixpt}{7}{5}
\DeclareMathSizes{\@xpt}{\@xpt}{7}{5}
\DeclareMathSizes{\@xipt}{\@xipt}{7}{5}

\DeclareRobustCommand*\textsubscript[1]{%
  \@textsubscript{\selectfont#1}}%
\def\@textsubscript#1{%
  {\m@th\ensuremath{_{\mbox{\fontsize\sf@size\z@#1}}}}}

%
%%%%%%%%%%%%%%%%%%%%%%%%%%%% Layout Settings %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

\RequirePackage{geometry}

%% Regular Pages (for Opening page - redefined)
%\geometry{paperwidth=210mm,
%    paperheight=280mm,
%    top={49.5pt},%{51.5pt},
%    headheight={7pt},
%    headsep={9.5pt},
%    textwidth={181mm},
%    textheight={240mm},
%    marginparsep=3mm,
%    marginparwidth=10mm,
%    left=43.05pt,
%    %bindingoffset=21pt,
%    footskip=0mm}
%

\newdimen\normbaselineskip
\newdimen\totaltextwidth
\normbaselineskip=11bp

\newbox\topskipht

\setbox\topskipht\hbox{{\normalsize ABCD$^{2}$X}}

\global\setlength{\paperwidth}{210truemm}%
\global\setlength{\paperheight}{280truemm}%
\setlength\topskip   {9\p@}
\setlength{\textheight}{61\normbaselineskip}
%\addtolength{\textheight}{\topskip}
\addtolength{\textheight}{\ht\topskipht}
\addtolength{\textheight}{1pt}
\setlength{\textwidth}{181mm}%
%
\setlength{\oddsidemargin}{15mm}%{54bp}
\setlength{\evensidemargin}{\paperwidth}
\addtolength{\evensidemargin}{-\textwidth}
\addtolength{\evensidemargin}{-\oddsidemargin}
\addtolength{\oddsidemargin}{-1in}
\addtolength{\evensidemargin}{-1in}
%
\setlength{\topmargin}{34.8pt}%
\addtolength{\topmargin}{-1in}
\setlength{\headheight}{8bp}
\setlength{\headsep}{30.5bp}
\addtolength\headsep {-\topskip}%%headsep from Base of RH to Base of First Text Line
\setlength{\footskip}{20pt}
\setlength{\maxdepth}{3pt}
%
\global\columnsep=5mm%
\parskip=\z@%
\parindent=12bp%
%
\totaltextwidth=\textwidth


%%\setlength{\marginparsep}{3mm}%
%%\setlength{\marginparwidth}{10mm}%
%%
%%\setlength\footskip{0\p@}
%%\setlength\maxdepth{3pt}

\setlength{\footnotesep}{7\p@}
\setlength{\skip\footins}{14\p@ \@plus 2 \p@} % \@minus 4\p@

\setlength\parindent{12pt}
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%% Pagination Settings %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Line spacing
\setlength\lineskip{1\p@}
\setlength\normallineskip{1\p@}
\renewcommand\baselinestretch{}
\parskip=0pt

% Page break penalties
\@lowpenalty   51
\@medpenalty  151
\@highpenalty 301

% Disallow widows and orphans
\clubpenalty 10000
\widowpenalty 10000

% Disable page breaks before equations, allow pagebreaks after
% equations and discourage widow lines before equations.
\displaywidowpenalty 100
\predisplaypenalty   10000
\postdisplaypenalty  0

% Set these global demerits
\doublehyphendemerits 1000000   % corresponds to badness 800
\finalhyphendemerits  1000000  % corresponds to badness 1000

% Allow loose lines rather than overfull lines
\vbadness=9999
\tolerance=9999

% Allow breaking the page in the middle of a paragraph
\interlinepenalty 0

% Disallow breaking the page after a hyphenated line
\brokenpenalty 10000

% Hyphenation; don't split words into less than three characters
\lefthyphenmin=3
\righthyphenmin=3

% Float placement parameters

% The total number of floats that can be allowed on a page.
\setcounter{totalnumber}{10}

% The maximum number of floats at the top and bottom of a page.
\setcounter{topnumber}{5}
\setcounter{bottomnumber}{5}

% The maximum part of the top or bottom of a text page that can be
% occupied by floats. This is set so that at least four lines of text
% fit on the page.
\renewcommand\topfraction{.921}
\renewcommand\bottomfraction{.921}

% The minimum amount of a text page that must be occupied by text.
% This should accomodate four lines of text.
\renewcommand\textfraction{.13}

% The minimum amount of a float page that must be occupied by floats.
\renewcommand\floatpagefraction{.887}

% The same parameters repeated for double column output
\renewcommand\dbltopfraction{.88}
\renewcommand\dblfloatpagefraction{.88}

% Space between floats
\setlength\floatsep    {18\p@ \@plus 2\p@ \@minus 2\p@}

% Space between floats and text
\setlength\textfloatsep{19\p@ \@plus 2\p@ \@minus 4\p@}

% Space above and below an inline figure
\setlength\intextsep   {18\p@ \@plus 2\p@ \@minus 2\p@}

% For double column floats
\setlength\dblfloatsep    {20\p@ \@plus 2\p@ \@minus 2\p@}
\setlength\dbltextfloatsep{18\p@ \@plus 2\p@ \@minus 4\p@}

\hyphenation{Figure Figures Table Tables Equation Equations Section Sections Appendix Theorem Lemma}

%
\newdimen\CP@toff@wd
\newdimen\CP@toff@ht
%
\newdimen\CP@boff@wd
\newdimen\CP@boff@ht
%
\newdimen\CP@crop@wd
\newdimen\CP@crop@ht
%
\newdimen\CP@bled@wd
\newdimen\CP@bled@ht
%
\newdimen\CP@trim@wd
\newdimen\CP@trim@ht
%
\def\str@yes{yes}
\def\SetCrop#1#2{%
    \gdef\IsCropSet{yes}
    \global\CP@crop@wd=#1\relax
    \global\CP@crop@ht=#2\relax}
\def\SetTrim#1#2{%
    \gdef\IsTrimSet{yes}
    \global\CP@trim@wd=#1\relax
    \global\CP@trim@ht=#2\relax}
\def\SetBleed#1#2{%
    \gdef\IsBleedSet{yes}
    \global\CP@bled@wd=#1\relax
    \global\CP@bled@ht=#2\relax}
%
\everyjob\expandafter{%
    \the\everyjob
    \typeout{%
        \filename\space <\filedate>^^J
        Version: v\fileversion^^J
        LaTeX macros for setting Page Box parameters
    }%
  \IfFileExists{\filename.cfg}{%
        \begingroup\@@input\@filef@und\endgroup
    }{%
        \typeout{No File: \filename.cfg}%
    }%
  \IfFileExists{\jobname.cfg}{%
        \begingroup\@@input\@filef@und\endgroup
    }{%
        \typeout{No File: \jobname.cfg}%
    }%
}
%
    \SetCrop{209.21mm}{278.95mm}%
    \SetTrim{209.21mm}{278.95mm}%
    \SetBleed{0mm}{0mm}%
%
\def\do@pagebox@calc{%
    \CP@toff@wd=\CP@crop@wd
    \advance\CP@toff@wd     by -\CP@trim@wd
    \divide\CP@toff@wd  by \tw@
%
    \CP@toff@ht=\CP@crop@ht
    \advance\CP@toff@ht     by -\CP@trim@ht
    \divide\CP@toff@ht  by \tw@
%
    \advance\CP@trim@wd     by \CP@toff@wd
    \advance\CP@trim@ht     by \CP@toff@ht
%
    \CP@boff@wd=\CP@toff@wd
    \advance\CP@boff@wd     by -\CP@bled@wd
%
    \CP@boff@ht=\CP@toff@ht
    \advance\CP@boff@ht     by -\CP@bled@ht
%
    \advance\CP@bled@wd     by \CP@trim@wd
    \advance\CP@bled@ht     by \CP@trim@ht
}
%
\def\pdf@page@parameters{%
    \ifx\IsCropSet\str@yes
        [{ThisPage} << /CropBox [0 0 \strip@pt\CP@crop@wd\space \strip@pt\CP@crop@ht] >> /PUT pdfmark
        [{ThisPage} << /MediaBox[0 0 \strip@pt\CP@crop@wd\space \strip@pt\CP@crop@ht] >> /PUT pdfmark
    \fi
    \ifx\IsTrimSet\str@yes
        [{ThisPage} << /TrimBox [\strip@pt\CP@toff@wd\space \strip@pt\CP@toff@ht\space \strip@pt\CP@trim@wd\space \strip@pt\CP@trim@ht] >> /PUT pdfmark
    \fi
    \ifx\IsBleedSet\str@yes
        [{ThisPage} << /BleedBox[\strip@pt\CP@boff@wd\space \strip@pt\CP@boff@ht\space \strip@pt\CP@bled@wd\space \strip@pt\CP@bled@ht] >> /PUT pdfmark
    \fi
}

\def\shipout@PageObjects{%
    \special{ps: \pdf@page@parameters}%
}
%%
\AtBeginDocument{%
    \do@pagebox@calc
    \let\org@begindvi\@begindvi
    \def\@begindvi{%
        \shipout@PageObjects
        \org@begindvi
        \global\let\@begindvi\rest@dvi@pages
    }%
}
\let\rest@dvi@pages\shipout@PageObjects
%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Draftrules %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\RequirePackage{showframe}
\newcount\ruleadj\ruleadj=6
\newdimen\pageheight\pageheight\textheight%
\advance\pageheight\ruleadj pt%
\renewcommand\ShowFramePicture{%
\begingroup
\normalcolor\thinlines%
\if@draftruleson%
    \AtTextLowerLeft{%
      \put(0,0){%
        \framebox(\LenToUnit{\textwidth},\LenToUnit{\textheight}){}}}%
    \AtTextUpperLeft{%
      \put(0,\LenToUnit{\headsep}){%
        \framebox(\LenToUnit{\textwidth},\LenToUnit{\headheight}){}}}%
    \AtTextLowerLeft{%
      \put(0,\LenToUnit{-\footskip}){%
        \line(1,0){\LenToUnit{\textwidth}}}}%
\else%
    \AtTextLowerLeft{}%
    \AtTextUpperLeft{}%
    \AtTextLowerLeft{}%
\fi%
    \AtTextLowerLeft{%
      \@tempdima=\textwidth\advance\@tempdima\marginparsep%
      \if@twoside%
        \ifodd\c@page\else%
          \if@mparswitch
            \@tempdima=-\marginparsep\advance\@tempdima-\marginparwidth%
          \fi
        \fi%
      \fi%
      %\put(\LenToUnit{\@tempdima},0)%
      %  {\framebox(\LenToUnit{\marginparwidth},\LenToUnit{\textheight}){}}%
    }%
    \endgroup}%
%\fi
%
%%%%%%%%%%%%%%%%%%%%% Ruler %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\if@ruleron
\RequirePackage{vruler}
%\setvruler[12.043pt][1][1][2][0][20pt][20pt][-26.55pt][10pc]%[3.5pt]
\setvruler[11bp][1][1][2][0][20pt][20pt][6.5bp][\textheight]%

\def\makevruler[#1][#2][#3][#4][#5]{\begingroup\offinterlineskip
\textheight=#5\vbadness=10000\vfuzz=120ex\overfullrule=0pt%
\global\setbox\bufferbox=\vbox to \textheight{%
{\parskip=0pt\hfuzz=150em\b@xheight=\textheight
\lineh@ight=#1\global\rulercount=#2%
\tot@l\b@xheight\divide\tot@l\lineh@ight\advance\tot@l2%
\refn@1\vskip-\lineh@ight\vskip1ex%
\loop\setbox\tempb@x=\hbox to0cm{{\reset@font\normalcolor\normalsize\hfil\fillzeros[#4]\rulercount}}%
\ht\tempb@x\lineh@ight\dp\tempb@x0pt\box\tempb@x\break
\advance\refn@1\global\advance\rulercount#3\relax
\ifnum\refn@<\tot@l\repeat}}\endgroup}

\fi
%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%% Math Settings %%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%% For above/below spacing
\def\eqnarray{%
   \stepcounter{equation}%
   \def\@currentlabel{\p@equation\theequation}%
   \global\@eqnswtrue
   \m@th
   \global\@eqcnt\z@
   \tabskip\@centering
   \let\\\@eqncr
   $$\everycr{}\halign to\displaywidth\bgroup
       \hskip\@centering$\displaystyle\tabskip\z@skip{##}$\@eqnsel
      &\global\@eqcnt\@ne\hskip \tw@\arraycolsep \hfil${##}$\hfil
      &\global\@eqcnt\tw@ \hskip \tw@\arraycolsep
         $\displaystyle{##}$\hfil\tabskip\@centering
      &\global\@eqcnt\thr@@ \hb@xt@\z@\bgroup\hss##\egroup
         \tabskip\z@skip
      \cr
}
\def\endeqnarray{%
      \@@eqncr
      \egroup
      \global\advance\c@equation\m@ne
   $$\@ignoretrue
}
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Color Definitions %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
\definecolor{tenprcntblack}{cmyk}{0,0,0,0.1}
\definecolor{fiftnprcntblack}{cmyk}{0,0,0,0.15}
\definecolor{twntyfiveprcntblk}{cmyk}{0,0,0,0.25}% 50% black
\definecolor{fortyprcntblk}{cmyk}{0,0,0,0.4}% 50% black
\definecolor{seventyprcntblk}{cmyk}{0,0,0,0.7}% 50% black
%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%% Titles %%%%%%%%%%%%%%%%%%%%%%%%%%%
%

\renewcommand\contentsname{Contents}
\renewcommand\listfigurename{List of Figures}
\renewcommand\listtablename{List of Tables}
\renewcommand\refname{References}
\renewcommand\indexname{Index}
\renewcommand\figurename{Figure}
\renewcommand\tablename{Table}
\renewcommand\partname{Part}
\renewcommand\appendixname{Appendix}
\renewcommand\abstractname{Abstract}

%
%%%%%%%%%%%%%%%%%%%%%%%%%%% Article Front Matter %%%%%%%%%%%%%%%%%%%%%%%%%%%
%

%% Article Type
\sodef\letterspacetwty{}{.13em}{.4em plus1em}{.5em plus 1em minus1em }
\def\articletype#1{\gdef\ArtType{{#1}}\gdef\@ArtType{#1}}%\letterspacetwty
\articletype{ARTICLE}%

%% Meta Info
\def\@artid{xx}
\def\@jname{xxx xxx}
\def\@jvol{xx}
\def\@jissue{xx}
\def\@jyear{{0000}}
\def\@jmonth{xx}
\def\@DOI{}
\def\@logourl{}
%
\def\artid#1{\gdef\@artid{#1}}
\def\jname#1{\markboth{\textit{#1}}{\textit{#1}}\gdef\@jname{#1}}
\def\jvol#1{\gdef\@jvol{#1}}
\def\jissue#1{\gdef\@jissue{#1}}
\def\jyear#1{\gdef\@jyear{#1}}
\def\jmonth#1{\gdef\@jmonth{#1}}
\def\jdoi#1{\gdef\@DOI{\href{https://doi.org/#1}{https://doi.org/#1}}}
\def\jrName#1{\gdef\@jrName{#1}}

\jrName{www.cambridge.org/qrd}
\jdoi{10.1017/xxxx}
\jname{Data/Math}%
%

%%% Font Def
\definecolor{chapcolor}{cmyk}{1,0.89,0.06,0.02}%{1,0.89,0.06,0.02}

\def\Titlefont{\fontfamily{\sfdefault}\fontsize{18bp}{20bp}\selectfont\color{chapcolor}\raggedright}
\def\Artcatfont{\sffamily\fontsize{11.5bp}{13.5bp}\selectfont\color{chapcolor}\bfseries}
\def\Authorfont{\sffamily\fontsize{10.5bp}{16bp}\selectfont}
\def\addressfont{\rmfamily\fontsize{7.5bp}{10bp}\selectfont\rightskip0pt plus1fill}
\def\abstractheadfont{\sffamily\bfseries\fontsize{9.25bp}{11bp}\selectfont}%
%%\def\abstractsubheadfont{\fontfamily{\rmdefault}\fontsize{9}{11}\fontseries{b}\selectfont}%
\def\abstractfont{\rmfamily\fontsize{9.25bp}{11bp}\selectfont}%
\def\keywordfont{\sffamily\fontsize{7.25bp}{9bp}\selectfont\raggedright}%
\def\historyfont{\sffamily\fontsize{7.25bp}{9bp}\selectfont\raggedright}

%% Article Title
%\def\title#1{\gdef\@title{#1}}

\renewcommand{\title}[2][]{%
\gdef\@checktitle{#1}\ifx\@checktitle\empty\gdef\@title{#2}
\gdef\s@title{#2}\else\gdef\@title{#2}\gdef\s@title{#1}\fi}

%% Cross Link for Author & Address
\def\jmkLabel#1{\@bsphack\protected@write\@auxout{}{\string\Newlabel{#1}{\@currentlabel}}\@esphack}
\def\Newlabel#1#2{\expandafter\xdef\csname X@#1\endcsname{#2}}
\def\jmkRef#1{\@ifundefined{X@#1}{0}{\csname X@#1\endcsname}}

%% Article Author(s)
\let\sep\@empty%
\let\authorsep\@empty%
\newcount\aucount%
\newcount\punctcount%
\def\author{\advance\aucount by 1\@ifstar\@@corrauthor\@@author}%
\def\au@and{\ifnum\punctcount=2\ and\else\unskip,\advance\punctcount by -1 \fi}%
\def\artauthors{}
\newif\if@auemail%
\newcommand{\@@author}[2][]{\def\@authfrstarg{#1}\g@addto@macro\artauthors{%
    \ifnum\aucount=1%
    \global\@auemailtrue%
    \else%
    \global\@auemailfalse%
    \fi%
    \Authorfont%
    \def\baselinestretch{1}%
    \authorsep{#2}\unskip\ifx\@authfrstarg\empty\else\textsuperscript{\smash{{%
      \@for\@@affmark:=#1\do{\edef\affnum{\@ifundefined{X@\@@affmark}{1}{\jmkRef{\@@affmark}}}%
     \unskip\sep\hyperlink{jrn:\affnum}{\affnum}\let\sep=,}}}}\fi%
    \def\authorsep{\au@and~}%%%
    \global\let\sep\@empty\global\let\@corref\@empty%
}}%

\newcommand{\@@corrauthor}[2][]{\gdef\@corrauthname{#2}\def\@authfrstarg{#1}\g@addto@macro\artauthors{%
    \global\@auemailtrue%
    \Authorfont%
    \def\baselinestretch{1}%
    \authorsep{#2}\unskip\ifx\@authfrstarg\empty\else\textsuperscript{\smash{{%
      \@for\@@affmark:=#1\do{\edef\affnum{\@ifundefined{X@\@@affmark}{1}{\jmkRef{\@@affmark}}}%
     \unskip\sep\hyperlink{jrn:\affnum}{\affnum}\let\sep=,}}}}\fi%\hyperlink{jrn:corresp}{*}
    \def\authorsep{\au@and~}%%%
    \global\let\sep\@empty\global\let\@corref\@empty%
}}%
%
\RequirePackage{ltxcmds}%
\def\authororcid#1{%
\ltx@ifpackageloaded{hyperref}{\href{https://orcid.org/#1}{\includegraphics{orcid_logo}}}{{\includegraphics{orcid_logo}}}%
}
\newcommand{\orcid}[1]{\protect\g@addto@macro\artauthors{%
\authororcid{#1}%
}}
%
%% Author Email
\newif\ifcorrauth
\def\addressrule{\kern-10\p@ \hrule \@height.15pt \@width\marginparwidth \kern 1.6\p@}%
\def\@email{}
\DeclareUrlCommand\myemail{}%
\def\email#1{{\hbox{Email:}~}\ltx@ifpackageloaded{hyperref}{\textcolor{blue}}{}{\protect\myemail{#1}}}%
\let\nomail\relax

%% Corrseponding Address
\def\@copycorthanks{}
\def\auaddress{}
\def\@auaddress{}
\newcounter{affn}
\renewcommand\theaffn{\arabic{affn}}
\def\address{\@ifstar\@@coraddress\@@address}
\newcount\addcount% To check the count of address
\newcommand{\@@coraddress}[2][]{\advance\addcount by 1%
\g@addto@macro\auaddress{%
     \stepcounter{affn}%
     \xdef\@currentlabel{\theaffn}%
     \jmkLabel{\theaffn}%
     {\textsuperscript{#1}#2}}
}

%% Author Address
\def\addsep{\par\vskip0pt}
\newcount\addcount% To check the count of address
\newcommand{\@@address}[2][]{\def\@adrsfrstarg{#1}\advance\addcount by 1\g@addto@macro\auaddress{\ifx\@adrsfrstarg\@empty\else\hypertarget{jrn:#1}{}\fi%
     \stepcounter{affn}%
     \xdef\@currentlabel{\theaffn}%
     \jmkLabel{\theaffn}%
     \ifnum\addcount=2\else\ifnum\theaffn=1\else;\space\fi\fi{\textsuperscript{#1}#2}}%\theaffn
}


%% Address tagging
\newcommand{\orgdiv}[1]{#1}%
\newcommand{\orgname}[1]{#1}%
\newcommand{\orgaddress}[1]{#1}%
\newcommand{\street}[1]{#1}
\newcommand{\postcode}[1]{#1}
\newcommand{\city}[1]{#1}
\newcommand{\state}[1]{#1}
\newcommand{\country}[1]{#1}

%%% corresponding author
\newcommand\corresp[1]{\gdef\@corresp{#1}}
\def\@corresp{}

%% Author name in Running Head
\def\@authormark{}%
\def\authormark#1{\markright{{{#1}}}\gdef\@authormark{\def\etal{{et al.}}#1}\gdef\@authormarkforcite{\def\etal{\textit{et al.}}#1}}%
\def\etal{\textit{et al.}}

%% Optional Text
\def\artnotefont{\reset@font\fontfamily{\rmdefault}\fontsize{8.6}{13}\selectfont\raggedright}
\def\artnote#1{\gdef\@Artnote{#1}}\artnote{}%

%% Article Abstract
\RequirePackage{framed}

\renewenvironment{snugshade}{%
  \def\FrameCommand##1{\FrameSep=9pt\fboxsep=\FrameSep\hskip\@totalleftmargin%\hskip-\fboxsep
  \colorbox{shadecolor}{##1}%\hskip-\fboxsep
      % There is no \@totalrightmargin, so:
      \hskip-\linewidth
      \hskip-\@totalleftmargin
      \hskip\columnwidth}%
  \MakeFramed {\advance\hsize-\width
    \@totalleftmargin\z@ \linewidth\hsize
    \@setminipage}%
 }{\par\unskip\@minipagefalse\endMakeFramed}
%

%%\newcommand\abstracthead{\@startsection {section}{1}{\z@}{-22pt \@plus2ex \@minus0ex}{0.0001pt}{\abstractheadfont}}
%%\newcommand\subabstracthead{\@startsection{subsection}{2}{\z@}{3pt \@plus0ex \@minus0ex}{-.5em}{\abstractsubheadfont}}

\def\@abstract{}%
\long\def\abstract#1{\def\@abstract{%
%\let\paragraph\subabstracthead%
%\abstractfont%
%\abstracthead*{\abstractname}\par%
#1\par}}%

\def\abstracthead#1{\noindent{{\abstractheadfont #1}}}%%
\definecolor{shadecolor}{cmyk}{0.10,0.06,0.02,0}
\renewenvironment{snugshade}{%
  \def\FrameCommand##1{\hskip\@totalleftmargin%\hskip-\fboxsep
  \colorbox{shadecolor}{##1}%\hskip-\fboxsep
      % There is no \@totalrightmargin, so:
      \hskip-\linewidth
      \hskip-\@totalleftmargin
      \hskip\columnwidth}%
  \MakeFramed {\advance\hsize-\width
    \@totalleftmargin\z@ \linewidth\hsize
    \@setminipage}%
 }{\par\unskip\@minipagefalse\endMakeFramed}
%
\newenvironment{Abstract}[1][\abstractname]{\nointerlineskip\par\vspace*{4pt}\nointerlineskip%
\setlength{\fboxsep}{6pt}%
\begin{snugshade}\parindent\z@%
\par\vskip-1.5pt%
\noindent\abstracthead{\abstractname}\par\vskip3pt%
\abstractfont\ignorespaces}%
{\par\vspace*{-0.15pt}\end{snugshade}\par\vskip17.2pt}


%%\def\printabstract{\ifx\@abstract\empty\else\par\vspace*{4pt}\begin{snugshade}\@abstract\par\vspace*{-2pt}\end{snugshade}\fi\par}%
\def\printabstract{\ifx\@abstract\empty\else\par\begin{Abstract}\@abstract\par\end{Abstract}\fi}%

\def\printkeywords{\ifx\@keywords\empty\else\@keywords\fi\par}%

%
%% Keywords
\def\keywordname{Keywords}
\newcommand{\keywords}[2][\keywordname]{%
\g@addto@macro\@keywords{\par\addvspace{8.5bp}{\keywordfont\textbf{#1:}\par #2\par\vskip8.5pt}}}
\def\@keywords{}
\newcommand{\codes}[2][Primary]{\textit{#1} -- #2}%

%%%%%%%%%%%%%%%%%%%%%%%%%%% Article History  %%%%%%%%%%%%%%%%%%%%
%
\newcommand{\received}[2][Received]{\g@addto@macro\@history{{{#1}: #2}}}%
\newcommand{\revised}[2][Revised]{\g@addto@macro\@history{{\par {#1}: #2}}}%
\newcommand{\accepted}[2][Accepted]{\g@addto@macro\@history{{\par {#1}: #2}}}%
%
%
\def\@history{}
\def\printhistory{{\par\vskip8.5bp%
\historyfont\noindent%
\ifx\@history\empty\gdef\@history{Received xx xxx xxxx}\fi\@history\par}
}%
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Article Header Definition
%%
\newdimen\copstubcolheight
\copstubcolheight=\textheight
\advance\copstubcolheight by 45pt
%
\newskip\pmalogoskip
\pmalogoskip=0pt
%%
\renewcommand{\@maketitle}
{\null\vskip-51.5pt\nointerlineskip%%
\llap{\vbox to 0pt{\vskip7pt\hsize=55mm\hskip-4mm\parbox[t]{50mm}{\vbox to \copstubcolheight{\hsize=50mm%\hspace*{-13.02pc}
\urlstyle{sf}%
    {\reset@font\sffamily\fontsize{11.5bp}{13.5bp}\selectfont\raggedright\color{chapcolor}\itshape\@jname\par}\vskip20bp%%\iflogoafterjrnname\vskip5pt\else\vskip20.07pt\fi
    {\reset@font\sffamily\fontsize{9bp}{11bp}\selectfont\bfseries\@jrName\par}\vskip37.7bp%
    {\reset@font\Artcatfont\ArtType\par}\vskip8.55pt%
    {\par\reset@font\sffamily\fontsize{7.25bp}{9bp}\selectfont\raggedright\textbf{Cite this
    article:}~{\@citthisartauthors}\ \textit{\@jname}\ % {\let\newline\relax``\@title.''}\ \textit{\@jname}, %\textbf{\@jrvol:}\@jrno, \thepage--\pageref*{LastPage}
    \@DOI\par%%\vskip8.5bp
        \printhistory%%
        \printkeywords%
%%        \ifx\@corresponding\@empty\else\@corresponding\par\fi%\textbf{Corresponding author:}\par
        \ifx\@corresp\@empty\else\textbf{Corresponding author:}\par \hbox{\@corrauthname;} \hbox{\@corresp}\par\fi
    }%\vskip9.6pt
    %%%%%%%%%
    \vfill%\iflogoafterjrnname\vspace*{22.58pc}\else\vspace*{20.905pc}\fi\vspace*{\bottomlogobelowskip}
    {\par\reset@font\sffamily\fontsize{7.25pt}{9pt}\selectfont\raggedright\printcopyright{\@copyrighttext}\par}\vskip24bp%\iflogoafterjrnname\else\vskip25.4pt%
    \includegraphics{CUP-logo.eps}\par\vskip11.5pt%\vskip\pmalogoskip%
    %\fi%
}}\hfill\hbox{}}}%
%%%%
\noindent{{%
    \parindent0pt%
    %% Aritle Title
    \ifx\@title\empty\else%
        \noindent{\color{chapcolor}{{\Titlefont\rightskip 0pt plus1fill \@title\par}}}
        %\addcontentsline{toc}{chapter}{\@title}% for bookmarks
    \fi%
    %% Aritle Authors, Address and Correspondings
    \ifnum\aucount>0
        \global\punctcount\aucount%
        \vskip8.1pt%
        \par{\color{chapcolor}{\rule{\textwidth}{0.5bp}}}\par\vskip-3pt%
        {\artauthors\vphantom{Sp}\par}\nointerlineskip%
        \vskip5pt{\color{chapcolor}{\rule{126mm}{0.5pt}}}\par\vskip3pt%
        {\addressfont\auaddress\par\vskip3pt%%      corresponding adress
        %%\ifx\@corresp\@empty\else\textbf{Corresponding author:}~\@corrauthname;~\@corresp\par\fi%\hypertarget{jrn:corresp}{}*
        }
     \fi%
     %%{\printhistory\par}%
     %%{\printabstract\par}%
    %% {\printkeywords\par}%
    }}\par\addvspace{0pt}}

%% Printing Article Header
\renewcommand\maketitle{\par
  \@afterindentfalse%
  \begingroup
    \gdef\UrlFont{\rmfamily}%
    \renewcommand\thefootnote{\@fnsymbol\c@footnote}%
    \def\@makefnmark{\rlap{\@textsuperscript{\normalfont\smash{\@thefnmark}}}}%
    \long\def\@makefntext##1{\parindent 1em\noindent\small\selectfont
            \hbox{\@textsuperscript{\normalfont\@thefnmark}}##1}%
    \if@twocolumn
      \ifnum \col@number=\@ne%
        \twocolumn[\@maketitle]%
      \else
        \twocolumn[\@maketitle]%
      \fi%
    \else%
      \newpage%
      \global\@topnum\z@% Prevents figures from going at top of page.
      \@maketitle%
    \fi%
    \thispagestyle{empty}%{titlepage}
    \printabstract%
  \endgroup%
%%  \bgroup%
%%  \renewcommand\@makefntext[1]{\bgroup\fontsize{7bp}{9bp}\selectfont\noindent##1\vphantom{y}\par\egroup}%
%%  \printcopyright{\footnotetext{\@copyrighttext}}%
%%  \egroup
%%  \global\advance\opshortpage23pt%
  \setcounter{footnote}{0}%
  \global\let\thanks\relax%
  \global\let\maketitle\relax%
  \global\let\@maketitle\relax%
  %\global\let\@thanks\@empty%
  \global\let\@author\@empty%
  \global\let\@date\@empty%
  %\global\let\@title\@empty%
  \global\let\title\relax%
  \global\let\author\relax%
  \global\let\date\relax%
  \global\let\and\relax
  %%%print continuous abstract on next page
  \@afterheading}%

\newif\if@Backmtter\global\@Backmtterfalse

\newenvironment{Frontmatter}{\par}{\maketitle\par}

\newenvironment{Backmatter}{\global\@Backmttertrue\par\fontsize{8bp}{10bp}\selectfont%
%\def\sectionfont{\fontfamily{\rmdefault}\fontsize{10}{12}\fontseries{b}\selectfont\raggedright}
\def\paragraphfont{\fontfamily{\sfdefault}\fontsize{8bp}{10bp}\selectfont\bfseries\color{chapcolor}\raggedright}
%
\renewcommand\paragraph{\@startsection{paragraph}{4}{\z@}%
                                    {8pt \@plus0pt \@minus0pt}%
                                    {-4pt}%
                                    {\paragraphfont}}
\def\bibfont{\fontsize{8bp}{10bp}\selectfont}%
%
}{\par}
%
\def\bysame{\leavevmode\hbox to3em{\hrulefill}}

%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Page Styles %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
\def\opheaderfont{\fontsize{7bp}{10bp}\selectfont}
\def\headerfont{\sffamily\fontsize{9bp}{11bp}\selectfont}
\def\footerfont{\sffamily\fontsize{9bp}{11bp}\selectfont}


%% Regular Page Style
\def\ps@headings{%
    \def\@oddfoot{\hfill}
    \let\@evenfoot\@oddfoot
      \def\@evenhead{{\headerfont\thepage\hfill{\rightmark}}}%
      \def\@oddhead{{\headerfont\textit{\leftmark}\hfill\thepage}}%
      \let\@mkboth\markboth%
      }

\newdimen\opshortpage%
\newif\if@prntcpyrghtline\global\@prntcpyrghtlinefalse
\def\printcopyright#1{\global\@prntcpyrghtlinefalse#1}%%

%%\def\copyrightline#1{\def\@copyrighttext{\begin{minipage}[t]{\textwidth}\footerfont #1\par\end{minipage}}}
\def\copyrightline#1{\def\@copyrighttext{#1}}
\copyrightline{\textcopyright\ The Author(s) 2020. This is an Open Access article, distributed under the terms of the Creative Commons Attribution licence (http://
creativecommons.org/licenses/by/4.0/), which permits unrestricted re-use, distribution, and reproduction in any medium, provided the original work is
properly cited.
}%

\AtEndDocument{\label{LastPage}}
%%\def\@opjournalheader{\textit{\@jname}\space\ {{(\@jyear),\ \textbf{\@jvol},}} {\thepage{--}\pageref*{LastPage}}\\
%%{\@DOI}}%
%%
%%%% Opening Page Style
%%\def\ps@titlepage{%
%%     \def\@oddhead{{\hbox to \textwidth{%
%%      \vbox to 0pt{\vskip-5pt\rlap{\hbox to \textwidth{\hfill\includegraphics{CUP-Logo.eps}}}}%
%%      \vbox to 0pt{\vskip-7.5pt\rlap{\parbox{\textwidth}{\opheaderfont\begin{tabular*}{\textwidth}[t]{@{\extracolsep{\fill}}@{}l@{}}%
%%      \@opjournalheader%
%%      \end{tabular*}}}}%
%%      }}}%
%%     \let\@evenhead\@oddhead%
%%     \def\@oddfoot{}%\vbox to 0pt{\vskip-\opshortpage{\printcopyright{\@copyrighttext}}}}%%
%%     \let\@evenfoot\@oddfoot}%
%%
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Sections %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
\def\numbered{\setcounter{secnumdepth}{3}}
\def\unnumbered{\setcounter{secnumdepth}{0}}
\numbered%% default is unnumbered Sections

\newcounter {chapter}[part]% for bookmarks
\renewcommand\thepart         {\@Roman\c@part}
\renewcommand\thesection      {\@arabic\c@section}
\renewcommand\thesubsection   {\thesection.\@arabic\c@subsection}
\renewcommand\thesubsubsection{\thesubsection.\@arabic\c@subsubsection}
\renewcommand\theparagraph    {\thesubsubsection.\@arabic\c@paragraph}
\renewcommand\thesubparagraph {\theparagraph.\@arabic\c@subparagraph}
%%
\renewcommand\part{\par
   \addvspace{4ex}%
   \@afterindentfalse
   \secdef\@part\@spart}
%%
\def\@part[#1]#2{%
    \ifnum \c@secnumdepth >\m@ne
      \refstepcounter{part}%
      \addcontentsline{toc}{part}{\thepart\hspace{1em}#1}%
    \else
      \addcontentsline{toc}{part}{#1}%
    \fi
    {\parindent \z@ \raggedright
     \interlinepenalty \@M
     \normalfont
     \ifnum \c@secnumdepth >\m@ne
       \Large\bfseries \partname~\thepart
       \par\nobreak
     \fi
     \huge \bfseries #2%
     \markboth{}{}\par}%
    \nobreak
    \vskip 3ex
    \@afterheading}

\def\@spart#1{%
    {\parindent \z@ \raggedright
     \interlinepenalty \@M
     \normalfont
     \huge \bfseries #1\par}%
     \nobreak
     \vskip 3ex
     \@afterheading}

\def\@sect#1#2#3#4#5#6[#7]#8{%
  \ifnum #2>\c@secnumdepth
    \let\@svsec\@empty
  \else
    \refstepcounter{#1}%
    \protected@edef\@svsec{\@seccntformat{#1}\relax}%
  \fi
  \@tempskipa #5\relax
  \ifdim \@tempskipa>\z@
    \begingroup
      #6{%
        \noindent{\hskip #3\relax\@svsec}%\@hangfrom
          \interlinepenalty \@M #8\@@par}%
    \endgroup
    \csname #1mark\endcsname{#7}%
    \addcontentsline{toc}{#1}{%
      \ifnum #2>\c@secnumdepth \else
        \protect\numberline{\csname the#1\endcsname}%
      \fi
      #7}%
  \else
    \def\@svsechd{%
      #6{\hskip #3\relax
      \@svsec #8.}%
      \csname #1mark\endcsname{#7}%
      \addcontentsline{toc}{#1}{%
        \ifnum #2>\c@secnumdepth \else
          \protect\numberline{\csname the#1\endcsname}%
        \fi
        #7}}%
  \fi
  \@xsect{#5}}
%
\def\sectionfont{\fontfamily{\sfdefault}\fontsize{9.5bp}{11bp}\selectfont\bfseries\color{chapcolor}\raggedright}
\def\subsectionfont{\fontfamily{\sfdefault}\fontseries{sb}\fontshape{it}\fontsize{9.5bp}{11bp}\selectfont\color{chapcolor}\raggedright}
\def\subsubsectionfont{\fontfamily{\sfdefault}\fontsize{9.5bp}{11bp}\selectfont\itshape\color{chapcolor}\raggedright}
\def\paragraphfont{\fontfamily{\rmdefault}\fontsize{10bp}{12bp}\selectfont}
\def\subparagraphfont{\fontfamily{\rmdefault}\fontsize{10bp}{12bp}\selectfont\raggedright}

\def\@seccntformat#1{{\csname the#1\endcsname.}\hskip.45em}

\renewcommand\section{\@startsection {section}{1}{\z@}%
                                   {-16.5bp \@plus -1pt}%
                                   {5.5bp}%
                                   {\sectionfont}}
\renewcommand\subsection{\@startsection{subsection}{2}{\z@}%
                                     {-15.5bp \@plus -1pt}%
                                     {5.5bp}%
                                     {\subsectionfont}}
\renewcommand\subsubsection{\@startsection{subsubsection}{3}{\z@}%
                                     {-11pt \@plus 1pt}%
                                     {0.001pt}%
                                     {\subsubsectionfont}}
\renewcommand\paragraph{\@startsection{paragraph}{4}{\z@}%
                                    {-14pt  \@plus -1pt}%
                                    {-3.5pt}%
                                    {\paragraphfont}}
\renewcommand\subparagraph{\@startsection{subparagraph}{5}{\z@}%
                                       {-6pt \@plus -1pt}%
                                       {0.001pt}%
                                     {\subparagraphfont}}
%
\def\@startsection#1#2#3#4#5#6{%
  \if@noskipsec \leavevmode \fi
  \par
  \@tempskipa #4\relax
  \@afterindenttrue
  \ifdim \@tempskipa <\z@
    \@tempskipa -\@tempskipa \@afterindentfalse
  \fi
  \if@nobreak
    \everypar{}\ifnum#2=2\fi%
  \else
    \addpenalty\@secpenalty\addvspace\@tempskipa%%\if@Backmtter\global\@Backmtterfalse\ifnum#2=4\addvspace{15pt}\fi\fi%
  \fi
  \@ifstar
    {\@ssect{#3}{#4}{#5}{#6}}%
    {\@dblarg{\@sect{#1}{#2}{#3}{#4}{#5}{#6}}}}
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Lists %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

\newdimen\labelwidthi
\newdimen\labelwidthii
\newdimen\labelwidthiii
\newdimen\labelwidthiv
\def\normal@labelsep{0.5em}
\labelsep\normal@labelsep
\settowidth{\labelwidthi}{(iii)}
\settowidth{\labelwidthii}{(d)}
\settowidth{\labelwidthiii}{(iii)}
\settowidth{\labelwidthiv}{(M)}
\leftmargini\labelwidthi    \advance\leftmargini\labelsep
\leftmarginii\labelwidthii  \advance\leftmarginii\labelsep
\leftmarginiii\labelwidthiii \advance\leftmarginiii\labelsep
\leftmarginiv\labelwidthiv  \advance\leftmarginiv\labelsep
\def\setleftmargin#1#2{\settowidth{\@tempdima}{#2}\labelsep\normal@labelsep
  \csname labelwidth#1\endcsname\@tempdima
  \@tempdimb\@tempdima \advance\@tempdimb\labelsep
  \csname leftmargin#1\endcsname\@tempdimb}
\def\@listI{\leftmargin\leftmargini
  \labelwidth\labelwidthi \labelsep\normal@labelsep
  \topsep 6pt \partopsep\z@ \parsep\z@ \itemsep\z@
  \listparindent 1em}
\def\@listii{\leftmargin\leftmarginii
  \labelwidth\labelwidthii \labelsep\normal@labelsep
  \topsep\z@ \partopsep\z@ \parsep\z@ \itemsep\z@
  \listparindent 1em}
\def\@listiii{\leftmargin\leftmarginiii
  \labelwidth\labelwidthiii \labelsep\normal@labelsep
  \topsep\z@ \partopsep\z@ \parsep\z@ \itemsep\z@
  \listparindent 1em}
\def\@listiv{\leftmargin\leftmarginiv
  \labelwidth\labelwidthiv \labelsep\normal@labelsep
  \topsep\z@ \partopsep\z@ \parsep\z@ \itemsep\z@
  \listparindent 1em}
\let\@listi\@listI
\@listi
%
\setlength  \labelsep  {.5em}
\setlength  \labelwidth{\leftmargini}
\addtolength\labelwidth{-\labelsep}
\@beginparpenalty -\@lowpenalty
\@endparpenalty   -\@lowpenalty
\@itempenalty     -\@lowpenalty
%
\def\labelitemi{$\bullet$}          \def\labelitemii{$\cdot$}
\def\labelenumi{\theenumi.}        \def\theenumi{\arabic{enumi}}
\def\labelenumii{(\alph{enumii})}   \def\theenumii{\theenumi\alph{enumii}}
\def\labelenumiii{(\roman{enumiii})}\def\theenumiii{\theenumii.\roman{enumiii}}
\def\labelenumiv{(\Alph{enumiv})}   \def\theenumiv{\theenumiii.\Alph{enumiv}}

%
%%%%%%%%%%%%%%%%%%%%%%%%%%% Ordered & Unordered List  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

\def\listfont{\normalsize}%

\def\enumargs{%
\leftmargini 0\p@%
\leftmarginii \z@%
\leftmarginiii \z@%
\ifnum \@enumdepth>1\topsep\z@\else\ifnum\@itemdepth>0\topsep0\p@\else\topsep6\p@\fi\fi%
\partopsep     \z@%
\itemsep \z@
   \itemsep 0\p@%
   \parsep        \z@%
   \labelsep 4\p@%
   \rightmargin   \z@%
   \listparindent \parindent%
   \itemindent\z@}

\def\enumerate{%
    \@ifnextchar[{\@numerate}{\@numerate[0.]}}

\def\@numerate[#1]{%
     \ifnum \@enumdepth >3 \@toodeep\else%
     \advance\@enumdepth \@ne%
     \edef\@enumctr{enum\romannumeral\the\@enumdepth}%
     \list{\csname label\@enumctr\endcsname}{%
       \enumargs%
       \setlength{\leftmargin}{\csname leftmargin\romannumeral\the\@enumdepth\endcsname}%
       \usecounter{\@enumctr}%
%       \if@otherlist\labelwidth\z@%\addtolength{\leftmargin}{\labelsep}\def\makelabel##1{{##1}}
%       \else
       \settowidth\labelwidth{\upshape#1}%\fi%
%       \ifdim\labelwidth<8pt\addtolength{\labelsep}{-1pt}\fi%
%       \if@otherlist\else%
       \addtolength{\leftmargin}{\labelwidth}%\ifnum\@enumdepth>1\addtolength{\labelsep}{1pt}\fi%
       \addtolength{\leftmargin}{\labelsep}\def\makelabel##1{\hbox to \labelwidth{\hfill\upshape##1}}%\fi%
       }%
     \fi\listfont%
   }
\def\endenumerate{\endlist}%
%

%%Unnumbered list%%
\def\unenumargs{%
   \leftmargini   22\p@
   \leftmarginii  22\p@
   \leftmarginiii 22\p@
   \topsep3pt plus2pt minus2pt%
   \partopsep     \z@%
   \itemsep       0\p@%2.5\p@%
   \labelwidth    \z@%
   \parsep        \z@%
   \labelsep      0\p@%
   \rightmargin   \z@%
%   \raggedright%
   \listparindent \parindent%
   \itemindent    -10\p@}%

\def\unenumerate{%
    \@ifnextchar[{\@unenumerate}{\@unenumerate[0.]}}

\def\@unenumerate[#1]{\par%
     \ifnum \@enumdepth >3 \@toodeep\else
     \advance\@enumdepth \@ne
     \edef\@enumctr{enum\romannumeral\the\@enumdepth}
     \list{}{%\csname label\@enumctr\endcsname
       \unenumargs
       \setlength{\leftmargin}{\csname leftmargin\romannumeral\the\@enumdepth\endcsname}
       \usecounter{\@enumctr}
%       \settowidth\labelwidth{#1}
%       \addtolength{\leftmargin}{\labelwidth}
%       \addtolength{\leftmargin}{\labelsep}
       \def\makelabel##1{\hss\llap{##1}}}%
     \fi\listfont}
\let\endunenumerate\endlist%

% Changes to the list parameters for itemize
\def\itemargs{%
\ifnum \@itemdepth>1\topsep\z@\else\ifnum\@enumdepth>0\topsep0\p@\else\topsep6\p@\fi\fi%
\ifnum \@itemdepth>1\leftmargini\z@\else\ifnum\@enumdepth>0\leftmargini\z@\else\leftmargini0\p@\fi\fi%
   \leftmarginii  \z@%
   \leftmarginiii \z@%
   \partopsep     \z@%
%\ifnum\@itemdepth=3\labelwidth13\p@\else\labelwidth16\p@\fi
   \itemsep 0\p@%
   \parsep        \z@%
   \labelsep4\p@%6.75pt
   \rightmargin   \z@%
   \listparindent \parindent%
   \itemindent    \z@}

\renewcommand\labelitemi{\textbullet}
\renewcommand\labelitemii{\textendash}

\def\itemize{%
   \@ifnextchar[{\@itemize}{\@itemize[$\bullet$]}}

\def\@itemize[#1]{%
     \def\@@@ndash{#1}
     \ifnum \@itemdepth >3 \@toodeep\else
     \advance\@itemdepth \@ne
     \edef\@itemctr{item\romannumeral\the\@itemdepth}
     \list{\csname label\@itemctr\endcsname}{%
       \itemargs
       \setlength{\leftmargin}{\csname leftmargin\romannumeral\the\@itemdepth\endcsname}
       \settowidth\labelwidth{#1}
       \addtolength{\leftmargin}{\labelwidth}
       \addtolength{\leftmargin}{\labelsep}
       \addtolength{\itemindent}{-0.4pt}
       \def\makelabel##1{{##1}}}%\hss \llap
     \fi\listfont}%

\let\enditemize\endlist
%
\def\verse{\let\\=\@centercr
  \list{}{\itemsep\z@
  \itemindent \z@
  \listparindent\z@
  \rightmargin 1em
  \leftmargin \rightmargin}\item[]}
\let\endverse\endlist
\def\quotation{\list{}{\vskip 8pt\itemindent\z@
 \leftmargin 1em \rightmargin \z@
  \parsep \z@ \@plus 1pt}\item[]}
\newcommand\e{\endlist\vskip 8pt}
\let\endquotation\e

\renewenvironment{quote}
               {\list{}{\leftmargin=12\p@\topsep6pt\partopsep0pt%
                \rightmargin\leftmargin%
                \parsep\z@\labelwidth=0pt%\parsep=5\p@
                \listparindent12pt%
                }%
                \item\relax}
               {\endlist}

\def\descriptionlabel#1{\bfseries #1}
%
\def\description{\@ifnextchar[{\@describelist}{\list{}{\leftmargin=2em\labelwidth\z@\labelsep=10pt
  \leftmargin \z@ \topsep6pt\itemsep0pt\itemindent-\leftmargin
  \parsep\z@\parindent\z@\itemsep0pt
  %\advance\itemindent-\labelsep
  \let\makelabel\descriptionlabel}}}
%
\let\enddescription\endlist
%
\def\@describelist[#1]{\list{}{\settowidth{\labelwidth}{\bfseries#1}%
\topsep6pt\partopsep0pt\labelsep=10pt\leftmargin\labelwidth\itemsep0pt
        \advance\leftmargin\labelsep
  \itemindent0pt\parsep\z@\parindent\z@
  \let\makelabel\descriptionlabel}}
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Float %%%%%%%%%%%%%%%%%%%%%%%%%%%%

\setlength\abovecaptionskip{7\p@}
\setlength\belowcaptionskip{3.5\p@}

\setlength\arraycolsep{2\p@}
\setlength\tabcolsep{6\p@}
\setlength\arrayrulewidth{.4\p@}
\setlength\doublerulesep{2\p@}
\setlength\tabbingsep{\labelsep}

\def\fnum@figure{{\figurename}\space\relax{\thefigure}}
\def\fnum@table{{\tablename}\space\relax{\thetable}}

\def\FigName{figure}

\long\def\@makecaption#1#2{%
    \ifx\FigName\@captype
      \vskip\abovecaptionskip
        \@figurecaption{#1}{#2}
    \else
        \@tablecaption{#1}{#2}
      \vskip\belowcaptionskip
    \fi%
}


%% Figure

\def\figurenumfont{\reset@font\fontfamily{\sfdefault}\fontsize{7bp}{9bp}\bfseries\selectfont}
\def\figurecaptionfont{\fontfamily{\sfdefault}\fontsize{7bp}{9bp}\selectfont}

\newdimen\figwidth%
\newdimen\figheight%
\newdimen\sidecapwidth
\newdimen\wrapcapline%
\newdimen\totalwrapline%
\newdimen\wraptotline%

%% Figures macro
\def\FIG#1#2{%
{\centering#1\par}
#2}

%% Figures caption
\newbox\figcapbox
\newbox\capbox
\long\def\@figurecaption#1#2{%
{%
\setbox\figcapbox\hbox{\figurecaptionfont{\figurenumfont #1}\nobreakspace#2.\vphantom{y}\par}
%% Caption printing depending on figure width
\ifdim\wd\figcapbox>\textwidth
{\figurecaptionfont{\figurenumfont #1.}\nobreakspace{#2}\par}%
\else%
{\figurecaptionfont{\figurenumfont #1.}\nobreakspace{#2}\par}%\centering
\fi%
}}%

%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
\definecolor{tabrulecolor}{cmyk}{0,0,0,1}
\definecolor{theadcolor}{cmyk}{0.4,0.25,0.02,0}%% 40%
\definecolor{trowcolor}{cmyk}{0.09,0.05,0,0}%% 9%
%
\RequirePackage{booktabs}
\cmidrulewidth=.5pt%
%
\def\tablenumfont{\reset@font\sffamily\fontsize{7.5bp}{9bp}\selectfont\bfseries}
\def\tablecaptionfont{\sffamily\fontsize{7.5bp}{9bp}\selectfont}
\def\tablebodyfont{\sffamily\fontsize{7.5bp}{9bp}\selectfont\mathversion{sans}}
\def\tablecolheadfont{\sffamily\fontsize{7.5bp}{9bp}\selectfont}
\def\tablefootnotefont{\sffamily\fontsize{6.5bp}{8bp}\selectfont}

%\definecolor{trowcolor}{cmyk}{0.081,0.0378,0.049,0.0189}%{0.09,0.05,0,0}%% 9%

%% Table Macro
\newbox\tablebox
%\newdimen\tabbodywidth
\long\def\TBL#1#2{%
\def\@classz{\@classx
   \@tempcnta \count@
   \prepnext@tok
\expandafter\CT@extract\the\toks\@tempcnta\columncolor!\@nil
   \@addtopreamble{%
    \setbox\z@\hbox\bgroup\bgroup
      \ifcase \@chnum
      \hskip\stretch{.5}\kern\z@
      \d@llarbegin
      \insert@column
      \d@llarend\hskip\stretch{.5}\or
      \hskip7.4pt\hskip-\col@sep\d@llarbegin \insert@column \d@llarend \hskip7.4pt\hfill \or
      \hfill\kern\z@ \d@llarbegin \insert@column \d@llarend \or
   $\vcenter
   \@startpbox{\@nextchar}\insert@column \@endpbox $\or
   \vtop \@startpbox{\@nextchar}\insert@column \@endpbox \or
   \vbox \@startpbox{\@nextchar}\insert@column \@endpbox
  \fi
 \egroup\egroup
\begingroup
  \CT@setup
  \CT@column@color
  \CT@row@color
  \CT@cell@color
  \CT@do@color
\endgroup
        \@tempdima\ht\z@
        \advance\@tempdima\minrowclearance
        \vrule\@height\@tempdima\@width\z@
        \unhbox\z@}%
  \prepnext@tok}%
%
\def\arrayrulewidth{0.5bp}\arrayrulecolor{tabrulecolor}%
\let\hline\rowrule%
\rowcolors{2}{trowcolor}{trowcolor}%
\renewcommand{\arraystretch}{1.48}%
%\setbox\tablebox\hbox{\tablebodyfont #2\par}
%\tabbodywidth\wd\tablebox%
#1\vskip 0pt%
{\tablebodyfont #2\par}%
}

%% Table Caption
\newbox\tabcapbox
\newdimen\tabcapwidth
\long\def\@tablecaption#1#2{%
{\setbox\tabcapbox\hbox{\tablecaptionfont{\tablenumfont #1.\hskip0.4em}#2\vphantom{y}\endgraf}%
\tabcapwidth\wd\tabcapbox%
\ifdim\tabcapwidth<\hsize%
    {\tablecaptionfont{\tablenumfont #1.\hskip0.4em}#2\vphantom{y}\par}%
\else
    {\tablecaptionfont{\tablenumfont #1.\hskip0.4em}#2\vphantom{y}\par}%
\fi}}%

%% Table Column Heads
\def\TCH#1{{\tablecolheadfont #1}}

%% Table Footnotes
\newenvironment{fntable}[1][\columnwidth]{%
\def\@makefnmark{\hbox{\@textsuperscript{\fontsize{5}{5}\selectfont\@thefnmark}}}%
\begin{minipage}{#1}%
\def\thempfootnote{{\@arabic\c@mpfootnote}}
%%%%%%%%%%
\def\@xfootnotemark[##1]{%
   \begingroup
      %\c@footnote #1\relax
      \unrestored@protected@xdef\@thefnmark{##1}%
   \endgroup
   \@footnotemark}
%%%%%%%%%
\def\@xfootnotenext[##1]{%
  \begingroup
     %\csname c@\@mpfn\endcsname ##1\relax
     \unrestored@protected@xdef\@thefnmark{##1}%
  \endgroup
  \@footnotetext}
\renewcommand\@makefntext[1]{{%
\tablefootnotefont%
\hskip0pt{\smash{\@makefnmark}}##1\par}}
\renewcommand\footnotesize{\@setfontsize\footnotesize{6.5}{8}}%
\setlength\footnotesep{6.25\p@}
}%
{\vspace{-0.45\skip\footins}%
\renewcommand{\footnoterule}{}%
\end{minipage}}%

%% Table Rules
%%\def\toprule{\rowcolor{twntyprcntcolor}%\noalign{\vskip3pt}
%%\noalign{\ifnum0=`}\fi
%%  \hrule \@height 5pt \@width 0pt
%%  \futurelet\@tempa\@xhline}
%%% Middle rule
%%\def\midrule{\noalign{\ifnum0=`}\fi%
%%  \hrule \@height 3pt \@width 0pt
%%  \hrule \@height .15pt % <- rule height
%%  \hrule \@height 5pt \@width 0pt
%%  \futurelet \@tempa\@xhline}
%%% Bottom rule
%%\def\botrule{\noalign{\ifnum0=`}\fi
%%  \hrule \@height 3pt \@width 0pt
%%  \hrule \@height .15\p@ % <- rule height
%%  \futurelet\@tempa\@xhline}
%%%
%%\def\@@@cmidrule[#1-#2]#3#4{\global\@cmidla#1\relax
%%    \global\advance\@cmidla\m@ne
%%    \ifnum\@cmidla>0\global\let\@gtempa\@cmidrulea\else
%%    \global\let\@gtempa\@cmidruleb\fi
%%    \global\@cmidlb#2\relax
%%    \global\advance\@cmidlb-\@cmidla
%%    \global\@thisrulewidth=#3
%%    \@setrulekerning{#4}
%%    \ifnum\@lastruleclass=\z@\vskip 3\p@\fi
%%    \ifnum0=`{\fi}\@gtempa
%%    \noalign{\ifnum0=`}\fi\futurenonspacelet\@tempa\@xcmidrule}
%%\def\@xcmidrule{%
%%   \ifx\@tempa\cmidrule
%%       \vskip-\@thisrulewidth
%%       \global\@lastruleclass=\@ne
%%   \else \ifx\@tempa\morecmidrules
%%       \vskip \cmidrulesep
%%       \global\@lastruleclass=\@ne\else
%%       \vskip 5\p@
%%       \global\@lastruleclass=\z@
%%   \fi\fi
%%   \ifnum0=`{\fi}\rowcolor{twntyprcntcolor}}

\heavyrulewidth=0.5bp \lightrulewidth=0.5bp \cmidrulewidth=0.5bp
\abovetopsep=0pt \aboverulesep=0pt \belowrulesep=0pt \cmidrulekern=0em
%
\def\toprule{\rowcolor{theadcolor}%
  \noalign{\ifnum0=`}\fi \hrule \@height 0.5pt\par%
    {\color{theadcolor}\hrule \@height 1.5pt}
  \futurelet
   \reserved@a\@xhline}
%
%\def\midrule{\noalign{\ifnum0=`}\fi
%  \@aboverulesep=\abovetopsep
%  \addtolength{\@aboverulesep}{2.8pt}%
%  \global\@belowrulesep=5.2pt%
%  \global\@thisruleclass=\@ne
%  \@ifnextchar[{\@BTrule}{\@BTrule[0.5pt]}}
\def\midrule{%
  \noalign{\ifnum0=`}\fi
    {\color{theadcolor}{\hrule \@height 2pt}}\par
    \hrule \@height 0.5pt\par%
    {\color{trowcolor}{\hrule \@height 3.17pt}}
  \futurelet
   \reserved@a\@xhline}
%\def\botrule{\noalign{\ifnum0=`}\fi
%  \@aboverulesep=\abovetopsep
%  \addtolength{\@aboverulesep}{0.8pt}%
%  \global\@belowrulesep=0pt%
%  \global\@thisruleclass=\@ne
%  \@ifnextchar[{\@BTrule}{\@BTrule[0.5pt]}}
\def\botrule{%
  \noalign{\ifnum0=`}\fi
    {\color{trowcolor}{\hrule \@height 0.5pt}}\par
    \hrule \@height 0.5pt%
  \futurelet
   \reserved@a\@xhline}
%
\def\@@@cmidrule[#1-#2]#3#4{\global\@cmidla#1\relax
    \global\advance\@cmidla\m@ne
    \ifnum\@cmidla>0\global\let\@gtempa\@cmidrulea\else
    \global\let\@gtempa\@cmidruleb\fi
    \global\@cmidlb#2\relax
    \global\advance\@cmidlb-\@cmidla
    \global\@thisrulewidth=#3
    \@setrulekerning{#4}
    \ifnum\@lastruleclass=\z@\vskip 2pt\fi
    \ifnum0=`{\fi}\@gtempa
    \noalign{\ifnum0=`}\fi\futurenonspacelet\@tempa\@xcmidrule}
%
\def\@xcmidrule{%
   \ifx\@tempa\cmidrule
       \vskip-\@thisrulewidth
       \global\@lastruleclass=\@ne
   \else \ifx\@tempa\morecmidrules
       \vskip 0pt
       \global\@lastruleclass=\@ne\else
       \vskip 1.8pt%\belowrulesep
       \global\@lastruleclass=\z@
   \fi\fi
   \ifnum0=`{\fi}\rowcolor{theadcolor}}

%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%5
%

\renewcommand\@pnumwidth{1.55em}
\renewcommand\@tocrmarg{2.55em}
\renewcommand\@dotsep{4.5}
\setcounter{tocdepth}{3}
\renewcommand\tableofcontents{%
    \section*{\contentsname
        \@mkboth{%
           \MakeUppercase\contentsname}{\MakeUppercase\contentsname}}%
    \@starttoc{toc}%
    }
\renewcommand*\l@part[2]{%
  \ifnum \c@tocdepth >-2\relax
    \addpenalty\@secpenalty
    \addvspace{2.25em \@plus\p@}%
    \begingroup
      \setlength\@tempdima{3em}%
      \parindent \z@ \rightskip \@pnumwidth
      \parfillskip -\@pnumwidth
      {\leavevmode
       \large \bfseries #1\hfil \hb@xt@\@pnumwidth{\hss #2}}\par
       \nobreak
       \if@compatibility
         \global\@nobreaktrue
         \everypar{\global\@nobreakfalse\everypar{}}%
      \fi
    \endgroup
  \fi}
\renewcommand*\l@section[2]{%
  \ifnum \c@tocdepth >\z@
    \addpenalty\@secpenalty
    \addvspace{0em}% \@plus\p@}%
    \setlength\@tempdima{1.5em}%
    \begingroup
      \parindent \z@ \rightskip \@pnumwidth
      \parfillskip -\@pnumwidth
      \leavevmode \bfseries
      \advance\leftskip\@tempdima
      \hskip -\leftskip
      #1\nobreak\hfil \nobreak\hb@xt@\@pnumwidth{\hss #2}\par
    \endgroup
  \fi}
\renewcommand*\l@subsection{\@dottedtocline{2}{1.5em}{2.3em}}
\renewcommand*\l@subsubsection{\@dottedtocline{3}{3.8em}{3.2em}}
\renewcommand*\l@paragraph{\@dottedtocline{4}{7.0em}{4.1em}}
\renewcommand*\l@subparagraph{\@dottedtocline{5}{10em}{5em}}
\renewcommand\listoffigures{%
    \section*{\listfigurename
      \@mkboth{\MakeUppercase\listfigurename}%
              {\MakeUppercase\listfigurename}}%
    \@starttoc{lof}%
    }
\renewcommand*\l@figure{\@dottedtocline{1}{1.5em}{2.3em}}
\renewcommand\listoftables{%
    \section*{\listtablename
      \@mkboth{%
          \MakeUppercase\listtablename}{\MakeUppercase\listtablename}}%
    \@starttoc{lot}%
    }
\let\l@table\l@figure

%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Mini-TOC %%%%%%%%%%%%%%%%%%%%%%%%%
%%%
%%\RequirePackage{etoc}
%%\etocarticlestylenomarks
%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Other Env. %%%%%%%%%%%%%%%%%%%%%%%%%
%


%
%%%%%%%%%%%%%%%%%%%%%%%%%%%% Appendix %%%%%%%%%%%%%%%%%%%%%%%%%
%

\newif\ifbackmatter%
\newcommand{\backmatter}{\par\global\backmattertrue}

%
%%%%%%%%%%%%%%%%%%%%%%%%%%%% Appendix %%%%%%%%%%%%%%%%%%%%%%%%%
%
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%% BackMatters %%%%%%%%%%%%%%%%%%%%%%%%%
%
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%


%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Doi-Links %%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%% From doi.sty %%

\DeclareRobustCommand{\doitext}{{doi}:}%

%% the meat of the code
%% the first command opens a group, and changes a few catcodes.
\newcommand*{\DOI}{%
  \begingroup
  \lccode`\~=`\#\relax
  \lowercase{\def~{\#}}%
  \lccode`\~=`\_\relax
  \lowercase{\def~{\_}}%
  \lccode`\~=`\<\relax
  \lowercase{\def~{\textless}}%
  \lccode`\~=`\>\relax
  \lowercase{\def~{\textgreater}}%
  \lccode`\~=0\relax
  \catcode`\#=\active
  \catcode`\_=\active
  \catcode`\<=\active
  \catcode`\>=\active
  \doitext\@mydoi
}

%% this is the actual command which processes the argument, with the catcodes
%% set in the previous command
%% it closes the group, and spits out the url.
\def\@mydoi#1{%
  \let\#\relax
  \let\_\relax
  \let\textless\relax
  \let\textgreater\relax
  \edef\x{\toks0={{#1}}}%
  \x
  \edef\#{\@percentchar23}%
  \edef\_{_}%
  \edef\textless{\@percentchar3C}% instead of {\string<} for Apple
  \edef\textgreater{\@percentchar3E}% instead of {\sting>} for Apple
  \edef\x{\toks1={\noexpand\href{http://dx.doi.org/#1}}}%
  \x
  \edef\x{\endgroup\the\toks1 \the\toks0}%
  \x
}
%
%
\renewenvironment{theindex}
               {\if@twocolumn
                  \@restonecolfalse
                \else
                  \@restonecoltrue
                \fi
                \columnseprule \z@
                \columnsep 35\p@
                \twocolumn[\section*{\indexname}]%
                \@mkboth{\MakeUppercase\indexname}%
                        {\MakeUppercase\indexname}%
                \thispagestyle{plain}\parindent\z@
                \parskip\z@ \@plus .3\p@\relax
                \let\item\@idxitem}
               {\if@restonecol\onecolumn\else\clearpage\fi}
\renewcommand\@idxitem{\par\hangindent 40\p@}
\renewcommand\subitem{\@idxitem \hspace*{20\p@}}
\renewcommand\subsubitem{\@idxitem \hspace*{30\p@}}
\renewcommand\indexspace{\par \vskip 10\p@ \@plus5\p@ \@minus3\p@\relax}

%
%%%%%%%%%%%%%%%%%%%%%%% Footnotes %%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

\renewcommand\footnoterule{\if@prntcpyrghtline\global\@prntcpyrghtlinefalse\else%
  \kern2\p@%
  %\hrule \@height0.5bp \@width5pc%
  %\kern2.5\p@
  \fi}%
%

\def\@makefnmark{{\textsuperscript{\@thefnmark}}}

\renewcommand\@makefntext[1]{\hskip9pt{\smash{\@makefnmark}}#1}
%
\AtBeginDocument{%
\@ifpackageloaded{hyperref}{%
\RequirePackage{hypcap}%
\renewcommand\UrlFont{\rmfamily}%
}{}%
%
\@ifpackageloaded{natbib}{%
  \renewcommand\bibsection{\section*{\refname}}%
  \bibhang=9pt
}{}%
}%

\def\doi#1{\quad\url{http://dx.doi.org/#1}}
%
\def\citethisarticle#1{\gdef\@citthisartauthors{#1}}
\def\@citthisartauthors{}
%%\newcommand\citethisarticle[1]{\bgroup%
%%\renewcommand\@makefntext[1]{\textbf{Cite this article:} #1}%
%%\footnotetext{#1}\egroup}
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

\pagestyle{headings}
\pagenumbering{arabic}
\sloppy
\frenchspacing
\flushbottom

%%% special parameters for TeX
\linepenalty=100

%\def\copbreak{{\parfillskip0pt\par}\restoregeometry\noindent}

\AtBeginDocument{
\newgeometry{%
left=69.806mm,top={1in},%
right=39.5pt,textheight=240mm,%
onecolumn=true}%
}

\def\copbreak{{\hfill\par}\restoregeometry\noindent}

\endinput
